/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.project.builder;

import java.util.Collections;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.compiler.ResolverUtils;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolverFactory;
import org.eclipse.m2m.internal.qvt.oml.emf.util.URIUtils;
import org.eclipse.m2m.internal.qvt.oml.project.QVTOProjectPlugin;
import org.eclipse.m2m.internal.qvt.oml.project.builder.QVTOBuilderConfig;
import org.eclipse.m2m.internal.qvt.oml.project.builder.WorkspaceUnitResolver;

public class WorkspaceUnitResolverFactory
extends UnitResolverFactory {
    public boolean accepts(URI uri) {
        return EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE && (uri.isPlatformResource() || WorkspaceUnitResolverFactory.isWorkspacePath(uri));
    }

    public UnitResolver getResolver(URI uri) {
        IResource file;
        if (WorkspaceUnitResolverFactory.isWorkspacePath(uri)) {
            uri = URI.createPlatformResourceURI((String)uri.path(), (boolean)false);
        }
        if ((file = URIUtils.getResource((URI)uri)) == null) {
            return null;
        }
        try {
            IContainer sourceContainer = QVTOBuilderConfig.getConfig(file.getProject()).getSourceContainer();
            if (sourceContainer != null) {
                return new WorkspaceUnitResolver(Collections.singletonList(sourceContainer));
            }
        }
        catch (CoreException e) {
            QVTOProjectPlugin.log(e.getStatus());
        }
        return null;
    }

    public String getQualifiedName(URI uri) {
        if (WorkspaceUnitResolverFactory.isWorkspacePath(uri)) {
            uri = URI.createPlatformResourceURI((String)uri.path(), (boolean)false);
        }
        IResource resource = URIUtils.getResource((URI)uri);
        try {
            IContainer sourceContainer = QVTOBuilderConfig.getConfig(resource.getProject()).getSourceContainer();
            URI sourceContainerUri = URIUtils.getResourceURI((IResource)sourceContainer);
            URI relativeUri = uri.deresolve(sourceContainerUri).trimFileExtension();
            assert (relativeUri.isRelative());
            return ResolverUtils.toQualifiedName((String[])relativeUri.segments(), (int)1, (int)(relativeUri.segmentCount() - 1));
        }
        catch (CoreException e) {
            QVTOProjectPlugin.log(e.getStatus());
            return null;
        }
    }

    private static boolean isWorkspacePath(URI uri) {
        return uri.scheme() == null && !uri.hasDevice() && !uri.hasAuthority() && !uri.hasEmptyPath() && !uri.hasQuery() && !uri.hasFragment() && uri.hasAbsolutePath();
    }
}

