/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor;

import java.util.List;
import org.eclipse.imp.editor.AnnotationHoverBase;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.ServiceFactory;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.imp.services.IDocumentationProvider;
import org.eclipse.imp.services.IHoverHelper;
import org.eclipse.imp.services.IReferenceResolver;
import org.eclipse.imp.utils.HTMLPrinter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;

public class HoverHelper
implements IHoverHelper {
    private final Language fLanguage;

    public HoverHelper(Language lang) {
        this.fLanguage = lang;
    }

    public String getHoverHelpAt(IParseController parseController, ISourceViewer srcViewer, int offset) {
        IDocumentationProvider docProvider;
        String doc;
        Object target;
        try {
            List<Annotation> annotations = AnnotationHoverBase.getSourceAnnotationsForLine(srcViewer, srcViewer.getDocument().getLineOfOffset(offset));
            if (annotations != null && annotations.size() > 0) {
                return AnnotationHoverBase.formatAnnotationList(annotations);
            }
        }
        catch (BadLocationException badLocationException) {
            return "???";
        }
        IReferenceResolver refResolver = ServiceFactory.getInstance().getReferenceResolver(this.fLanguage);
        Object root = parseController.getCurrentAst();
        ISourcePositionLocator nodeLocator = parseController.getSourcePositionLocator();
        if (root == null) {
            return null;
        }
        Object selNode = nodeLocator.findNode(root, offset);
        if (selNode == null) {
            return null;
        }
        Object object = target = refResolver != null ? refResolver.getLinkTarget(selNode, parseController) : selNode;
        if (target == null) {
            target = selNode;
        }
        String string = doc = (docProvider = ServiceFactory.getInstance().getDocumentationProvider(this.fLanguage)) != null ? docProvider.getDocumentation(target, parseController) : null;
        if (doc != null) {
            return doc;
        }
        if (target == selNode) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addSmallHeader(buffer, target.toString());
        HTMLPrinter.addParagraph(buffer, doc);
        return buffer.toString();
    }
}

