/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.relations.atlvm;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.m2m.atl.drivers.emf4atl.ASMEMFModel;
import org.eclipse.m2m.atl.engine.vm.ASM;
import org.eclipse.m2m.atl.engine.vm.ASMExecEnv;
import org.eclipse.m2m.atl.engine.vm.ASMInterpreter;
import org.eclipse.m2m.atl.engine.vm.ASMXMLReader;
import org.eclipse.m2m.atl.engine.vm.Debugger;
import org.eclipse.m2m.atl.engine.vm.SimpleDebugger;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModule;
import org.eclipse.qvt.declarative.atlvm.problems.problems.Problem;
import org.eclipse.qvt.declarative.atlvm.problems.problems.ProblemsPackage;
import org.eclipse.qvt.declarative.common.framework.service.Operation;
import org.eclipse.qvt.declarative.compilation.CompilationProvider;
import org.eclipse.qvt.declarative.compilation.CompileOperation;
import org.eclipse.qvt.declarative.compilation.DeclarativeQVTCompilationException;
import org.eclipse.qvt.declarative.compilation.QVTRelationsCompilationException;
import org.eclipse.qvt.declarative.ecore.QVTBase.TypedModel;
import org.eclipse.qvt.declarative.ecore.QVTRelation.RelationalTransformation;
import org.eclipse.qvt.declarative.relations.atlvm.Activator;
import org.eclipse.qvt.declarative.relations.atlvm.runner.ATLVMCodeJavaRunnerWriter;
import org.eclipse.qvt.declarative.relations.atlvm.runner.ATLVMCodeJavaRunnerWriterParameters;
import org.eclipse.qvt.declarative.relations.atlvm.utils.ASMEMFModelUtils;
import org.eclipse.qvt.declarative.relations.atlvm.utils.ASMUtils;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ATLVMCompiler
implements CompilationProvider {
    private static final String COMPILER_ASM_LOCATION = "resources/QVTR.asm";
    private static final String DEFAULT_DEBUGGER_PROPERTIES_LOCATION = "debugger.properties.xml";
    private static final String DEFAULT_COMPILATION_PARAMETERS_LOCATION = "resources/compilation.parameters.xml";
    protected static final String EXECUTABLE_SUFFIX = "asm";
    public static final String OUT_FILE_PARAMETER_NAME = "WriteTo";
    public static final String DIRECTION_PARAMETER_NAME = "direction";
    public static final String TRANSFORMATION_MODEL_NAME = "IN";
    private static final String PROBLEM_MODEL_FILE_EXTENSION = "pbm.xmi";
    private static final String PROBLEM_MODEL_NAME = "OUT";
    private static final ASM COMPILER_ASM = ATLVMCompiler.loadQVTRCompiler();
    private static final String RELATION_METAMODEL_ALIAS = "QVTR";
    private static final ASMEMFModel PROBLEM_METAMODEL = ASMEMFModelUtils.getASMEMFModelFrom((EPackage)ProblemsPackage.eINSTANCE, null);
    private static final Debugger DEFAULT_DEBUGGER = ATLVMCompiler.createDefaultDebugger();
    private static final Properties DEFAULT_COMPILATION_PARAMETERS = ATLVMCompiler.loadDefaultCompilationProperties();

    private static final ASM loadQVTRCompiler() {
        Bundle bundle = Activator.getDefault().getBundle();
        ASM compilerASM = null;
        URL compilerUrl = FileLocator.find((Bundle)bundle, (IPath)new Path(COMPILER_ASM_LOCATION), (Map)Collections.EMPTY_MAP);
        try {
            compilerASM = new ASMXMLReader().read((InputStream)new BufferedInputStream(compilerUrl.openStream()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return compilerASM;
    }

    private static Debugger createDefaultDebugger() {
        Properties debuggerProperties = new Properties();
        URL debuggerPropertiesURL = ATLVMCompiler.class.getResource(DEFAULT_DEBUGGER_PROPERTIES_LOCATION);
        try {
            debuggerProperties.loadFromXML(debuggerPropertiesURL.openStream());
        }
        catch (InvalidPropertiesFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SimpleDebugger result = new SimpleDebugger(Boolean.toString(true).equals(debuggerProperties.get("step")), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), true, Boolean.toString(true).equals(debuggerProperties.get("showSummary")), Boolean.toString(true).equals(debuggerProperties.get("profile")), Boolean.toString(true).equals(debuggerProperties.get("continueAfterError")));
        return result;
    }

    private static Properties loadDefaultCompilationProperties() {
        Bundle bundle = Activator.getDefault().getBundle();
        Properties compilationParameters = new Properties();
        URL compilationParametersUrl = FileLocator.find((Bundle)bundle, (IPath)new Path(DEFAULT_COMPILATION_PARAMETERS_LOCATION), (Map)Collections.EMPTY_MAP);
        try {
            compilationParameters.loadFromXML(compilationParametersUrl.openStream());
        }
        catch (InvalidPropertiesFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return compilationParameters;
    }

    protected String getDefaultExecutablePath(URI relativeAbstractSyntaxTreeURI, String direction, URI binFolderURI) {
        URI result = relativeAbstractSyntaxTreeURI.resolve(binFolderURI);
        result = result.trimFileExtension().appendFileExtension(direction).appendFileExtension(EXECUTABLE_SUFFIX);
        return result.toFileString();
    }

    protected ASMEMFModel createProblemModelFor(Resource abstractSyntaxTree) throws Exception {
        URI abstractSyntaxTreeURI = abstractSyntaxTree.getURI();
        String problemFileName = abstractSyntaxTreeURI.trimFileExtension().appendFileExtension(PROBLEM_MODEL_FILE_EXTENSION).toString();
        return ASMEMFModel.newASMEMFModel((String)PROBLEM_MODEL_NAME, (String)problemFileName, (ASMEMFModel)PROBLEM_METAMODEL, null);
    }

    protected Properties createCompilationsProperties(URI relativeAbstractSyntaxTreeURI, Map<String, String> parameters, String direction, URI binFolderURI) {
        Properties effectiveParameters = new Properties();
        effectiveParameters.putAll((Map<?, ?>)DEFAULT_COMPILATION_PARAMETERS);
        effectiveParameters.putAll(parameters);
        if (!effectiveParameters.containsKey(OUT_FILE_PARAMETER_NAME)) {
            String executablePath = this.getDefaultExecutablePath(relativeAbstractSyntaxTreeURI, direction, binFolderURI);
            effectiveParameters.put(OUT_FILE_PARAMETER_NAME, executablePath);
        }
        return effectiveParameters;
    }

    protected URI[] getSplittedSourceURI(List<File> sourceFolders, File sourceFile) {
        URI sourceFileURI = URI.createFileURI((String)sourceFile.getAbsolutePath());
        URI currentFolderURI = URI.createURI((String)"./");
        URI relativeURI = null;
        for (File folder : sourceFolders) {
            URI folderURI = URI.createFileURI((String)folder.getAbsolutePath()).appendSegment("");
            relativeURI = sourceFileURI.replacePrefix(folderURI, currentFolderURI);
            if (relativeURI == null) continue;
            return new URI[]{folderURI, relativeURI};
        }
        return new URI[2];
    }

    public List<File> compile(Object abstractSyntaxTree, Map<String, String> parameters, List<File> sourceFolders, File binFolder) throws DeclarativeQVTCompilationException {
        if (!(abstractSyntaxTree instanceof File)) {
            String message = "Abstract Syntax is not a file: " + abstractSyntaxTree.toString();
            QVTRelationsCompilationException exception = new QVTRelationsCompilationException(message, 0, 0, 0);
            throw exception;
        }
        File abstractSyntaxTreeFile = (File)abstractSyntaxTree;
        URI[] splittedSourceURI = this.getSplittedSourceURI(sourceFolders, abstractSyntaxTreeFile);
        URI sourceFolderURI = splittedSourceURI[0];
        URI relativeAbstractSyntaxTreeURI = splittedSourceURI[1];
        if (sourceFolderURI != null && relativeAbstractSyntaxTreeURI != null) {
            URI binFolderURI = URI.createFileURI((String)binFolder.getAbsolutePath()).appendSegment("");
            URI abstractSyntaxTreeURI = URI.createFileURI((String)abstractSyntaxTreeFile.getAbsolutePath());
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource abstractSyntaxTreeResource = resourceSet.createResource(abstractSyntaxTreeURI);
            ASMEMFModel qvtrTransformation = null;
            try {
                qvtrTransformation = ASMEMFModelUtils.getASMEMFModelFrom(abstractSyntaxTreeResource, TRANSFORMATION_MODEL_NAME);
            }
            catch (Exception e) {
                String message = "Unable to load the AST in the ATLVM : " + e.getMessage();
                QVTRelationsCompilationException exception = new QVTRelationsCompilationException(message, 0, 0, 0);
                throw exception;
            }
            List<String> directions = this.getDirections(abstractSyntaxTreeResource);
            ArrayList<File> result = new ArrayList<File>(directions.size());
            for (String directionDomainName : directions) {
                ASM directionASM = ASMUtils.createDirectionLibrary(directionDomainName);
                ASMEMFModel myProblems = null;
                try {
                    myProblems = this.createProblemModelFor(abstractSyntaxTreeResource);
                }
                catch (Exception e) {
                    String message = "Unable to create a problem model for the ATLVM : " + e.getMessage();
                    QVTRelationsCompilationException exception = new QVTRelationsCompilationException(message, 0, 0, 0);
                    throw exception;
                }
                Properties effectiveParameters = this.createCompilationsProperties(relativeAbstractSyntaxTreeURI, parameters, directionDomainName, binFolderURI);
                if (qvtrTransformation == null || myProblems == null) continue;
                File resultFile = this.compile(qvtrTransformation, directionASM, myProblems, DEFAULT_DEBUGGER, effectiveParameters);
                result.add(resultFile);
                this.handleProblems(myProblems);
            }
            return result;
        }
        return null;
    }

    protected List<String> getDirections(Resource resource) {
        ArrayList<String> result = new ArrayList<String>();
        EList contents = resource.getContents();
        if (!contents.isEmpty() && contents.get(0) instanceof RelationalTransformation) {
            RelationalTransformation relationalTransformation = (RelationalTransformation)contents.get(0);
            for (TypedModel typedModel : relationalTransformation.getModelParameter()) {
                result.add(typedModel.getName());
            }
            return result;
        }
        return null;
    }

    protected void handleProblems(ASMEMFModel problems) throws QVTRelationsCompilationException {
        Set problemSet = problems.getElementsByType("Problem");
        for (Object object : problemSet) {
            if (!(object instanceof Problem)) continue;
            Problem problem = (Problem)object;
            String message = problem.getDescription();
            int startLine = problem.getStartLine();
            int startColumn = problem.getStartColumn();
            int endColumn = problem.getEndColumn();
            throw new QVTRelationsCompilationException(message, startLine, startColumn, endColumn);
        }
    }

    protected void createJavaLauncher(Resource abstractSyntaxTreeResource, URI sourceFolderURI) throws IOException {
        String javaLoaderSourcePath = abstractSyntaxTreeResource.getURI().trimSegments(1).appendSegment(this.getClassName(abstractSyntaxTreeResource)).appendFileExtension("java").toFileString();
        File javaLoaderSourceFile = new File(javaLoaderSourcePath);
        javaLoaderSourceFile.createNewFile();
        BufferedWriter writer = new BufferedWriter(new FileWriter(javaLoaderSourceFile));
        ATLVMCodeJavaRunnerWriterParameters writerParameters = new ATLVMCodeJavaRunnerWriterParameters(abstractSyntaxTreeResource, sourceFolderURI);
        ATLVMCodeJavaRunnerWriter javaRunnerWriter = new ATLVMCodeJavaRunnerWriter();
        String content = javaRunnerWriter.generate(writerParameters);
        writer.write(content);
        writer.close();
    }

    protected RelationalTransformation getTransformation(Resource resource) {
        EObject eObject = (EObject)resource.getContents().get(0);
        if (eObject instanceof RelationalTransformation) {
            return (RelationalTransformation)eObject;
        }
        return null;
    }

    protected String getClassName(Resource abstractSyntaxTreeResource) {
        RelationalTransformation transformation = this.getTransformation(abstractSyntaxTreeResource);
        String unformatedName = transformation.getName();
        return String.valueOf(unformatedName.substring(0, 1).toUpperCase()) + unformatedName.substring(1);
    }

    public boolean provides(Operation operation) {
        CompileOperation compileOperation;
        Object source;
        if (operation instanceof CompileOperation && (source = (compileOperation = (CompileOperation)operation).getSource()) instanceof File && compileOperation.getSourceFolders() != null && compileOperation.getBinFolder() != null) {
            boolean canHandleSource;
            File sourceFile = (File)source;
            boolean bl = canHandleSource = sourceFile.canRead() && sourceFile.isFile();
            if (canHandleSource) {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                URI sourceURI = URI.createFileURI((String)sourceFile.getPath());
                Resource resource = resourceSet.getResource(sourceURI, true);
                if (!resource.getContents().isEmpty()) {
                    EObject eObject = (EObject)resource.getContents().get(0);
                    canHandleSource = eObject instanceof RelationalTransformation;
                } else {
                    canHandleSource = false;
                }
                resource.unload();
            }
            return canHandleSource;
        }
        return false;
    }

    protected File compile(ASMEMFModel qvtrTransformation, ASM directionLibary, ASMEMFModel myProblems, Debugger debugger, Properties compilationParameters) throws QVTRelationsCompilationException {
        ASMModule asmModule = new ASMModule(COMPILER_ASM);
        ASMExecEnv env = new ASMExecEnv(asmModule, debugger, true);
        env.addPermission("file.read");
        env.addPermission("file.write");
        env.addModel(RELATION_METAMODEL_ALIAS, qvtrTransformation.getMetamodel());
        env.addModel(qvtrTransformation.getName(), (ASMModel)qvtrTransformation);
        env.addModel(myProblems.getMetamodel().getName(), myProblems.getMetamodel());
        env.addModel(myProblems.getName(), (ASMModel)myProblems);
        env.registerOperations(directionLibary);
        env.registerOperations(COMPILER_ASM);
        try {
            new ASMInterpreter(COMPILER_ASM, asmModule, env, (Map)compilationParameters);
        }
        catch (Exception e) {
            String message = e.getMessage();
            QVTRelationsCompilationException exception = new QVTRelationsCompilationException(message, 0, 0, 0);
            throw exception;
        }
        File resultFile = new File(compilationParameters.getProperty(OUT_FILE_PARAMETER_NAME));
        return resultFile;
    }
}

