/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.parser.qvtrelation.environment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.AmbiguousLookupException;
import org.eclipse.ocl.LookupException;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.ocl.utilities.UMLReflection;
import org.eclipse.qvt.declarative.ecore.QVTBase.Function;
import org.eclipse.qvt.declarative.ecore.QVTBase.Transformation;
import org.eclipse.qvt.declarative.ecore.QVTBase.TypedModel;
import org.eclipse.qvt.declarative.ecore.QVTRelation.QVTRelationFactory;
import org.eclipse.qvt.declarative.ecore.QVTRelation.Relation;
import org.eclipse.qvt.declarative.ecore.QVTRelation.RelationalTransformation;
import org.eclipse.qvt.declarative.parser.qvt.cst.IdentifierCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.cst.ModelDeclCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.cst.QueryCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.cst.RelationCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.cst.TransformationCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.environment.QVTrEnvironment;
import org.eclipse.qvt.declarative.parser.qvtrelation.environment.QVTrQueryEnvironment;
import org.eclipse.qvt.declarative.parser.qvtrelation.environment.QVTrRelationEnvironment;
import org.eclipse.qvt.declarative.parser.qvtrelation.environment.QVTrTopLevelEnvironment;
import org.eclipse.qvt.declarative.parser.qvtrelation.environment.QVTrTypedModelEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QVTrTransformationEnvironment
extends QVTrEnvironment<QVTrTopLevelEnvironment, RelationalTransformation, TransformationCS> {
    private Map<RelationCS, QVTrRelationEnvironment> relEnvMap = new HashMap<RelationCS, QVTrRelationEnvironment>();
    private Map<QueryCS, QVTrQueryEnvironment> queryEnvMap = new HashMap<QueryCS, QVTrQueryEnvironment>();
    private Map<String, QVTrTypedModelEnvironment> modelIdToTypedModelEnvironment = new HashMap<String, QVTrTypedModelEnvironment>();
    private final Map<String, Set<EPackage>> metaModelIdToPackages = new HashMap<String, Set<EPackage>>();
    private final Set<EPackage> allMetaModelPackages = new HashSet<EPackage>();
    protected Map<String, List<EReference>> oppositeFeaturesMap = null;

    public QVTrTransformationEnvironment(QVTrTopLevelEnvironment env, TransformationCS transformationCS) {
        super(env, QVTRelationFactory.eINSTANCE.createRelationalTransformation(), transformationCS);
        IdentifierCS identifier = transformationCS.getIdentifier();
        QVTrTransformationEnvironment.setNameFromIdentifier((ENamedElement)((ENamedElement)this.ast), (IdentifierCS)identifier);
        Variable variable = EcoreFactory.eINSTANCE.createVariable();
        this.getASTNodeToCSTNodeMap().put(variable, identifier);
        variable.setName("self");
        variable.setType((Object)((EClassifier)this.ast));
        this.setSelfVariable((org.eclipse.ocl.expressions.Variable)variable);
        IdentifierCS identifierCS = transformationCS.getExtends();
        if (identifierCS != null) {
            Transformation extendedTransformation = env.lookupImportedTransformation(identifierCS.getValue());
            ((RelationalTransformation)this.ast).setExtends(extendedTransformation);
        }
    }

    public void addMetaModelPackage(String metaModelId, EPackage ePackage) {
        Set<EPackage> contents = this.metaModelIdToPackages.get(metaModelId);
        if (contents == null) {
            contents = new HashSet<EPackage>();
            this.metaModelIdToPackages.put(metaModelId, contents);
        }
        contents.add(ePackage);
        this.allMetaModelPackages.add(ePackage);
    }

    public QVTrTypedModelEnvironment createEnvironment(ModelDeclCS modelDeclCS) {
        String modelId = modelDeclCS.getModelId().getValue();
        QVTrTypedModelEnvironment environment = this.modelIdToTypedModelEnvironment.get(modelId);
        if (environment != null) {
            this.analyzerError("modelId '" + modelId + "' already defined", "modelDeclCS", modelDeclCS);
            return null;
        }
        environment = new QVTrTypedModelEnvironment(this, modelDeclCS);
        TypedModel typedModel = environment.getTypedModel();
        ((RelationalTransformation)this.ast).getModelParameter().add((Object)typedModel);
        this.modelIdToTypedModelEnvironment.put(modelId, environment);
        return environment;
    }

    public QVTrQueryEnvironment createEnvironment(QueryCS queryCS) {
        QVTrQueryEnvironment environment = new QVTrQueryEnvironment(this, queryCS);
        this.queryEnvMap.put(queryCS, environment);
        return environment;
    }

    public QVTrRelationEnvironment createEnvironment(RelationCS relationCS) {
        QVTrRelationEnvironment environment = new QVTrRelationEnvironment(this, relationCS);
        Relation relation = environment.getRelation();
        ((RelationalTransformation)this.ast).getRule().add((Object)relation);
        this.relEnvMap.put(relationCS, environment);
        return environment;
    }

    public QVTrQueryEnvironment getEnvironment(QueryCS queryCS) {
        return this.queryEnvMap.get(queryCS);
    }

    public QVTrRelationEnvironment getEnvironment(RelationCS relationCS) {
        return this.relEnvMap.get(relationCS);
    }

    public QVTrTypedModelEnvironment getEnvironment(TypedModel typedModel) {
        return this.modelIdToTypedModelEnvironment.get(typedModel.getName());
    }

    public String getModelName(EObject object) {
        for (String key : this.metaModelIdToPackages.keySet()) {
            Set<EPackage> ePackages = this.metaModelIdToPackages.get(key);
            if (!ePackages.contains(object)) continue;
            return key;
        }
        return null;
    }

    @Override
    public List<Function> getQueries(String queryName, List<OCLExpression> args) {
        return this.findMatchingQueries((Transformation)this.ast, queryName, args);
    }

    @Override
    public RelationalTransformation getRelationalTransformation() {
        return (RelationalTransformation)this.ast;
    }

    protected void initializeFeatures(EPackage ePackage) {
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            if (!(eClassifier instanceof EClass)) continue;
            EClass eClass = (EClass)eClassifier;
            for (EStructuralFeature eFeature : eClass.getEStructuralFeatures()) {
                EReference eReference;
                if (!(eFeature instanceof EReference) || (eReference = (EReference)eFeature).getEOpposite() != null) continue;
                String oppositeName = this.getOppositeName(eReference);
                List<EReference> features = this.oppositeFeaturesMap.get(oppositeName);
                if (features == null) {
                    features = new ArrayList<EReference>();
                    this.oppositeFeaturesMap.put(oppositeName, features);
                }
                features.add(eReference);
            }
        }
    }

    public Variable lookupImplicitSourceForOperation(String name, List<? extends TypedElement<EClassifier>> params) {
        Relation relation = ((RelationalTransformation)this.ast).getRelation(name);
        if (relation != null) {
            return (Variable)this.getSelfVariable();
        }
        Function query = ((RelationalTransformation)this.ast).getFunction(name);
        if (query != null) {
            return (Variable)this.getSelfVariable();
        }
        return super.lookupImplicitSourceForOperation(name, params);
    }

    public EClassifier tryLookupClassifier(List<String> names) throws LookupException {
        EClassifier eClassifier;
        EClassifier eClassifier2;
        String metaModelId;
        Set<EPackage> contextPackages;
        if (names == null) {
            return null;
        }
        int namesSize = names.size();
        if (namesSize > 1 && (contextPackages = this.metaModelIdToPackages.get(metaModelId = names.get(0))) != null && !contextPackages.isEmpty() && (eClassifier2 = this.tryLookupClassifier(contextPackages, names.subList(1, namesSize))) != null) {
            return eClassifier2;
        }
        if (namesSize > 0 && this.allMetaModelPackages != null && !this.allMetaModelPackages.isEmpty() && (eClassifier = this.tryLookupClassifier(this.allMetaModelPackages, names)) != null) {
            return eClassifier;
        }
        return super.tryLookupClassifier(names);
    }

    public EOperation tryLookupOperation(EClassifier owner, String name, List<? extends TypedElement<EClassifier>> args) throws LookupException {
        Function query;
        if (owner == this.ast && (query = ((RelationalTransformation)this.ast).getFunction(name)) != null) {
            return query;
        }
        UMLReflection uml = this.getUMLReflection();
        owner = (EClassifier)uml.getOCLType((Object)owner);
        return super.tryLookupOperation(owner, name, args);
    }

    public EReference tryLookupOppositeProperty(EClass eClass, String propertyName) throws LookupException {
        List<EReference> references;
        if (this.oppositeFeaturesMap == null) {
            this.oppositeFeaturesMap = new HashMap<String, List<EReference>>();
            for (EPackage ePackage : this.allMetaModelPackages) {
                this.initializeFeatures(ePackage);
            }
        }
        if ((references = this.oppositeFeaturesMap.get(propertyName)) == null) {
            return null;
        }
        EReference oppositeReference = null;
        ArrayList<EReference> ambiguousReferences = null;
        for (EReference reference : references) {
            if (!reference.getEReferenceType().isSuperTypeOf(eClass)) continue;
            if (oppositeReference == null) {
                oppositeReference = reference;
                continue;
            }
            if (ambiguousReferences == null) {
                ambiguousReferences = new ArrayList<EReference>();
                ambiguousReferences.add(oppositeReference);
            }
            ambiguousReferences.add(reference);
        }
        if (ambiguousReferences != null) {
            throw new AmbiguousLookupException("Ambiguous property", ambiguousReferences);
        }
        return oppositeReference;
    }

    public EStructuralFeature tryLookupProperty(EClassifier owner, String name) throws LookupException {
        EStructuralFeature result = super.lookupOCLProperty(owner, name);
        if (result != null) {
            return result;
        }
        QVTrTopLevelEnvironment parent = (QVTrTopLevelEnvironment)this.getParentEnvironment();
        if (parent != null) {
            return (EStructuralFeature)parent.tryLookupProperty(owner, name);
        }
        return null;
    }
}

