/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.modelregistry.environment;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.emf.common.util.URI;
import org.eclipse.qvt.declarative.modelregistry.environment.AccessorKindRegistry;
import org.eclipse.qvt.declarative.modelregistry.environment.ModelContentRegistry;
import org.eclipse.qvt.declarative.modelregistry.environment.ModelSerializationRegistry;
import org.eclipse.qvt.declarative.modelregistry.standalone.StandaloneModelRegistryEnvironment;

public abstract class ModelRegistryEnvironment {
    public static final String PLUGIN_ID = "org.eclipse.qvt.declarative.modelregistry";
    private static ModelRegistryEnvironment INSTANCE = null;
    private AccessorKindRegistry accessorKindRegistry = null;
    private ModelContentRegistry modelContentRegistry = null;
    private ModelSerializationRegistry modelSerializationRegistry = null;

    public static ModelRegistryEnvironment getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new StandaloneModelRegistryEnvironment();
        }
        return INSTANCE;
    }

    public static void logError(String string, Throwable e) {
        ModelRegistryEnvironment.getInstance().logTheError(string, e);
    }

    protected ModelRegistryEnvironment() {
        INSTANCE = this;
    }

    protected AccessorKindRegistry createAccessorKindRegistry() {
        return new AccessorKindRegistry();
    }

    protected ModelContentRegistry createModelContentRegistry() {
        return new ModelContentRegistry();
    }

    protected ModelSerializationRegistry createModelSerializationRegistry() {
        return new ModelSerializationRegistry();
    }

    public AccessorKindRegistry getAccessorKindRegistry() {
        if (this.accessorKindRegistry == null) {
            this.accessorKindRegistry = this.createAccessorKindRegistry();
            this.initializeAccessorKindRegistry(this.accessorKindRegistry);
        }
        return this.accessorKindRegistry;
    }

    public File getFile(URI uri) throws URISyntaxException, IOException {
        String fileString = uri.toString();
        URL url = new URL(fileString);
        if (!"file".equals(url.getProtocol())) {
            return null;
        }
        return new File(url.toString().substring(5));
    }

    public ModelContentRegistry getModelContentRegistry() {
        if (this.modelContentRegistry == null) {
            this.modelContentRegistry = this.createModelContentRegistry();
            this.initializeModelContentRegistry(this.modelContentRegistry);
        }
        return this.modelContentRegistry;
    }

    public ModelSerializationRegistry getModelSerializationRegistry() {
        if (this.modelSerializationRegistry == null) {
            this.modelSerializationRegistry = this.createModelSerializationRegistry();
            this.initializeModelSerializationRegistry(this.modelSerializationRegistry);
        }
        return this.modelSerializationRegistry;
    }

    protected abstract void initializeAccessorKindRegistry(AccessorKindRegistry var1);

    protected abstract void initializeModelContentRegistry(ModelContentRegistry var1);

    protected abstract void initializeModelSerializationRegistry(ModelSerializationRegistry var1);

    public abstract void logTheError(String var1, Throwable var2);
}

