/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.creation;

import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.properties.ui.creation.EcorePropertyEditorFactory;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.properties.Activator;
import org.eclipse.papyrus.uml.tools.providers.UMLEClassLabelProvider;
import org.eclipse.swt.graphics.Image;

public class UMLPropertyEditorFactory
extends EcorePropertyEditorFactory {
    private UMLEClassLabelProvider provider = new UMLEClassLabelProvider();

    public UMLPropertyEditorFactory(EReference referenceIn) {
        super(referenceIn);
    }

    public Collection<Object> validateObjects(Collection<Object> objectsToValidate) {
        if (!this.referenceIn.isContainment()) {
            for (Object objectToValidate : objectsToValidate) {
                EcorePropertyEditorFactory.CreateIn creationInformation = (EcorePropertyEditorFactory.CreateIn)this.createIn.get(objectToValidate);
                if (creationInformation != null) {
                    this.set(creationInformation.createInObject, creationInformation.createInReference, objectToValidate);
                    continue;
                }
                Activator.log.warn("Unknown object : " + String.valueOf(objectToValidate));
            }
        }
        return objectsToValidate;
    }

    protected void set(EObject container, EReference reference, Object value) {
        try {
            EditingDomain domain = EMFHelper.resolveEditingDomain((EObject)container);
            if (domain == null) {
                container.eSet((EStructuralFeature)reference, value);
                return;
            }
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)container);
            if (provider != null) {
                SetRequest request = new SetRequest((TransactionalEditingDomain)domain, container, (EStructuralFeature)reference, value);
                ICommand createGMFCommand = provider.getEditCommand((IEditCommandRequest)request);
                GMFtoEMFCommandWrapper emfCommand = new GMFtoEMFCommandWrapper(createGMFCommand);
                domain.getCommandStack().execute((Command)emfCommand);
            }
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    protected Image getImage(EClass eClass) {
        return this.provider.getImage((Object)eClass);
    }
}

