/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class IOUtils {
    public static void close(Closeable is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void copyStream(InputStream is, OutputStream os) throws IOException {
        IOUtils.copyStream(is, os, true, true);
    }

    public static void copyStream(InputStream is, OutputStream os, boolean closeInput, boolean closeOutput) throws IOException {
        byte[] buffer = new byte[1024];
        try {
            int len;
            while ((len = is.read(buffer)) != -1) {
                os.write(buffer, 0, len);
            }
        }
        catch (Throwable throwable) {
            try {
                if (closeInput) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
            if (closeOutput) {
                os.close();
            }
            throw throwable;
        }
        try {
            if (closeInput) {
                is.close();
            }
        }
        catch (IOException iOException) {}
        if (closeOutput) {
            os.close();
        }
    }

    public static String readString(InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        IOUtils.copyStream(is, os);
        return new String(os.toByteArray());
    }

    public static void delete(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path directory, IOException exception) throws IOException {
                if (exception == null) {
                    Files.delete(directory);
                }
                return super.postVisitDirectory(directory, exception);
            }
        });
    }
}

