/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.utils.rules;

import java.util.function.BiFunction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class PreferenceRule<T>
implements TestRule {
    private final IPreferenceStore store;
    private final String key;
    private final T value;
    private T oldValue;
    private final BiFunction<IPreferenceStore, String, ? extends T> accessor;
    private final TriConsumer<IPreferenceStore, String, ? super T> mutator;

    private PreferenceRule(IPreferenceStore store, String key, T value, BiFunction<IPreferenceStore, String, ? extends T> accessor, TriConsumer<IPreferenceStore, String, ? super T> mutator) {
        this.store = store;
        this.key = key;
        this.value = value;
        this.accessor = accessor;
        this.mutator = mutator;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                PreferenceRule.this.setPreference(PreferenceRule.this.store, PreferenceRule.this.key);
                try {
                    base.evaluate();
                }
                finally {
                    PreferenceRule.this.restorePreference(PreferenceRule.this.store, PreferenceRule.this.key);
                }
            }
        };
    }

    protected void setPreference(IPreferenceStore store, String key) {
        this.oldValue = this.accessor.apply(store, key);
        this.mutator.accept(store, key, (IPreferenceStore)this.value);
    }

    protected void restorePreference(IPreferenceStore store, String key) {
        this.mutator.accept(store, key, (IPreferenceStore)this.oldValue);
    }

    public static final PreferenceRule<Boolean> create(IPreferenceStore store, String key, boolean value) {
        return new PreferenceRule<Boolean>(store, key, value, IPreferenceStore::getBoolean, IPreferenceStore::setValue);
    }

    public static final PreferenceRule<String> create(IPreferenceStore store, String key, String value) {
        return new PreferenceRule<String>(store, key, value, IPreferenceStore::getString, IPreferenceStore::setValue);
    }

    public static final PreferenceRule<Integer> create(IPreferenceStore store, String key, int value) {
        return new PreferenceRule<Integer>(store, key, value, IPreferenceStore::getInt, IPreferenceStore::setValue);
    }

    @FunctionalInterface
    private static interface TriConsumer<T, U, V> {
        public void accept(T var1, U var2, V var3);
    }
}

