/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.editor.welcome.internal.modelelements;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.papyrus.infra.core.language.ILanguage;
import org.eclipse.papyrus.infra.core.language.Version;
import org.eclipse.papyrus.infra.tools.databinding.ReferenceCountedObservable;
import org.eclipse.papyrus.infra.tools.databinding.TouchableValue;

public class LanguageObservable
extends ReferenceCountedObservable.Abstract {
    private final ILanguage language;
    private final TouchableValue<String> nameValue;
    private final TouchableValue<Version> versionValue;

    public LanguageObservable(ILanguage language) {
        this(Realm.getDefault(), language);
    }

    public LanguageObservable(Realm realm, ILanguage language) {
        super(realm);
        this.language = language;
        this.nameValue = new TouchableValue(realm, String.class, (Object)language.getName());
        this.versionValue = new TouchableValue(realm, Version.class, (Object)language.getVersion());
        IChangeListener rollup = new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                LanguageObservable.this.fireChange();
            }
        };
        this.nameValue.addChangeListener(rollup);
        this.versionValue.addChangeListener(rollup);
    }

    public synchronized void dispose() {
        this.nameValue.dispose();
        this.versionValue.dispose();
        super.dispose();
    }

    public IObservableValue<String> getName() {
        return this.nameValue;
    }

    public IObservableValue<Version> getVersion() {
        return this.versionValue;
    }

    public boolean isStale() {
        return false;
    }

    ILanguage getLanguage() {
        return this.language;
    }
}

