/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.stereotype.edition.internal.edithelper.advice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayUtil;
import org.eclipse.uml2.uml.Element;

public class AppliedStereotypeNotationDependentsAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getAfterDestroyDependentsCommand(DestroyDependentsRequest request) {
        Collection<View> appliedStereotypeViews;
        ICommand result = super.getAfterDestroyDependentsCommand(request);
        EObject element = request.getElementToDestroy();
        if (element instanceof Element && !(appliedStereotypeViews = this.getAppliedStereotypeViews(element)).isEmpty()) {
            ICommand destroy = request.getDestroyDependentsCommand(appliedStereotypeViews);
            result = result == null ? destroy : result.compose((IUndoableOperation)destroy);
        }
        return result;
    }

    protected Collection<View> getAppliedStereotypeViews(EObject object) {
        ArrayList result = null;
        List views = DiagramEditPartsUtil.getEObjectViews((EObject)object);
        if (!views.isEmpty()) {
            result = new ArrayList(views.size() * 3 * 3 / 2);
            this.collectAppliedStereotypeViews(new LinkedList<View>(views), result, StereotypeDisplayUtil.getInstance());
        }
        return result == null ? Collections.emptyList() : result;
    }

    protected void collectAppliedStereotypeViews(Queue<View> views, Collection<? super View> result, StereotypeDisplayUtil helper) {
        View next = views.poll();
        while (next != null) {
            Node comment = helper.getStereotypeComment(next);
            if (comment != null) {
                result.add((View)comment);
                result.addAll((Collection<? super View>)comment.getSourceEdges());
                result.addAll((Collection<? super View>)comment.getTargetEdges());
            }
            views.addAll((Collection<View>)next.getChildren());
            next = views.poll();
        }
    }
}

