/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.tests;

import org.eclipse.net4j.util.collection.ConcurrentArray;
import org.eclipse.net4j.util.tests.AbstractOMTest;

public class FastListTest
extends AbstractOMTest {
    public static void testAddFirst() throws Exception {
        TestList list = new TestList();
        list.add(5);
        Integer[] result = (Integer[])list.get();
        FastListTest.assertEquals((boolean)true, (result != null ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result.length == 1 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (list.getElements().length == 1 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (!list.isEmpty() ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (list.added == 1 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (list.removed == 0 ? 1 : 0) != 0);
    }

    public static void testAddSecond() throws Exception {
        TestList list = new TestList();
        list.add(5);
        list.add(7);
        Integer[] result = (Integer[])list.get();
        FastListTest.assertEquals((boolean)true, (result != null ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result.length == 2 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (list.getElements().length == 2 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (!list.isEmpty() ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (list.added == 1 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (list.removed == 0 ? 1 : 0) != 0);
    }

    public static void testRemoveHead() throws Exception {
        TestList list = new TestList();
        list.add(5);
        list.add(7);
        list.add(2);
        list.add(9);
        list.add(1);
        list.add(4);
        list.add(8);
        Integer[] old = list.reset();
        boolean removed = list.remove(5);
        Integer[] result = (Integer[])list.get();
        FastListTest.assertEquals((boolean)true, (boolean)removed);
        FastListTest.assertEquals((boolean)true, (result != null ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result != old ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result.length == 6 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (list.getElements().length == 6 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (!list.isEmpty() ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (list.added == 0 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (list.removed == 0 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result[0] == 7 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result[1] == 2 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result[2] == 9 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result[3] == 1 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result[4] == 4 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result[5] == 8 ? 1 : 0) != 0);
    }

    public static void testRemoveMiddle() throws Exception {
        TestList list = new TestList();
        list.add(5);
        list.add(7);
        list.add(2);
        list.add(9);
        list.add(1);
        list.add(4);
        list.add(8);
        Integer[] old = list.reset();
        boolean removed = list.remove(9);
        Integer[] result = (Integer[])list.get();
        FastListTest.assertEquals((boolean)true, (boolean)removed);
        FastListTest.assertEquals((boolean)true, (result != null ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result != old ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result.length == 6 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (list.getElements().length == 6 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (!list.isEmpty() ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (list.added == 0 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (list.removed == 0 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result[0] == 5 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result[1] == 7 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result[2] == 2 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result[3] == 1 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result[4] == 4 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result[5] == 8 ? 1 : 0) != 0);
    }

    public void testRemoveMiddleOfThree() {
        TestList list = new TestList();
        Integer one = 1;
        Integer two = 2;
        Integer three = 3;
        list.add(one);
        list.add(two);
        list.add(three);
        list.remove(two);
        Integer[] elements = (Integer[])list.get();
        FastListTest.assertSame((Object)one, (Object)elements[0]);
        FastListTest.assertSame((Object)three, (Object)elements[1]);
    }

    public static void testRemoveTail() throws Exception {
        TestList list = new TestList();
        list.add(5);
        list.add(7);
        list.add(2);
        list.add(9);
        list.add(1);
        list.add(4);
        list.add(8);
        Integer[] old = list.reset();
        boolean removed = list.remove(8);
        Integer[] result = (Integer[])list.get();
        FastListTest.assertEquals((boolean)true, (boolean)removed);
        FastListTest.assertEquals((boolean)true, (result != old ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result != null ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result.length == 6 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (list.getElements().length == 6 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (!list.isEmpty() ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (list.added == 0 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (list.removed == 0 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result[0] == 5 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result[1] == 7 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result[2] == 2 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result[3] == 9 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result[4] == 1 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result[5] == 4 ? 1 : 0) != 0);
    }

    public static void testRemoveLast() throws Exception {
        TestList list = new TestList();
        list.add(5);
        list.add(7);
        Integer[] old = list.reset();
        boolean removed1 = list.remove(7);
        boolean removed2 = list.remove(5);
        Integer[] result = (Integer[])list.get();
        FastListTest.assertEquals((boolean)true, (boolean)removed1);
        FastListTest.assertEquals((boolean)true, (boolean)removed2);
        FastListTest.assertEquals((boolean)true, (result != old ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result == null ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (list.getElements() == null ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (boolean)list.isEmpty());
        FastListTest.assertEquals((boolean)true, (list.added == 0 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (list.removed == 1 ? 1 : 0) != 0);
    }

    public static void testNotFoundInMany() throws Exception {
        TestList list = new TestList();
        list.add(5);
        list.add(7);
        list.add(2);
        list.add(9);
        list.add(1);
        list.add(4);
        list.add(8);
        Integer[] old = list.reset();
        boolean removed = list.remove(10);
        Integer[] result = (Integer[])list.get();
        FastListTest.assertEquals((boolean)true, (!removed ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result != null ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result == old ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result.length == 7 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (list.getElements().length == 7 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (!list.isEmpty() ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (list.added == 0 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (list.removed == 0 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result[0] == 5 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result[1] == 7 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result[2] == 2 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result[3] == 9 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result[4] == 1 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result[5] == 4 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result[6] == 8 ? 1 : 0) != 0);
    }

    public static void testNotFoundInOne() throws Exception {
        TestList list = new TestList();
        list.add(5);
        Integer[] old = list.reset();
        boolean removed = list.remove(10);
        Integer[] result = (Integer[])list.get();
        FastListTest.assertEquals((boolean)true, (!removed ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result != null ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result == old ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result.length == 1 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (list.getElements().length == 1 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (!list.isEmpty() ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (list.added == 0 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (list.removed == 0 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result[0] == 5 ? 1 : 0) != 0);
    }

    public static void testNotFoundInEmpty() throws Exception {
        TestList list = new TestList();
        Integer[] old = list.reset();
        boolean removed = list.remove(10);
        Integer[] result = (Integer[])list.get();
        FastListTest.assertEquals((boolean)true, (!removed ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result == null ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (result == old ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (boolean)list.isEmpty());
        FastListTest.assertEquals((boolean)true, (list.added == 0 ? 1 : 0) != 0);
        FastListTest.assertEquals((boolean)true, (list.removed == 0 ? 1 : 0) != 0);
    }

    public static class TestList
    extends ConcurrentArray<Integer> {
        public int added;
        public int removed;

        public Integer[] getElements() {
            return (Integer[])this.elements;
        }

        public Integer[] reset() {
            this.added = 0;
            this.removed = 0;
            return (Integer[])this.elements;
        }

        protected Integer[] newArray(int length) {
            return new Integer[length];
        }

        protected void firstElementAdded() {
            ++this.added;
        }

        protected void lastElementRemoved() {
            ++this.removed;
        }
    }
}

