/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.context;

import java.util.HashSet;
import java.util.Stack;
import org.apache.derby.iapi.security.SecurityUtil;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.SystemContext;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.shared.common.error.ShutdownException;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derby.shared.common.stream.HeaderPrintWriter;

public final class ContextService {
    private static ContextService factory;
    private HeaderPrintWriter errorStream;
    private ThreadLocal<Object> threadContextList = new ThreadLocal();
    private HashSet<ContextManager> allContexts;

    public ContextService() {
        this.errorStream = Monitor.getStream();
        factory = this;
        this.allContexts = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        SecurityUtil.checkDerbyInternalsPrivilege();
        ContextService fact = factory;
        if (fact != null) {
            ContextService contextService = fact;
            synchronized (contextService) {
                fact.allContexts = null;
                fact.threadContextList = null;
                factory = null;
            }
        }
    }

    public static ContextService getFactory() {
        SecurityUtil.checkDerbyInternalsPrivilege();
        ContextService csf = factory;
        if (csf == null) {
            throw new ShutdownException();
        }
        return csf;
    }

    public static Context getContext(String contextId) {
        SecurityUtil.checkDerbyInternalsPrivilege();
        ContextManager cm = ContextService.getFactory().getCurrentContextManager();
        if (cm == null) {
            return null;
        }
        return cm.getContext(contextId);
    }

    public static Context getContextOrNull(String contextId) {
        SecurityUtil.checkDerbyInternalsPrivilege();
        ContextService csf = factory;
        if (csf == null) {
            return null;
        }
        ContextManager cm = csf.getCurrentContextManager();
        if (cm == null) {
            return null;
        }
        return cm.getContext(contextId);
    }

    public ContextManager getCurrentContextManager() {
        ThreadLocal<Object> tcl = this.threadContextList;
        if (tcl == null) {
            return null;
        }
        Object list = tcl.get();
        if (list instanceof ContextManager) {
            Thread me = Thread.currentThread();
            ContextManager cm = (ContextManager)list;
            if (cm.activeThread == me) {
                return cm;
            }
            return null;
        }
        if (list == null) {
            return null;
        }
        return (ContextManager)((ContextManagerStack)list).peek();
    }

    public void resetCurrentContextManager(ContextManager cm) {
        ThreadLocal<Object> tcl = this.threadContextList;
        if (tcl == null) {
            return;
        }
        if (Thread.currentThread() != cm.activeThread) {
            SanityManager.THROWASSERT("resetCurrentContextManager - mismatch threads - current" + Thread.currentThread() + " - cm's " + cm.activeThread);
        }
        if (this.getCurrentContextManager() != cm) {
            SanityManager.THROWASSERT("resetCurrentContextManager - mismatch contexts - " + Thread.currentThread());
        }
        if (cm.activeCount < -1) {
            SanityManager.THROWASSERT("resetCurrentContextManager - invalid count - current" + Thread.currentThread() + " - count " + cm.activeCount);
        }
        if (cm.activeCount == 0) {
            SanityManager.THROWASSERT("resetCurrentContextManager - invalid count - current" + Thread.currentThread() + " - count " + cm.activeCount);
        }
        if (cm.activeCount > 0 && tcl.get() != cm) {
            SanityManager.THROWASSERT("resetCurrentContextManager - invalid thread local " + Thread.currentThread() + " - object " + tcl.get());
        }
        if (cm.activeCount != -1) {
            if (--cm.activeCount == 0) {
                cm.activeThread = null;
                if (cm.isEmpty()) {
                    tcl.set(null);
                }
            }
            return;
        }
        ContextManagerStack stack = (ContextManagerStack)tcl.get();
        stack.pop();
        ContextManager nextCM = (ContextManager)stack.peek();
        boolean seenMultipleCM = false;
        boolean seenCM = false;
        for (ContextManager stackCM : stack) {
            if (stackCM != nextCM) {
                seenMultipleCM = true;
            }
            if (stackCM != cm) continue;
            seenCM = true;
        }
        if (!seenCM) {
            cm.activeThread = null;
            cm.activeCount = 0;
        }
        if (!seenMultipleCM) {
            nextCM.activeCount = stack.size();
            tcl.set(nextCM);
        }
    }

    private boolean addToThreadList(Thread me, ContextManager associateCM) {
        ContextManagerStack stack;
        ThreadLocal<Object> tcl = this.threadContextList;
        if (tcl == null) {
            return false;
        }
        Object list = tcl.get();
        if (associateCM == list) {
            return true;
        }
        if (list == null) {
            tcl.set(associateCM);
            return true;
        }
        if (list instanceof ContextManager) {
            ContextManager threadsCM = (ContextManager)list;
            if (me == null) {
                me = Thread.currentThread();
            }
            if (threadsCM.activeThread != me) {
                tcl.set(associateCM);
                return true;
            }
            stack = new ContextManagerStack();
            tcl.set(stack);
            for (int i = 0; i < threadsCM.activeCount; ++i) {
                stack.push(threadsCM);
            }
            threadsCM.activeCount = -1;
        } else {
            stack = (ContextManagerStack)list;
        }
        stack.push(associateCM);
        associateCM.activeCount = -1;
        if (SanityManager.DEBUG_ON("memoryLeakTrace") && stack.size() > 10) {
            System.out.println("memoryLeakTrace:ContextService:threadLocal " + stack.size());
        }
        return false;
    }

    public void setCurrentContextManager(ContextManager cm) {
        Thread me = Thread.currentThread();
        if (cm.activeThread != null && me != cm.activeThread) {
            SanityManager.THROWASSERT("setCurrentContextManager - mismatch threads - current " + me + " - cm's " + cm.activeThread);
        }
        me = null;
        if (cm.activeThread == null) {
            cm.activeThread = me = Thread.currentThread();
        }
        if (this.addToThreadList(me, cm)) {
            ++cm.activeCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextManager newContextManager() {
        ContextManager cm = new ContextManager(this, this.errorStream);
        new SystemContext(cm);
        ContextService contextService = this;
        synchronized (contextService) {
            this.allContexts.add(cm);
            if (SanityManager.DEBUG_ON("memoryLeakTrace") && this.allContexts.size() > 50) {
                System.out.println("memoryLeakTrace:ContextService:allContexts " + this.allContexts.size());
            }
        }
        return cm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAllActiveThreads(Context c) {
        Thread me = Thread.currentThread();
        ContextService contextService = this;
        synchronized (contextService) {
            for (ContextManager cm : this.allContexts) {
                Thread active = cm.activeThread;
                if (active == me || active == null) continue;
                Thread fActive = active;
                if (!cm.setInterrupted(c)) continue;
                fActive.interrupt();
            }
        }
    }

    synchronized void removeContext(ContextManager cm) {
        if (this.allContexts != null) {
            this.allContexts.remove(cm);
        }
    }

    private static class ContextManagerStack
    extends Stack<ContextManager> {
        private ContextManagerStack() {
        }
    }
}

