/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Vector;
import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.impl.sql.execute.rts.RealNoPutResultSetStatistics;
import org.apache.derby.shared.common.i18n.MessageService;

public class RealOnceResultSetStatistics
extends RealNoPutResultSetStatistics {
    public int subqueryNumber;
    public int pointOfAttachment;
    public ResultSetStatistics childResultSetStatistics;

    public RealOnceResultSetStatistics(int numOpens, int rowsSeen, int rowsFiltered, long constructorTime, long openTime, long nextTime, long closeTime, int resultSetNumber, int subqueryNumber, int pointOfAttachment, double optimizerEstimatedRowCount, double optimizerEstimatedCost, ResultSetStatistics childResultSetStatistics) {
        super(numOpens, rowsSeen, rowsFiltered, constructorTime, openTime, nextTime, closeTime, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.subqueryNumber = subqueryNumber;
        this.pointOfAttachment = pointOfAttachment;
        this.childResultSetStatistics = childResultSetStatistics;
    }

    @Override
    public String getStatementExecutionPlanText(int depth) {
        String attachmentString = this.pointOfAttachment == -1 ? ":" : MessageService.getTextMessage("43X00.U", new Object[0]) + " " + this.pointOfAttachment + "):";
        this.initFormatInfo(depth);
        return this.indent + MessageService.getTextMessage("43X01.U", new Object[0]) + " " + this.subqueryNumber + "\n" + this.indent + MessageService.getTextMessage("43X92.U", new Object[0]) + attachmentString + "\n" + this.indent + MessageService.getTextMessage("43X03.U", new Object[0]) + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage("43X04.U", new Object[0]) + " = " + this.rowsSeen + "\n" + this.indent + MessageService.getTextMessage("43X05.U", new Object[0]) + ":\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + this.dumpEstimatedCosts(this.subIndent) + "\n" + this.childResultSetStatistics.getStatementExecutionPlanText(this.sourceDepth) + "\n" + this.indent + MessageService.getTextMessage("43X06.U", new Object[0]) + " " + this.subqueryNumber + "\n";
    }

    @Override
    public String getScanStatisticsText(String tableName, int depth) {
        return this.childResultSetStatistics.getScanStatisticsText(tableName, depth);
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    @Override
    public Vector<ResultSetStatistics> getChildren() {
        Vector<ResultSetStatistics> children = new Vector<ResultSetStatistics>();
        children.addElement(this.childResultSetStatistics);
        return children;
    }

    @Override
    public String getNodeName() {
        return MessageService.getTextMessage("43X92.U", new Object[0]);
    }

    @Override
    public void accept(XPLAINVisitor visitor) {
        int noChildren = 0;
        if (this.childResultSetStatistics != null) {
            ++noChildren;
        }
        visitor.setNumberOfChildren(noChildren);
        visitor.visit(this);
        if (this.childResultSetStatistics != null) {
            this.childResultSetStatistics.accept(visitor);
        }
    }

    @Override
    public String getRSXplainType() {
        return "ONCE";
    }

    @Override
    public String getRSXplainDetails() {
        String attachmentString = this.pointOfAttachment == -1 ? "" : "ATTACHED:" + this.pointOfAttachment;
        return attachmentString + ";" + this.resultSetNumber;
    }
}

