/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.signal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.buffer.BufferInputStream;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.buffer.IBufferProvider;
import org.eclipse.net4j.channel.ChannelOutputStream;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.signal.AcknowledgeCompressedStringsIndication;
import org.eclipse.net4j.signal.AcknowledgeCompressedStringsRequest;
import org.eclipse.net4j.signal.EntityIndication;
import org.eclipse.net4j.signal.ISignalProtocol;
import org.eclipse.net4j.signal.IndicationWithResponse;
import org.eclipse.net4j.signal.MonitorCanceledIndication;
import org.eclipse.net4j.signal.MonitorProgressIndication;
import org.eclipse.net4j.signal.RemoteExceptionIndication;
import org.eclipse.net4j.signal.RequestWithConfirmation;
import org.eclipse.net4j.signal.SetTimeoutIndication;
import org.eclipse.net4j.signal.SetTimeoutRequest;
import org.eclipse.net4j.signal.Signal;
import org.eclipse.net4j.signal.SignalActor;
import org.eclipse.net4j.signal.SignalFinishedEvent;
import org.eclipse.net4j.signal.SignalReactor;
import org.eclipse.net4j.signal.SignalScheduledEvent;
import org.eclipse.net4j.util.ExceptionHandler;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.Entity;
import org.eclipse.net4j.util.container.IManagedContainerProvider;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.io.IStreamWrapper;
import org.eclipse.net4j.util.io.StreamWrapperChain;
import org.eclipse.net4j.util.io.StringCompressor;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.spi.net4j.Protocol;

public class SignalProtocol<INFRA_STRUCTURE>
extends Protocol<INFRA_STRUCTURE>
implements ISignalProtocol.WithSignalCounters<INFRA_STRUCTURE>,
Entity.Store.Provider {
    public static final long COMPRESSED_STRINGS_ACKNOWLEDGE_TIMEOUT = OMPlatform.INSTANCE.getProperty("org.eclipse.net4j.signal.COMPRESSED_STRINGS_ACKNOWLEDGE_TIMEOUT", 5000L);
    public static final short SIGNAL_REMOTE_EXCEPTION = -1;
    public static final short SIGNAL_MONITOR_CANCELED = -2;
    public static final short SIGNAL_MONITOR_PROGRESS = -3;
    public static final short SIGNAL_SET_TIMEOUT = -4;
    public static final short SIGNAL_ACKNOWLEDGE_COMPRESSED_STRINGS = -5;
    public static final short SIGNAL_ENTITY = -6;
    private static final int BOS_BIT = 1;
    private static final int BOS_MASK = -2;
    private static final int INC_CORRELATION_ID = 2;
    private static final int MIN_CORRELATION_ID = 2;
    private static final int MAX_CORRELATION_ID = 0x7FFFFFFE;
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_SIGNAL, SignalProtocol.class);
    private static boolean testing;
    private long timeout = 10000L;
    private IStreamWrapper streamWrapper;
    private Map<Integer, Signal> signals = new HashMap<Integer, Signal>();
    private int nextCorrelationID = 2;
    private boolean failingOver;
    private AtomicLong sentSignals = new AtomicLong();
    private AtomicLong receivedSignals = new AtomicLong();

    public SignalProtocol(String type) {
        super(type);
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(long timeout) {
        this.setTimeout(timeout, false);
    }

    public boolean setTimeout(long timeout, boolean useOldTimeoutToSendNewOne) {
        boolean timeoutSent = false;
        long oldTimeout = this.timeout;
        if (!useOldTimeoutToSendNewOne) {
            this.handleSetTimeOut(timeout);
        }
        if (oldTimeout != timeout && this.isActive()) {
            timeoutSent = this.sendSetTimeout();
        }
        if (timeoutSent && useOldTimeoutToSendNewOne) {
            this.handleSetTimeOut(timeout);
        }
        return timeoutSent;
    }

    @Override
    public IStreamWrapper getStreamWrapper() {
        return this.streamWrapper;
    }

    @Override
    public void setStreamWrapper(IStreamWrapper streamWrapper) {
        this.streamWrapper = streamWrapper;
    }

    @Override
    public void addStreamWrapper(IStreamWrapper streamWrapper) {
        this.streamWrapper = this.streamWrapper == null ? streamWrapper : new StreamWrapperChain(streamWrapper, this.streamWrapper);
    }

    public Entity.Store getEntityStore() {
        Object infraStructure = this.getInfraStructure();
        return Entity.Store.of(infraStructure);
    }

    @Override
    public long getSentSignals() {
        return this.sentSignals.get();
    }

    @Override
    public long getReceivedSignals() {
        return this.receivedSignals.get();
    }

    @Override
    public IChannel open(IConnector connector) {
        return connector.openChannel(this);
    }

    @Override
    public void close() {
        LifecycleUtil.deactivate((Object)this, (OMLogger.Level)OMLogger.Level.DEBUG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitForSignals(long timeout) {
        Map<Integer, Signal> map = this.signals;
        synchronized (map) {
            while (!this.signals.isEmpty()) {
                try {
                    this.signals.wait(timeout);
                }
                catch (InterruptedException ex) {
                    return false;
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleBuffer(IBuffer buffer) {
        ByteBuffer byteBuffer = buffer.getByteBuffer();
        int correlationID = byteBuffer.getInt();
        boolean beginOfSignal = false;
        if ((correlationID & 1) != 0) {
            correlationID &= 0xFFFFFFFE;
            beginOfSignal = true;
            if (TRACER.isEnabled()) {
                TRACER.trace("Received first buffer for correlation " + correlationID);
            }
        } else if (TRACER.isEnabled()) {
            TRACER.trace("Received buffer for correlation " + correlationID);
        }
        Signal signal = null;
        boolean newSignalScheduled = false;
        Map<Integer, Signal> map = this.signals;
        synchronized (map) {
            if (correlationID > 0) {
                if (beginOfSignal) {
                    short signalID = byteBuffer.getShort();
                    if (TRACER.isEnabled()) {
                        TRACER.trace("Got signalID: " + signalID);
                    }
                    if ((signal = this.provideSignalReactor(signalID)) != null) {
                        signal.setCorrelationID(-correlationID);
                        signal.setBufferInputStream(new SignalInputStream(this.getTimeout()));
                        if (signal instanceof IndicationWithResponse) {
                            signal.setBufferOutputStream(new SignalOutputStream(-correlationID, signalID, false));
                        }
                        this.signals.put(-correlationID, signal);
                        this.getExecutorService().execute(signal);
                        newSignalScheduled = true;
                    }
                } else {
                    signal = this.signals.get(-correlationID);
                }
            } else {
                signal = this.signals.get(-correlationID);
            }
        }
        if (signal != null) {
            if (newSignalScheduled) {
                this.fireSignalScheduledEvent(signal);
            }
            BufferInputStream inputStream = signal.getBufferInputStream();
            inputStream.handleBuffer(buffer);
        } else {
            if (TRACER.isEnabled()) {
                TRACER.trace("Discarding buffer");
            }
            buffer.release();
        }
    }

    public String toString() {
        IChannel channel = this.getChannel();
        if (channel != null) {
            return MessageFormat.format("SignalProtocol[{0}, {1}, {2}]", new Object[]{channel.getID(), channel.getLocation(), this.getType()});
        }
        return MessageFormat.format("SignalProtocol[{0}]", this.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doBeforeDeactivate() throws Exception {
        if (!testing) {
            Map<Integer, Signal> map = this.signals;
            synchronized (map) {
                int waitMillis = 10000;
                long stop = System.currentTimeMillis() + (long)waitMillis;
                while (!this.signals.isEmpty() && System.currentTimeMillis() < stop) {
                    this.signals.wait(1000L);
                }
            }
        }
        super.doBeforeDeactivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDeactivate() throws Exception {
        try {
            Map<Integer, Signal> map = this.signals;
            synchronized (map) {
                this.signals.clear();
            }
            IChannel channel = this.getChannel();
            if (channel != null) {
                channel.close();
                this.setChannel(null);
            }
        }
        finally {
            super.doDeactivate();
        }
    }

    @Override
    protected void handleChannelDeactivation() {
        if (!this.failingOver) {
            super.handleChannelDeactivation();
        }
    }

    protected final SignalReactor provideSignalReactor(short signalID) {
        if (!this.isActive()) {
            return null;
        }
        switch (signalID) {
            case -1: {
                return new RemoteExceptionIndication(this);
            }
            case -2: {
                return new MonitorCanceledIndication(this);
            }
            case -3: {
                return new MonitorProgressIndication(this);
            }
            case -4: {
                return new SetTimeoutIndication(this);
            }
            case -5: {
                return new AcknowledgeCompressedStringsIndication(this);
            }
        }
        this.checkStringCompressorAcknowledgements();
        SignalReactor signal = this.createSignalReactor(signalID);
        if (signal == null) {
            throw new InvalidSignalIDException(signalID);
        }
        return signal;
    }

    protected SignalReactor createSignalReactor(short signalID) {
        if (signalID == -6) {
            return new EntityIndication(this);
        }
        return null;
    }

    protected boolean isSendingTimeoutChanges() {
        return true;
    }

    protected StringCompressor getStringCompressor() {
        return null;
    }

    synchronized int getNextCorrelationID() {
        int correlationID = this.nextCorrelationID;
        if (this.nextCorrelationID == 0x7FFFFFFE) {
            if (TRACER.isEnabled()) {
                TRACER.trace("Correlation ID wrap-around");
            }
            this.nextCorrelationID = 2;
        } else {
            this.nextCorrelationID += 2;
        }
        return correlationID;
    }

    InputStream wrapInputStream(InputStream in) throws IOException {
        if (this.streamWrapper != null) {
            in = this.streamWrapper.wrapInputStream(in);
        }
        return in;
    }

    OutputStream wrapOutputStream(OutputStream out) throws IOException {
        if (this.streamWrapper != null) {
            out = this.streamWrapper.wrapOutputStream(out);
        }
        return out;
    }

    void finishInputStream(InputStream in) throws IOException {
        if (this.streamWrapper != null) {
            this.streamWrapper.finishInputStream(in);
        }
    }

    void finishOutputStream(OutputStream out) throws IOException {
        if (this.streamWrapper != null) {
            this.streamWrapper.finishOutputStream(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startSignal(SignalActor signalActor, long timeout) throws Exception {
        this.checkArg(signalActor.getProtocol() == this, "Wrong protocol");
        short signalID = signalActor.getID();
        int correlationID = signalActor.getCorrelationID();
        signalActor.setBufferOutputStream(new SignalOutputStream(correlationID, signalID, true));
        if (signalActor instanceof RequestWithConfirmation) {
            signalActor.setBufferInputStream(new SignalInputStream(timeout));
        }
        Map<Integer, Signal> map = this.signals;
        synchronized (map) {
            this.signals.put(correlationID, signalActor);
        }
        this.fireSignalScheduledEvent(signalActor);
        signalActor.runSync();
        this.checkStringCompressorAcknowledgements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopSignal(Signal signal, Exception exception) {
        int correlationID = signal.getCorrelationID();
        Map<Integer, Signal> map = this.signals;
        synchronized (map) {
            this.signals.remove(correlationID);
            this.signals.notifyAll();
        }
        this.fireSignalFinishedEvent(signal, exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleRemoteException(int correlationID, Throwable t, boolean responding) {
        Map<Integer, Signal> map = this.signals;
        synchronized (map) {
            Signal signal = this.signals.remove(correlationID);
            if (signal instanceof RequestWithConfirmation) {
                RequestWithConfirmation request = (RequestWithConfirmation)signal;
                request.setRemoteException(t, responding);
            }
            this.signals.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleMonitorProgress(int correlationID, double totalWork, double work) {
        Map<Integer, Signal> map = this.signals;
        synchronized (map) {
            Signal signal = this.signals.get(correlationID);
            if (signal instanceof SignalActor) {
                ((SignalActor)signal).setMonitorProgress(totalWork, work);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleMonitorCanceled(int correlationID) {
        Map<Integer, Signal> map = this.signals;
        synchronized (map) {
            Signal signal = this.signals.get(-correlationID);
            if (signal instanceof SignalReactor) {
                ((SignalReactor)signal).setMonitorCanceled();
            }
        }
    }

    void handleSetTimeOut(long timeout) {
        long oldTimeout = this.timeout;
        if (oldTimeout != timeout) {
            this.timeout = timeout;
            this.fireEvent((IEvent)new TimeoutChangedEvent(this, oldTimeout, timeout));
        }
    }

    boolean sendSetTimeout() {
        boolean timeoutSent = false;
        if (this.isSendingTimeoutChanges()) {
            try {
                timeoutSent = (Boolean)new SetTimeoutRequest(this, this.timeout).send();
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }
        return timeoutSent;
    }

    private void checkStringCompressorAcknowledgements() {
        Collection acknowledgements;
        StringCompressor compressor = this.getStringCompressor();
        if (compressor != null && (acknowledgements = compressor.getPendingAcknowledgements(COMPRESSED_STRINGS_ACKNOWLEDGE_TIMEOUT)) != null) {
            try {
                new AcknowledgeCompressedStringsRequest(this, acknowledgements).sendAsync();
            }
            catch (Exception ex) {
                ExceptionHandler.Factory.handle((IManagedContainerProvider)this, (Throwable)ex, (String)"AcknowledgeCompressedStringsRequest failed", (OMLogger)OM.LOG);
            }
        }
    }

    private void fireSignalScheduledEvent(Signal signal) {
        signal.scheduled = System.currentTimeMillis();
        IListener[] listeners = this.getListeners();
        if (listeners.length != 0) {
            this.fireEvent((IEvent)new SignalScheduledEvent(this, signal), listeners);
        }
    }

    private void fireSignalFinishedEvent(Signal signal, Exception exception) {
        if (signal instanceof SignalActor) {
            this.sentSignals.incrementAndGet();
        } else if (signal instanceof SignalReactor) {
            this.receivedSignals.incrementAndGet();
        }
        IListener[] listeners = this.getListeners();
        if (listeners.length != 0) {
            this.fireEvent((IEvent)new SignalFinishedEvent(this, signal, exception), listeners);
        }
    }

    public static final class InvalidSignalIDException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;
        private final short signalID;

        public InvalidSignalIDException(short signalID) {
            super("Invalid signal ID " + signalID);
            this.signalID = signalID;
        }

        public short getSignalID() {
            return this.signalID;
        }
    }

    class SignalInputStream
    extends BufferInputStream {
        private long timeout;

        public SignalInputStream(long timeout) {
            this.timeout = timeout;
        }

        @Override
        public long getMillisBeforeTimeout() {
            return this.timeout;
        }

        @Override
        protected void closeChannel() {
            IChannel channel = SignalProtocol.this.getChannel();
            LifecycleUtil.deactivate((Object)channel);
        }
    }

    class SignalOutputStream
    extends ChannelOutputStream {
        public SignalOutputStream(final int correlationID, final short signalID, boolean request) {
            super(SignalProtocol.this.getChannel(), new IBufferProvider(request){
                private IBufferProvider delegate;
                private boolean beginOfSignal;
                private boolean addSignalID;
                {
                    this.delegate = SignalProtocol.this.getBufferProvider();
                    this.beginOfSignal = true;
                    this.addSignalID = bl;
                }

                @Override
                public short getBufferCapacity() {
                    return this.delegate.getBufferCapacity();
                }

                @Override
                public IBuffer provideBuffer() {
                    IChannel channel = SignalProtocol.this.getChannel();
                    if (channel == null) {
                        throw new IORuntimeException("No channel for protocol " + SignalProtocol.this);
                    }
                    IBuffer buffer = this.delegate.provideBuffer();
                    ByteBuffer byteBuffer = buffer.startPutting(channel.getID());
                    if (this.beginOfSignal) {
                        byteBuffer.putInt(correlationID | 1);
                        this.beginOfSignal = false;
                        if (this.addSignalID) {
                            byteBuffer.putShort(signalID);
                            this.addSignalID = false;
                        }
                    } else {
                        byteBuffer.putInt(correlationID);
                    }
                    return buffer;
                }

                @Override
                public void retainBuffer(IBuffer buffer) {
                    this.delegate.retainBuffer(buffer);
                }
            });
        }
    }

    public static final class TimeoutChangedEvent
    extends Event {
        private static final long serialVersionUID = 1L;
        private long oldTimeout;
        private long newTimeout;

        private TimeoutChangedEvent(ISignalProtocol<?> source, long oldTimeout, long newTimeout) {
            super(source);
            this.oldTimeout = oldTimeout;
            this.newTimeout = newTimeout;
        }

        public SignalProtocol<?> getSource() {
            return (SignalProtocol)super.getSource();
        }

        public long getOldTimeout() {
            return this.oldTimeout;
        }

        public long getNewTimeout() {
            return this.newTimeout;
        }

        public String toString() {
            return "TimeoutChangedEvent [oldTimeout=" + this.oldTimeout + ", newTimeout=" + this.newTimeout + ", source=" + this.source + "]";
        }
    }
}

