/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.tests.config;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.function.Supplier;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jetty.ee8.servlet.ServletContextHandler;
import org.eclipse.jetty.ee8.servlet.ServletHolder;
import org.eclipse.jetty.ee8.websocket.server.config.JettyWebSocketServletContainerInitializer;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.net4j.acceptor.IAcceptor;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.internal.tcp.TCPConnector;
import org.eclipse.net4j.internal.tcp.ssl.SSLConnector;
import org.eclipse.net4j.internal.ws.WSConnector;
import org.eclipse.net4j.jvm.IJVMAcceptor;
import org.eclipse.net4j.jvm.IJVMConnector;
import org.eclipse.net4j.jvm.JVMUtil;
import org.eclipse.net4j.tcp.ITCPAcceptor;
import org.eclipse.net4j.tcp.ITCPConnector;
import org.eclipse.net4j.tcp.TCPUtil;
import org.eclipse.net4j.tcp.ssl.SSLUtil;
import org.eclipse.net4j.tests.bundle.OM;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.ws.IWSAcceptor;
import org.eclipse.net4j.ws.IWSConnector;
import org.eclipse.net4j.ws.WSUtil;
import org.eclipse.net4j.ws.jetty.Net4jWebSocketServlet;
import org.eclipse.net4j.wss.WSSUtil;

public abstract class TestConfig {
    public abstract boolean needsSeparateContainers();

    public abstract void prepareContainer(IManagedContainer var1);

    public IAcceptor getAcceptor(IManagedContainer container) {
        return this.getAcceptor(container, true);
    }

    public abstract IAcceptor getAcceptor(IManagedContainer var1, boolean var2);

    public IConnector getConnector(IManagedContainer container) {
        return this.getConnector(container, true);
    }

    public abstract IConnector getConnector(IManagedContainer var1, boolean var2);

    public void closeUnderlyingConnection(IConnector connector) throws IOException {
        connector.close();
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public static interface Factory {
        public TestConfig createConfig();
    }

    public static class JVM
    implements Factory {
        public static final String NAME = "default";

        @Override
        public TestConfig createConfig() {
            return new TestConfig(){

                @Override
                public boolean needsSeparateContainers() {
                    return false;
                }

                @Override
                public void prepareContainer(IManagedContainer container) {
                    JVMUtil.prepareContainer((IManagedContainer)container);
                }

                @Override
                public IAcceptor getAcceptor(IManagedContainer container, boolean activate) {
                    return (IJVMAcceptor)container.getElement("org.eclipse.net4j.acceptors", "jvm", JVM.NAME, activate);
                }

                @Override
                public IConnector getConnector(IManagedContainer container, boolean activate) {
                    return (IJVMConnector)container.getElement("org.eclipse.net4j.connectors", "jvm", JVM.NAME, activate);
                }

                public String toString() {
                    return JVM.class.getSimpleName();
                }
            };
        }
    }

    public static class SSL
    implements Factory {
        public static final String HOST = "localhost";

        static {
            System.setProperty("org.eclipse.net4j.tcp.ssl.passphrase", "ab987c");
            System.setProperty("org.eclipse.net4j.tcp.ssl.trust", "file:sslKey/testTrust");
            System.setProperty("org.eclipse.net4j.tcp.ssl.key", "file:sslKey/testKeys");
            System.setProperty("check.validity.certificate", "false");
        }

        @Override
        public TestConfig createConfig() {
            return new TestConfig(){

                @Override
                public boolean needsSeparateContainers() {
                    return true;
                }

                @Override
                public void prepareContainer(IManagedContainer container) {
                    SSLUtil.prepareContainer((IManagedContainer)container);
                }

                @Override
                public IAcceptor getAcceptor(IManagedContainer container, boolean activate) {
                    return (ITCPAcceptor)container.getElement("org.eclipse.net4j.acceptors", "ssl", null, activate);
                }

                @Override
                public IConnector getConnector(IManagedContainer container, boolean activate) {
                    return (ITCPConnector)container.getElement("org.eclipse.net4j.connectors", "ssl", SSL.HOST, activate);
                }

                @Override
                public void closeUnderlyingConnection(IConnector connector) throws IOException {
                    ((SSLConnector)connector).getSocketChannel().close();
                }

                public String toString() {
                    return SSL.class.getSimpleName();
                }
            };
        }
    }

    public static class TCP
    implements Factory {
        public static final String HOST = "localhost";

        @Override
        public TestConfig createConfig() {
            return new TestConfig(){

                @Override
                public boolean needsSeparateContainers() {
                    return false;
                }

                @Override
                public void prepareContainer(IManagedContainer container) {
                    TCPUtil.prepareContainer((IManagedContainer)container);
                }

                @Override
                public IAcceptor getAcceptor(IManagedContainer container, boolean activate) {
                    return (ITCPAcceptor)container.getElement("org.eclipse.net4j.acceptors", "tcp", null, activate);
                }

                @Override
                public IConnector getConnector(IManagedContainer container, boolean activate) {
                    return (ITCPConnector)container.getElement("org.eclipse.net4j.connectors", "tcp", TCP.HOST, activate);
                }

                @Override
                public void closeUnderlyingConnection(IConnector connector) throws IOException {
                    ((TCPConnector)connector).getSocketChannel().close();
                }

                public String toString() {
                    return TCP.class.getSimpleName();
                }
            };
        }
    }

    public static class WS
    implements Factory {
        public static final int HTTP_PORT = 8087;
        public static final String SERVICE_URI = "ws://localhost:8087/net4j";
        public static final String ACCEPTOR_NAME = "default";

        @Override
        public TestConfig createConfig() {
            return new TestConfig(){
                private Server server;

                @Override
                public boolean needsSeparateContainers() {
                    return false;
                }

                @Override
                public void prepareContainer(IManagedContainer container) {
                    WSUtil.prepareContainer((IManagedContainer)container);
                }

                @Override
                public IAcceptor getAcceptor(IManagedContainer container, boolean activate) {
                    return (IWSAcceptor)container.getElement("org.eclipse.net4j.acceptors", "ws", WS.ACCEPTOR_NAME, activate);
                }

                @Override
                public IConnector getConnector(IManagedContainer container, boolean activate) {
                    try {
                        String description = WSUtil.getConnectorDescription((String)WS.SERVICE_URI, (String)WS.ACCEPTOR_NAME, (String[])new String[0]);
                        return (IWSConnector)container.getElement("org.eclipse.net4j.connectors", "ws", description, activate);
                    }
                    catch (URISyntaxException ex) {
                        throw new RuntimeException(ex);
                    }
                }

                @Override
                public void closeUnderlyingConnection(IConnector connector) throws IOException {
                    ((WSConnector)connector).getWebSocket().close();
                }

                @Override
                public void setUp() throws Exception {
                    IOUtil.OUT().println("Starting Jetty...");
                    this.server = new Server(8087);
                    ServletContextHandler handler = new ServletContextHandler(1);
                    handler.setContextPath("/");
                    this.server.setHandler((Supplier)handler);
                    JettyWebSocketServletContainerInitializer.configure((ServletContextHandler)handler, null);
                    handler.addServlet(new ServletHolder("net4j", Net4jWebSocketServlet.class), "/net4j");
                    this.server.start();
                    System.out.println("Started Jetty server...");
                }

                @Override
                public void tearDown() throws Exception {
                    IOUtil.OUT().println("Stopping Jetty...");
                    this.server.stop();
                    this.server = null;
                }

                public String toString() {
                    return WS.class.getSimpleName();
                }
            };
        }
    }

    public static class WSS
    implements Factory {
        public static final int HTTPS_PORT = 8088;
        public static final String SERVICE_URI = "wss://localhost:8088/net4j";
        public static final String ACCEPTOR_NAME = "default";

        @Override
        public TestConfig createConfig() {
            return new TestConfig(){
                private Server server;

                @Override
                public boolean needsSeparateContainers() {
                    return false;
                }

                @Override
                public void prepareContainer(IManagedContainer container) {
                    WSSUtil.prepareContainer((IManagedContainer)container);
                }

                @Override
                public IAcceptor getAcceptor(IManagedContainer container, boolean activate) {
                    return (IWSAcceptor)container.getElement("org.eclipse.net4j.acceptors", "wss", WSS.ACCEPTOR_NAME, activate);
                }

                @Override
                public IConnector getConnector(IManagedContainer container, boolean activate) {
                    try {
                        System.setProperty("org.eclipse.net4j.internal.wss.ssl.trustall", "true");
                        String description = WSSUtil.getConnectorDescription((String)WSS.SERVICE_URI, (String)WSS.ACCEPTOR_NAME, (String[])new String[0]);
                        return (IWSConnector)container.getElement("org.eclipse.net4j.connectors", "wss", description, activate);
                    }
                    catch (URISyntaxException ex) {
                        throw new RuntimeException(ex);
                    }
                }

                @Override
                public void closeUnderlyingConnection(IConnector connector) throws IOException {
                    ((WSConnector)connector).getWebSocket().close();
                }

                @Override
                public void setUp() throws Exception {
                    IOUtil.OUT().println("Starting Jetty...");
                    this.server = new Server();
                    SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
                    URL baseurl = OM.BUNDLE.getBaseURL();
                    File file = URIUtil.toFile((URI)URIUtil.toURI((URL)baseurl));
                    File keyStoreFile = new File(file.getPath() + File.separator + "sslKey" + File.separator + "testKeys");
                    sslContextFactory.setKeyStorePath(keyStoreFile.getPath());
                    sslContextFactory.setKeyStorePassword("ab987c");
                    HttpConfiguration httpsConfig = new HttpConfiguration();
                    httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer(false));
                    ServerConnector wssConnector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.toString()), new HttpConnectionFactory(httpsConfig)});
                    wssConnector.setHost("localhost");
                    wssConnector.setPort(8088);
                    this.server.addConnector((Connector)wssConnector);
                    ServletContextHandler handler = new ServletContextHandler(1);
                    handler.setContextPath("/");
                    this.server.setHandler((Supplier)handler);
                    JettyWebSocketServletContainerInitializer.configure((ServletContextHandler)handler, null);
                    handler.addServlet(new ServletHolder("net4j", Net4jWebSocketServlet.class), "/net4j");
                    this.server.start();
                    System.out.println("Started Jetty server...");
                }

                @Override
                public void tearDown() throws Exception {
                    IOUtil.OUT().println("Stopping Jetty...");
                    this.server.stop();
                    this.server = null;
                }

                public String toString() {
                    return WSS.class.getSimpleName();
                }
            };
        }
    }
}

