/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.Timestamp;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptorList;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DDLSingleTableConstantAction;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class CreateTriggerConstantAction
extends DDLSingleTableConstantAction {
    private String triggerName;
    private String triggerSchemaName;
    private TableDescriptor triggerTable;
    private UUID triggerTableId;
    private int eventMask;
    private boolean isBefore;
    private boolean isRow;
    private boolean isEnabled;
    private boolean referencingOld;
    private boolean referencingNew;
    private UUID whenSPSId;
    private String whenText;
    private UUID actionSPSId;
    private String actionText;
    private final String originalWhenText;
    private String originalActionText;
    private String oldReferencingName;
    private String newReferencingName;
    private UUID spsCompSchemaId;
    private int[] referencedCols;
    private int[] referencedColsInTriggerAction;
    private final ProviderInfo[] providerInfo;

    CreateTriggerConstantAction(String triggerSchemaName, String triggerName, int eventMask, boolean isBefore, boolean isRow, boolean isEnabled, TableDescriptor triggerTable, UUID whenSPSId, String whenText, UUID actionSPSId, String actionText, UUID spsCompSchemaId, int[] referencedCols, int[] referencedColsInTriggerAction, String originalWhenText, String originalActionText, boolean referencingOld, boolean referencingNew, String oldReferencingName, String newReferencingName, ProviderInfo[] providerInfo) {
        super(triggerTable.getUUID());
        this.triggerName = triggerName;
        this.triggerSchemaName = triggerSchemaName;
        this.triggerTable = triggerTable;
        this.eventMask = eventMask;
        this.isBefore = isBefore;
        this.isRow = isRow;
        this.isEnabled = isEnabled;
        this.whenSPSId = whenSPSId;
        this.whenText = whenText;
        this.actionSPSId = actionSPSId;
        this.actionText = actionText;
        this.spsCompSchemaId = spsCompSchemaId;
        this.referencedCols = referencedCols;
        this.referencedColsInTriggerAction = referencedColsInTriggerAction;
        this.originalActionText = originalActionText;
        this.originalWhenText = originalWhenText;
        this.referencingOld = referencingOld;
        this.referencingNew = referencingNew;
        this.oldReferencingName = oldReferencingName;
        this.newReferencingName = newReferencingName;
        this.providerInfo = providerInfo;
        SanityManager.ASSERT(triggerSchemaName != null, "triggerSchemaName sd is null");
        SanityManager.ASSERT(triggerName != null, "trigger name is null");
        SanityManager.ASSERT(triggerTable != null, "triggerTable is null");
        SanityManager.ASSERT(actionText != null, "actionText is null");
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        Object tabName;
        SPSDescriptor whenspsd = null;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        dd.startWriting(lcc);
        SchemaDescriptor triggerSd = CreateTriggerConstantAction.getSchemaDescriptorForCreate(dd, activation, this.triggerSchemaName);
        if (this.spsCompSchemaId == null) {
            SchemaDescriptor def = lcc.getDefaultSchema();
            if (def.getUUID() == null) {
                def = dd.getSchemaDescriptor(def.getDescriptorName(), tc, false);
            }
            if (def != null) {
                this.spsCompSchemaId = def.getUUID();
            }
        }
        if (this.triggerTable != null) {
            this.triggerTableId = this.triggerTable.getUUID();
            tabName = this.triggerTable.getName();
        } else {
            tabName = "with UUID " + this.triggerTableId;
        }
        this.triggerTable = dd.getTableDescriptor(this.triggerTableId);
        if (this.triggerTable == null) {
            throw StandardException.newException("X0X05.S", tabName);
        }
        this.lockTableForDDL(tc, this.triggerTable.getHeapConglomerateId(), true);
        this.triggerTable = dd.getTableDescriptor(this.triggerTableId);
        if (this.triggerTable == null) {
            throw StandardException.newException("X0X05.S", tabName);
        }
        dm.invalidateFor(this.triggerTable, 28, lcc);
        UUID tmpTriggerId = dd.getUUIDFactory().createUUID();
        UUID uUID = this.actionSPSId = this.actionSPSId == null ? dd.getUUIDFactory().createUUID() : this.actionSPSId;
        if (this.whenSPSId == null && this.whenText != null) {
            this.whenSPSId = dd.getUUIDFactory().createUUID();
        }
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        TriggerDescriptor triggerd = ddg.newTriggerDescriptor(triggerSd, tmpTriggerId, this.triggerName, this.eventMask, this.isBefore, this.isRow, this.isEnabled, this.triggerTable, this.whenSPSId, this.actionSPSId, this.makeCreationTimestamp(dd), this.referencedCols, this.referencedColsInTriggerAction, this.originalActionText, this.referencingOld, this.referencingNew, this.oldReferencingName, this.newReferencingName, this.originalWhenText);
        dd.addDescriptor(triggerd, triggerSd, 13, false, tc);
        if (this.whenText != null) {
            String whenValuesStmt = "VALUES " + this.whenText;
            whenspsd = this.createSPS(lcc, ddg, dd, tc, tmpTriggerId, triggerSd, this.whenSPSId, this.spsCompSchemaId, whenValuesStmt, true, this.triggerTable);
        }
        SPSDescriptor actionspsd = this.createSPS(lcc, ddg, dd, tc, tmpTriggerId, triggerSd, this.actionSPSId, this.spsCompSchemaId, this.actionText, false, this.triggerTable);
        if (whenspsd != null) {
            dm.addDependency(triggerd, whenspsd, lcc.getContextManager());
        }
        dm.addDependency(triggerd, actionspsd, lcc.getContextManager());
        dm.addDependency(triggerd, this.triggerTable, lcc.getContextManager());
        for (ProviderInfo info : this.providerInfo) {
            Provider provider = (Provider)info.getDependableFinder().getDependable(dd, info.getObjectId());
            dm.addDependency(triggerd, provider, lcc.getContextManager());
        }
        this.storeViewTriggerDependenciesOnPrivileges(activation, triggerd);
    }

    private SPSDescriptor createSPS(LanguageConnectionContext lcc, DataDescriptorGenerator ddg, DataDictionary dd, TransactionController tc, UUID triggerId, SchemaDescriptor sd, UUID spsId, UUID compSchemaId, String text, boolean isWhen, TableDescriptor triggerTable) throws StandardException {
        if (text == null) {
            return null;
        }
        String spsName = "TRIGGER" + (isWhen ? "WHEN_" : "ACTN_") + triggerId + "_" + triggerTable.getUUID().toString();
        SPSDescriptor spsd = new SPSDescriptor(dd, spsName, spsId == null ? dd.getUUIDFactory().createUUID() : spsId, sd.getUUID(), compSchemaId == null ? lcc.getDefaultSchema().getUUID() : compSchemaId, 'T', true, text, true);
        spsd.prepareAndRelease(lcc, triggerTable);
        dd.addSPSDescriptor(spsd, tc);
        return spsd;
    }

    public String toString() {
        return this.constructToString("CREATE TRIGGER ", this.triggerName);
    }

    private Timestamp makeCreationTimestamp(DataDictionary dd) throws StandardException {
        TriggerDescriptorList tdl;
        int numTriggers;
        Timestamp now = new Timestamp(System.currentTimeMillis());
        String val = PropertyUtil.getSystemProperty("derby.debug.overrideTriggerCreationTimestamp");
        if (val != null) {
            now.setTime(Long.parseLong(val));
        }
        if ((numTriggers = (tdl = dd.getTriggerDescriptors(this.triggerTable)).size()) == 0) {
            return now;
        }
        Timestamp highest = ((TriggerDescriptor)tdl.get(numTriggers - 1)).getCreationTimestamp();
        if (now.after(highest)) {
            return now;
        }
        now.setTime(highest.getTime() + 1L);
        return now;
    }
}

