/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.qvt.declarative.ecore.mappings.MappingConfigurationException;
import org.eclipse.qvt.declarative.editor.ui.paged.PagedEditor;
import org.eclipse.qvt.declarative.editor.ui.pages.EditorPageManager;
import org.eclipse.qvt.declarative.editor.ui.text.LazyTextPageEditor;
import org.eclipse.qvt.declarative.editor.ui.xml.XMLPageEditor;
import org.eclipse.qvt.declarative.modelregistry.environment.AbstractFileHandle;
import org.eclipse.qvt.declarative.parser.environment.ICSTFileEnvironment;
import org.eclipse.qvt.declarative.parser.utils.ProblemCounter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XMLPageManager
extends EditorPageManager {
    public XMLPageManager(PagedEditor pagedEditor, XMLResource resource, String pageTitle) {
        super(pagedEditor, resource, false, pageTitle);
    }

    @Override
    public ProblemCounter cannotDeactivate(Map<XMLResource, XMLResource> updates, IProgressMonitor monitor) {
        ResourceSet resourceSet = this.getResourceSet();
        AbstractFileHandle fileHandle = this.getFileHandle();
        ICSTFileEnvironment environment = this.getCreationFactory().createFileEnvironment(fileHandle, resourceSet, this.resource.getURI());
        ProblemCounter reporter = new ProblemCounter();
        environment.setProblemHandler((ProblemHandler)reporter);
        new ByteArrayInputStream(this.getCurrentContents().getBytes());
        String fatalMessage = null;
        try {
            XMLResource newResource = (XMLResource)resourceSet.getResource(this.resource.getURI(), true);
            updates.put(this.resource, this.getEcoreResource(newResource));
        }
        catch (Exception e) {
            fatalMessage = "XMI analysis gives " + e.getMessage();
        }
        if (fatalMessage != null) {
            reporter.handleProblem(ProblemHandler.Severity.FATAL, ProblemHandler.Phase.UTILITY, fatalMessage, "", -1, -1);
        }
        return reporter;
    }

    @Override
    public void createContents(OutputStream outputStream) throws MappingConfigurationException, IOException {
        this.getCreationFactory().assignXmiIds(this.resource);
        this.resource.save(outputStream, null);
    }

    @Override
    protected LazyTextPageEditor createEditor() {
        return new XMLPageEditor(this);
    }

    protected XMLResource getEcoreResource(XMLResource resource) {
        return resource;
    }

    @Override
    public void refresh() {
    }
}

