/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeCT;

import com.ibm.wala.shrikeCT.AttributeReader;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.ConstantPoolParser;
import com.ibm.wala.shrikeCT.InvalidClassFileException;

public final class InnerClassesReader
extends AttributeReader {
    public InnerClassesReader(ClassReader.AttrIterator iter) throws InvalidClassFileException {
        super(iter, "InnerClasses");
        this.checkSize(this.attr, 8);
        int count = this.cr.getUShort(this.attr + 6);
        this.checkSizeEquals(this.attr + 8, 8 * count);
    }

    public int[] getRawTable() {
        int count = this.cr.getUShort(this.attr + 6);
        int[] r = new int[count * 4];
        int i = 0;
        while (i < r.length) {
            r[i] = this.cr.getUShort(this.attr + 8 + i * 2);
            ++i;
        }
        return r;
    }

    public String[] getInnerClasses() throws InvalidClassFileException {
        int count = this.cr.getUShort(this.attr + 6);
        String[] r = new String[count];
        ConstantPoolParser cp = this.cr.getCP();
        int i = 0;
        while (i < r.length) {
            r[i] = cp.getCPClass(this.cr.getUShort(this.attr + 8 + i * 8));
            ++i;
        }
        return r;
    }

    public String getOuterClass(String s) throws InvalidClassFileException {
        String[] inner = this.getInnerClasses();
        int i = 0;
        while (i < inner.length) {
            int x;
            if (inner[i].equals(s) && (x = this.cr.getUShort(this.attr + 8 + i * 8 + 2)) != 0) {
                ConstantPoolParser cp = this.cr.getCP();
                return cp.getCPClass(this.cr.getUShort(this.attr + 8 + i * 8 + 2));
            }
            ++i;
        }
        return null;
    }

    public int getAccessFlags(String s) throws InvalidClassFileException {
        String[] inner = this.getInnerClasses();
        int i = 0;
        while (i < inner.length) {
            if (inner[i].equals(s)) {
                return this.cr.getUShort(this.attr + 8 + i * 8 + 6);
            }
            ++i;
        }
        return 0;
    }
}

