/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.AlignmentRequest;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.ResizeTracker;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.sirius.diagram.sequence.business.internal.RangeHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractFrame;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.ISequenceEventEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy.SequenceInteractionFeedBackBuilder;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.AbstractInteractionFrameValidator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.ISEComplexMoveValidator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.figure.RangeGuide;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.ui.SequenceDragEditPartsTrackerEx;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.RequestQuery;
import org.eclipse.sirius.diagram.sequence.util.Range;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.AirResizableEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SiriusResizeTracker;
import org.eclipse.sirius.ext.draw2d.figure.FigureUtilities;
import org.eclipse.sirius.ext.draw2d.figure.HorizontalGuide;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;
import org.eclipse.swt.graphics.Color;

public abstract class AbstractFrameResizableEditPolicy
extends AirResizableEditPolicy {
    private static final Color FRAME_FEEDBACK_COLOR = ColorConstants.lightGray;
    private Collection<Figure> guides = new ArrayList<Figure>();

    public AbstractFrameResizableEditPolicy() {
        this.setResizeDirections(5);
    }

    protected void createResizeHandle(List handles, int direction) {
        if ((1 & direction) == 1 || (4 & direction) == 4) {
            super.createResizeHandle(handles, direction);
        }
    }

    public void setResizeDirections(int newDirections) {
        super.setResizeDirections(5);
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        this.eraseChangeBoundsFeedback(request);
        this.cancelHorizontalDelta(request);
        super.showChangeBoundsFeedback(request);
        ISequenceEventEditPart hostPart = (ISequenceEventEditPart)this.getHost();
        RequestQuery requestQuery = new RequestQuery((Request)request);
        ISequenceEvent frame = hostPart.getISequenceEvent();
        if (hostPart.getSelected() == 2 && requestQuery.isMove()) {
            ISEComplexMoveValidator validator = ISEComplexMoveValidator.getOrCreateValidator(request, requestQuery, frame);
            if (validator != null) {
                SequenceInteractionFeedBackBuilder feedBackBuilder = new SequenceInteractionFeedBackBuilder(validator, this.getFeedbackLayer(), (IGraphicalEditPart)hostPart);
                for (Figure fig : feedBackBuilder.buildFeedBack()) {
                    this.addFeedback((IFigure)fig);
                    this.guides.add(fig);
                }
            }
        } else if (requestQuery.isResize()) {
            Rectangle newBounds = this.getNewBounds(this.getHostAbsoluteBounds().getCopy(), request);
            RangeGuide frameGuide = new RangeGuide(FRAME_FEEDBACK_COLOR, new Range(newBounds.y, newBounds.y + Math.max(0, newBounds.height)), false);
            Rectangle bounds = this.getFeedbackLayer().getBounds().getCopy();
            bounds.y = newBounds.y;
            bounds.height = newBounds.height;
            frameGuide.setBounds(bounds);
            this.addFeedback((IFigure)frameGuide);
            this.guides.add(frameGuide);
            for (ISequenceEventEditPart child : this.getChildrenToFeedBack(request)) {
                newBounds = this.getNewBounds(this.getAbsoluteBounds(child.getFigure()), request);
                HorizontalGuide childGuide = this.createAndAddFeedbackHGuide(newBounds.getTop().y);
                this.guides.add((Figure)childGuide);
            }
            if (frame instanceof AbstractFrame) {
                AbstractInteractionFrameValidator validator = AbstractInteractionFrameValidator.getOrCreateResizeValidator(request, (AbstractFrame)frame);
                if (!validator.isValid()) {
                    this.feedBackConflicts(validator);
                }
                this.feedBackExpansion(validator);
            }
        }
    }

    private void feedBackExpansion(AbstractInteractionFrameValidator validator) {
        Rectangle bounds = this.getFeedbackLayer().getBounds().getCopy();
        Range expansionZone = validator.getExpansionZone();
        if (!expansionZone.isEmpty()) {
            Rectangle screenRange = new Rectangle(0, expansionZone.getLowerBound(), 0, expansionZone.width());
            screenRange.performScale(GraphicalHelper.getZoom((EditPart)this.getHost()));
            Range expand = RangeHelper.verticalRange((Rectangle)screenRange);
            RangeGuide expansion = new RangeGuide(validator.isValid() ? ColorConstants.blue : ColorConstants.red, expand, true);
            bounds.height = expand.width();
            bounds.y = expand.getLowerBound();
            expansion.setBounds(bounds);
            this.addFeedback((IFigure)expansion);
            this.guides.add(expansion);
        }
    }

    private void feedBackConflicts(AbstractInteractionFrameValidator validator) {
        for (Integer conflict : validator.getInvalidPositions()) {
            Point conflictingPosition = new Point(0, conflict.intValue());
            conflictingPosition.performScale(GraphicalHelper.getZoom((EditPart)this.getHost()));
            Rectangle bounds = this.getFeedbackLayer().getBounds().getCopy();
            bounds.y = conflictingPosition.y;
            bounds.height = 1;
            HorizontalGuide conflictGuide = new HorizontalGuide(ColorConstants.red, conflictingPosition.y);
            conflictGuide.setBounds(bounds);
            this.addFeedback((IFigure)conflictGuide);
            this.guides.add((Figure)conflictGuide);
        }
    }

    private Rectangle getNewBounds(Rectangle oldBounds, ChangeBoundsRequest cbr) {
        Rectangle newBounds = cbr.getTransformedRectangle(oldBounds).getCopy();
        FreeformViewport viewport = FigureUtilities.getFreeformViewport((IFigure)this.getHostFigure());
        if (viewport != null) {
            newBounds.translate(viewport.getViewLocation());
        }
        return newBounds;
    }

    private HorizontalGuide createAndAddFeedbackHGuide(int y) {
        Rectangle bounds = this.getFeedbackLayer().getBounds().getCopy();
        bounds.height = 1;
        bounds.y = y;
        HorizontalGuide guide = new HorizontalGuide(FRAME_FEEDBACK_COLOR, y);
        guide.setBounds(bounds);
        this.addFeedback((IFigure)guide);
        return guide;
    }

    protected void eraseChangeBoundsFeedback(ChangeBoundsRequest request) {
        this.removeFeedBackOnGuides();
        super.eraseChangeBoundsFeedback(request);
    }

    protected Command getAutoSizeCommand(Request request) {
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getAlignCommand(AlignmentRequest request) {
        return UnexecutableCommand.INSTANCE;
    }

    protected void cancelHorizontalDelta(ChangeBoundsRequest request) {
        Dimension sizeDelta;
        if (request == null) {
            return;
        }
        Point moveDelta = request.getMoveDelta();
        if (moveDelta != null) {
            request.setMoveDelta(new Point(0, moveDelta.y));
        }
        if ((sizeDelta = request.getSizeDelta()) != null) {
            request.setSizeDelta(new Dimension(0, sizeDelta.height));
        }
    }

    private void removeFeedBackOnGuides() {
        if (this.guides != null && !this.guides.isEmpty()) {
            for (Figure hGuide : this.guides) {
                this.removeFeedback((IFigure)hGuide);
            }
            this.guides.clear();
        }
    }

    private Rectangle getHostAbsoluteBounds() {
        return this.getAbsoluteBounds(this.getHostFigure());
    }

    private Rectangle getAbsoluteBounds(IFigure figure) {
        Rectangle bounds = figure.getBounds().getCopy();
        figure.getParent().translateToAbsolute((Translatable)bounds);
        return bounds;
    }

    protected abstract Collection<ISequenceEventEditPart> getChildrenToFeedBack(ChangeBoundsRequest var1);

    protected ResizeTracker getResizeTracker(int direction) {
        return new SiriusResizeTracker((org.eclipse.gef.GraphicalEditPart)((GraphicalEditPart)this.getHost()), direction){

            protected boolean handleButtonUp(int button) {
                SequenceDragEditPartsTrackerEx.SequenceCacheDragTrackerHelper.handleButtonUp((IGraphicalEditPart)this.getOwner());
                return super.handleButtonUp(button);
            }

            protected boolean handleButtonDown(int button) {
                boolean handleButtonDown = super.handleButtonDown(button);
                SequenceDragEditPartsTrackerEx.SequenceCacheDragTrackerHelper.handleButtonDown((IGraphicalEditPart)this.getOwner());
                return handleButtonDown;
            }
        };
    }
}

