/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.template.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.internal.corext.template.java.IJavaContext;
import org.eclipse.jdt.internal.ui.text.template.contentassist.MultiVariable;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;

public class NameResolver
extends TemplateVariableResolver {
    private final String fDefaultType;

    public NameResolver() {
        this("java.lang.Object");
    }

    NameResolver(String defaultType) {
        this.fDefaultType = defaultType;
    }

    public void resolve(TemplateVariable variable, TemplateContext context) {
        List params = variable.getVariableType().getParams();
        String param = params.size() == 0 ? this.fDefaultType : (String)params.get(0);
        IJavaContext jc = (IJavaContext)context;
        TemplateVariable ref = jc.getTemplateVariable(param);
        MultiVariable mv = (MultiVariable)variable;
        if (ref instanceof MultiVariable) {
            Object[] types;
            MultiVariable refVar = (MultiVariable)ref;
            jc.addDependency(refVar, mv);
            refVar.getAllChoices();
            Object[] objectArray = types = this.flatten(refVar.getAllChoices());
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                Object type = objectArray[n2];
                Object[] names = jc.suggestVariableNames(mv.toString(type));
                mv.setChoices(type, names);
                ++n2;
            }
            mv.setKey(refVar.getCurrentChoice());
            jc.markAsUsed(mv.getDefaultValue());
        } else {
            jc.addImport(param);
            Object[] names = jc.suggestVariableNames(param);
            mv.setChoices(names);
            jc.markAsUsed((String)names[0]);
        }
    }

    private Object[] flatten(Object[][] allValues) {
        ArrayList<Object> flattened = new ArrayList<Object>(allValues.length);
        Object[][] objectArray = allValues;
        int n = allValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] allValue = objectArray[n2];
            flattened.addAll(Arrays.asList(allValue));
            ++n2;
        }
        return flattened.toArray(new Object[flattened.size()]);
    }
}

