/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.view.factories;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.gmf.runtime.diagram.ui.view.factories.AbstractViewFactory;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.ShapeStyle;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.ui.business.internal.query.DNodeQuery;
import org.eclipse.sirius.diagram.ui.internal.view.factories.AbstractDesignerNodeFactory;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;

public abstract class AbstractDNodeViewFactory
extends AbstractDesignerNodeFactory {
    protected abstract int getVisualId();

    protected abstract int getNameVisualId();

    protected List<ShapeStyle> createStyles(View view) {
        ArrayList<ShapeStyle> styles = new ArrayList<ShapeStyle>();
        styles.add(NotationFactory.eINSTANCE.createShapeStyle());
        return styles;
    }

    @Override
    protected void decorateView(View containerView, View view, IAdaptable semanticAdapter, String semanticHint, int index, boolean persisted) {
        String semHint = this.checkSemanticHint(view, semanticHint);
        super.decorateView(containerView, view, semanticAdapter, semHint, index, persisted);
        this.addShortcutEannotation(containerView, view);
        EObjectAdapter eObjectAdapter = null;
        EObject eObject = (EObject)semanticAdapter.getAdapter(EObject.class);
        if (eObject != null) {
            eObjectAdapter = new EObjectAdapter(eObject);
        }
        this.createLabelView(view, (IAdaptable)eObjectAdapter, eObject);
        this.updateLayoutConstraint(view, semanticAdapter);
    }

    private String checkSemanticHint(View view, String semanticHint) {
        String semHint = semanticHint;
        if (semHint == null) {
            semHint = SiriusVisualIDRegistry.getType(this.getVisualId());
            view.setType(semHint);
        }
        return semHint;
    }

    private void addShortcutEannotation(View containerView, View view) {
        if (2001 == this.getVisualId() && !"Sirius".equals(SiriusVisualIDRegistry.getModelID(containerView))) {
            EAnnotation shortcutAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            shortcutAnnotation.setSource("Shortcut");
            shortcutAnnotation.getDetails().put((Object)"modelID", (Object)"Sirius");
            view.getEAnnotations().add((Object)shortcutAnnotation);
        }
    }

    private void createLabelView(View view, IAdaptable eObjectAdapter, EObject eObject) {
        Node node = AbstractViewFactory.getViewService().createNode(eObjectAdapter, view, SiriusVisualIDRegistry.getType(this.getNameVisualId()), -1, true, this.getPreferencesHint());
        if (eObject instanceof DDiagramElement) {
            node.setVisible(!new DDiagramElementQuery((DDiagramElement)eObject).isLabelHidden());
        }
    }

    private void updateLayoutConstraint(View view, IAdaptable semanticAdapter) {
        if (view instanceof Node && ((Node)view).getLayoutConstraint() instanceof Size) {
            Size size = (Size)((Node)view).getLayoutConstraint();
            DNode viewNode = (DNode)semanticAdapter.getAdapter(DNode.class);
            if (viewNode != null) {
                Dimension defaultDimension = new DNodeQuery(viewNode).getDefaultDimension();
                size.setHeight(defaultDimension.height);
                size.setWidth(defaultDimension.width);
            }
        }
    }
}

