/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

final class RefCache {
    private static final RefCache INSTANCE = new RefCache();
    private final Map<Repository, Map<String, Ref>> branchRefs = new WeakHashMap<Repository, Map<String, Ref>>();
    private final Map<Repository, List<Ref>> additionalRefs = new WeakHashMap<Repository, List<Ref>>();
    private final Map<Repository, ListenerHandle> refsChangedListeners = new WeakHashMap<Repository, ListenerHandle>();
    private final Map<Repository, ListenerHandle> indexChangedListeners = new WeakHashMap<Repository, ListenerHandle>();
    private long refCount;

    private RefCache() {
    }

    protected synchronized boolean isLoaded(Repository repository) {
        return this.branchRefs.get(repository) != null;
    }

    protected synchronized Map<String, Ref> byPrefix(Repository repository, String prefix) throws IOException {
        Map allRefs = this.branchRefs.get(repository);
        if (allRefs == null) {
            allRefs = repository.getRefDatabase().getRefs("");
            this.branchRefs.put(repository, allRefs);
            if (this.refsChangedListeners.get(repository) == null) {
                this.refsChangedListeners.put(repository, repository.getListenerList().addRefsChangedListener(event -> {
                    RefCache refCache = this;
                    synchronized (refCache) {
                        this.branchRefs.remove(event.getRepository());
                        this.additionalRefs.remove(event.getRepository());
                    }
                }));
            }
        }
        if (prefix.equals("")) {
            return allRefs;
        }
        HashMap<String, Ref> filtered = new HashMap<String, Ref>();
        for (Map.Entry entry : allRefs.entrySet()) {
            if (!((String)entry.getKey()).startsWith(prefix)) continue;
            filtered.put((String)entry.getKey(), (Ref)entry.getValue());
        }
        return filtered;
    }

    protected synchronized List<Ref> additional(Repository repository) throws IOException {
        List result = this.additionalRefs.get(repository);
        if (result == null) {
            result = repository.getRefDatabase().getAdditionalRefs();
            this.additionalRefs.put(repository, result);
            if (this.indexChangedListeners.get(repository) == null) {
                this.indexChangedListeners.put(repository, repository.getListenerList().addIndexChangedListener(event -> {
                    RefCache refCache = this;
                    synchronized (refCache) {
                        this.additionalRefs.remove(event.getRepository());
                    }
                }));
            }
        }
        return result;
    }

    protected synchronized void remove(Collection<Repository> repositories) {
        for (Repository repo : repositories) {
            ListenerHandle listener = this.refsChangedListeners.get(repo);
            if (listener != null) {
                listener.remove();
            }
            if ((listener = this.indexChangedListeners.get(repo)) == null) continue;
            listener.remove();
        }
        this.refsChangedListeners.keySet().removeAll(repositories);
        this.indexChangedListeners.keySet().removeAll(repositories);
        this.branchRefs.keySet().removeAll(repositories);
        this.additionalRefs.keySet().removeAll(repositories);
    }

    protected synchronized void unregister() {
        if (this.refCount == 0L) {
            return;
        }
        if (--this.refCount == 0L) {
            this.refsChangedListeners.values().forEach(ListenerHandle::remove);
            this.refsChangedListeners.clear();
            this.indexChangedListeners.values().forEach(ListenerHandle::remove);
            this.indexChangedListeners.clear();
            this.branchRefs.clear();
            this.additionalRefs.clear();
        }
    }

    private synchronized Cache register() {
        ++this.refCount;
        return new CacheAccessor();
    }

    public static Cache get() {
        return INSTANCE.register();
    }

    static interface Cache {
        public boolean isLoaded(Repository var1);

        default public Ref exact(Repository repository, String fullName) throws IOException {
            return this.byPrefix(repository, "").get(fullName);
        }

        public Map<String, Ref> byPrefix(Repository var1, String var2) throws IOException;

        public List<Ref> additional(Repository var1) throws IOException;

        default public Ref findAdditional(Repository repository, String name) throws IOException {
            Ref ref = this.exact(repository, name);
            if (ref != null) {
                return ref;
            }
            for (Ref additional : this.additional(repository)) {
                if (!additional.getName().equals(name)) continue;
                return additional;
            }
            return null;
        }

        public void remove(Collection<Repository> var1);

        public void dispose();
    }

    static class CacheAccessor
    implements Cache {
        private boolean disposed;

        CacheAccessor() {
        }

        @Override
        public boolean isLoaded(Repository repository) {
            return INSTANCE.isLoaded(repository);
        }

        @Override
        public void remove(Collection<Repository> repositories) {
            INSTANCE.remove(repositories);
        }

        @Override
        public Map<String, Ref> byPrefix(Repository repository, String prefix) throws IOException {
            if (this.disposed) {
                return Collections.emptyMap();
            }
            return INSTANCE.byPrefix(repository, prefix);
        }

        @Override
        public List<Ref> additional(Repository repository) throws IOException {
            if (this.disposed) {
                return Collections.emptyList();
            }
            return INSTANCE.additional(repository);
        }

        @Override
        public void dispose() {
            if (!this.disposed) {
                this.disposed = true;
                INSTANCE.unregister();
            }
        }
    }
}

