/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.layout.ordering;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.ui.tools.api.layout.ordering.AbstractEdgeViewOrdering;

public class SimpleCompositeEdgeViewOrdering
extends AbstractEdgeViewOrdering {
    private List<AbstractEdgeViewOrdering> edgeViewOrderings = new LinkedList<AbstractEdgeViewOrdering>();

    @Override
    public void setConnector(View connector) {
        super.setConnector(connector);
        for (AbstractEdgeViewOrdering current : this.edgeViewOrderings) {
            current.setConnector(connector);
        }
    }

    public void addEdgeViewOrdering(AbstractEdgeViewOrdering edgeViewOrdering) {
        this.edgeViewOrderings.add(edgeViewOrdering);
    }

    @Override
    public int compare(Edge edge1, Edge edge2) {
        AbstractEdgeViewOrdering viewOrdering1 = this.getViewOrderingFor(edge1);
        AbstractEdgeViewOrdering viewOrdering2 = this.getViewOrderingFor(edge2);
        int comparison = viewOrdering1 == null ? (viewOrdering2 == null ? 0 : 1) : (viewOrdering2 == null ? -1 : (viewOrdering1 == viewOrdering2 ? viewOrdering1.compare(edge1, edge2) : viewOrdering1.hashCode() - viewOrdering2.hashCode()));
        return comparison;
    }

    @Override
    public boolean isAbleToManageEdge(Edge edge) {
        return this.getViewOrderingFor(edge) != null;
    }

    protected AbstractEdgeViewOrdering getViewOrderingFor(Edge view) {
        for (AbstractEdgeViewOrdering currentViewOrdering : this.edgeViewOrderings) {
            if (!currentViewOrdering.isAbleToManageView((View)view)) continue;
            return currentViewOrdering;
        }
        return null;
    }
}

