/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.refactoring.descriptors.GeneralizeTypeDescriptor;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CollectingSearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.refactoring.rename.RippleMethodFinder2;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ASTCreator;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.CompositeOrTypeConstraint;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ConstraintCollector;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ConstraintOperator;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ConstraintVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ConstraintVariableFactory;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ExpressionVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.FullConstraintCreator;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ITypeConstraint;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ParameterTypeVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ReturnTypeVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.SimpleTypeConstraint;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.TypeConstraintFactory;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.TypeVariable;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class ChangeTypeRefactoring
extends Refactoring {
    private static final String ATTRIBUTE_TYPE = "type";
    private final Map<ICompilationUnit, List<ITypeConstraint>> fConstraintCache;
    private int fSelectionStart;
    private int fSelectionLength;
    private int fEffectiveSelectionStart;
    private int fEffectiveSelectionLength;
    private ICompilationUnit fCu;
    private IMethodBinding fMethodBinding;
    private int fParamIndex;
    private String fParamName;
    private IVariableBinding fFieldBinding;
    private ICompilationUnit[] fAffectedUnits;
    private Collection<ConstraintVariable> fRelevantVars;
    private final Collection<ITypeBinding> fValidTypes;
    private Collection<ITypeConstraint> fRelevantConstraints;
    private Collection<ITypeConstraint> fAllConstraints;
    private String fSelectedTypeName;
    private ITypeBinding fSelectedType;
    private Map<ICompilationUnit, SearchResultGroup> fCuToSearchResultGroup = new HashMap<ICompilationUnit, SearchResultGroup>();
    private ITypeBinding fObject;
    private static final boolean DEBUG = false;
    private ConstraintVariable fCv;
    private IBinding fSelectionBinding;
    private ITypeBinding fSelectionTypeBinding;
    private ConstraintCollector fCollector;

    public ITypeBinding getObject() {
        return this.fObject;
    }

    public ChangeTypeRefactoring(ICompilationUnit cu, int selectionStart, int selectionLength) {
        this(cu, selectionStart, selectionLength, null);
    }

    public ChangeTypeRefactoring(ICompilationUnit cu, int selectionStart, int selectionLength, String selectedType) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fEffectiveSelectionStart = selectionStart;
        this.fEffectiveSelectionLength = selectionLength;
        this.fCu = cu;
        if (selectedType != null) {
            this.fSelectedTypeName = selectedType;
        }
        this.fConstraintCache = new HashMap<ICompilationUnit, List<ITypeConstraint>>();
        this.fValidTypes = new HashSet<ITypeBinding>();
    }

    public ChangeTypeRefactoring(JavaRefactoringArguments arguments, RefactoringStatus status) {
        this(null, 0, 0, null);
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        if (this.fCu == null || !this.fCu.isStructureKnown()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeTypeRefactoring_invalidSelection);
        }
        return this.checkSelection((IProgressMonitor)new SubProgressMonitor(pm, 1));
    }

    private void setSelectionRanges(Expression exp) {
        this.fEffectiveSelectionStart = exp.getStartPosition();
        this.fEffectiveSelectionLength = exp.getLength();
        this.fSelectionBinding = ExpressionVariable.resolveBinding(exp);
        this.setOriginalType(exp.resolveTypeBinding());
    }

    private RefactoringStatus checkSelection(IProgressMonitor pm) {
        try {
            IMethod selectedMethod;
            pm.beginTask("", 5);
            ASTNode node = this.getTargetNode(this.fCu, this.fSelectionStart, this.fSelectionLength);
            TypeConstraintFactory typeConstraintFactory = new TypeConstraintFactory(){

                @Override
                public boolean filter(ConstraintVariable v1, ConstraintVariable v2, ConstraintOperator o) {
                    if (o.isStrictSubtypeOperator()) {
                        return true;
                    }
                    if (v1.getBinding() != null && v2.getBinding() != null && !Bindings.equals((IBinding)v1.getBinding(), (IBinding)ChangeTypeRefactoring.this.fSelectionTypeBinding) && !Bindings.equals((IBinding)v2.getBinding(), (IBinding)ChangeTypeRefactoring.this.fSelectionTypeBinding)) {
                        return true;
                    }
                    return super.filter(v1, v2, o);
                }
            };
            this.fCollector = new ConstraintCollector(new FullConstraintCreator(new ConstraintVariableFactory(), typeConstraintFactory));
            String selectionValid = this.determineSelection(node);
            if (selectionValid != null) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)selectionValid);
                return refactoringStatus;
            }
            if (this.fMethodBinding != null && (selectedMethod = (IMethod)this.fMethodBinding.getJavaElement()) == null) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeTypeRefactoring_insideLocalTypesNotSupported);
                return refactoringStatus;
            }
            pm.worked(1);
            RefactoringStatus result = new RefactoringStatus();
            if (this.fSelectionTypeBinding.isArray()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeTypeRefactoring_arraysNotSupported);
                return refactoringStatus;
            }
            if (this.fSelectionTypeBinding.isPrimitive()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeTypeRefactoring_primitivesNotSupported);
                return refactoringStatus;
            }
            if (this.checkOverriddenBinaryMethods()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeTypeRefactoring_notSupportedOnBinary);
                return refactoringStatus;
            }
            if (this.fSelectionTypeBinding.isLocal()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeTypeRefactoring_localTypesNotSupported);
                return refactoringStatus;
            }
            if (this.fFieldBinding != null && this.fFieldBinding.getDeclaringClass().isLocal()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeTypeRefactoring_insideLocalTypesNotSupported);
                return refactoringStatus;
            }
            if (this.fSelectionTypeBinding.isTypeVariable()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeTypeRefactoring_typeParametersNotSupported);
                return refactoringStatus;
            }
            if (this.fSelectionTypeBinding.isEnum()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeTypeRefactoring_enumsNotSupported);
                return refactoringStatus;
            }
            pm.worked(1);
            if (this.fSelectedType != null) {
                this.computeValidTypes((IProgressMonitor)new NullProgressMonitor());
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private boolean checkOverriddenBinaryMethods() {
        if (this.fMethodBinding != null) {
            Set<ITypeBinding> declaringSupertypes = ChangeTypeRefactoring.getDeclaringSuperTypes(this.fMethodBinding);
            for (ITypeBinding superType : declaringSupertypes) {
                IMethodBinding overriddenMethod = ChangeTypeRefactoring.findMethod(this.fMethodBinding, superType);
                Assert.isNotNull((Object)overriddenMethod);
                IMethod iMethod = (IMethod)overriddenMethod.getJavaElement();
                if (!iMethod.isBinary()) continue;
                return true;
            }
        }
        return false;
    }

    private static IMethodBinding findMethod(IMethodBinding methodBinding, ITypeBinding type) {
        if (methodBinding.getDeclaringClass().equals((Object)type)) {
            return methodBinding;
        }
        return Bindings.findOverriddenMethodInType((ITypeBinding)type, (IMethodBinding)methodBinding);
    }

    private static Set<ITypeBinding> getDeclaringSuperTypes(IMethodBinding methodBinding) {
        ITypeBinding[] allSuperTypes = Bindings.getAllSuperTypes((ITypeBinding)methodBinding.getDeclaringClass());
        HashSet<ITypeBinding> result = new HashSet<ITypeBinding>();
        int i = 0;
        while (i < allSuperTypes.length) {
            ITypeBinding type = allSuperTypes[i];
            if (ChangeTypeRefactoring.findMethod(methodBinding, type) != null) {
                result.add(type);
            }
            ++i;
        }
        return result;
    }

    public Collection<ITypeBinding> computeValidTypes(IProgressMonitor pm) {
        pm.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_checking_preconditions, 100);
        try {
            this.fCv = this.findConstraintVariableForSelectedNode((IProgressMonitor)new SubProgressMonitor(pm, 3));
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.fRelevantVars = this.findRelevantConstraintVars(this.fCv, (IProgressMonitor)new SubProgressMonitor(pm, 50));
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.fRelevantConstraints = this.findRelevantConstraints(this.fRelevantVars, (IProgressMonitor)new SubProgressMonitor(pm, 30));
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.fValidTypes.addAll(this.computeValidTypes(this.fSelectionTypeBinding, this.fRelevantVars, this.fRelevantConstraints, (IProgressMonitor)new SubProgressMonitor(pm, 20)));
        }
        catch (CoreException e) {
            JavaPlugin.logErrorMessage("Error occurred during computation of valid types: " + e.toString());
            this.fValidTypes.clear();
        }
        pm.done();
        return this.fValidTypes;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_checking_preconditions, 1);
        RefactoringStatus result = Checks.validateModifiesFiles(ResourceUtil.getFiles(this.fAffectedUnits), this.getValidationContext());
        pm.done();
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.ChangeTypeMessages_CreateChangesForChangeType, 1);
        try {
            HashMap<ICompilationUnit, Set<ConstraintVariable>> relevantVarsByUnit = new HashMap<ICompilationUnit, Set<ConstraintVariable>>();
            this.groupChangesByCompilationUnit(relevantVarsByUnit);
            HashMap<String, String> arguments = new HashMap<String, String>();
            String project = null;
            IJavaProject javaProject = this.fCu.getJavaProject();
            if (javaProject != null) {
                project = javaProject.getElementName();
            }
            String description = RefactoringCoreMessages.ChangeTypeRefactoring_descriptor_description_short;
            String header = Messages.format(RefactoringCoreMessages.ChangeTypeRefactoring_descriptor_description, new String[]{BindingLabelProvider.getBindingLabel(this.fSelectionBinding, JavaElementLabels.ALL_FULLY_QUALIFIED), BindingLabelProvider.getBindingLabel((IBinding)this.fSelectedType, JavaElementLabels.ALL_FULLY_QUALIFIED)});
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, (Object)this, header);
            comment.addSetting(Messages.format(RefactoringCoreMessages.ChangeTypeRefactoring_original_element_pattern, BindingLabelProvider.getBindingLabel(this.fSelectionBinding, JavaElementLabels.ALL_FULLY_QUALIFIED)));
            comment.addSetting(Messages.format(RefactoringCoreMessages.ChangeTypeRefactoring_original_type_pattern, BindingLabelProvider.getBindingLabel((IBinding)this.getOriginalType(), JavaElementLabels.ALL_FULLY_QUALIFIED)));
            comment.addSetting(Messages.format(RefactoringCoreMessages.ChangeTypeRefactoring_refactored_type_pattern, BindingLabelProvider.getBindingLabel((IBinding)this.fSelectedType, JavaElementLabels.ALL_FULLY_QUALIFIED)));
            GeneralizeTypeDescriptor descriptor = RefactoringSignatureDescriptorFactory.createGeneralizeTypeDescriptor((String)project, (String)description, (String)comment.asString(), arguments, (int)786434);
            arguments.put("input", JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fCu));
            arguments.put("selection", String.valueOf(new Integer(this.fSelectionStart).toString()) + " " + new Integer(this.fSelectionLength).toString());
            arguments.put(ATTRIBUTE_TYPE, this.fSelectedType.getQualifiedName());
            DynamicValidationRefactoringChange result = new DynamicValidationRefactoringChange((JavaRefactoringDescriptor)descriptor, RefactoringCoreMessages.ChangeTypeRefactoring_allChanges);
            for (ICompilationUnit icu : relevantVarsByUnit.keySet()) {
                Set cVars = (Set)relevantVarsByUnit.get(icu);
                CompilationUnitChange cuChange = new CompilationUnitChange(this.getName(), icu);
                this.addAllChangesFor(icu, cVars, cuChange);
                result.add((Change)cuChange);
                pm.worked(1);
                if (!pm.isCanceled()) continue;
                throw new OperationCanceledException();
            }
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = result;
            return dynamicValidationRefactoringChange;
        }
        finally {
            pm.done();
        }
    }

    private void addAllChangesFor(ICompilationUnit icu, Set<ConstraintVariable> vars, CompilationUnitChange unitChange) throws CoreException {
        CompilationUnit unit = new RefactoringASTParser(10).parse((ITypeRoot)icu, true);
        ASTRewrite unitRewriter = ASTRewrite.create((AST)unit.getAST());
        MultiTextEdit root = new MultiTextEdit();
        unitChange.setEdit((TextEdit)root);
        String typeName = this.updateImports(unit, root);
        this.updateCu(unit, vars, unitChange, unitRewriter, typeName);
        root.addChild(unitRewriter.rewriteAST());
    }

    private void updateCu(CompilationUnit unit, Set<ConstraintVariable> vars, CompilationUnitChange unitChange, ASTRewrite unitRewriter, String typeName) throws JavaModelException {
        unitRewriter.setTargetSourceRangeComputer((TargetSourceRangeComputer)new SourceRangeComputer());
        for (ConstraintVariable cv : vars) {
            ASTNode decl = this.findDeclaration(unit, cv);
            if ((decl instanceof SimpleName || decl instanceof QualifiedName) && cv instanceof ExpressionVariable) {
                ASTNode gp = decl.getParent().getParent();
                this.updateType(unit, ChangeTypeRefactoring.getType(gp), unitChange, unitRewriter, typeName);
                continue;
            }
            if (decl instanceof MethodDeclaration || decl instanceof FieldDeclaration) {
                this.updateType(unit, ChangeTypeRefactoring.getType(decl), unitChange, unitRewriter, typeName);
                continue;
            }
            if (!(decl instanceof ParameterizedType)) continue;
            this.updateType(unit, ChangeTypeRefactoring.getType(decl), unitChange, unitRewriter, typeName);
        }
    }

    private void updateType(CompilationUnit cu, Type oldType, CompilationUnitChange unitChange, ASTRewrite unitRewriter, String typeName) {
        String oldName = this.fSelectionTypeBinding.getName();
        Object[] keys = new String[]{BasicElementLabels.getJavaElementName((String)oldName), BasicElementLabels.getJavaElementName((String)typeName)};
        String description = Messages.format(RefactoringCoreMessages.ChangeTypeRefactoring_typeChange, keys);
        TextEditGroup gd = new TextEditGroup(description);
        AST ast = cu.getAST();
        Type nodeToReplace = oldType;
        if (this.fSelectionTypeBinding.isParameterizedType() && !this.fSelectionTypeBinding.isRawType() && oldType.isSimpleType()) {
            nodeToReplace = oldType.getParent();
        }
        Assert.isTrue((this.fSelectedType.isClass() || this.fSelectedType.isInterface() ? 1 : 0) != 0);
        Object newType = null;
        newType = !this.fSelectedType.isParameterizedType() ? ast.newSimpleType(ASTNodeFactory.newName(ast, typeName)) : this.createParameterizedType(ast, this.fSelectedType);
        unitRewriter.replace((ASTNode)nodeToReplace, (ASTNode)newType, gd);
        unitChange.addTextEditGroup(gd);
    }

    private Type createParameterizedType(AST ast, ITypeBinding typeBinding) {
        if (typeBinding.isParameterizedType() && !typeBinding.isRawType()) {
            SimpleType baseType = ast.newSimpleType(ASTNodeFactory.newName(ast, typeBinding.getErasure().getName()));
            ParameterizedType newType = ast.newParameterizedType((Type)baseType);
            int i = 0;
            while (i < typeBinding.getTypeArguments().length) {
                ITypeBinding typeArg = typeBinding.getTypeArguments()[i];
                Type argType = this.createParameterizedType(ast, typeArg);
                newType.typeArguments().add(argType);
                ++i;
            }
            return newType;
        }
        if (!typeBinding.isTypeVariable()) {
            return ast.newSimpleType(ASTNodeFactory.newName(ast, typeBinding.getErasure().getName()));
        }
        return ast.newSimpleType((Name)ast.newSimpleName(typeBinding.getName()));
    }

    private void groupChangesByCompilationUnit(Map<ICompilationUnit, Set<ConstraintVariable>> relevantVarsByUnit) {
        for (ConstraintVariable cv : this.fRelevantVars) {
            if (!(cv instanceof ExpressionVariable) && !(cv instanceof ReturnTypeVariable)) continue;
            ICompilationUnit icu = null;
            if (cv instanceof ExpressionVariable) {
                ExpressionVariable ev = (ExpressionVariable)cv;
                icu = ev.getCompilationUnitRange().getCompilationUnit();
            } else if (cv instanceof ReturnTypeVariable) {
                ReturnTypeVariable rtv = (ReturnTypeVariable)cv;
                IMethodBinding mb = rtv.getMethodBinding();
                icu = ((IMethod)mb.getJavaElement()).getCompilationUnit();
            }
            if (!relevantVarsByUnit.containsKey(icu)) {
                relevantVarsByUnit.put(icu, new HashSet());
            }
            relevantVarsByUnit.get(icu).add(cv);
        }
    }

    private ASTNode findDeclaration(CompilationUnit root, ConstraintVariable cv) throws JavaModelException {
        if (this.fFieldBinding != null) {
            IField f = (IField)this.fFieldBinding.getJavaElement();
            return ASTNodeSearchUtil.getFieldDeclarationNode(f, root);
        }
        if (cv instanceof ExpressionVariable) {
            for (ITypeConstraint constraint : this.fAllConstraints) {
                ConstraintVariable right;
                SimpleTypeConstraint stc;
                if (!constraint.isSimpleTypeConstraint() || !(stc = (SimpleTypeConstraint)constraint).isDefinesConstraint() || !stc.getLeft().equals(cv) || !((right = stc.getRight()) instanceof TypeVariable)) continue;
                TypeVariable typeVariable = (TypeVariable)right;
                return NodeFinder.perform((ASTNode)root, (ISourceRange)typeVariable.getCompilationUnitRange().getSourceRange());
            }
        } else if (cv instanceof ReturnTypeVariable) {
            ReturnTypeVariable rtv = (ReturnTypeVariable)cv;
            IMethodBinding mb = rtv.getMethodBinding();
            IMethod im = (IMethod)mb.getJavaElement();
            return ASTNodeSearchUtil.getMethodDeclarationNode(im, root);
        }
        return null;
    }

    private static Type getType(ASTNode node) {
        switch (node.getNodeType()) {
            case 44: {
                return ((SingleVariableDeclaration)node).getType();
            }
            case 23: {
                return ((FieldDeclaration)node).getType();
            }
            case 60: {
                return ((VariableDeclarationStatement)node).getType();
            }
            case 58: {
                return ((VariableDeclarationExpression)node).getType();
            }
            case 31: {
                return ((MethodDeclaration)node).getReturnType2();
            }
            case 74: {
                return ((ParameterizedType)node).getType();
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public String getName() {
        return RefactoringCoreMessages.ChangeTypeRefactoring_name;
    }

    private String determineSelection(ASTNode node) {
        if (node == null) {
            return RefactoringCoreMessages.ChangeTypeRefactoring_invalidSelection;
        }
        ASTNode parent = node.getParent();
        ASTNode grandParent = parent.getParent();
        if (grandParent == null) {
            return ChangeTypeRefactoring.nodeTypeNotSupported();
        }
        if (grandParent.getNodeType() == 74) {
            node = grandParent;
        }
        ASTNode current = null;
        if (node.getNodeType() == 40) {
            current = node;
            while (current.getNodeType() == 40) {
                current = current.getParent();
            }
            if (current.getNodeType() != 43) {
                return ChangeTypeRefactoring.nodeTypeNotSupported();
            }
            node = current.getParent();
        } else if (parent.getNodeType() == 40) {
            current = parent;
            while (current.getNodeType() == 40) {
                current = current.getParent();
            }
            if (current.getNodeType() != 43) {
                return ChangeTypeRefactoring.nodeTypeNotSupported();
            }
            node = current.getParent();
        }
        this.fObject = node.getAST().resolveWellKnownType("java.lang.Object");
        switch (node.getNodeType()) {
            case 42: {
                return this.simpleNameSelected((SimpleName)node);
            }
            case 60: {
                return this.variableDeclarationStatementSelected((VariableDeclarationStatement)node);
            }
            case 23: {
                return this.fieldDeclarationSelected((FieldDeclaration)node);
            }
            case 44: {
                return this.singleVariableDeclarationSelected((SingleVariableDeclaration)node);
            }
            case 74: {
                return this.parameterizedTypeSelected((ParameterizedType)node);
            }
        }
        return ChangeTypeRefactoring.nodeTypeNotSupported();
    }

    private static String nodeTypeNotSupported() {
        return RefactoringCoreMessages.ChangeTypeRefactoring_notSupportedOnNodeType;
    }

    private String singleVariableDeclarationSelected(SingleVariableDeclaration svd) {
        SimpleName name = svd.getName();
        this.setSelectionRanges((Expression)name);
        return this.simpleNameSelected(name);
    }

    private String parameterizedTypeSelected(ParameterizedType pt) {
        ASTNode parent = pt.getParent();
        if (parent.getNodeType() != 31) {
            if (parent.getNodeType() == 44) {
                return this.singleVariableDeclarationSelected((SingleVariableDeclaration)parent);
            }
            if (parent.getNodeType() == 60) {
                return this.variableDeclarationStatementSelected((VariableDeclarationStatement)parent);
            }
            if (parent.getNodeType() == 23) {
                return this.fieldDeclarationSelected((FieldDeclaration)parent);
            }
            return ChangeTypeRefactoring.nodeTypeNotSupported();
        }
        this.fMethodBinding = ((MethodDeclaration)parent).resolveBinding();
        this.fParamIndex = -1;
        this.fEffectiveSelectionStart = pt.getStartPosition();
        this.fEffectiveSelectionLength = pt.getLength();
        this.setOriginalType(pt.resolveBinding());
        return null;
    }

    private String variableDeclarationStatementSelected(VariableDeclarationStatement vds) {
        if (vds.fragments().size() != 1) {
            return RefactoringCoreMessages.ChangeTypeRefactoring_multiDeclarationsNotSupported;
        }
        VariableDeclarationFragment elem = (VariableDeclarationFragment)vds.fragments().iterator().next();
        SimpleName name = elem.getName();
        this.setSelectionRanges((Expression)name);
        return this.simpleNameSelected(name);
    }

    private String fieldDeclarationSelected(FieldDeclaration fieldDeclaration) {
        if (fieldDeclaration.fragments().size() != 1) {
            return RefactoringCoreMessages.ChangeTypeRefactoring_multiDeclarationsNotSupported;
        }
        VariableDeclarationFragment elem = (VariableDeclarationFragment)fieldDeclaration.fragments().iterator().next();
        this.fFieldBinding = elem.resolveBinding();
        SimpleName name = elem.getName();
        this.setSelectionRanges((Expression)name);
        return this.simpleNameSelected(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String simpleNameSelected(SimpleName simpleName) {
        ASTNode parent = simpleName.getParent();
        ASTNode grandParent = parent.getParent();
        if (parent.getNodeType() == 60) {
            VariableDeclarationStatement vds = (VariableDeclarationStatement)parent;
            if (vds.fragments().size() <= 1) return null;
            return RefactoringCoreMessages.ChangeTypeRefactoring_multiDeclarationsNotSupported;
        }
        if (parent.getNodeType() == 59) {
            if (grandParent.getNodeType() == 60) {
                VariableDeclarationStatement vds = (VariableDeclarationStatement)grandParent;
                if (vds.fragments().size() > 1) {
                    return RefactoringCoreMessages.ChangeTypeRefactoring_multiDeclarationsNotSupported;
                }
                this.setSelectionRanges((Expression)simpleName);
                return null;
            } else if (grandParent.getNodeType() == 58) {
                VariableDeclarationExpression vde = (VariableDeclarationExpression)grandParent;
                if (vde.fragments().size() > 1) {
                    return RefactoringCoreMessages.ChangeTypeRefactoring_multiDeclarationsNotSupported;
                }
                this.setSelectionRanges((Expression)simpleName);
                return null;
            } else {
                if (grandParent.getNodeType() != 23) return RefactoringCoreMessages.ChangeTypeRefactoring_notSupportedOnNodeType;
                FieldDeclaration fd = (FieldDeclaration)grandParent;
                if (fd.fragments().size() > 1) {
                    return RefactoringCoreMessages.ChangeTypeRefactoring_multiDeclarationsNotSupported;
                }
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)parent;
                this.fFieldBinding = fragment.resolveBinding();
                this.setSelectionRanges((Expression)fragment.getName());
            }
            return null;
        } else if (parent.getNodeType() == 44) {
            SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)parent;
            if (singleVariableDeclaration.getType() instanceof UnionType) {
                return RefactoringCoreMessages.ChangeTypeRefactoring_uniontypeNotSupported;
            }
            if (grandParent.getNodeType() == 31) {
                this.fMethodBinding = ((MethodDeclaration)grandParent).resolveBinding();
                this.setOriginalType(simpleName.resolveTypeBinding());
                this.fParamIndex = ((MethodDeclaration)grandParent).parameters().indexOf(parent);
                this.fParamName = singleVariableDeclaration.getName().getIdentifier();
                return null;
            } else {
                this.setSelectionRanges((Expression)singleVariableDeclaration.getName());
            }
            return null;
        } else if (parent.getNodeType() == 43 && grandParent.getNodeType() == 44) {
            ASTNode greatGrandParent = grandParent.getParent();
            SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)grandParent;
            if (singleVariableDeclaration.getExtraDimensions() > 0 || singleVariableDeclaration.isVarargs()) {
                return RefactoringCoreMessages.ChangeTypeRefactoring_arraysNotSupported;
            }
            if (greatGrandParent != null && greatGrandParent.getNodeType() == 31) {
                this.fMethodBinding = ((MethodDeclaration)greatGrandParent).resolveBinding();
                this.fParamIndex = ((MethodDeclaration)greatGrandParent).parameters().indexOf(grandParent);
                this.fParamName = singleVariableDeclaration.getName().getIdentifier();
                this.setSelectionRanges((Expression)simpleName);
                return null;
            } else {
                this.setSelectionRanges((Expression)singleVariableDeclaration.getName());
            }
            return null;
        } else if (parent.getNodeType() == 43 && grandParent.getNodeType() == 31) {
            this.fMethodBinding = ((MethodDeclaration)grandParent).resolveBinding();
            this.setOriginalType(this.fMethodBinding.getReturnType());
            this.fParamIndex = -1;
            return null;
        } else if (parent.getNodeType() == 31 && grandParent.getNodeType() == 55) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)parent;
            if (methodDeclaration.getName().equals((Object)simpleName)) {
                return RefactoringCoreMessages.ChangeTypeRefactoring_notSupportedOnNodeType;
            }
            this.fMethodBinding = ((MethodDeclaration)parent).resolveBinding();
            this.fParamIndex = -1;
            return null;
        } else {
            if (parent.getNodeType() == 43 && grandParent.getNodeType() == 60) {
                return this.variableDeclarationStatementSelected((VariableDeclarationStatement)grandParent);
            }
            if (parent.getNodeType() == 11) {
                ASTNode decl = ChangeTypeRefactoring.findDeclaration(parent.getRoot(), this.fSelectionStart, this.fSelectionLength + 1);
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)decl;
                SimpleName name = fragment.getName();
                this.setSelectionRanges((Expression)name);
                return null;
            } else {
                if (parent.getNodeType() == 43 && grandParent.getNodeType() == 23) {
                    return this.fieldDeclarationSelected((FieldDeclaration)grandParent);
                }
                if (parent.getNodeType() == 43 && grandParent.getNodeType() == 5) {
                    return RefactoringCoreMessages.ChangeTypeRefactoring_arraysNotSupported;
                }
                if (parent.getNodeType() != 40) return RefactoringCoreMessages.ChangeTypeRefactoring_notSupportedOnNodeType;
                this.setSelectionRanges((Expression)simpleName);
            }
        }
        return null;
    }

    private ConstraintVariable findConstraintVariableForSelectedNode(IProgressMonitor pm) {
        pm.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_analyzingMessage, 100);
        ICompilationUnit[] cus = new ICompilationUnit[]{this.fCu};
        Collection<ITypeConstraint> allConstraints = this.getConstraints(cus, (IProgressMonitor)new SubProgressMonitor(pm, 50));
        SubProgressMonitor subMonitor = new SubProgressMonitor(pm, 50);
        subMonitor.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_analyzingMessage, allConstraints.size());
        Iterator<ITypeConstraint> it = allConstraints.iterator();
        while (it.hasNext()) {
            subMonitor.worked(1);
            ITypeConstraint tc = it.next();
            if (!(tc instanceof SimpleTypeConstraint)) continue;
            SimpleTypeConstraint stc = (SimpleTypeConstraint)tc;
            if (this.matchesSelection(stc.getLeft())) {
                return stc.getLeft();
            }
            if (!this.matchesSelection(stc.getRight())) continue;
            return stc.getRight();
        }
        subMonitor.done();
        pm.done();
        Assert.isTrue((boolean)false, (String)RefactoringCoreMessages.ChangeTypeRefactoring_noMatchingConstraintVariable);
        return null;
    }

    private boolean matchesSelection(ConstraintVariable cv) {
        if (cv instanceof ExpressionVariable) {
            ExpressionVariable ev = (ExpressionVariable)cv;
            return this.fSelectionBinding != null && Bindings.equals((IBinding)this.fSelectionBinding, (IBinding)ev.getExpressionBinding());
        }
        if (cv instanceof ParameterTypeVariable) {
            ParameterTypeVariable ptv = (ParameterTypeVariable)cv;
            if (this.fMethodBinding != null && Bindings.equals((IBinding)ptv.getMethodBinding(), (IBinding)this.fMethodBinding) && ptv.getParameterIndex() == this.fParamIndex) {
                return true;
            }
        } else if (cv instanceof ReturnTypeVariable) {
            ReturnTypeVariable rtv = (ReturnTypeVariable)cv;
            if (this.fMethodBinding != null && Bindings.equals((IBinding)rtv.getMethodBinding(), (IBinding)this.fMethodBinding) && this.fParamIndex == -1) {
                return true;
            }
        }
        return false;
    }

    private Collection<ConstraintVariable> findRelevantConstraintVars(ConstraintVariable cv, IProgressMonitor pm) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_analyzingMessage, 150);
        HashSet<ConstraintVariable> result = new HashSet<ConstraintVariable>();
        result.add(cv);
        ICompilationUnit[] cus = this.collectAffectedUnits((IProgressMonitor)new SubProgressMonitor(pm, 50));
        Collection<ITypeConstraint> allConstraints = this.getConstraints(cus, (IProgressMonitor)new SubProgressMonitor(pm, 50));
        ArrayList<ConstraintVariable> workList = new ArrayList<ConstraintVariable>(result);
        while (!workList.isEmpty()) {
            pm.worked(10);
            ConstraintVariable first = (ConstraintVariable)workList.remove(0);
            Iterator<ITypeConstraint> iter = allConstraints.iterator();
            while (iter.hasNext()) {
                ConstraintVariable match;
                SimpleTypeConstraint stc;
                pm.worked(1);
                ITypeConstraint typeConstraint = iter.next();
                if (!typeConstraint.isSimpleTypeConstraint() || !(stc = (SimpleTypeConstraint)typeConstraint).isDefinesConstraint() && !stc.isEqualsConstraint() || !((match = ChangeTypeRefactoring.match(first, stc.getLeft(), stc.getRight())) instanceof ExpressionVariable) && !(match instanceof ParameterTypeVariable) && !(match instanceof ReturnTypeVariable) || result.contains(match)) continue;
                workList.add(match);
                result.add(match);
            }
        }
        pm.done();
        return result;
    }

    private static ConstraintVariable match(ConstraintVariable matchee, ConstraintVariable left, ConstraintVariable right) {
        if (matchee.equals(left)) {
            return right;
        }
        if (matchee.equals(right)) {
            return left;
        }
        return null;
    }

    private Collection<ITypeConstraint> findRelevantConstraints(Collection<ConstraintVariable> relevantConstraintVars, IProgressMonitor pm) throws CoreException {
        ICompilationUnit[] cus = this.collectAffectedUnits((IProgressMonitor)new SubProgressMonitor(pm, 100));
        this.fAllConstraints = this.getConstraints(cus, (IProgressMonitor)new SubProgressMonitor(pm, 900));
        pm.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_analyzingMessage, 1000 + this.fAllConstraints.size());
        ArrayList<ITypeConstraint> result = new ArrayList<ITypeConstraint>();
        for (ITypeConstraint tc : this.fAllConstraints) {
            if (tc.isSimpleTypeConstraint()) {
                SimpleTypeConstraint stc = (SimpleTypeConstraint)tc;
                if (stc.isDefinesConstraint() || stc.isEqualsConstraint() || stc.getLeft().equals(stc.getRight()) || ChangeTypeRefactoring.isNull(stc.getLeft())) continue;
                if (relevantConstraintVars.contains(stc.getLeft()) || relevantConstraintVars.contains(stc.getRight())) {
                    result.add(tc);
                }
            } else {
                CompositeOrTypeConstraint cotc = (CompositeOrTypeConstraint)tc;
                ITypeConstraint[] components = cotc.getConstraints();
                int i = 0;
                while (i < components.length) {
                    ITypeConstraint component = components[i];
                    SimpleTypeConstraint simpleComponent = (SimpleTypeConstraint)component;
                    if (relevantConstraintVars.contains(simpleComponent.getLeft())) {
                        result.add(tc);
                    }
                    ++i;
                }
            }
            pm.worked(1);
        }
        pm.done();
        return result;
    }

    private static ASTNode findDeclaration(ASTNode root, int start, int length) {
        ASTNode node = NodeFinder.perform((ASTNode)root, (int)start, (int)length);
        Assert.isTrue((boolean)(node instanceof SimpleName), (String)String.valueOf(node.getNodeType()));
        Assert.isTrue((boolean)(root instanceof CompilationUnit), (String)String.valueOf(root.getNodeType()));
        return ((CompilationUnit)root).findDeclaringNode(((SimpleName)node).resolveBinding());
    }

    static String print(Collection<ITypeBinding> types) {
        if (types.isEmpty()) {
            return "{ }";
        }
        String result = "{ ";
        Iterator<ITypeBinding> it = types.iterator();
        while (it.hasNext()) {
            ITypeBinding type = it.next();
            result = String.valueOf(result) + type.getQualifiedName();
            result = it.hasNext() ? String.valueOf(result) + ", " : String.valueOf(result) + " }";
        }
        return result;
    }

    private Collection<ITypeBinding> computeValidTypes(ITypeBinding originalType, Collection<ConstraintVariable> relevantVars, Collection<ITypeConstraint> relevantConstraints, IProgressMonitor pm) throws JavaModelException {
        HashSet<ITypeBinding> result = new HashSet<ITypeBinding>();
        HashSet<ITypeBinding> allTypes = new HashSet<ITypeBinding>();
        allTypes.addAll(this.getAllSuperTypes(originalType));
        pm.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_analyzingMessage, allTypes.size());
        for (ITypeBinding type : allTypes) {
            if (!this.isValid(type, relevantVars, relevantConstraints, (IProgressMonitor)new SubProgressMonitor(pm, 1))) continue;
            result.add(type);
        }
        result.remove(originalType);
        pm.done();
        return result;
    }

    private boolean isValid(ITypeBinding type, Collection<ConstraintVariable> relevantVars, Collection<ITypeConstraint> constraints, IProgressMonitor pm) throws JavaModelException {
        pm.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_analyzingMessage, constraints.size());
        ICompilationUnit[] iCompilationUnitArray = this.fAffectedUnits;
        int n = this.fAffectedUnits.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit cu = iCompilationUnitArray[n2];
            if (!JavaModelUtil.isVisibleInHierarchy((IMember)((IMember)type.getJavaElement()), (IPackageFragment)((IPackageFragment)cu.getParent()))) {
                return false;
            }
            ++n2;
        }
        for (ITypeConstraint tc : constraints) {
            if (tc instanceof SimpleTypeConstraint ? !this.isValidSimpleConstraint(type, relevantVars, (SimpleTypeConstraint)tc) : tc instanceof CompositeOrTypeConstraint && !this.isValidOrConstraint(type, relevantVars, (CompositeOrTypeConstraint)tc)) {
                return false;
            }
            pm.worked(1);
        }
        pm.done();
        return true;
    }

    private boolean isValidSimpleConstraint(ITypeBinding type, Collection<ConstraintVariable> relevantVars, SimpleTypeConstraint stc) {
        return !relevantVars.contains(stc.getLeft()) || this.isSubTypeOf(type, this.findType(stc.getRight()));
    }

    private boolean isValidOrConstraint(ITypeBinding type, Collection<ConstraintVariable> relevantVars, CompositeOrTypeConstraint cotc) {
        ITypeConstraint[] components = cotc.getConstraints();
        int i = 0;
        while (i < components.length) {
            SimpleTypeConstraint sc;
            if (components[i] instanceof SimpleTypeConstraint && (relevantVars.contains((sc = (SimpleTypeConstraint)components[i]).getLeft()) ? this.isSubTypeOf(type, this.findType(sc.getRight())) : relevantVars.contains(sc.getRight()) && this.isSubTypeOf(this.findType(sc.getLeft()), type))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private ITypeBinding findType(ConstraintVariable cv) {
        return cv.getBinding();
    }

    private Collection<ITypeConstraint> getConstraints(ICompilationUnit[] referringCus, IProgressMonitor pm) {
        pm.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_analyzingMessage, referringCus.length);
        ArrayList<ITypeConstraint> result = new ArrayList<ITypeConstraint>();
        int i = 0;
        while (i < referringCus.length) {
            result.addAll(this.getConstraints(referringCus[i]));
            pm.worked(1);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            ++i;
        }
        pm.done();
        return result;
    }

    private List<ITypeConstraint> getConstraints(ICompilationUnit unit) {
        if (this.fConstraintCache.containsKey(unit)) {
            return this.fConstraintCache.get(unit);
        }
        CompilationUnit cu = ASTCreator.createAST(unit, null);
        if (this.fMethodBinding != null && this.fCuToSearchResultGroup.containsKey(unit)) {
            SearchResultGroup group = this.fCuToSearchResultGroup.get(unit);
            ASTNode[] nodes = ASTNodeSearchUtil.getAstNodes(group.getSearchResults(), cu);
            int i = 0;
            while (i < nodes.length) {
                ASTNode node = nodes[i];
                if (this.fMethodBinding != null) {
                    ASTNode n = node;
                    while (n != null && !(n instanceof MethodDeclaration)) {
                        n = n.getParent();
                    }
                    MethodDeclaration md = (MethodDeclaration)n;
                    if (md != null) {
                        md.accept((ASTVisitor)this.fCollector);
                    }
                }
                ++i;
            }
        } else {
            cu.accept((ASTVisitor)this.fCollector);
        }
        List<ITypeConstraint> constraints = Arrays.asList(this.fCollector.getConstraints());
        this.fConstraintCache.put(unit, constraints);
        return constraints;
    }

    private String updateImports(CompilationUnit astRoot, MultiTextEdit rootEdit) throws CoreException {
        ImportRewrite rewrite = StubUtility.createImportRewrite(astRoot, true);
        ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext(astRoot, this.fSelectionStart, rewrite);
        String typeName = rewrite.addImport(this.fSelectedType.getQualifiedName(), (ImportRewrite.ImportRewriteContext)context);
        rootEdit.addChild(rewrite.rewriteImports(null));
        return typeName;
    }

    public Collection<ITypeBinding> getValidTypes() {
        return this.fValidTypes;
    }

    public ITypeBinding getOriginalType() {
        return this.fSelectionTypeBinding;
    }

    private void setOriginalType(ITypeBinding originalType) {
        this.fSelectionTypeBinding = originalType;
        this.fSelectedType = this.findSuperTypeByName(originalType, this.fSelectedTypeName);
    }

    public String getTarget() {
        String typeName;
        String string = typeName = this.fSelectionTypeBinding == null ? "" : String.valueOf(this.fSelectionTypeBinding.getName()) + " ";
        if (this.fFieldBinding != null) {
            return String.valueOf(typeName) + this.fFieldBinding.getName();
        }
        if (this.fMethodBinding != null) {
            if (this.fParamIndex == -1) {
                return String.valueOf(typeName) + this.fMethodBinding.getName() + "(...)";
            }
            return String.valueOf(typeName) + this.fParamName;
        }
        if (this.fSelectionBinding != null) {
            return String.valueOf(typeName) + this.fSelectionBinding.getName();
        }
        return typeName;
    }

    public Collection<String> getValidTypeNames() {
        ArrayList<String> typeNames = new ArrayList<String>();
        for (ITypeBinding type : this.fValidTypes) {
            typeNames.add(type.getQualifiedName());
        }
        return typeNames;
    }

    private ASTNode getTargetNode(ICompilationUnit unit, int offset, int length) {
        CompilationUnit root = ASTCreator.createAST(unit, null);
        ASTNode node = NodeFinder.perform((ASTNode)root, (int)offset, (int)length);
        return node;
    }

    private ICompilationUnit[] collectAffectedUnits(IProgressMonitor pm) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_analyzingMessage, 100);
        if (this.fAffectedUnits != null) {
            pm.worked(100);
            return this.fAffectedUnits;
        }
        if (this.fMethodBinding != null) {
            if (this.fMethodBinding != null) {
                IMethod root;
                IMethod selectedMethod = (IMethod)this.fMethodBinding.getJavaElement();
                if (selectedMethod == null) {
                    Assert.isTrue((boolean)false, (String)RefactoringCoreMessages.ChangeTypeRefactoring_no_method);
                }
                if (!(root = selectedMethod).getDeclaringType().isInterface() && MethodChecks.isVirtual(root)) {
                    SubProgressMonitor subMonitor = new SubProgressMonitor(pm, 5);
                    IMethod inInterface = MethodChecks.isDeclaredInInterface(root, root.getDeclaringType().newTypeHierarchy((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 1)), (IProgressMonitor)subMonitor);
                    if (inInterface != null && !inInterface.equals(root)) {
                        root = inInterface;
                    }
                }
                IMethod[] rippleMethods = RippleMethodFinder2.getRelatedMethods(root, (IProgressMonitor)new SubProgressMonitor(pm, 15), null);
                SearchPattern pattern = RefactoringSearchEngine.createOrPattern((IJavaElement[])rippleMethods, 3);
                IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)selectedMethod);
                CollectingSearchRequestor csr = new CollectingSearchRequestor();
                SearchResultGroup[] groups = RefactoringSearchEngine.search(pattern, null, scope, csr, (IProgressMonitor)new SubProgressMonitor(pm, 80), new RefactoringStatus());
                this.fAffectedUnits = this.getCus(groups);
            }
        } else if (this.fFieldBinding != null) {
            IField iField = (IField)this.fFieldBinding.getJavaElement();
            if (iField == null) {
                Assert.isTrue((boolean)false, (String)RefactoringCoreMessages.ChangeTypeRefactoring_no_filed);
            }
            SearchPattern pattern = SearchPattern.createPattern((IJavaElement)iField, (int)3, (int)24);
            IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)iField);
            CollectingSearchRequestor csr = new CollectingSearchRequestor();
            SearchResultGroup[] groups = RefactoringSearchEngine.search(pattern, null, scope, csr, (IProgressMonitor)new SubProgressMonitor(pm, 100), new RefactoringStatus());
            this.fAffectedUnits = this.getCus(groups);
        } else {
            this.fAffectedUnits = new ICompilationUnit[]{this.fCu};
        }
        pm.done();
        return this.fAffectedUnits;
    }

    public void setSelectedType(ITypeBinding type) {
        this.fSelectedType = type;
    }

    private static boolean isNull(ConstraintVariable cv) {
        return cv instanceof ExpressionVariable && ((ExpressionVariable)cv).getExpressionType() == 33;
    }

    void printCollection(String title, Collection<?> l) {
        System.out.println(String.valueOf(l.size()) + " " + title);
        Iterator<?> it = l.iterator();
        while (it.hasNext()) {
            System.out.println("  " + it.next());
        }
    }

    private ICompilationUnit[] getCus(SearchResultGroup[] groups) {
        ArrayList<ICompilationUnit> result = new ArrayList<ICompilationUnit>(groups.length);
        int i = 0;
        while (i < groups.length) {
            SearchResultGroup group = groups[i];
            ICompilationUnit cu = group.getCompilationUnit();
            if (cu != null) {
                result.add(cu);
                this.fCuToSearchResultGroup.put(cu, group);
            }
            ++i;
        }
        return result.toArray(new ICompilationUnit[result.size()]);
    }

    public Set<ITypeBinding> getAllSuperTypes(ITypeBinding type) {
        HashSet<ITypeBinding> result = new HashSet<ITypeBinding>();
        result.add(type);
        if (type.getSuperclass() != null) {
            result.addAll(this.getAllSuperTypes(type.getSuperclass()));
        }
        ITypeBinding[] interfaces = type.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            result.addAll(this.getAllSuperTypes(interfaces[i]));
            ++i;
        }
        if (type != this.fObject && !ChangeTypeRefactoring.contains(result, this.fObject)) {
            result.add(this.fObject);
        }
        return result;
    }

    private ITypeBinding findSuperTypeByName(ITypeBinding type, String superTypeName) {
        Set<ITypeBinding> superTypes = this.getAllSuperTypes(type);
        for (ITypeBinding sup : superTypes) {
            if (!sup.getQualifiedName().equals(superTypeName)) continue;
            return sup;
        }
        return null;
    }

    public boolean isSubTypeOf(ITypeBinding type1, ITypeBinding type2) {
        if (type1.isParameterizedType() && type1.getTypeDeclaration().isEqualTo((IBinding)type2.getTypeDeclaration())) {
            return true;
        }
        Set<ITypeBinding> superTypes = this.getAllSuperTypes(type1);
        return ChangeTypeRefactoring.contains(superTypes, type2);
    }

    private static boolean contains(Collection<ITypeBinding> c, ITypeBinding binding) {
        for (ITypeBinding b : c) {
            if (!Bindings.equals((IBinding)b, (IBinding)binding)) continue;
            return true;
        }
        return false;
    }

    private RefactoringStatus initialize(JavaRefactoringArguments arguments) {
        IJavaElement element;
        int length;
        int offset;
        String selection = arguments.getAttribute("selection");
        if (selection != null) {
            offset = -1;
            length = -1;
            StringTokenizer tokenizer = new StringTokenizer(selection);
            if (tokenizer.hasMoreTokens()) {
                offset = Integer.valueOf(tokenizer.nextToken());
            }
            if (tokenizer.hasMoreTokens()) {
                length = Integer.valueOf(tokenizer.nextToken());
            }
            if (offset < 0 || length < 0) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{selection, "selection"}));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
        }
        this.fSelectionStart = offset;
        this.fSelectionLength = length;
        String handle = arguments.getAttribute("input");
        if (handle != null) {
            element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), handle, false);
            if (element == null || !element.exists() || element.getElementType() != 5) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getName(), "org.eclipse.jdt.ui.change.type");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        this.fCu = (ICompilationUnit)element;
        String type = arguments.getAttribute(ATTRIBUTE_TYPE);
        if (type == null || "".equals(type)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_TYPE));
        }
        this.fSelectedTypeName = type;
        return new RefactoringStatus();
    }

    private class SourceRangeComputer
    extends TargetSourceRangeComputer {
        private SourceRangeComputer() {
        }

        public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode node) {
            return new TargetSourceRangeComputer.SourceRange(node.getStartPosition(), node.getLength());
        }
    }
}

