/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.properties.sections.contribution.featurecontribution;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.sirius.description.contribution.Contribution;
import org.eclipse.sirius.description.contribution.ContributionPackage;
import org.eclipse.sirius.description.contribution.DirectEObjectReference;
import org.eclipse.sirius.editor.editorPlugin.SiriusEditor;
import org.eclipse.sirius.editor.properties.sections.common.AbstractComboPropertySection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class FeatureContributionTargetFeaturePropertySection
extends AbstractComboPropertySection {
    @Override
    protected String getDefaultLabelText() {
        return "TargetFeature";
    }

    @Override
    protected String getLabelText() {
        String labelText = String.valueOf(super.getLabelText()) + "*:";
        return labelText;
    }

    protected EReference getFeature() {
        return ContributionPackage.eINSTANCE.getFeatureContribution_TargetFeature();
    }

    @Override
    protected Object getFeatureValue(int index) {
        return this.getFeatureValueAt(index);
    }

    @Override
    protected boolean isEqual(int index) {
        boolean isEqual = false;
        isEqual = this.getFeatureValueAt(index) == null ? this.eObject.eGet((EStructuralFeature)this.getFeature()) == null : this.getFeatureValueAt(index).equals(this.eObject.eGet((EStructuralFeature)this.getFeature()));
        return isEqual;
    }

    protected Object getFeatureValueAt(int index) {
        List<?> values = this.getChoiceOfValues();
        if (values.size() < index || values.size() == 0 || index == -1) {
            return null;
        }
        return values.get(index);
    }

    @Override
    protected List<?> getChoiceOfValues() {
        EObject actualTarget;
        Contribution contrib;
        ArrayList values = Collections.emptyList();
        List<IItemPropertyDescriptor> propertyDescriptors = this.getDescriptors();
        for (IItemPropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if ((EStructuralFeature)propertyDescriptor.getFeature((Object)this.eObject) != this.getFeature()) continue;
            values = new ArrayList(propertyDescriptor.getChoiceOfValues((Object)this.eObject));
        }
        if (this.eObject.eContainer() instanceof Contribution && (contrib = (Contribution)this.eObject.eContainer()).getTarget() instanceof DirectEObjectReference && (actualTarget = ((DirectEObjectReference)contrib.getTarget()).getValue()) != null) {
            EClass targetType = actualTarget.eClass();
            values = Lists.newArrayList((Iterable)targetType.getEAllStructuralFeatures());
        }
        return values;
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.combo.setToolTipText("The feature in the target object to which the contribution values are applied.");
        CLabel help = this.getWidgetFactory().createCLabel(this.composite, "");
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.combo, 0, 128);
        data.left = new FormAttachment((Control)this.nameLabel);
        help.setLayoutData((Object)data);
        help.setImage(this.getHelpIcon());
        help.setToolTipText("The feature in the target object to which the contribution values are applied.");
        this.nameLabel.setFont(SiriusEditor.getFontRegistry().get("required"));
    }
}

