/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.commands;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionAnchorsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.sirius.diagram.ui.business.api.query.ConnectionEditPartQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.EdgeQuery;
import org.eclipse.sirius.diagram.ui.business.internal.operation.ShiftDirectBorderedNodesOperation;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramBorderNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramEdgeEditPart;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SetConnectionBendpointsAndLabelCommmand;
import org.eclipse.sirius.diagram.ui.internal.edit.commands.ChangeBendpointsOfEdgesCommand;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.diagram.ui.internal.refresh.borderednode.CanonicalDBorderItemLocator;
import org.eclipse.sirius.diagram.ui.internal.refresh.edge.SlidableAnchor;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IBorderItemOffsets;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.straighten.StraightenToAction;
import org.eclipse.sirius.diagram.ui.tools.internal.edit.command.CommandFactory;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;

public class StraightenToCommand
extends AbstractTransactionalCommand {
    Map<AbstractDiagramEdgeEditPart, StraightenToCommandData> edgeEditParts = Maps.newHashMap();
    Map<AbstractDiagramEdgeEditPart, StraightenToCommandData> edgeEditPartsToStraighten = Maps.newHashMap();
    private int straightenType;
    private List<Node> movedBorderNodes;

    public StraightenToCommand(AbstractDiagramEdgeEditPart edgeEditPart, int straightenType, List<AbstractDiagramEdgeEditPart> selectedEdgeEditParts) {
        super(edgeEditPart.getEditingDomain(), StraightenToAction.getLabel(straightenType), null);
        this.straightenType = straightenType;
        for (AbstractDiagramEdgeEditPart selectedEdgeEditPart : selectedEdgeEditParts) {
            StraightenToCommandData straightenToCommandData = new StraightenToCommandData();
            if (selectedEdgeEditPart.getSource() instanceof IGraphicalEditPart) {
                straightenToCommandData.sourceEditPart = (IGraphicalEditPart)selectedEdgeEditPart.getSource();
            }
            if (selectedEdgeEditPart.getTarget() instanceof IGraphicalEditPart) {
                straightenToCommandData.targetEditPart = (IGraphicalEditPart)selectedEdgeEditPart.getTarget();
            }
            this.edgeEditParts.put(selectedEdgeEditPart, straightenToCommandData);
        }
    }

    public boolean canExecute() {
        StraightenToCommandData data;
        AbstractDiagramEdgeEditPart edgeEditPart;
        boolean canExecuteThisEdge;
        boolean canExecute = true;
        for (Map.Entry<AbstractDiagramEdgeEditPart, StraightenToCommandData> edgeEditPartWithData : this.edgeEditParts.entrySet()) {
            canExecuteThisEdge = true;
            edgeEditPart = edgeEditPartWithData.getKey();
            data = edgeEditPartWithData.getValue();
            Object model = edgeEditPart.getModel();
            if (model instanceof Edge && data.sourceEditPart != null && data.targetEditPart != null) {
                Edge edge = (Edge)model;
                EdgeQuery edgeQuery = new EdgeQuery(edge);
                boolean bl = canExecuteThisEdge = !edgeQuery.isEdgeWithTreeRoutingStyle();
                if (canExecuteThisEdge) {
                    boolean bl2 = canExecuteThisEdge = !(data.sourceEditPart instanceof org.eclipse.gef.ConnectionEditPart) && !(data.targetEditPart instanceof org.eclipse.gef.ConnectionEditPart);
                }
                if (canExecuteThisEdge) {
                    data.isSourceABorderNode = data.sourceEditPart instanceof AbstractDiagramBorderNodeEditPart;
                    data.isTargetABorderNode = data.targetEditPart instanceof AbstractDiagramBorderNodeEditPart;
                    int axis = this.getSourceAndTargetSameAxis(edgeEditPart, data);
                    boolean bl3 = canExecuteThisEdge = axis != 0;
                    if (canExecuteThisEdge) {
                        if (axis == 64 && (this.straightenType == 0 || this.straightenType == 1 || this.straightenType == 4 || this.straightenType == 5) || axis == 128 && (this.straightenType == 2 || this.straightenType == 3 || this.straightenType == 6 || this.straightenType == 7)) {
                            data.moveSource = this.isSourceWillBeMoved(edgeEditPart, data);
                        } else {
                            canExecuteThisEdge = false;
                        }
                    }
                }
                if (canExecuteThisEdge) {
                    boolean bl4 = canExecuteThisEdge = !this.isCentered(edgeEditPart, data);
                }
            }
            if (canExecuteThisEdge) {
                this.edgeEditPartsToStraighten.put(edgeEditPart, data);
            }
            boolean bl = canExecute = canExecute || canExecuteThisEdge;
        }
        if (canExecute) {
            for (Map.Entry<AbstractDiagramEdgeEditPart, StraightenToCommandData> edgeEditPartWithData : this.edgeEditParts.entrySet()) {
                canExecuteThisEdge = true;
                edgeEditPart = edgeEditPartWithData.getKey();
                data = edgeEditPartWithData.getValue();
                if (canExecuteThisEdge) {
                    canExecuteThisEdge = this.isNewLocationInParentBounds(edgeEditPart, data);
                }
                if (canExecuteThisEdge) {
                    this.movedBorderNodes = this.getMovedBorderNodes();
                    boolean bl = canExecuteThisEdge = !this.isOverlapped(edgeEditPart, data);
                }
                if (canExecuteThisEdge) continue;
                this.edgeEditPartsToStraighten.remove(edgeEditPart);
            }
        }
        return this.edgeEditPartsToStraighten.size() > 0;
    }

    private List<Node> getMovedBorderNodes() {
        ArrayList movedNodes = Lists.newArrayList();
        for (StraightenToCommandData data : this.edgeEditParts.values()) {
            if (data.moveSource && data.isSourceABorderNode) {
                if (!(data.sourceEditPart.getModel() instanceof Node)) continue;
                movedNodes.add((Node)data.sourceEditPart.getModel());
                continue;
            }
            if (data.moveSource || !data.isTargetABorderNode || !(data.targetEditPart.getModel() instanceof Node)) continue;
            movedNodes.add((Node)data.targetEditPart.getModel());
        }
        return movedNodes;
    }

    public boolean canUndo() {
        return true;
    }

    public boolean canRedo() {
        return true;
    }

    public void dispose() {
        this.edgeEditParts = null;
        this.movedBorderNodes = null;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        CommandResult commandResult = CommandResult.newOKCommandResult();
        for (Map.Entry<AbstractDiagramEdgeEditPart, StraightenToCommandData> edgeEditPartWithData : this.edgeEditPartsToStraighten.entrySet()) {
            AbstractDiagramEdgeEditPart edgeEditPart = edgeEditPartWithData.getKey();
            StraightenToCommandData data = edgeEditPartWithData.getValue();
            if (!(edgeEditPart.getFigure() instanceof Connection) || !(edgeEditPart.getModel() instanceof Edge)) continue;
            CompositeCommand cc = new CompositeCommand(this.getLabel());
            Rectangle sourceBounds = GraphicalHelper.getAbsoluteBoundsIn100Percent((GraphicalEditPart)data.sourceEditPart);
            Rectangle targetBounds = GraphicalHelper.getAbsoluteBoundsIn100Percent((GraphicalEditPart)data.targetEditPart);
            Connection figure = (Connection)edgeEditPart.getFigure();
            Point firstPoint = figure.getPoints().getFirstPoint().getCopy();
            Point lastPoint = figure.getPoints().getLastPoint().getCopy();
            if (data.moveSource) {
                if (data.isSourceABorderNode) {
                    sourceBounds = sourceBounds.getTranslated(data.deltaX, data.deltaY);
                }
                if (data.isSpecificCase) {
                    this.computePointsInSpecificCase(firstPoint, lastPoint, sourceBounds, targetBounds);
                } else {
                    firstPoint = firstPoint.getTranslated(data.deltaX, data.deltaY);
                }
                this.completeCommand(cc, edgeEditPartWithData, data.sourceEditPart, data.isSourceABorderNode, sourceBounds, targetBounds, firstPoint, lastPoint);
            } else {
                if (data.isTargetABorderNode) {
                    targetBounds = targetBounds.getTranslated(data.deltaX, data.deltaY);
                }
                if (data.isSpecificCase) {
                    this.computePointsInSpecificCase(firstPoint, lastPoint, sourceBounds, targetBounds);
                } else {
                    lastPoint = lastPoint.getTranslated(data.deltaX, data.deltaY);
                }
                this.completeCommand(cc, edgeEditPartWithData, data.targetEditPart, data.isTargetABorderNode, sourceBounds, targetBounds, firstPoint, lastPoint);
            }
            IStatus status = cc.execute(monitor, info);
            if (status == null || status.isOK()) continue;
            if (status.getSeverity() == 8) {
                commandResult = CommandResult.newCancelledCommandResult();
                continue;
            }
            if (status.getSeverity() != 4) continue;
            commandResult = CommandResult.newErrorCommandResult((Throwable)status.getException());
        }
        return commandResult;
    }

    private void computePointsInSpecificCase(Point firstPoint, Point lastPoint, Rectangle sourceBounds, Rectangle targetBounds) {
        if (this.straightenType == 0 || this.straightenType == 1 || this.straightenType == 4 || this.straightenType == 5) {
            firstPoint.setX(firstPoint.x).setY(sourceBounds.getCenter().y);
            lastPoint.setX(lastPoint.x).setY(targetBounds.getCenter().y);
        } else {
            firstPoint.setX(sourceBounds.getCenter().x).setY(firstPoint.y);
            lastPoint.setX(targetBounds.getCenter().x).setY(lastPoint.y);
        }
    }

    private void completeCommand(CompositeCommand command, Map.Entry<AbstractDiagramEdgeEditPart, StraightenToCommandData> edgeEditPartWithData, IGraphicalEditPart editPartOnMovedSide, boolean isABorderNode, Rectangle sourceBounds, Rectangle targetBounds, Point firstPoint, Point lastPoint) {
        if (isABorderNode) {
            command.add((IUndoableOperation)CommandFactory.createICommand(this.getEditingDomain(), new ShiftDirectBorderedNodesOperation(Lists.newArrayList((Object[])new Node[]{(Node)editPartOnMovedSide.getModel()}), new Dimension(edgeEditPartWithData.getValue().deltaX, edgeEditPartWithData.getValue().deltaY))));
            if (editPartOnMovedSide.getSourceConnections().size() + editPartOnMovedSide.getTargetConnections().size() > 1) {
                PrecisionPoint moveDelta = new PrecisionPoint(edgeEditPartWithData.getValue().deltaX, edgeEditPartWithData.getValue().deltaY);
                GraphicalHelper.applyZoomOnPoint((IGraphicalEditPart)editPartOnMovedSide, (Point)moveDelta);
                ChangeBendpointsOfEdgesCommand cboec = new ChangeBendpointsOfEdgesCommand(editPartOnMovedSide, moveDelta);
                cboec.setIgnoreSelectionChecks(true);
                command.add((IUndoableOperation)cboec);
            }
        }
        SetConnectionAnchorsCommand scaCommand = new SetConnectionAnchorsCommand(this.getEditingDomain(), "");
        PrecisionPoint newSourceAnchor = BaseSlidableAnchor.getAnchorRelativeLocation((Point)firstPoint, (Rectangle)sourceBounds);
        scaCommand.setNewSourceTerminal(SlidableAnchor.composeTerminalString(newSourceAnchor));
        PrecisionPoint newTargetAnchor = BaseSlidableAnchor.getAnchorRelativeLocation((Point)lastPoint, (Rectangle)targetBounds);
        scaCommand.setNewTargetTerminal(SlidableAnchor.composeTerminalString(newTargetAnchor));
        scaCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)((Edge)edgeEditPartWithData.getKey().getModel())));
        command.add((IUndoableOperation)scaCommand);
        SetConnectionBendpointsAndLabelCommmand resetBendpointsCmd = new SetConnectionBendpointsAndLabelCommmand(this.getEditingDomain());
        resetBendpointsCmd.setEdgeAdapter((IAdaptable)new EObjectAdapter((EObject)((Edge)edgeEditPartWithData.getKey().getModel())));
        PointList newPointList = new PointList(2);
        newPointList.addPoint(firstPoint);
        newPointList.addPoint(lastPoint);
        resetBendpointsCmd.setNewPointList(newPointList, firstPoint, lastPoint);
        resetBendpointsCmd.setLabelsToUpdate((ConnectionEditPart)edgeEditPartWithData.getKey());
        command.add((IUndoableOperation)resetBendpointsCmd);
    }

    private int getSourceAndTargetSameAxis(AbstractDiagramEdgeEditPart edgeEditPart, StraightenToCommandData data) {
        int axis = 0;
        int sideOfSource = 0;
        if (data.isSourceABorderNode) {
            sideOfSource = ((IBorderItemEditPart)edgeEditPart.getSource()).getBorderItemLocator().getCurrentSideOfParent();
        } else if (edgeEditPart.getSource() instanceof GraphicalEditPart && edgeEditPart.getFigure() instanceof Connection) {
            Point firstPoint = ((Connection)edgeEditPart.getFigure()).getPoints().getFirstPoint();
            sideOfSource = this.getLocation(firstPoint, GraphicalHelper.getAbsoluteBoundsIn100Percent((GraphicalEditPart)((GraphicalEditPart)edgeEditPart.getSource())));
        }
        int sideOfTarget = 0;
        if (data.isTargetABorderNode) {
            sideOfTarget = ((IBorderItemEditPart)edgeEditPart.getTarget()).getBorderItemLocator().getCurrentSideOfParent();
        } else if (edgeEditPart.getTarget() instanceof GraphicalEditPart && edgeEditPart.getFigure() instanceof Connection) {
            Point lastPoint = ((Connection)edgeEditPart.getFigure()).getPoints().getLastPoint();
            sideOfTarget = this.getLocation(lastPoint, GraphicalHelper.getAbsoluteBoundsIn100Percent((GraphicalEditPart)((GraphicalEditPart)edgeEditPart.getTarget())));
        }
        if (this.isOnHorizontalAxis(sideOfSource) && this.isOnHorizontalAxis(sideOfTarget)) {
            axis = 64;
        } else if (this.isOnVerticalAxis(sideOfSource) && this.isOnVerticalAxis(sideOfTarget)) {
            axis = 128;
        }
        return axis;
    }

    private boolean isSourceWillBeMoved(AbstractDiagramEdgeEditPart edgeEditPart, StraightenToCommandData data) {
        Point targetPoint;
        PointList pointList;
        Point sourcePoint;
        boolean isSourceWillBeMoved = false;
        if (data.isSourceABorderNode) {
            sourcePoint = GraphicalHelper.getAbsoluteBoundsIn100Percent((GraphicalEditPart)data.sourceEditPart).getCenter();
        } else if (edgeEditPart.getFigure() instanceof AbstractDiagramEdgeEditPart.ViewEdgeFigure) {
            pointList = ((AbstractDiagramEdgeEditPart.ViewEdgeFigure)edgeEditPart.getFigure()).getPoints().getCopy();
            sourcePoint = pointList.getFirstPoint();
        } else {
            sourcePoint = new Point();
        }
        if (data.isTargetABorderNode) {
            targetPoint = GraphicalHelper.getAbsoluteBoundsIn100Percent((GraphicalEditPart)data.targetEditPart).getCenter();
        } else if (edgeEditPart.getFigure() instanceof AbstractDiagramEdgeEditPart.ViewEdgeFigure) {
            pointList = ((AbstractDiagramEdgeEditPart.ViewEdgeFigure)edgeEditPart.getFigure()).getPoints().getCopy();
            targetPoint = pointList.getLastPoint();
        } else {
            targetPoint = new Point();
        }
        if (this.straightenType == 2 || this.straightenType == 4) {
            if (sourcePoint.x > targetPoint.x) {
                isSourceWillBeMoved = true;
            }
        } else if (this.straightenType == 3 || this.straightenType == 5) {
            if (sourcePoint.x < targetPoint.x) {
                isSourceWillBeMoved = true;
            }
        } else if (this.straightenType == 0 || this.straightenType == 6) {
            if (sourcePoint.y > targetPoint.y) {
                isSourceWillBeMoved = true;
            }
        } else if (sourcePoint.y < targetPoint.y) {
            isSourceWillBeMoved = true;
        }
        return isSourceWillBeMoved;
    }

    private boolean isCentered(AbstractDiagramEdgeEditPart edgeEditPart, StraightenToCommandData data) {
        boolean isCentered = false;
        if (edgeEditPart.getFigure() instanceof AbstractDiagramEdgeEditPart.ViewEdgeFigure) {
            boolean isExceptionCase;
            AbstractDiagramEdgeEditPart.ViewEdgeFigure figure = (AbstractDiagramEdgeEditPart.ViewEdgeFigure)edgeEditPart.getFigure();
            boolean bl = isExceptionCase = data.isSourceABorderNode && data.isTargetABorderNode && figure.isSourceCentered() && figure.isTargetCentered();
            if (isExceptionCase) {
                data.isSpecificCase = true;
            } else {
                isCentered = new ConnectionEditPartQuery(edgeEditPart).isEdgeWithObliqueRoutingStyle() ? figure.isSourceCentered() || figure.isTargetCentered() : (data.moveSource ? figure.isSourceCentered() : figure.isTargetCentered());
            }
        }
        return isCentered;
    }

    private boolean isNewLocationInParentBounds(AbstractDiagramEdgeEditPart edgeEditPart, StraightenToCommandData data) {
        boolean isNewLocationInParentBounds = false;
        if (edgeEditPart.getFigure() instanceof Connection) {
            Connection figure = (Connection)edgeEditPart.getFigure();
            Point firstPoint = figure.getPoints().getFirstPoint().getCopy();
            Point lastPoint = figure.getPoints().getLastPoint().getCopy();
            if (data.isSpecificCase) {
                firstPoint = GraphicalHelper.getAbsoluteBoundsIn100Percent((GraphicalEditPart)data.sourceEditPart).getCenter();
                lastPoint = GraphicalHelper.getAbsoluteBoundsIn100Percent((GraphicalEditPart)data.targetEditPart).getCenter();
            }
            if (data.moveSource) {
                if (this.straightenType == 0 || this.straightenType == 1 || this.straightenType == 4 || this.straightenType == 5) {
                    data.deltaY = lastPoint.y - firstPoint.y;
                } else if (this.straightenType == 2 || this.straightenType == 3 || this.straightenType == 6 || this.straightenType == 7) {
                    data.deltaX = lastPoint.x - firstPoint.x;
                }
                if (data.isSourceABorderNode) {
                    Rectangle parentBorderNodeBounds = GraphicalHelper.getAbsoluteBoundsIn100Percent((GraphicalEditPart)((GraphicalEditPart)data.sourceEditPart.getParent()));
                    Rectangle borderNodeBounds = GraphicalHelper.getAbsoluteBoundsIn100Percent((GraphicalEditPart)data.sourceEditPart);
                    borderNodeBounds = borderNodeBounds.getTranslated(data.deltaX, data.deltaY);
                    if (this.straightenType == 0 || this.straightenType == 1 || this.straightenType == 4 || this.straightenType == 5) {
                        if (parentBorderNodeBounds.y <= borderNodeBounds.y && borderNodeBounds.y + borderNodeBounds.height <= parentBorderNodeBounds.y + parentBorderNodeBounds.height) {
                            isNewLocationInParentBounds = true;
                        }
                    } else if ((this.straightenType == 2 || this.straightenType == 3 || this.straightenType == 6 || this.straightenType == 7) && parentBorderNodeBounds.x <= borderNodeBounds.x && borderNodeBounds.x + borderNodeBounds.width <= parentBorderNodeBounds.x + parentBorderNodeBounds.width) {
                        isNewLocationInParentBounds = true;
                    }
                } else {
                    Rectangle bounds = GraphicalHelper.getAbsoluteBoundsIn100Percent((GraphicalEditPart)data.sourceEditPart);
                    if (this.straightenType == 0 || this.straightenType == 1 || this.straightenType == 4 || this.straightenType == 5) {
                        if (bounds.y <= lastPoint.y && lastPoint.y <= bounds.y + bounds.height) {
                            isNewLocationInParentBounds = true;
                        }
                    } else if ((this.straightenType == 2 || this.straightenType == 3 || this.straightenType == 6 || this.straightenType == 7) && bounds.x <= lastPoint.x && lastPoint.x <= bounds.x + bounds.width) {
                        isNewLocationInParentBounds = true;
                    }
                }
            } else {
                if (this.straightenType == 0 || this.straightenType == 1 || this.straightenType == 4 || this.straightenType == 5) {
                    data.deltaY = firstPoint.y - lastPoint.y;
                } else if (this.straightenType == 2 || this.straightenType == 3 || this.straightenType == 6 || this.straightenType == 7) {
                    data.deltaX = firstPoint.x - lastPoint.x;
                }
                if (data.isTargetABorderNode) {
                    Rectangle parentBorderNodeBounds = GraphicalHelper.getAbsoluteBoundsIn100Percent((GraphicalEditPart)((GraphicalEditPart)data.targetEditPart.getParent()));
                    Rectangle borderNodeBounds = GraphicalHelper.getAbsoluteBoundsIn100Percent((GraphicalEditPart)data.targetEditPart);
                    borderNodeBounds = borderNodeBounds.getTranslated(data.deltaX, data.deltaY);
                    if (this.straightenType == 0 || this.straightenType == 1 || this.straightenType == 4 || this.straightenType == 5) {
                        if (parentBorderNodeBounds.y <= borderNodeBounds.y && borderNodeBounds.y + borderNodeBounds.height <= parentBorderNodeBounds.y + parentBorderNodeBounds.height) {
                            isNewLocationInParentBounds = true;
                        }
                    } else if ((this.straightenType == 2 || this.straightenType == 3 || this.straightenType == 6 || this.straightenType == 7) && parentBorderNodeBounds.x <= borderNodeBounds.x && borderNodeBounds.x + borderNodeBounds.width <= parentBorderNodeBounds.x + parentBorderNodeBounds.width) {
                        isNewLocationInParentBounds = true;
                    }
                } else {
                    Rectangle bounds = GraphicalHelper.getAbsoluteBoundsIn100Percent((GraphicalEditPart)data.targetEditPart);
                    if (this.straightenType == 0 || this.straightenType == 1 || this.straightenType == 4 || this.straightenType == 5) {
                        if (bounds.y <= firstPoint.y && firstPoint.y <= bounds.y + bounds.height) {
                            isNewLocationInParentBounds = true;
                        }
                    } else if ((this.straightenType == 2 || this.straightenType == 3 || this.straightenType == 6 || this.straightenType == 7) && bounds.x <= firstPoint.x && firstPoint.x <= bounds.x + bounds.width) {
                        isNewLocationInParentBounds = true;
                    }
                }
            }
        }
        return isNewLocationInParentBounds;
    }

    private boolean isOverlapped(AbstractDiagramEdgeEditPart edgeEditPart, StraightenToCommandData data) {
        boolean isOverlapped = false;
        if (data.moveSource && data.isSourceABorderNode) {
            if (data.sourceEditPart.getModel() instanceof Node) {
                isOverlapped = this.isOverlapped((Node)data.sourceEditPart.getModel(), data);
            }
        } else if (!data.moveSource && data.isTargetABorderNode && data.targetEditPart.getModel() instanceof Node) {
            isOverlapped = this.isOverlapped((Node)data.targetEditPart.getModel(), data);
        }
        return isOverlapped;
    }

    private boolean isOverlapped(Node node, StraightenToCommandData data) {
        boolean isOverlapped = false;
        Node parentNode = (Node)node.eContainer();
        CanonicalDBorderItemLocator borderItemLocator = new CanonicalDBorderItemLocator(parentNode, 29);
        borderItemLocator.setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
        LayoutConstraint initialLayoutConstraint = node.getLayoutConstraint();
        if (initialLayoutConstraint instanceof Location) {
            Rectangle initialRelativeConstraint;
            if (initialLayoutConstraint instanceof Bounds) {
                Bounds bounds = (Bounds)initialLayoutConstraint;
                initialRelativeConstraint = new Rectangle(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
            } else {
                Location location = (Location)initialLayoutConstraint;
                initialRelativeConstraint = new Rectangle(location.getX(), location.getY(), -1, -1);
            }
            Point parentAbsoluteLocation = GMFHelper.getAbsoluteLocation(parentNode);
            Rectangle initialAsboluteConstraint = initialRelativeConstraint.getTranslated(parentAbsoluteLocation);
            Point validInitialAbsoluteLocation = borderItemLocator.getValidLocation(initialAsboluteConstraint, node, Lists.newArrayList((Object[])new Node[]{node}));
            Rectangle validInitialAbsoluteConstraint = initialAsboluteConstraint.getCopy();
            if ((this.straightenType == 2 || this.straightenType == 3 || this.straightenType == 6 || this.straightenType == 7) && initialAsboluteConstraint.y != validInitialAbsoluteLocation.y) {
                validInitialAbsoluteConstraint.setY(validInitialAbsoluteLocation.y);
            } else if ((this.straightenType == 0 || this.straightenType == 1 || this.straightenType == 4 || this.straightenType == 5) && initialAsboluteConstraint.x != validInitialAbsoluteLocation.x) {
                validInitialAbsoluteConstraint.setX(validInitialAbsoluteLocation.x);
            }
            Rectangle expectedAsboluteConstraint = validInitialAbsoluteConstraint.getTranslated(data.deltaX, data.deltaY);
            if (!expectedAsboluteConstraint.getLocation().equals((Object)borderItemLocator.getValidLocation(expectedAsboluteConstraint, node, this.movedBorderNodes))) {
                isOverlapped = true;
            }
        }
        return isOverlapped;
    }

    private boolean isOnHorizontalAxis(int side) {
        return (side & 0x10) > 0 || (side & 8) > 0;
    }

    private boolean isOnVerticalAxis(int side) {
        return (side & 1) > 0 || (side & 4) > 0;
    }

    private int getLocation(Point point, Rectangle rect) {
        int side = rect.getPosition(point);
        if (side == 0) {
            if (point.x() == rect.x) {
                side = 8;
            } else if (point.x() == rect.x + rect.width) {
                side = 16;
            }
            if (point.y() == rect.y) {
                side |= 1;
            } else if (point.y() == rect.y + rect.height) {
                side |= 4;
            }
        }
        return side;
    }

    private static class StraightenToCommandData {
        private IGraphicalEditPart sourceEditPart;
        private IGraphicalEditPart targetEditPart;
        private boolean isSourceABorderNode;
        private boolean isTargetABorderNode;
        private boolean moveSource;
        private boolean isSpecificCase;
        private int deltaX = 0;
        private int deltaY = 0;

        private StraightenToCommandData() {
        }
    }
}

