/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.internal.utils.workspace;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.acceleo.common.AcceleoCommonPlugin;
import org.eclipse.acceleo.common.internal.utils.workspace.BundleURLConverter;
import org.eclipse.acceleo.common.internal.utils.workspace.ClassLoadingCompanion;
import org.eclipse.acceleo.common.internal.utils.workspace.ClassLoadingCompanionsRegistry;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.ecore.EPackage;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public final class AcceleoWorkspaceUtil {
    public static final AcceleoWorkspaceUtil INSTANCE = new AcceleoWorkspaceUtil();

    public void refreshContributions() {
        for (ClassLoadingCompanion companion : ClassLoadingCompanionsRegistry.INSTANCE.getAllRegisteredCompanions()) {
            companion.refreshContributions();
        }
    }

    public static Bundle[] getBundles(String bundleName) {
        Bundle[] bundle = null;
        BundleContext context = AcceleoCommonPlugin.getDefault().getContext();
        ServiceReference packageAdminReference = context.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = null;
        if (packageAdminReference != null) {
            packageAdmin = (PackageAdmin)context.getService(packageAdminReference);
        }
        if (packageAdmin != null) {
            bundle = packageAdmin.getBundles(bundleName, null);
        }
        if (packageAdminReference != null) {
            context.ungetService(packageAdminReference);
        }
        return bundle;
    }

    public Object getServiceInstance(Class<?> serviceClass) {
        Iterator<ClassLoadingCompanion> it = ClassLoadingCompanionsRegistry.INSTANCE.getAllRegisteredCompanions().iterator();
        Object found = null;
        while (it.hasNext() && found == null) {
            found = it.next().getServiceInstance(serviceClass);
        }
        return found;
    }

    public Class<?> getClass(IProject project, String qualifiedName) {
        Iterator<ClassLoadingCompanion> it = ClassLoadingCompanionsRegistry.INSTANCE.getAllRegisteredCompanions().iterator();
        Class<?> found = null;
        while (it.hasNext() && found == null) {
            found = it.next().getClass(project, qualifiedName);
        }
        return found;
    }

    public static IProject getProject(String bundleName) {
        Iterator<ClassLoadingCompanion> it = ClassLoadingCompanionsRegistry.INSTANCE.getAllRegisteredCompanions().iterator();
        IProject found = null;
        while (it.hasNext() && found == null) {
            found = it.next().getProject(bundleName);
        }
        return found;
    }

    public static String resolveAsPlatformPlugin(String filePath) {
        BundleURLConverter converter = new BundleURLConverter(filePath);
        return converter.resolveAsPlatformPlugin();
    }

    public void initialize() {
        for (ClassLoadingCompanion companion : ClassLoadingCompanionsRegistry.INSTANCE.getAllRegisteredCompanions()) {
            companion.initialize();
        }
    }

    public void dispose() {
        for (ClassLoadingCompanion companion : ClassLoadingCompanionsRegistry.INSTANCE.getAllRegisteredCompanions()) {
            companion.dispose();
        }
    }

    public boolean isInDynamicBundle(Class<? extends EPackage> clazz) {
        Iterator<ClassLoadingCompanion> it = ClassLoadingCompanionsRegistry.INSTANCE.getAllRegisteredCompanions().iterator();
        boolean isDynamic = false;
        while (it.hasNext() && !isDynamic) {
            isDynamic = it.next().isInDynamicBundle(clazz);
        }
        return isDynamic;
    }

    /*
     * Unable to fully structure code
     */
    public ResourceBundle getResourceBundle(String qualifiedName) {
        originalException = null;
        try {
            bundle = ResourceBundle.getBundle(qualifiedName);
            return bundle;
        }
        catch (MissingResourceException e) {
            originalException = e;
            it = ClassLoadingCompanionsRegistry.INSTANCE.getAllRegisteredCompanions().iterator();
            ** while (it.hasNext())
        }
lbl-1000:
        // 1 sources

        {
            found = it.next().getResourceBundle(qualifiedName);
            if (found == null) continue;
            return found;
        }
lbl12:
        // 1 sources

        throw originalException;
    }

    public static String resolveInBundles(String filePath) {
        BundleURLConverter converter = new BundleURLConverter(filePath);
        return converter.resolveAsNativeProtocolURL();
    }

    public static Bundle getBundle(Class clazz) {
        Bundle bundle = null;
        BundleContext context = AcceleoCommonPlugin.getDefault().getContext();
        ServiceReference packageAdminReference = context.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = null;
        if (packageAdminReference != null) {
            packageAdmin = (PackageAdmin)context.getService(packageAdminReference);
        }
        if (packageAdmin != null) {
            bundle = packageAdmin.getBundle(clazz);
        }
        if (packageAdminReference != null) {
            context.ungetService(packageAdminReference);
        }
        return bundle;
    }

    public static URL getResourceURL(Class<?> clazz, String resourcePath) throws IOException {
        Bundle bundle;
        BundleContext context = AcceleoCommonPlugin.getDefault().getContext();
        ServiceReference packageAdminReference = context.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = null;
        if (packageAdminReference != null) {
            packageAdmin = (PackageAdmin)context.getService(packageAdminReference);
        }
        URL resourceURL = null;
        if (packageAdmin != null && (bundle = packageAdmin.getBundle(clazz)) != null) {
            resourceURL = AcceleoWorkspaceUtil.getBundleResourceURL(bundle, "/", resourcePath);
        }
        if (resourceURL == null) {
            resourceURL = clazz.getResource(resourcePath);
        }
        if (packageAdminReference != null) {
            context.ungetService(packageAdminReference);
        }
        return resourceURL;
    }

    private static URL getBundleResourceURL(Bundle bundle, String pathSeparator, String resourcePath) throws IOException {
        Enumeration resources;
        URL resourceURL = null;
        Enumeration emtlFiles = bundle.findEntries(pathSeparator, resourcePath, true);
        if (emtlFiles != null && emtlFiles.hasMoreElements()) {
            resourceURL = (URL)emtlFiles.nextElement();
        }
        if (resourceURL == null && (resources = bundle.getResources(resourcePath)) != null && resources.hasMoreElements()) {
            resourceURL = (URL)resources.nextElement();
        }
        if (resourceURL != null) {
            resourceURL = FileLocator.resolve(resourceURL);
        }
        return resourceURL;
    }

    public static Bundle getBundle(String pluginLocation) {
        Bundle[] bundles = AcceleoCommonPlugin.getDefault().getContext().getBundles();
        int i = 0;
        while (i < bundles.length) {
            if (pluginLocation.equals(bundles[i].getLocation())) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }
}

