/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.repair;

import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.ui.tools.api.migration.DiagramCrossReferencer;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.repair.AbstractDNodeDiagramElementState;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.repair.DDiagramElementContainerDiagramElementState;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.repair.DEdgeDiagramElementState;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.repair.DNodeDiagramElementState;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.repair.DNodeListDiagramElementState;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.repair.DefaultDiagramElementState;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.repair.IDiagramElementState;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.repair.Identifier;
import org.eclipse.sirius.ext.base.Option;

public class DiagramElementStateFactory {
    private static final Map<Class<? extends DDiagramElement>, Class<? extends IDiagramElementState<? extends DDiagramElement>>> ASSOCIATION = Maps.newLinkedHashMap();
    private static final Map<Class<? extends DDiagramElement>, Constructor<? extends IDiagramElementState<? extends DDiagramElement>>> CACHE;
    private static final Class<DefaultDiagramElementState> DEFAULT_DIAGRAM_ELT_STATE;

    static {
        ASSOCIATION.put(DEdge.class, DEdgeDiagramElementState.class);
        ASSOCIATION.put(DNode.class, DNodeDiagramElementState.class);
        ASSOCIATION.put(DNodeListElement.class, DNodeListDiagramElementState.class);
        ASSOCIATION.put(DDiagramElementContainer.class, DDiagramElementContainerDiagramElementState.class);
        ASSOCIATION.put(AbstractDNode.class, AbstractDNodeDiagramElementState.class);
        CACHE = Maps.newLinkedHashMap();
        DEFAULT_DIAGRAM_ELT_STATE = DefaultDiagramElementState.class;
    }

    protected DiagramElementStateFactory() {
    }

    public static DiagramElementStateFactory newInstance() {
        return new DiagramElementStateFactory();
    }

    public boolean isValid(DDiagramElement diagramElement) {
        boolean result = false;
        EObject target = diagramElement.getTarget();
        Option mapping = new DDiagramElementQuery(diagramElement).getMapping();
        if (target != null && mapping != null && mapping.some()) {
            if (diagramElement instanceof DEdge) {
                DEdge edge = (DEdge)diagramElement;
                if (edge.getSourceNode() instanceof DDiagramElement) {
                    result = this.isValid((DDiagramElement)edge.getSourceNode());
                }
                if (result && edge.getTargetNode() instanceof DDiagramElement) {
                    result = this.isValid((DDiagramElement)edge.getTargetNode());
                }
            } else {
                result = diagramElement.eContainer() instanceof DDiagramElement ? this.isValid((DDiagramElement)diagramElement.eContainer()) : true;
            }
        }
        return result;
    }

    public IDiagramElementState<? extends DDiagramElement> buildDiagramElementState(Identifier id, DDiagramElement diagramElement, DiagramCrossReferencer crossReferencer) {
        EObject target = diagramElement.getTarget();
        DiagramElementMapping mapping = diagramElement.getDiagramElementMapping();
        IDiagramElementState<DDiagramElement> diagramElementState = this.createDiagramElementStateInstance(id, diagramElement, crossReferencer);
        diagramElementState.storeElementState(target, mapping, diagramElement);
        return diagramElementState;
    }

    private IDiagramElementState<DDiagramElement> createDiagramElementStateInstance(Identifier id, DDiagramElement diagramElement, DiagramCrossReferencer crossReferencer) {
        Constructor<? extends IDiagramElementState<? extends DDiagramElement>> cachedConstructor = CACHE.get(diagramElement.getClass());
        if (cachedConstructor == null) {
            Class<? extends IDiagramElementState<? extends DDiagramElement>> clazz = this.getDiagramElementStateClass(diagramElement);
            try {
                cachedConstructor = clazz.getConstructor(Identifier.class, DiagramCrossReferencer.class);
                CACHE.put(diagramElement.getClass(), cachedConstructor);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        try {
            return cachedConstructor.newInstance(new Object[]{id, crossReferencer});
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause().getMessage(), e.getCause());
        }
    }

    private Class<? extends IDiagramElementState<? extends DDiagramElement>> getDiagramElementStateClass(DDiagramElement diagramElement) {
        Class<IDiagramElementState<DDiagramElement>> classFound = DEFAULT_DIAGRAM_ELT_STATE;
        for (Map.Entry<Class<? extends DDiagramElement>, Class<? extends IDiagramElementState<? extends DDiagramElement>>> entry : ASSOCIATION.entrySet()) {
            Class<? extends DDiagramElement> clazz = entry.getKey();
            if (!clazz.isAssignableFrom(diagramElement.getClass())) continue;
            classFound = entry.getValue();
            break;
        }
        return classFound;
    }

    public void dispose() {
        CACHE.clear();
    }
}

