/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.parts;

import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IClippingStrategy;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.ui.business.internal.view.ShowingViewUtil;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramNodeEditPart;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SiriusContainerDropPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SpecificBorderItemSelectionEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNode2EditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.DNode3ItemSemanticEditPolicy;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;
import org.eclipse.sirius.diagram.ui.tools.api.figure.AirDefaultSizeNodeFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.DBorderedNodeFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.FoldingToggleAwareClippingStrategy;
import org.eclipse.sirius.diagram.ui.tools.api.figure.FoldingToggleImageFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.SiriusWrapLabel;
import org.eclipse.sirius.diagram.ui.tools.api.figure.anchor.AnchorProvider;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IStyleConfigurationRegistry;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.StyleConfiguration;
import org.eclipse.sirius.diagram.ui.tools.api.policies.FlowLayoutEditPolicy;
import org.eclipse.sirius.diagram.ui.tools.internal.figure.ViewNodeFigure;
import org.eclipse.sirius.viewpoint.DStylizable;

public class DNode3EditPart
extends AbstractDiagramNodeEditPart {
    public static final int VISUAL_ID = 3007;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    private DefaultSizeNodeFigure nodePlate = null;
    private Object savedConstraint;

    public DNode3EditPart(View view) {
        super(view);
    }

    @Override
    public void activate() {
        if (this.nodePlate instanceof AirDefaultSizeNodeFigure) {
            ((AirDefaultSizeNodeFigure)this.nodePlate).setZoomManager(this.getZoomManager());
        }
        super.activate();
    }

    @Override
    public void deactivate() {
        super.deactivate();
        if (this.nodePlate instanceof AirDefaultSizeNodeFigure) {
            ((AirDefaultSizeNodeFigure)this.nodePlate).setZoomManager(null);
        }
    }

    @Override
    protected void createDefaultEditPolicies() {
        this.installEditPolicy("CreationPolicy", (EditPolicy)new CreationEditPolicy(){

            public Command getCommand(Request request) {
                if (this.understandsRequest(request)) {
                    if (request instanceof CreateViewRequest) {
                        CreateViewRequest request2 = (CreateViewRequest)request;
                        Command originalCommand = super.getCreateCommand(request2);
                        return DNode3EditPart.this.getPortCreationCommand(originalCommand, request2);
                    }
                    return super.getCommand(request);
                }
                return null;
            }
        });
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new DNode3ItemSemanticEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new SiriusContainerDropPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
        this.removeEditPolicy("ConnectionHandlesPolicy");
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        FlowLayoutEditPolicy lep = new FlowLayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                if (child instanceof AbstractDiagramNameEditPart) {
                    return new SpecificBorderItemSelectionEditPolicy();
                }
                if (child instanceof AbstractBorderItemEditPart) {
                    return ((AbstractBorderItemEditPart)child).getPrimaryDragEditPolicy();
                }
                return super.createChildEditPolicy(child);
            }

            protected int getFeedbackIndexFor(Request request) {
                if (request instanceof ChangeBoundsRequest && ((ChangeBoundsRequest)request).getLocation() == null) {
                    ((ChangeBoundsRequest)request).setLocation(new Point());
                }
                return super.getFeedbackIndexFor(request);
            }

            protected Command createAddCommand(EditPart child, EditPart after) {
                return null;
            }

            protected Command createMoveChildCommand(EditPart child, EditPart after) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }

            public Command getCommand(Request request) {
                Command command;
                if ("resize children".equals(request.getType()) && request instanceof ChangeBoundsRequest && (command = DNode3EditPart.this.getResizeBorderItemCommand((ChangeBoundsRequest)request)) != null) {
                    return command;
                }
                return super.getCommand(request);
            }
        };
        return lep;
    }

    protected NodeFigure createNodeFigure() {
        DBorderedNodeFigure nodeFigure = new DBorderedNodeFigure((IFigure)this.createMainFigure()){

            public void paint(Graphics graphics) {
                ShowingViewUtil.initGraphicsForVisibleAndInvisibleElements((IFigure)this, graphics, (View)DNode3EditPart.this.getModel());
                try {
                    super.paint(graphics);
                    graphics.restoreState();
                }
                finally {
                    graphics.popState();
                }
            }
        };
        nodeFigure.getBorderItemContainer().add((IFigure)new FoldingToggleImageFigure(this));
        nodeFigure.getBorderItemContainer().setClippingStrategy((IClippingStrategy)new FoldingToggleAwareClippingStrategy());
        return nodeFigure;
    }

    protected IFigure createNodeShape() {
        ViewNodeFigure figure = new ViewNodeFigure();
        this.primaryShape = figure;
        return this.primaryShape;
    }

    public IFigure getNodePlate() {
        return this.nodePlate;
    }

    public ViewNodeFigure getPrimaryShape() {
        return (ViewNodeFigure)this.primaryShape;
    }

    protected void addBorderItem(IFigure borderItemContainer, IBorderItemEditPart borderItemEditPart) {
        if (borderItemEditPart instanceof DNodeNameEditPart) {
            if (this.resolveSemanticElement() instanceof DNode) {
                DNode node = (DNode)this.resolveSemanticElement();
                StyleConfiguration styleConfiguration = IStyleConfigurationRegistry.INSTANCE.getStyleConfiguration(node.getDiagramElementMapping(), node.getStyle());
                IBorderItemLocator locator = styleConfiguration.getNameBorderItemLocator(node, this.getMainFigure());
                borderItemContainer.add(borderItemEditPart.getFigure(), (Object)locator);
            }
        } else if (borderItemEditPart instanceof DNode2EditPart && borderItemEditPart.resolveSemanticElement() instanceof DDiagramElement) {
            BorderItemLocator locator = null;
            if (!(this.savedConstraint instanceof BorderItemLocator)) {
                locator = this.createBorderItemLocator(this.getMainFigure(), (DDiagramElement)borderItemEditPart.resolveSemanticElement());
                locator.setConstraint(borderItemEditPart.getFigure().getBounds());
            } else {
                locator = (BorderItemLocator)this.savedConstraint;
                this.savedConstraint = null;
            }
            borderItemContainer.add(borderItemEditPart.getFigure(), (Object)locator);
        } else {
            super.addBorderItem(borderItemContainer, borderItemEditPart);
        }
    }

    protected NodeFigure createNodePlate() {
        AirDefaultSizeNodeFigure result = new AirDefaultSizeNodeFigure(10, 10, null);
        EObject eObj = this.resolveSemanticElement();
        if (eObj instanceof DStylizable && eObj instanceof DDiagramElement) {
            DStylizable viewNode = (DStylizable)eObj;
            StyleConfiguration styleConfiguration = IStyleConfigurationRegistry.INSTANCE.getStyleConfiguration(((DDiagramElement)eObj).getDiagramElementMapping(), viewNode.getStyle());
            AnchorProvider anchorProvider = styleConfiguration.getAnchorProvider();
            result = new AirDefaultSizeNodeFigure(this.getMapMode().DPtoLP(5), this.getMapMode().DPtoLP(5), anchorProvider);
            this.nodePlate = result;
        }
        return result;
    }

    protected NodeFigure createMainFigure() {
        NodeFigure figure = this.createNodePlate();
        if (figure != null) {
            figure.setLayoutManager((LayoutManager)new FlowLayout());
            IFigure shape = this.createNodeShape();
            figure.add(shape);
            this.contentPane = this.setupContentPane(shape);
        }
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(this.getMapMode().DPtoLP(5));
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(SiriusVisualIDRegistry.getType(5003));
    }

    @Override
    public SiriusWrapLabel getNodeLabel() {
        return this.getPrimaryShape().getNodeLabel();
    }

    @Override
    public IFigure getPrimaryFigure() {
        return this.getPrimaryShape();
    }

    @Override
    public Class<?> getMetamodelType() {
        return DNode.class;
    }

    protected void reorderChild(EditPart child, int index) {
        if (child instanceof DNode2EditPart) {
            this.savedConstraint = ((DNode2EditPart)child).getBorderItemLocator();
        }
        super.reorderChild(child, index);
    }
}

