/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.identity;

import java.net.URI;
import java.util.UUID;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.identity.BaseID;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.Namespace;

public class UuID
extends BaseID {
    private static final long serialVersionUID = -2586540125532542205L;
    protected final UUID uuid;

    protected UuID(UuIDNamespace ns, UUID uuid) {
        super(ns);
        Assert.isNotNull((Object)uuid);
        this.uuid = uuid;
    }

    protected int namespaceCompareTo(BaseID obj) {
        return this.getName().compareTo(obj.getName());
    }

    protected boolean namespaceEquals(BaseID obj) {
        if (!(obj instanceof UuID)) {
            return false;
        }
        UuID o = (UuID)obj;
        return this.uuid.equals(o.uuid);
    }

    protected String namespaceGetName() {
        return this.uuid.toString();
    }

    protected int namespaceHashCode() {
        return this.uuid.hashCode() ^ this.getClass().hashCode();
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String toString() {
        return "UuID[uuid=" + this.uuid + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UuIDNamespace
    extends Namespace {
        private static final long serialVersionUID = -7708511830843215943L;
        public static final String SCHEME = "uuid";

        public UuIDNamespace() {
            this(UuID.class.getName(), "UuID Namespace");
        }

        public UuIDNamespace(String name, String description) {
            super(name, description);
        }

        @Override
        public ID createInstance(Object[] parameters) throws IDCreateException {
            try {
                String init = this.getInitStringFromExternalForm(parameters);
                if (init != null) {
                    return new UuID(this, UUID.fromString(init));
                }
                if (parameters != null && parameters.length > 0) {
                    if (parameters[0] instanceof String) {
                        return new UuID(this, UUID.fromString((String)parameters[0]));
                    }
                    if (parameters[0] instanceof URI) {
                        return new UuID(this, UUID.fromString(((URI)parameters[0]).getSchemeSpecificPart()));
                    }
                    if (parameters[0] instanceof UUID) {
                        return new UuID(this, (UUID)parameters[0]);
                    }
                }
                return new UuID(this, UUID.randomUUID());
            }
            catch (Exception e) {
                throw new IDCreateException(String.valueOf(this.getName()) + " createInstance()", e);
            }
        }

        @Override
        public String getScheme() {
            return SCHEME;
        }

        @Override
        public Class<?>[][] getSupportedParameterTypes() {
            return new Class[][]{{String.class}, {UUID.class}, {URI.class}};
        }
    }
}

