/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.core.query.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.lyo.core.query.PName;
import org.eclipse.lyo.core.query.Property;

class PropertyInvocationHandler
implements InvocationHandler {
    private final CommonTree tree;
    private final Property.Type type;
    protected final Map<String, String> prefixMap;
    private final Boolean isWildcard;
    private PName identifier = null;

    public PropertyInvocationHandler(CommonTree tree, Property.Type type, Map<String, String> prefixMap, boolean isWildcard) {
        this.tree = tree;
        this.type = type;
        this.prefixMap = prefixMap;
        this.isWildcard = isWildcard;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals("type")) {
            return this.type;
        }
        if (methodName.equals("isWildcard")) {
            return this.isWildcard;
        }
        boolean isIdentifier = methodName.equals("identifier");
        if (isIdentifier && this.isWildcard.booleanValue()) {
            throw new IllegalStateException("wildcard has no identifier");
        }
        if (isIdentifier && this.identifier != null) {
            return this.identifier;
        }
        String rawIdentifier = this.tree.getText();
        this.identifier = new PName();
        int colon = rawIdentifier.indexOf(58);
        if (colon < 0) {
            this.identifier.local = rawIdentifier;
        } else {
            if (colon > 0) {
                this.identifier.prefix = rawIdentifier.substring(0, colon);
                this.identifier.namespace = this.prefixMap.get(this.identifier.prefix);
            }
            this.identifier.local = rawIdentifier.substring(colon + 1);
        }
        if (isIdentifier) {
            return this.identifier;
        }
        return this.identifier.toString();
    }
}

