/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.graphing.ui.wizards.graph;

import java.text.MessageFormat;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.Localization;
import org.eclipse.linuxtools.systemtap.graphing.ui.wizards.graph.GraphFactory;
import org.eclipse.linuxtools.systemtap.graphing.ui.wizards.graph.GraphModel;
import org.eclipse.linuxtools.systemtap.graphing.ui.wizards.graph.SelectGraphAndSeriesWizard;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SelectGraphAndSeriesWizardPage
extends WizardPage
implements Listener {
    private Button[] btnGraphs;
    private SelectGraphAndSeriesWizard wizard;
    private Text txtTitle;
    private Combo cboXItem;
    private Combo[] cboYItems;
    private Label[] lblYItems;
    private GraphModel model;
    private boolean[] deleted;

    public SelectGraphAndSeriesWizardPage() {
        super("selectGraphAndSeries");
        this.setTitle(Localization.getString("SelectGraphAndSeriesWizardPage.SelectGraphAndSeries"));
    }

    public void createControl(Composite parent) {
        int selected;
        this.wizard = (SelectGraphAndSeriesWizard)this.getWizard();
        this.model = this.wizard.model;
        boolean edit = this.wizard.isEditing();
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        Group cmpGraphOptsGraph = new Group(comp, 16);
        cmpGraphOptsGraph.setLayoutData((Object)new GridData(4, 1, true, false));
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        cmpGraphOptsGraph.setLayout((Layout)rowLayout);
        cmpGraphOptsGraph.setText(Localization.getString("SelectGraphAndSeriesWizardPage.Graph"));
        String[] graphIDs = GraphFactory.getAvailableGraphs(this.wizard.model.getDataSet());
        int btnGraphSelected = -1;
        this.btnGraphs = new Button[graphIDs.length];
        for (int i = 0; i < this.btnGraphs.length; ++i) {
            this.btnGraphs[i] = new Button((Composite)cmpGraphOptsGraph, 16);
            this.btnGraphs[i].setImage(GraphFactory.getGraphImage(graphIDs[i]));
            this.btnGraphs[i].addListener(13, (Listener)this);
            this.btnGraphs[i].setData((Object)graphIDs[i]);
            this.btnGraphs[i].setToolTipText(GraphFactory.getGraphName(this.btnGraphs[i].getData().toString()) + "\n\n" + GraphFactory.getGraphDescription(this.btnGraphs[i].getData().toString()));
            if (btnGraphSelected != -1 || !this.wizard.isEditing() || !graphIDs[i].equals(this.wizard.model.getGraphID())) continue;
            this.btnGraphs[i].setSelection(true);
            btnGraphSelected = i;
        }
        ScrolledComposite scrolledComposite = new ScrolledComposite(comp, 2560);
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        scrolledComposite.setExpandHorizontal(true);
        Composite cmpGraphOptsSeries = new Composite((Composite)scrolledComposite, 0);
        cmpGraphOptsSeries.setLayoutData((Object)new GridData(4, 4, true, true));
        cmpGraphOptsSeries.setLayout((Layout)new GridLayout(2, false));
        scrolledComposite.setContent((Control)cmpGraphOptsSeries);
        Label lblTitle = new Label(cmpGraphOptsSeries, 0);
        lblTitle.setLayoutData((Object)new GridData(4, 4, false, false));
        lblTitle.setText(Localization.getString("SelectGraphAndSeriesWizardPage.Title"));
        this.txtTitle = new Text(cmpGraphOptsSeries, 2048);
        this.txtTitle.setLayoutData((Object)new GridData(4, 4, true, false));
        if (edit) {
            this.txtTitle.setText(this.model.getGraphData().title);
        }
        this.txtTitle.addModifyListener(e -> this.checkErrors(false));
        String[] labels = this.model.getSeries();
        this.cboYItems = new Combo[!edit ? labels.length : Math.max(labels.length, this.model.getYSeries().length)];
        this.lblYItems = new Label[this.cboYItems.length];
        this.deleted = new boolean[this.cboYItems.length + 1];
        Label lblXItem = new Label(cmpGraphOptsSeries, 0);
        lblXItem.setLayoutData((Object)new GridData(4, 4, false, false));
        lblXItem.setText(Localization.getString("SelectGraphAndSeriesWizardPage.XSeries"));
        this.cboXItem = new Combo(cmpGraphOptsSeries, 12);
        this.cboXItem.setLayoutData((Object)new GridData(4, 4, true, false));
        this.cboXItem.addSelectionListener((SelectionListener)new ComboSelectionListener());
        this.cboXItem.add(Localization.getString("SelectGraphAndSeriesWizardPage.RowID"));
        for (int i = 0; i < this.cboYItems.length; ++i) {
            this.lblYItems[i] = new Label(cmpGraphOptsSeries, 0);
            this.lblYItems[i].setLayoutData((Object)new GridData(4, 4, false, false));
            this.lblYItems[i].setText(MessageFormat.format(Localization.getString("SelectGraphAndSeriesWizardPage.YSeries"), i));
            this.cboYItems[i] = new Combo(cmpGraphOptsSeries, 12);
            this.cboYItems[i].setLayoutData((Object)new GridData(4, 4, true, false));
            this.cboYItems[i].addSelectionListener((SelectionListener)new ComboSelectionListener());
            if (i <= 0) continue;
            this.cboYItems[i].add(Localization.getString("SelectGraphAndSeriesWizardPage.NA"));
            this.cboYItems[i].setVisible(false);
            this.lblYItems[i].setVisible(false);
        }
        for (int i = 0; i < labels.length; ++i) {
            this.cboXItem.add(labels[i]);
            for (int j = 0; j < this.lblYItems.length; ++j) {
                this.cboYItems[j].add(labels[i]);
            }
        }
        if (!edit) {
            this.cboXItem.select(0);
            this.cboYItems[0].select(0);
        } else {
            selected = this.model.getXSeries();
            if (selected < labels.length) {
                this.cboXItem.select(selected + 1);
            } else {
                this.cboXItem.add(Localization.getString("SelectGraphAndSeriesWizardPage.Deleted"), 0);
                this.cboXItem.select(0);
                this.deleted[0] = true;
            }
            selected = this.model.getYSeries()[0];
            if (selected < labels.length) {
                this.cboYItems[0].select(selected);
            } else {
                this.cboYItems[0].add(Localization.getString("SelectGraphAndSeriesWizardPage.Deleted"), 0);
                this.cboYItems[0].select(0);
                this.deleted[1] = true;
            }
        }
        boolean cvisible = true;
        for (int i = 1; i < this.cboYItems.length; ++i) {
            if (!edit || this.model.getYSeries().length <= i) {
                selected = 0;
                this.cboYItems[i].select(0);
            } else {
                selected = this.model.getYSeries()[i];
                if (selected < labels.length) {
                    this.cboYItems[i].select(selected + 1);
                } else {
                    this.cboYItems[i].add(Localization.getString("SelectGraphAndSeriesWizardPage.Deleted"), 0);
                    this.cboYItems[i].select(0);
                    this.deleted[i + 1] = true;
                }
            }
            this.cboYItems[i].setVisible(cvisible);
            this.lblYItems[i].setVisible(cvisible);
            cvisible = selected > 0;
        }
        if (!edit) {
            this.btnGraphs[0].setSelection(true);
            this.saveDataToModelGraph(graphIDs[0]);
        } else if (btnGraphSelected == -1) {
            this.saveDataToModelGraph(null);
        }
        cmpGraphOptsSeries.pack();
        this.setControl((Control)comp);
        this.checkErrors(true);
    }

    public void handleEvent(Event event) {
        Widget widget = event.widget;
        if (widget instanceof Button) {
            Button b = (Button)widget;
            this.saveDataToModelGraph(b.getData().toString());
            this.checkErrors(false);
            this.wizard.getContainer().updateButtons();
        }
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public boolean isPageComplete() {
        return this.saveDataToModelSeries();
    }

    private void saveDataToModelGraph(String selected) {
        this.model.setGraph(selected);
    }

    private boolean saveDataToModelSeries() {
        if (this.getErrorMessage() == null) {
            int i;
            this.model.setTitle(this.txtTitle.getText());
            this.model.setXSeries(this.cboXItem.getSelectionIndex() - 1);
            int count = 1;
            for (i = 1; i < this.cboYItems.length && 0 != this.cboYItems[i].getSelectionIndex(); ++i) {
                ++count;
            }
            int[] ySeries = new int[count];
            ySeries[0] = this.cboYItems[0].getSelectionIndex();
            for (i = 1; i < count; ++i) {
                ySeries[i] = this.cboYItems[i].getSelectionIndex() - 1;
            }
            this.model.setYSeries(ySeries);
            return true;
        }
        return false;
    }

    private void markAsDuplicate(Combo item, Boolean bad) {
        item.setForeground(item.getDisplay().getSystemColor(bad != false ? 3 : 2));
    }

    private boolean isSeriesUnique() {
        Combo item = this.cboXItem;
        int i = 0;
        while (!item.isVisible() || !item.getForeground().equals((Object)item.getDisplay().getSystemColor(3))) {
            if (i == this.cboYItems.length) {
                return true;
            }
            item = this.cboYItems[i++];
        }
        return false;
    }

    private boolean findAndMarkDuplicates() {
        boolean foundDuplicate = false;
        this.markAsDuplicate(this.cboXItem, false);
        for (int i = 0; i < this.cboYItems.length; ++i) {
            this.markAsDuplicate(this.cboYItems[i], false);
        }
        for (int i = 0; i < this.cboYItems.length; ++i) {
            if (!this.cboYItems[i].isVisible() || this.deleted[i + 1]) continue;
            int offset = i == 0 ? 1 : 0;
            for (int j = i + 1; j < this.cboYItems.length; ++j) {
                try {
                    if (this.deleted[j + 1] || !this.cboYItems[j].isVisible() || this.cboYItems[i].getSelectionIndex() + offset != this.cboYItems[j].getSelectionIndex()) continue;
                    this.markAsDuplicate(this.cboYItems[i], true);
                    this.markAsDuplicate(this.cboYItems[j], true);
                    foundDuplicate = true;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.deleted[0]) continue;
            try {
                int selection = this.cboYItems[i].getSelectionIndex() + offset;
                if (selection == 0 || selection != this.cboXItem.getSelectionIndex()) continue;
                this.markAsDuplicate(this.cboYItems[i], true);
                this.markAsDuplicate(this.cboXItem, true);
                foundDuplicate = true;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return !foundDuplicate;
    }

    private boolean isSeriesDeleted() {
        for (int i = 0; i < this.deleted.length; ++i) {
            if (!this.deleted[i]) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
        int i;
        super.dispose();
        if (null != this.btnGraphs) {
            for (i = 0; i < this.btnGraphs.length; ++i) {
                this.btnGraphs[i].dispose();
            }
        }
        this.btnGraphs = null;
        if (null != this.txtTitle) {
            this.txtTitle.dispose();
        }
        this.txtTitle = null;
        if (null != this.cboXItem) {
            this.cboXItem.dispose();
        }
        this.cboXItem = null;
        if (null != this.cboYItems) {
            for (i = 0; i < this.cboYItems.length; ++i) {
                if (null != this.cboYItems[i]) {
                    this.cboYItems[i].dispose();
                }
                this.cboYItems[i] = null;
                if (null != this.lblYItems[i]) {
                    this.lblYItems[i].dispose();
                }
                this.lblYItems[i] = null;
            }
        }
        this.cboYItems = null;
        this.lblYItems = null;
        this.model = null;
    }

    private void checkErrors(boolean markDuplicates) {
        boolean isUnique;
        boolean bl = isUnique = markDuplicates ? this.findAndMarkDuplicates() : this.isSeriesUnique();
        if (this.model.getGraphID() == null) {
            this.setErrorMessage(Localization.getString("SelectGraphAndSeriesWizardPage.NoGraphType"));
        } else if (!isUnique) {
            this.setErrorMessage(Localization.getString("SelectGraphAndSeriesWizardPage.SeriesNotUnique"));
        } else if (this.isSeriesDeleted()) {
            this.setErrorMessage(Localization.getString("SelectGraphAndSeriesWizardPage.SeriesDeleted"));
        } else if (this.txtTitle.getText().length() == 0) {
            this.setErrorMessage(Localization.getString("SelectGraphAndSeriesWizardPage.TitleNotSet"));
        } else {
            this.setErrorMessage(null);
        }
        this.getWizard().getContainer().updateButtons();
    }

    private class ComboSelectionListener
    extends SelectionAdapter {
        private ComboSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Combo source = (Combo)e.getSource();
            if (SelectGraphAndSeriesWizardPage.this.cboXItem.equals(source)) {
                if (SelectGraphAndSeriesWizardPage.this.deleted[0] && SelectGraphAndSeriesWizardPage.this.cboXItem.getSelectionIndex() != 0) {
                    SelectGraphAndSeriesWizardPage.this.cboXItem.remove(0);
                    SelectGraphAndSeriesWizardPage.this.deleted[0] = false;
                }
            } else {
                for (int i = 0; i < SelectGraphAndSeriesWizardPage.this.cboYItems.length; ++i) {
                    if (!SelectGraphAndSeriesWizardPage.this.deleted[i + 1] || !SelectGraphAndSeriesWizardPage.this.cboYItems[i].equals(source) || SelectGraphAndSeriesWizardPage.this.cboYItems[i].getSelectionIndex() == 0) continue;
                    SelectGraphAndSeriesWizardPage.this.cboYItems[i].remove(0);
                    SelectGraphAndSeriesWizardPage.this.deleted[i + 1] = false;
                    break;
                }
                boolean setVisible = true;
                if (GraphFactory.isMultiGraph(SelectGraphAndSeriesWizardPage.this.model.getGraphID())) {
                    for (int i = 1; i < SelectGraphAndSeriesWizardPage.this.cboYItems.length; ++i) {
                        SelectGraphAndSeriesWizardPage.this.cboYItems[i].setVisible(setVisible);
                        SelectGraphAndSeriesWizardPage.this.lblYItems[i].setVisible(setVisible);
                        if (!setVisible && SelectGraphAndSeriesWizardPage.this.deleted[i + 1]) {
                            SelectGraphAndSeriesWizardPage.this.cboYItems[i].remove(0);
                            SelectGraphAndSeriesWizardPage.this.deleted[i + 1] = false;
                            SelectGraphAndSeriesWizardPage.this.cboYItems[i].select(0);
                        }
                        setVisible = SelectGraphAndSeriesWizardPage.this.deleted[i + 1] || SelectGraphAndSeriesWizardPage.this.cboYItems[i].getSelectionIndex() > 0 && SelectGraphAndSeriesWizardPage.this.cboYItems[i].isVisible();
                    }
                }
            }
            SelectGraphAndSeriesWizardPage.this.checkErrors(true);
        }
    }
}

