/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor.rules;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.linuxtools.internal.rpm.ui.editor.detectors.IStrictWordDetector;

public class StringWithEndingRule
implements IRule {
    private IToken token;
    private IStrictWordDetector fDetector;
    private int fColumn = -1;
    private static final int UNDEFINED = -1;
    private StringBuilder fBuffer = new StringBuilder();
    private String fStartingSequence;
    private boolean fMandatoryEndSequence;

    public StringWithEndingRule(String startingSequence, IStrictWordDetector trailingCharDetector, IToken inToken, boolean endSequenceRequired) {
        this.token = inToken;
        this.fDetector = trailingCharDetector;
        this.fStartingSequence = startingSequence;
        this.fMandatoryEndSequence = endSequenceRequired;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c = scanner.read();
        this.fBuffer.setLength(0);
        for (int i = 0; i < this.fStartingSequence.length(); ++i) {
            this.fBuffer.append((char)c);
            if (this.fStartingSequence.charAt(i) != c) {
                this.unreadBuffer(scanner);
                return Token.UNDEFINED;
            }
            c = scanner.read();
        }
        if (this.fDetector.isWordStart((char)c) && (this.fColumn == -1 || this.fColumn == scanner.getColumn() - 1)) {
            do {
                this.fBuffer.append((char)c);
            } while ((c = scanner.read()) != -1 && this.fDetector.isWordPart((char)c));
            if (c != -1 && !this.fDetector.isEndingCharacter((char)c)) {
                this.unreadBuffer(scanner);
                return Token.UNDEFINED;
            }
            return this.token;
        }
        if (!this.fMandatoryEndSequence && this.fDetector.isEndingCharacter((char)c)) {
            return this.token;
        }
        scanner.unread();
        this.unreadBuffer(scanner);
        return Token.UNDEFINED;
    }

    protected void unreadBuffer(ICharacterScanner scanner) {
        for (int i = this.fBuffer.length() - 1; i >= 0; --i) {
            scanner.unread();
        }
    }
}

