/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor.rules;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class SectionRule
implements IPredicateRule {
    private StringBuilder fBuffer = new StringBuilder();
    private StringBuilder nextHeaderBuffer = new StringBuilder();
    private IToken token;
    private String startingHeader;
    private String[] endingHeaders;

    public SectionRule(String startingHeader, String[] endingHeaders, IToken token) {
        this.startingHeader = startingHeader;
        this.endingHeaders = endingHeaders;
        this.token = token;
    }

    public IToken getSuccessToken() {
        return this.token;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        boolean readingEndSequence = false;
        this.fBuffer.setLength(0);
        this.nextHeaderBuffer.setLength(0);
        int c = scanner.read();
        if (!resume) {
            for (int i = 0; i < this.startingHeader.length(); ++i) {
                this.fBuffer.append((char)c);
                if (this.startingHeader.charAt(i) != (char)c) {
                    this.unreadBuffer(scanner, this.fBuffer);
                    return Token.UNDEFINED;
                }
                c = scanner.read();
            }
        }
        this.fBuffer.append((char)c);
        do {
            if (c == 10) {
                readingEndSequence = false;
                c = scanner.read();
                if (c == 37) {
                    this.nextHeaderBuffer.setLength(0);
                    readingEndSequence = true;
                } else {
                    if (c == -1) break;
                    this.fBuffer.append((char)c);
                    continue;
                }
            }
            if (readingEndSequence) {
                this.nextHeaderBuffer.append((char)c);
                for (String tempSectionheader : this.endingHeaders) {
                    if (!this.nextHeaderBuffer.toString().equals(tempSectionheader)) continue;
                    this.unreadBuffer(scanner, this.nextHeaderBuffer);
                    return this.token;
                }
            }
            c = scanner.read();
            this.fBuffer.append((char)c);
        } while (c != -1);
        return this.token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }

    protected void unreadBuffer(ICharacterScanner scanner, StringBuilder buffer) {
        for (int i = buffer.length() - 1; i >= 0; --i) {
            scanner.unread();
        }
    }
}

