/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_kxv_Orya extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_EE = "ଏସ୍ଟନିଆ";
        final String metaValue_chr = "ଚେରକୀ";
        final String metaValue_ml = "ମାଲାୟଲମ୍";
        final String metaValue_or = "ଅଡ଼ିଆ";
        final String metaValue_ta = "ତାମିଲ୍";
        final String metaValue_te = "ତେଲୁଗୁ";
        final Object[][] data = new Object[][] {
            { "419", "ଲାଟିନ୍‌ ଆମେରିକା" },
            { "AD", "ଆଣ୍ଡୋରା" },
            { "AE", "ଆଣ୍ଡିତି ଆରବ ଏମିରେଟସ୍" },
            { "AF", "ଆପଗାନିସ୍ତାନ୍" },
            { "AG", "ଏଣ୍ଟିଗୁଆ ଅଡ଼େ ବାରବୁଦା" },
            { "AI", "ଏଙ୍ଗ୍ୱିଲା" },
            { "AL", "ଆଲବାନିଆ" },
            { "AM", "ଆର୍ମେନିଆ" },
            { "AO", "ଅଙ୍ଗଲା" },
            { "AQ", "ଆଣ୍ଟାର୍କଟିକା" },
            { "AR", "ଅର୍ଜେଣ୍ଟିନା" },
            { "AS", "ଅମେରିକା ତି ସମୱା" },
            { "AT", "ଅଷ୍ଟ୍ରିଆ" },
            { "AU", "ଅଷ୍ଟ୍ରେଲିଆ" },
            { "AW", "ଅରୁବା" },
            { "AX", "ଏଲେଣ୍ଡ" },
            { "AZ", "ଅଜେର୍‍‍ବାଇଜାନ୍" },
            { "BA", "ବସ୍ନିଆ ଅଡ଼େ ହର୍ଜଗୱିନା" },
            { "BB", "ବାର୍‍ବଡସ" },
            { "BD", "ବାଂଲାଦେଶ" },
            { "BE", "ବେଲଜିୟମ୍" },
            { "BF", "ବୁର୍କିନା ପାସ୍ୱ" },
            { "BG", "ବୁଲ୍‍ଗାରିଆ" },
            { "BH", "ବହରେନ୍" },
            { "BI", "ବୁରୁନ୍ଦି" },
            { "BJ", "ବେନିନ୍" },
            { "BL", "ସେଣ୍ଟ ବାର୍ତେଲେମି" },
            { "BM", "ବର୍‍ମୁଣ୍ଡା" },
            { "BN", "ବ୍ରୂନେଇ" },
            { "BO", "ବଲିୱିୟା" },
            { "BQ", "କାରିବିୟନ ନେଦରଲ୍ୟାଣ୍ଡସ୍" },
            { "BR", "ବ୍ରାଜିଲ୍" },
            { "BS", "ବାହାମାସ୍" },
            { "BT", "ବୁଟାନ" },
            { "BW", "ବସ୍ଟୱାନା" },
            { "BY", "ବେଲାରୂସ୍" },
            { "BZ", "ବେଲିଜ୍" },
            { "CA", "କାନାଡା" },
            { "CC", "କକସ୍ (କିଲିଂ) ଦିପ" },
            { "CD", "କଙ୍ଗ-କିଂସାସା" },
            { "CF", "ମାଦିନି ଆପ୍ରିକା ରିପବ୍ଲିକ୍" },
            { "CG", "କଂଙ୍ଗ- ବ୍ରାଜାୱିଲି" },
            { "CH", "ସ୍ୱୀଜଅର୍‍ଲାଣ୍ଡ" },
            { "CI", "କଟ ଡି ୱା" },
            { "CK", "କୁକ ଦିପ" },
            { "CL", "ଚିଲି" },
            { "CM", "କାମେରନ୍" },
            { "CN", "ଚିନ୍" },
            { "CO", "କଲମ୍ବିଆ" },
            { "CR", "କସ୍ଟା ରିକା" },
            { "CU", "କ୍ୟୁବା" },
            { "CV", "କେପ୍ ୱଡ଼" },
            { "CW", "କ୍ୟୁରାସାଅ" },
            { "CX", "କ୍ରିସ୍ଟମାସ୍ ଦିପ" },
            { "CY", "ସାଇପ୍ରସ୍" },
            { "CZ", "ଚେକିଆ" },
            { "DE", "ଜର୍ମାନି" },
            { "DG", "ଡିଏଗ ଗାର୍ସିଆ" },
            { "DJ", "ଜିବୁତି" },
            { "DK", "ଡେନମାର୍କ" },
            { "DM", "ଡମିନିକା" },
            { "DO", "ଡମିନିକା ତି ରିପବ୍ଲିକ୍" },
            { "DZ", "ଅଲଜେରିଆ" },
            { "EA", "ସେଅଟା ଅଡ଼େ ମେଲିଲା" },
            { "EC", "ଇକ୍ୱାଡର" },
            { "EE", metaValue_EE },
            { "EG", "ଇଜିପ୍ଟ" },
            { "EH", "ୱେଡ଼ାକୁଣ୍ପୁ ସାହାରା" },
            { "ER", "ଇରିଟ୍ରିଆ" },
            { "ES", "ସ୍ପେନ୍" },
            { "ET", "ଇତିୟପିଆ" },
            { "FI", "ପିନ୍‍ଲାଣ୍ଡ" },
            { "FJ", "ପିଜି" },
            { "FK", "ପାକ୍‍ଲାଣ୍ଡ ଦିପ" },
            { "FM", "ମାକ୍ରନେସିଆ" },
            { "FO", "ପେରୋ ଦୀପ" },
            { "FR", "ପ୍ରାନ୍ସ" },
            { "GA", "ଗାବନ" },
            { "GB", "ଇଉନାଇଟେଡ୍ କିଂଡମ୍" },
            { "GD", "ଗ୍ରେନାଡା" },
            { "GE", "ଜର୍ଜିଆ" },
            { "GF", "ପ୍ରେଞ୍ଚ୍ ଗୁୟାନା" },
            { "GG", "ଗର୍ନସି" },
            { "GH", "ଗାନା" },
            { "GI", "ଜିବ୍ରାଲଟର" },
            { "GL", "ଗ୍ରୀନ୍ ଲାଣ୍ଡ" },
            { "GM", "ଗାମ୍ବିଆ" },
            { "GN", "ଗିନି" },
            { "GP", "ଗ୍ୱାଡେଲୁପ" },
            { "GQ", "ଇକ୍ୟୁଏଟେରିୟଲ ଗିନି" },
            { "GR", "ଗ୍ରିସ୍" },
            { "GS", "ଦକିନ ଜର୍ଜିଆ ଅଡ଼େ ଦକିନ ସାଣ୍ଡୱିଚ୍ ଦୀପ" },
            { "GT", "ଗ୍ୱାଟେମାଲା" },
            { "GU", "ଗୁଆମ୍" },
            { "GW", "ଗିନି ବିସାଉ" },
            { "GY", "ଗୁୟାନା" },
            { "HK", "ହଂଗ କଂଗ (ଏସଏଆର୍ ଚିନା)" },
            { "HN", "ହଣ୍ଡୁରାସ" },
            { "HR", "କ୍ରସିଆ" },
            { "HT", "ହାଇତି" },
            { "HU", "ହଙ୍ଗେରି" },
            { "IC", "କେନାରି ଦିପ" },
            { "ID", "ଇଣ୍ଡନେସିୟା" },
            { "IE", "ଅଇରଲାଣ୍ଡ" },
            { "IL", "ଇସରାଇଲ" },
            { "IM", "ମାଣିସି ତା ଦିପ" },
            { "IN", "ବାରତ" },
            { "IO", "ବ୍ରିଟିସ୍ ହିନ୍ଦ ସାମୁଦ୍ରି ହାନ୍ଦି" },
            { "IQ", "ଇରାକ" },
            { "IR", "ଇରାନ" },
            { "IS", "ଆଇସଲାଣ୍ଡ" },
            { "IT", "ଇଟାଲି" },
            { "JE", "ଜରସି" },
            { "JM", "ଜାମାଇକା" },
            { "JO", "ଜର୍ଡାନ" },
            { "JP", "ଜାପାନ" },
            { "KE", "କେନ୍ୟା" },
            { "KG", "କିରଗିସ୍ତାନ" },
            { "KH", "କମ୍ବଡିଆ" },
            { "KI", "କିରିବାତି" },
            { "KM", "କମରସ" },
            { "KN", "ସେଣ୍ଟ. କିଟ୍ସ ଅଡ଼େ ନେବିସ" },
            { "KP", "ଉତର କରିୟା" },
            { "KR", "ଦକିଣ କରିୟା" },
            { "KW", "କୁୱେତ୍" },
            { "KY", "କାଇମାନ ଦିପ" },
            { "KZ", "କାଜାକସ୍ତାନ" },
            { "LA", "ଲାଅସ୍" },
            { "LB", "ଲେବନାନ" },
            { "LC", "ସେଣ୍ଟ. ଲୁସିଆ" },
            { "LI", "ଲିକ୍‍ଟନ୍‍ସ୍ଟାଇନ୍" },
            { "LK", "ସ୍ରି ଲଙ୍କା" },
            { "LR", "ଲାଇବେରିଆ" },
            { "LS", "ଲେସତ" },
            { "LT", "ଲିତୁଆନିଆ" },
            { "LU", "ଲଗ୍ଜମବର୍ଗ" },
            { "LV", "ଲାତ୍‍ୱିୟା" },
            { "LY", "ଲିବିୟା" },
            { "MA", "ମରକ" },
            { "MC", "ମନାକ" },
            { "MD", "ମଲ୍‍ଡୱା" },
            { "ME", "ମଣ୍ଟେନେଗ୍ର" },
            { "MF", "ସେଣ୍ଟ ମାର୍ଟିନ" },
            { "MG", "ମାଡ଼ାଗାସ୍କାର" },
            { "MH", "ମାର୍ସାଲ ଦିପ" },
            { "MK", "ଉତର ମାସାଡନିୟା" },
            { "ML", "ମାଲି" },
            { "MM", "ମିୟାଁମାର (ବର୍ମା)" },
            { "MN", "ମଙ୍ଗଲିୟା" },
            { "MO", "ମକାଉ ଏସଏଆର ଚିନା" },
            { "MP", "ଉତର ମାରିୟାନ ଦିପ" },
            { "MQ", "ମାର୍ଟିନିକ୍" },
            { "MR", "ମଉରିଟାନିୟା" },
            { "MS", "ମଣ୍ଟସେରେଟ" },
            { "MT", "ମାଲ୍ଟା" },
            { "MU", "ମରିସସ୍" },
            { "MV", "ମାଲଦୀପି" },
            { "MW", "ମଲାୱି" },
            { "MX", "ମେକ୍ସିକ" },
            { "MY", "ମାଲେସିଆ" },
            { "MZ", "ମଜାମ୍ବିକ" },
            { "NA", "ନାମିବିୟା" },
            { "NC", "ନ୍ୟୁ କେଲେଡନିୟା" },
            { "NE", "ନାଇଜର" },
            { "NF", "ନର୍‍ପକ୍ ଦିପ" },
            { "NG", "ନାଇଜେରିଆ" },
            { "NI", "ନିକାରଗୁଆ" },
            { "NL", "ନେଦରଲାଣ୍ଡ" },
            { "NO", "ନରୱେ" },
            { "NP", "ନେପାଲ" },
            { "NR", "ନାଉରୁ" },
            { "NU", "ନିୟୁ" },
            { "NZ", "ନିୟୁଜିଲାଣ୍ଡ" },
            { "OM", "ଅମାନ" },
            { "PA", "ପନମା" },
            { "PE", "ପେରୁ" },
            { "PF", "ପ୍ରେଞ୍ଚ୍ ପଲିନେସିୟା" },
            { "PG", "ପପୁଆ ନିୟୁ ଗିନି" },
            { "PH", "ପିଲିପାଇନ୍ସ" },
            { "PK", "ପାକିସ୍ତାନ" },
            { "PL", "ପଲାଣ୍ଡ" },
            { "PM", "ସେଣ୍ଟ ପିଏରେ ଅଡ଼େ ମିକ୍ୱେଲାନ" },
            { "PN", "ପିଟ୍‍କଇର୍ନ୍ ଦିପ" },
            { "PR", "ପର୍ଟ ରିକ" },
            { "PS", "ପାଲେସ୍ଟିଆତି ହାନ୍ଦି" },
            { "PT", "ପର୍ତୁଗାଲ" },
            { "PW", "ପଲାଉ" },
            { "PY", "ପରଗ୍ୱେ" },
            { "QA", "କତର" },
            { "RE", "ରିୟୁନିୟନ" },
            { "RO", "ରମାନିଆ" },
            { "RS", "ସର୍ବିୟା" },
            { "RU", "ରୁସିଆ" },
            { "RW", "ର୍‍ୱାଣ୍ଡା" },
            { "SA", "ସାଉଦି ଆରବ" },
            { "SB", "ସଲମନ ଦିପ" },
            { "SC", "ସିସେଲ୍ସ" },
            { "SD", "ସୁଡାନ" },
            { "SE", "ସ୍ୱିଡେନ" },
            { "SG", "ସିଙ୍ଗାପୁର" },
            { "SH", "ସେଣ୍ଟ ହେଲେନ" },
            { "SI", "ସ୍ଲବେନିଆ" },
            { "SJ", "ସ୍ୱାଲବାର୍ଡ ଅଡ଼େ ଜାନ ମାୟେନ" },
            { "SK", "ସ୍ଲବାକିୟା" },
            { "SL", "ସିଏରା ଲିୟନ" },
            { "SM", "ସନ ମାରିନ" },
            { "SN", "ସେନେଗାଲ" },
            { "SO", "ସମାଲିଆ" },
            { "SR", "ସୁରିନାମ" },
            { "SS", "ଦକିଣ ସୁଡାନ" },
            { "ST", "ସାଅ ଟମ ଅଡ଼େ ପ୍ରିନ୍ସିପେ" },
            { "SV", "ଅଲ ସଲବାଡର" },
            { "SX", "ସିଣ୍ଟ ମାର୍ଟିନ" },
            { "SY", "ସିରିୟା" },
            { "SZ", "ଏସ୍ୱାଟିନି" },
            { "TC", "ତୁର୍କ ଅଡ଼େ କାଇକସ ଦିପ" },
            { "TD", "ଚାଡ" },
            { "TF", "ପ୍ରେଞ୍ଚ ଦକିନୀୟ ଟେରିଟୋରୀ" },
            { "TG", "ଟଗ" },
            { "TH", "ତାଇଲାଣ୍ଡ" },
            { "TJ", "ତାଜିକିସ୍ତାନ" },
            { "TK", "ତକେଲାଉ" },
            { "TL", "ତିମର-ଲେସ୍ତେ" },
            { "TM", "ତୁର୍କମେନିସ୍ତାନ" },
            { "TN", "ଟ୍ୟୁନିସିୟା" },
            { "TO", "ଟଙ୍ଗ" },
            { "TR", "ତୁର୍କି" },
            { "TT", "ତ୍ରିନିଡାଡ ଅଡ଼େ ଟବାଗ" },
            { "TV", "ତୁୱାଲୁ" },
            { "TW", "ତାଇୱାନ" },
            { "TZ", "ତାଞ୍ଜାନିୟା" },
            { "UA", "ୟୁକ୍ରେନ୍" },
            { "UG", "ଉଗାଣ୍ଡା" },
            { "UM", "ୟୁ ଏସ୍ ଆଉଟଲାଇଙ୍କ ଦିପ" },
            { "US", "ଆଣ୍ଡିତି ରାଜ୍ୟ" },
            { "UY", "ଉରୁଗ୍ୱେ" },
            { "UZ", "ଉଜବେକିସ୍ତାନ" },
            { "VA", "ବାଟିକାନ୍ ସିଟି" },
            { "VC", "ସେଣ୍ଟ ୱିନସେଣ୍ଟ ଅଡ଼େ ଗ୍ରିନାଡାଇନ୍ସ" },
            { "VE", "ୱେନେଜୁଏଲ" },
            { "VG", "ବ୍ରିଟିସ୍ ୱିରଜିନ ଦିପ" },
            { "VI", "ୟୁ ଏସ ୱିରଜିନ ଦିପ" },
            { "VN", "ୱିଏତନାମ" },
            { "VU", "ୱାନୁଆତୁ" },
            { "WF", "ୱାଲିସ ଅଡ଼େ ପୁଟୁନା" },
            { "WS", "ସମୱା" },
            { "XK", "କସୱ" },
            { "YE", "ୟମନ" },
            { "YT", "ମାୟତେ" },
            { "ZA", "ଦକିଣ ଆପ୍ରିକା" },
            { "ZM", "ଜାମ୍ବିୟା" },
            { "ZW", "ଜିମ୍ବାୱେ" },
            { "af", "ଆପ୍ରୀକାନ୍‍ସ" },
            { "am", "ଆମ୍‍ହେରି" },
            { "ar", "ଆରବିକ" },
            { "as", "ଆସାମିଜ୍" },
            { "az", "ଆଜେରବେଇଜାନି" },
            { "be", "ବେଲାରୁଷିଆନ୍" },
            { "bg", "ବୁଲଗାରିଆନ୍" },
            { "bn", "ବଙ୍ଗାଲି" },
            { "bo", "ତିବତି" },
            { "bs", "ବସନିଆନ୍" },
            { "ca", "କାଟଲାନ୍" },
            { "cs", "ଚେକ୍" },
            { "da", "ଡେନିସ୍" },
            { "de", "ଜର୍ମାନ୍" },
            { "el", "ଗ୍ରୀକ୍" },
            { "en", "ଇଂରାଜୀ" },
            { "es", "ସ୍ପାନିସ୍" },
            { "et", metaValue_EE },
            { "eu", "ବାସ୍କ" },
            { "fa", "ପର୍ସିୟାନ୍" },
            { "fi", "ପିନିସ୍" },
            { "fr", "ପ୍ରେଞ୍ଚ‍" },
            { "gl", "ଗଲସିଆତି" },
            { "gu", "ଗୁଜୁରାଟି" },
            { "he", "ହିବ୍ରୁ" },
            { "hi", "ହିନ୍ଦି" },
            { "hr", "କ୍ରଏସିଆତି" },
            { "hu", "ହଙ୍ଗେରୀୟାତି" },
            { "hy", "ଆର୍ମେନିଆତି" },
            { "id", "ଇଣ୍ଡନେସୀୟା ତି" },
            { "is", "ଆଇସଲାଣ୍ଡିକ୍" },
            { "it", "ଇଟାଲି ତି" },
            { "ja", "ଜାପାନିଜ୍" },
            { "ka", "ଜର୍ଜିୟାତି" },
            { "kk", "କାଜାକ୍" },
            { "km", "କାମେର୍" },
            { "kn", "କାନ୍ନାଡ଼ା" },
            { "ko", "କରିଆନ୍ ତି" },
            { "ks", "କାସ୍ମିର" },
            { "ky", "କୀରଗୀଜ୍" },
            { "lo", "ଲାଅ" },
            { "lt", "ଲିଥୁଆନିଆତି" },
            { "lv", "ଲାଟବିଆତି" },
            { "mk", "ମାସେଡୋନିଆ ତି" },
            { "ml", metaValue_ml },
            { "mn", "ମଙ୍ଗଲିୟ ତି" },
            { "mr", "ମରାଟୀ" },
            { "ms", "ମଲୟ" },
            { "my", "ବର୍ମୀଜ୍" },
            { "nb", "ନରୱେଜିଆନ୍ ବୋକମଲ୍" },
            { "ne", "ନେପାଳୀ" },
            { "nl", "ଡଚ୍" },
            { "or", metaValue_or },
            { "pa", "ପଞ୍ଜାବୀ" },
            { "pl", "ପଲିସ୍" },
            { "pt", "ପର୍ତୁଗୀଜ୍‌" },
            { "ro", "ରମାନିଆ ତି" },
            { "ru", "ରୁଷିଆ ତି" },
            { "sa", "ସଂସ୍କୃତ" },
            { "sd", "ସିନ୍ଦୀ" },
            { "si", "ସିଂହଲା" },
            { "sk", "ସ୍ଲବାକ୍" },
            { "sl", "ସ୍ଲବେନିଆ ତି" },
            { "sq", "ଆଲବାନିଆନ୍ ତି" },
            { "sr", "ସର୍ବିୟ ତି" },
            { "sv", "ସ୍ୱିଡିସ୍" },
            { "sw", "ସ୍ୱାହିଲି" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "th", "ତାଇ" },
            { "tr", "ତୁର୍କିସ୍" },
            { "uk", "ୟୁକ୍ରାନିଆତି" },
            { "ur", "ଉର୍ଦୁ" },
            { "uz", "ଉଜବେକ୍" },
            { "vi", "ୱିଏତନାମ ତି" },
            { "zh", "ଚାଇନା ତି" },
            { "zu", "ଜୁଲୁ" },
            { "brx", "ବଡ" },
            { "chr", metaValue_chr },
            { "doi", "ଡଗ୍ରୀ" },
            { "fil", "ପିଲିପିନ" },
            { "kok", "କଂଙ୍କଣି" },
            { "kxv", "କୁୱି" },
            { "mai", "ମଇତିଲୀ" },
            { "mni", "ମଣିପୁରୀ" },
            { "sat", "ସାନ୍ତାଲି" },
            { "Arab", "ଆରବିକ୍" },
            { "Beng", "ବଙ୍ଗାଲୀ" },
            { "Brah", "ବ୍ରାହ୍ମି" },
            { "Cher", metaValue_chr },
            { "Cyrl", "ସିରିଲିକ୍" },
            { "Deva", "ଦେୱନାଗରୀ" },
            { "Gujr", "ଗୁଜୁରାଟୀ" },
            { "Guru", "ଗୁରମୁକୀ" },
            { "Hans", "ସହଜ" },
            { "Hant", "ହିରୁଦଲୁ" },
            { "Knda", "କନ୍ନଡ଼" },
            { "Latn", "ଲାଟିନ୍" },
            { "Mlym", metaValue_ml },
            { "Orya", metaValue_or },
            { "Saur", "ସଉରାଷ୍ଟ୍ର" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "de_AT", "ଅଷ୍ଟ୍ରିଆ ତି ଜର୍ମାନ" },
            { "de_CH", "ସ୍ୱିସ୍‌ ହାଇ ତି ଜର୍ମାନ" },
            { "en_AU", "ଅଷ୍ଟ୍ରେଲିୟାତି ଇଂରାଜୀ" },
            { "en_CA", "କାନାଡିୟାତି ଇଂରାଜୀ" },
            { "en_GB", "ବ୍ରିଟିଶ୍‌ତି ଇଂରାଜୀ" },
            { "en_US", "ଆମେରିକାତି ଇଂରାଜୀ" },
            { "es_ES", "ୟୁରପୀୟାତି ସ୍ପେନିସ୍‌" },
            { "es_MX", "ମେକ୍ସିକତି ସ୍ପେନିସ୍‌" },
            { "fa_AF", "ଡରି" },
            { "fr_CA", "କାନାଡାତି ପ୍ରେଞ୍ଚ‍" },
            { "fr_CH", "ସ୍ୱିସ୍ ପ୍ରେଞ୍ଚ‍" },
            { "nl_BE", "ପେ୍ଲମିସ୍" },
            { "pt_BR", "ବ୍ରାଜିଲିଆନ୍ ପର୍ତୁଗୀଜ୍" },
            { "pt_PT", "ୟୁରପ୍ ତି ପର୍ତୁଗୀଜ୍" },
            { "ro_MD", "ମଲଡୋଭିଆନ୍ ତି" },
            { "sw_CD", "କଙ୍ଗ ସ୍ୱାହିଲି" },
            { "ar_001", "ପୁନି ଜୁଗ ମାନାଙ୍କ ଆରବିକ୍" },
            { "es_419", "ଲାଟିନ୍‌ ଆମେରିକା ତି ସ୍ପେନିସ୍" },
            { "key.ca", "କେଲେଣ୍ଡର" },
            { "key.cf", "ଟାକାଁ ପରମାଟ" },
            { "key.co", "ମିଲା କ୍ରମ" },
            { "key.cu", "ଟାକାଁ" },
            { "key.hc", "ୱେଡ଼ାତି ଗିଲା (୧୨ ଅଡ଼େ ୨୪)" },
            { "key.lb", "ଦାଡ଼ି ଡିକିହିନ ଆଡା" },
            { "key.ms", "ଲାଚିନି ଲେକା" },
            { "key.nu", "ସଂକ୍ୟା" },
            { "zh_Hans", "ସହଜ ଚୀନ" },
            { "zh_Hant", "ହିରୁଦଲୁ ଚାଇନିଜ୍‌" },
            { "type.hc.h11", "୧୨ ଗଣ୍ଟା ତି ପଦ୍ଦତି (0–୧୧)" },
            { "type.hc.h12", "୧୨ ଗଣ୍ଟା ତି ପଦ୍ଦତି (୧–୧୨)" },
            { "type.hc.h23", "୨୪ ଗଣ୍ଟା ତି ପଦ୍ଦତି (0–୨୩)" },
            { "type.hc.h24", "୨୪ ଗଣ୍ଟା ତି ପଦ୍ଦତି (୧–୨୪)" },
            { "type.nu.arab", "ଆରବିକ୍-ବାରତୀୟ ନମ୍ବର" },
            { "type.nu.beng", "ବଙ୍ଗାଲୀ ନମ୍ବର" },
            { "type.nu.deva", "ଦେବନାଗରୀ ନମ୍ବର" },
            { "type.nu.gujr", "ଗୁଜରାଟି ନମ୍ବର" },
            { "type.nu.guru", "ଗୁରୁମୁକି ନମ୍ବର" },
            { "type.nu.knda", "କନଡ ନମ୍ବର" },
            { "type.nu.latn", "ୱେସ୍ଟେନ୍ ନମ୍ବର" },
            { "type.nu.mlym", "ମାଲାୟାଲମ୍ ନମ୍ବର" },
            { "type.nu.orya", "ଅଡ଼ିଆ ନମ୍ବର" },
            { "type.nu.taml", "ହିରୁଦୁଲୁ ତାମିଲ ନମ୍ବର" },
            { "type.nu.telu", "ତେଲୁଗୁ ନମ୍ବର" },
            { "type.co.ducet", "ଡିପଲଟ ୟୁନିକଡ ସର୍ଟ ଲେଁ" },
            { "type.nu.roman", "ରମାନ ନମ୍ବର" },
            { "type.ca.indian", "ବାରତ ଜାତିୟ କେଲେଣ୍ଡର" },
            { "type.co.search", "ସାମାନି-ଉଦେସ୍ୟ ପାରିନ" },
            { "type.ms.metric", "ମେଟ୍ରକି ପଦ୍ଦତି" },
            { "type.nu.arabext", "ନକିଆତି ଆରବିକ୍-ବାରତୀୟ ନମ୍ବର" },
            { "type.nu.tamldec", "ତାମିଲ୍ ନମ୍ବର" },
            { "type.cf.standard", "ମାନାଙ୍କ ଟାକାଁ ରୁପ" },
            { "type.co.standard", "ମାନାଙ୍କ ସର୍ଟ ଲେଁ" },
            { "type.ms.uksystem", "ସାମ୍ରାଜ୍ୟତି ଆଟିନି ମାପ ପଦ୍ଦତି" },
            { "type.ms.ussystem", "ଆମେରିକାତି ମାପ ପଦ୍ଦତି" },
            { "type.nu.romanlow", "ରମାନ ମିଲା ଅରା ନମ୍ବର" },
            { "type.ca.gregorian", "ଗ୍ରେଗରିୟାନ କେଲେଣ୍ଡର" },
            { "type.co.phonebook", "ପନ୍‍ବହି ବାଗା ଅର୍ଡର" },
        };
        return data;
    }
}
