/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_kgp extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "arame";
        final String metaValue_ban = "marinẽj";
        final String metaValue_bax = "mamũm";
        final String metaValue_bn = "megari";
        final String metaValue_chr = "seroki";
        final String metaValue_got = "gótiko";
        final String metaValue_el = "gregu";
        final String metaValue_jv = "javanẽj";
        final String metaValue_km = "kymẽr";
        final String metaValue_ko = "korejỹnũ";
        final String metaValue_la = "ratĩnh";
        final String metaValue_mn = "mãgór";
        final String metaValue_my = "mirmỹnẽj";
        final String metaValue_nqo = "nyko";
        final String metaValue_or = "orija";
        final String metaValue_phn = "fenĩso";
        final String metaValue_th = "tajrỹnej";
        final String metaValue_bo = "timetỹnũ";
        final String metaValue_vai = "vaj";
        final String metaValue_ssy = "saho";
        final Object[][] data = new Object[][] {
            { "001", "Tã mĩ ke kar" },
            { "002", "Afrika" },
            { "003", "Nãrti-Amẽrika" },
            { "005", "Sur-Amẽrika" },
            { "009", "Oseanĩja" },
            { "011", "Afrika Rãpur" },
            { "013", "Amẽrika-Kuju" },
            { "014", "Afrika Rãjur" },
            { "015", "Nãrti-Afrika" },
            { "017", "Afrika-Kuju" },
            { "018", "Afrika Mẽrinhonỹr" },
            { "019", "Amẽrika ag" },
            { "021", "Amẽrika Setẽntrionỹr" },
            { "029", "Karime" },
            { "030", "Ajia Rãjur" },
            { "034", "Ajia Mẽrinhonỹr" },
            { "035", "Ajia Sur-Rãjur" },
            { "039", "Orópa Mẽrinhonỹr" },
            { "053", "Ausitrarajia" },
            { "054", "Mẽranẽjia" },
            { "057", "Mĩkronẽjia Pénĩn" },
            { "061", "Porinẽjia" },
            { "142", "Ajia" },
            { "143", "Ajia-Kuju" },
            { "145", "Ajia-Rãpur" },
            { "150", "Orópa" },
            { "151", "Orópa-Rãjur" },
            { "154", "Orópa Setẽntrionỹr" },
            { "155", "Orópa Rãpur" },
            { "202", "Afrika Sahara-Jẽgu" },
            { "419", "Amẽrika Ratinỹ" },
            { "AC", "Asẽnsỹv Goj-vẽso" },
            { "AD", "Ỹnora" },
            { "AE", "Emĩrano Arame Unĩno" },
            { "AF", "Afeganĩtã" },
            { "AG", "Ỹntiguva kar Marmuna" },
            { "AI", "Ỹngira" },
            { "AL", "Armánĩja" },
            { "AM", "Armẽnĩja" },
            { "AO", "Ỹgóra" },
            { "AQ", "Ỹntartina" },
            { "AR", "Arjẽtinỹ" },
            { "AS", "Samãva Amẽrikynỹ" },
            { "AT", "Agtirija" },
            { "AU", "Avotyraria" },
            { "AW", "Aruma" },
            { "AX", "Gojga Goj-vẽso" },
            { "AZ", "Ajermajjáv" },
            { "BA", "Mósinĩja" },
            { "BB", "Juvã-mág" },
            { "BD", "Mágranési" },
            { "BE", "Mérjika" },
            { "BF", "Murkinỹ Faso" },
            { "BG", "Murgarjia" },
            { "BH", "Marẽj" },
            { "BI", "Murũni" },
            { "BJ", "Menĩnh" },
            { "BL", "Sỹ Martoromeu" },
            { "BM", "Mermũna" },
            { "BN", "Mrunẽj" },
            { "BO", "Morivija" },
            { "BQ", "Pajisi Rur Karimejã" },
            { "BR", "Mrasir" },
            { "BS", "Mahámỹ" },
            { "BT", "Mutỹv" },
            { "BV", "Muve Goj-vẽso" },
            { "BW", "Monsuvỹnỹ" },
            { "BY", "Miero-Husija" },
            { "BZ", "Merije" },
            { "CA", "Kanỹna" },
            { "CC", "Kokonh Goj-vẽso (Killing)" },
            { "CD", "Kãgo - Kĩsaja" },
            { "CF", "Afrikanỹ-kuju Repumrika" },
            { "CG", "Kãgo Repumrika" },
            { "CH", "Suvisa" },
            { "CI", "Jãn-mág-kupri Fyr" },
            { "CK", "Kuki Goj-vẽso" },
            { "CL", "Sire" },
            { "CM", "Kamỹrãj" },
            { "CN", "Sĩnỹ" },
            { "CO", "Korãmija" },
            { "CP", "Kripertãn Goj-vẽso" },
            { "CR", "Konhta Rika" },
            { "CU", "Kuma" },
            { "CV", "Pu Tánh" },
            { "CW", "Kurasavo" },
            { "CX", "Krĩtimỹnh Goj-vẽso" },
            { "CY", "Sipre" },
            { "CZ", "Sékija" },
            { "DE", "Aremỹija" },
            { "DG", "Niego Garsija" },
            { "DJ", "Nhimuti" },
            { "DK", "Ninỹmỹrka" },
            { "DM", "Nomĩnĩka" },
            { "DO", "Repumrika Nomĩnĩkỹnỹ" },
            { "DZ", "Arjérija" },
            { "EA", "Sevuta kar Mẽrira" },
            { "EC", "Ekuvanor" },
            { "EE", "Enhtonĩja" },
            { "EG", "Ejito" },
            { "EH", "Sahara Rãpur" },
            { "ER", "Erytiréja" },
            { "ES", "Enhpỹnija" },
            { "ET", "Etiópija" },
            { "EU", "Unĩjáv Oropéja" },
            { "EZ", "Evoro Ga" },
            { "FI", "Fĩrỹnija" },
            { "FJ", "Fiji" },
            { "FK", "Mỹrvĩnỹ Goj-vẽso" },
            { "FM", "Goj-vẽso-sĩ Kẽsir" },
            { "FO", "Faróve Goj-vẽso" },
            { "FR", "Frỹsa" },
            { "GA", "Gabã" },
            { "GB", "Rejnũ Unĩnu" },
            { "GD", "Granỹna" },
            { "GE", "Jiórja" },
            { "GF", "Frỹsa Gijanỹ" },
            { "GG", "Gérnesej" },
            { "GH", "Ganỹ" },
            { "GI", "Gimrar-tar" },
            { "GL", "Groẽrỹnija" },
            { "GM", "Gỹmija" },
            { "GN", "Ginẽ" },
            { "GP", "Guvanarupe" },
            { "GQ", "Ginẽ Ekuvatoriar" },
            { "GR", "Grésa" },
            { "GS", "Jiórja-Sur kar Sỹnvisi-Sur Goj-vẽso Ag" },
            { "GT", "Guvatimỹra" },
            { "GU", "Guvỹm" },
            { "GW", "Ginẽ-Misav" },
            { "GY", "Gijỹnỹ" },
            { "HK", "Hãg Kãg, Sinỹ ERA" },
            { "HM", "Hárni kar Magtonarni Goj-vẽso Ag" },
            { "HN", "Hãnura" },
            { "HR", "Kroasa" },
            { "HT", "Ajti" },
            { "HU", "Ũgrija" },
            { "IC", "Kanỹrija Goj-vẽso" },
            { "ID", "Ĩnonẽja" },
            { "IE", "Irỹna" },
            { "IL", "Isihaé" },
            { "IM", "Mỹn Goj-vẽso" },
            { "IN", "Ĩnija" },
            { "IQ", "Iraki" },
            { "IR", "Irỹ" },
            { "IS", "Inhrỹnija" },
            { "IT", "Itarija" },
            { "JE", "Jérsej" },
            { "JM", "Jamỹjka" },
            { "JO", "Jornánĩja" },
            { "JP", "Japã" },
            { "KE", "Kenĩja" },
            { "KG", "Kirginhtỹv" },
            { "KH", "Kỹmója" },
            { "KI", "Kirimati" },
            { "KM", "Komãre" },
            { "KN", "Sỹ Krinhtóvỹv kar Nẽvinh" },
            { "KP", "Nãrti-Koréja" },
            { "KR", "Sur-Koréja" },
            { "KW", "Kuvajti" },
            { "KY", "Kajmỹm Goj-vẽso" },
            { "KZ", "Kajakinhtỹv" },
            { "LA", "Raosi" },
            { "LB", "Rimanã" },
            { "LC", "Sỹta Rusija" },
            { "LI", "Rinhsiténh-tajin" },
            { "LK", "Siri Rỹnka" },
            { "LR", "Rimérija" },
            { "LS", "Resotu" },
            { "LT", "Rituỹnĩja" },
            { "LU", "Rusẽmurgu" },
            { "LV", "Retãnĩja" },
            { "LY", "Rimija" },
            { "MA", "Mỹhókonh" },
            { "MC", "Mãnỹko" },
            { "MD", "Mãrnova" },
            { "ME", "Krĩsá" },
            { "MF", "Sỹ Mỹrtĩjũ" },
            { "MG", "Mỹnaganhtar" },
            { "MH", "MỹrSar Goj-vẽso" },
            { "MK", "Nãrti-Mỹsenonĩja" },
            { "ML", "Mỹri" },
            { "MM", "Mĩjỹmỹr" },
            { "MN", "Mãngórija" },
            { "MO", "Mỹkav, Sĩnỹ ERA" },
            { "MP", "Nãrti-Mỹrijỹnỹ Goj-vẽso" },
            { "MQ", "Mỹrtinĩka" },
            { "MR", "Mãritỹnĩja" },
            { "MS", "Mãtisehati" },
            { "MT", "Mỹrta" },
            { "MU", "Mãriso" },
            { "MV", "Mỹrniva" },
            { "MW", "Mỹravi" },
            { "MX", "Mẽsiku" },
            { "MY", "Mỹraja" },
            { "MZ", "Mãsỹmiki" },
            { "NA", "Nỹmĩmija" },
            { "NC", "Karenonĩja Tãg" },
            { "NE", "Nĩjer" },
            { "NF", "Nãrforki Goj-vẽso" },
            { "NG", "Nĩjérija" },
            { "NI", "Nĩkaragva" },
            { "NL", "Pajisi Rur" },
            { "NO", "Nãrovéga" },
            { "NP", "Nẽpar" },
            { "NR", "Nỹuru" },
            { "NU", "Nĩvue" },
            { "NZ", "Jerỹnija Tãg" },
            { "OM", "Omỹ" },
            { "PA", "Panỹmỹ" },
            { "PE", "Piru" },
            { "PF", "Frỹsa Porinẽja" },
            { "PG", "Papuva-Ginẽ Tãg" },
            { "PH", "Firipinỹ" },
            { "PK", "Pakinhtỹv" },
            { "PL", "Porãnija" },
            { "PM", "Sỹ Penru kar Mĩkerỹv" },
            { "PN", "Pinkajir Goj-vẽso" },
            { "PR", "Portu Hiku" },
            { "PS", "Tehitórijo Parenhtinũ" },
            { "PT", "Portugar" },
            { "PW", "Paravu" },
            { "PY", "Paraguvaj" },
            { "QA", "Katar" },
            { "QO", "Osiỹnĩja Kuvar-gy" },
            { "RE", "Hujáv" },
            { "RO", "Homẽnĩja" },
            { "RS", "Sérvija" },
            { "RU", "Husija" },
            { "RW", "Huỹna" },
            { "SA", "Aramija Savnita" },
            { "SB", "Saromỹv Goj-vẽso" },
            { "SC", "Sejserenh" },
            { "SD", "Suná" },
            { "SE", "Suésa" },
            { "SG", "Sĩgapura" },
            { "SH", "Sỹnta Erenỹ" },
            { "SI", "Enhrovenĩja" },
            { "SJ", "Inhvarmarni kar Jan Mỹjẽn" },
            { "SK", "Enhrovakija" },
            { "SL", "Krĩ Mĩgkusũg-fi" },
            { "SM", "Sỹ Mỹrĩnũ" },
            { "SN", "Senẽgar" },
            { "SO", "Somỹrija" },
            { "SR", "Surinỹmĩ" },
            { "SS", "Sur-Sunáv" },
            { "ST", "Sỹ Tomẽ kar Prĩsipi" },
            { "SV", "Er Sarvanor" },
            { "SX", "Sĩti Mỹ’artẽn" },
            { "SY", "Sirija" },
            { "SZ", "Esuatinĩ" },
            { "TA", "Trinhtỹv Nakũja" },
            { "TC", "Turka kar Kajko Goj-vẽso Ag" },
            { "TD", "Sane" },
            { "TF", "Sur Frỹsa Tehitórijo" },
            { "TG", "Togo" },
            { "TH", "Taj-Ga" },
            { "TJ", "Tanijikinhtỹv" },
            { "TK", "Tokeravu" },
            { "TL", "Timãr-Rãjur" },
            { "TM", "Turkomẽnĩnhtỹv" },
            { "TN", "Tunĩja" },
            { "TO", "Tãga" },
            { "TR", "Turkija" },
            { "TT", "Trĩnane kar Tomagu" },
            { "TV", "Tuvaru" },
            { "TW", "Tajuvỹ" },
            { "TZ", "Tỹnjỹnĩja" },
            { "UA", "Ukrỹnĩja" },
            { "UG", "Ugỹna" },
            { "UM", "EUA Goj-vẽso Kãsir" },
            { "UN", "Nỹsãn Unĩna" },
            { "US", "Enhtano Unĩno" },
            { "UY", "Urugvaj" },
            { "UZ", "Unhmekinhtỹv" },
            { "VA", "Vatikỹnũ Emã-mág" },
            { "VC", "Sỹ Visenti kar Granỹninỹ" },
            { "VE", "Venẽjuvéra" },
            { "VG", "Mritỹnĩja Goj-vẽso" },
            { "VI", "Virjĩg Goj-vẽso tỹ Amẽrikỹnỹ" },
            { "VN", "Vijétinỹ" },
            { "VU", "Vanũvatu" },
            { "WF", "Varinh kar Futunỹ" },
            { "WS", "Samãva" },
            { "XA", "Ón vĩ ag" },
            { "XB", "Ón régre mĩ." },
            { "XK", "Kosovo" },
            { "YE", "Jemẽn" },
            { "YT", "Mỹjóte" },
            { "ZA", "Sur-Afrika" },
            { "ZM", "Jỹmija" },
            { "ZW", "Jĩmamuje" },
            { "ZZ", "Reji’ỹv Veja tũ" },
            { "aa", "afar" },
            { "ab", "amekaso" },
            { "ae", "avétiko" },
            { "af", "afrikỹnẽ" },
            { "ak", "akỹn" },
            { "am", "amỹriko" },
            { "an", "aragonẽ" },
            { "ar", metaValue_ar },
            { "as", "ajamẽ" },
            { "av", "avariko" },
            { "ay", "ajimỹra" },
            { "az", "ajermajỹnũ" },
            { "ba", "majkir" },
            { "be", "huso-kupri" },
            { "bg", "mugaru" },
            { "bi", "miramá" },
            { "bm", "mámara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "mretỹ" },
            { "bs", "mojnia" },
            { "ca", "katarũg" },
            { "ce", "sesẽnũ" },
            { "ch", "samãhu" },
            { "co", "korso" },
            { "cr", "kri" },
            { "cs", "séko" },
            { "cu", "eravu ekresijatiko" },
            { "cv", "suvase" },
            { "cy", "garej" },
            { "da", "nhinỹmỹrkej" },
            { "de", "arimỹv" },
            { "dv", "nivehi" },
            { "dz", "jãnga" },
            { "ee", "eve" },
            { "el", metaValue_el },
            { "en", "ĩnhgrej" },
            { "eo", "enhperỹtu" },
            { "es", "enhpỹjór" },
            { "et", "enhtonĩjỹnũ" },
            { "eu", "manhku" },
            { "fa", "pérsa" },
            { "ff", "fura" },
            { "fi", "fĩranẽj" },
            { "fj", "fijỹnũ" },
            { "fo", "fervej" },
            { "fr", "frỹsej" },
            { "fy", "friso rãpur" },
            { "ga", "irỹnej" },
            { "gd", "gajériko enhkosej" },
            { "gl", "garego" },
            { "gn", "góranĩ" },
            { "gu", "gujerati" },
            { "gv", "mỹnsi" },
            { "ha", "havusa" },
            { "he", "emrajko" },
            { "hi", "hĩni" },
            { "ho", "hiri motu" },
            { "hr", "krovata" },
            { "ht", "hajtijỹnũ" },
            { "hu", "ũgaru" },
            { "hy", "armẽnĩju" },
            { "hz", "herero" },
            { "ia", "vĩ-jãgja" },
            { "id", "ĩnonẽsijo" },
            { "ie", "vĩ-ag kuju ki" },
            { "ig", "igmo" },
            { "ii", "sisuvỹ ji" },
            { "ik", "ĩnũpijake" },
            { "io", "ino" },
            { "is", "kukryr" },
            { "it", "itarijỹnũ" },
            { "iu", "inugtituti" },
            { "ja", "japonẽj" },
            { "jv", metaValue_jv },
            { "ka", "jiórjijỹnũ" },
            { "kg", "kãgorej" },
            { "ki", "kikuju" },
            { "kj", "kuvanhỹmỹ" },
            { "kk", "kajake" },
            { "kl", "grohẽrỹnej" },
            { "km", metaValue_km },
            { "kn", "kanỹrim" },
            { "ko", metaValue_ko },
            { "kr", "kanũri" },
            { "ks", "kasemĩra" },
            { "ku", "kurno" },
            { "kv", "komĩ" },
            { "kw", "kórnĩko" },
            { "ky", "kirginh" },
            { "la", metaValue_la },
            { "lb", "rusẽmurgej" },
            { "lg", "rugỹna" },
            { "li", "rĩmurgej" },
            { "ln", "rĩgara" },
            { "lo", "raosijỹnũ" },
            { "lt", "rituvỹnũ" },
            { "lu", "ruma-katỹga" },
            { "lv", "retỹv" },
            { "mg", "mỹrgase" },
            { "mh", "mỹrsarej" },
            { "mi", "mỹvóri" },
            { "mk", "mỹsenojũ" },
            { "ml", "mỹrajara" },
            { "mn", metaValue_mn },
            { "mr", "marati" },
            { "ms", "mỹrajo" },
            { "mt", "mỹrtej" },
            { "my", metaValue_my },
            { "na", "nỹvuruvánũ" },
            { "nb", "mógmỹr nãrovegej" },
            { "nd", "nemere nãrti" },
            { "ne", "nẽparej" },
            { "ng", "nogã" },
            { "nl", "orỹnej" },
            { "nn", "nĩnãrsig nãrovegej" },
            { "no", "nãrovegej" },
            { "nr", "nemere sur" },
            { "nv", "nỹvaho" },
            { "ny", "nĩjỹnja" },
            { "oc", "ogsitỹnũ" },
            { "oj", "ojimva" },
            { "om", "orãmũ" },
            { "or", metaValue_or },
            { "os", "oseto" },
            { "pa", "pỹjami" },
            { "pi", "pari" },
            { "pl", "poronẽj" },
            { "ps", "pasito" },
            { "pt", "fóg-vĩ" },
            { "qu", "kinsuva" },
            { "rm", "homỹse" },
            { "rn", "hũni" },
            { "ro", "homẽnũ" },
            { "ru", "huso" },
            { "rw", "kinĩjarvỹna" },
            { "sa", "sỹnhkrito" },
            { "sc", "sarno" },
            { "sd", "sĩni" },
            { "se", "samĩ nãrti" },
            { "sg", "sỹgo" },
            { "sh", "servo-krovata" },
            { "si", "sĩgarej" },
            { "sk", "erovako" },
            { "sl", "erovenũ" },
            { "sm", "samovỹnũ" },
            { "sn", "sãnỹ" },
            { "so", "somỹri" },
            { "sq", "armánẽj" },
            { "sr", "sérvijo" },
            { "ss", "suvaji" },
            { "st", "soto sur" },
            { "su", "sunanẽj" },
            { "sv", "suvéko" },
            { "sw", "suvahiri" },
            { "ta", "támĩr" },
            { "te", "térugo" },
            { "tg", "tanhike" },
            { "th", metaValue_th },
            { "ti", "tigrinĩja" },
            { "tk", "turkomẽnũ" },
            { "tl", "tagaro" },
            { "tn", "tisuvanỹ" },
            { "to", "tãnganẽj" },
            { "tr", "turko" },
            { "ts", "tesãga" },
            { "tt", "tartaru" },
            { "tw", "tuvi" },
            { "ty", "tajtijỹnũ" },
            { "ug", "ujgur" },
            { "uk", "ukranĩjỹnũ" },
            { "ur", "urnu" },
            { "uz", "unhmeke" },
            { "ve", "vẽna" },
            { "vi", "vijétinỹmũ" },
            { "vo", "vorapuke" },
            { "wa", "varỹv" },
            { "wo", "vorofe" },
            { "xh", "sosa" },
            { "yi", "jinhise" },
            { "yo", "joruma" },
            { "za", "juvỹg" },
            { "zh", "sĩnẽj" },
            { "zu", "suru" },
            { "ace", "agsẽm" },
            { "ach", "akori" },
            { "ada", "anágme" },
            { "ady", "anhige" },
            { "afh", "afrihiri" },
            { "agq", "aghẽm" },
            { "ain", "ajinũ" },
            { "akk", "akajỹnũ" },
            { "ale", "arevute" },
            { "alt", "artaj sur" },
            { "ang", "ĩnhgrej arkajiku" },
            { "anp", "ỹgika" },
            { "arc", "aramajiko" },
            { "arn", "mỹpunugũn" },
            { "arp", "arapaho" },
            { "ars", "arame nẽgene" },
            { "arw", "aruvaki" },
            { "asa", "asu" },
            { "ast", "anhturijỹnũ" },
            { "awa", "avanhi" },
            { "bal", "marusi" },
            { "ban", metaValue_ban },
            { "bas", "masa" },
            { "bax", metaValue_bax },
            { "bbj", "gumỹra" },
            { "bej", "meja" },
            { "bem", "mema" },
            { "bez", "menỹ" },
            { "bfd", "mafun" },
            { "bgn", "marusi-rãpurja" },
            { "bho", "mojpuri" },
            { "bik", "mikor" },
            { "bin", "minĩ" },
            { "bkm", "kãm" },
            { "bla", "sigsika" },
            { "bra", "mraj" },
            { "brx", "mono" },
            { "bss", "akuse" },
            { "bua", "murijato" },
            { "bug", "muginẽj" },
            { "bum", "muru" },
            { "byn", "mrĩn" },
            { "byv", "menuma" },
            { "cad", "kano" },
            { "car", "karime" },
            { "cay", "kajuga" },
            { "cch", "ansỹm" },
            { "ccp", "sakimỹ" },
            { "ceb", "semujỹnũ" },
            { "cgg", "siga" },
            { "chb", "simsa" },
            { "chg", "sagataj" },
            { "chk", "sukese" },
            { "chm", "mỹri" },
            { "chn", "jargỹ sinũki" },
            { "cho", "sogtavo" },
            { "chp", "sipevyjỹ" },
            { "chr", metaValue_chr },
            { "chy", "sejẽnẽ" },
            { "ckb", "kurno kuju" },
            { "cop", "komta" },
            { "crh", "krimẽja tá turko" },
            { "crs", "sejséri krijoro-frỹsej" },
            { "csb", "kasumijỹ" },
            { "dak", "nakota" },
            { "dar", "narguva" },
            { "dav", "tajta" },
            { "del", "neravare" },
            { "den", "sirave" },
            { "dgr", "nogrim" },
            { "din", "ninka" },
            { "dje", "jarma" },
            { "doi", "nogri" },
            { "dsb", "soramiv rur" },
            { "dua", "nuvara" },
            { "dum", "orỹnej kuju" },
            { "dyo", "jora-fonyj" },
            { "dyu", "nhivura" },
            { "dzg", "najaga" },
            { "ebu", "ẽmu" },
            { "efi", "efike" },
            { "egy", "ejimso arkajku" },
            { "eka", "ekajuki" },
            { "elx", "eramĩte" },
            { "enm", "ĩnhgrej kuju" },
            { "ewo", "evãnu" },
            { "fan", "fỹnge" },
            { "fat", "fỹti" },
            { "fil", "firipĩnũ" },
            { "fon", "fãm" },
            { "frc", "frỹsej kajũn" },
            { "frm", "frỹsej kuju" },
            { "fro", "frỹsej arkajku" },
            { "frr", "friso tỹ nãrti" },
            { "frs", "frisỹ rãjur" },
            { "fur", "frijurỹnũ" },
            { "gaa", "ga" },
            { "gag", "gagavuj" },
            { "gan", "gỹn" },
            { "gay", "gajo" },
            { "gba", "gemaja" },
            { "gez", "gij" },
            { "gil", "gimertej" },
            { "gmh", "arimỹv-téj kuju" },
            { "goh", "arimỹv-téj arkajku" },
            { "gon", "gãnni" },
            { "gor", "gorãntar" },
            { "got", metaValue_got },
            { "grb", "gremo" },
            { "grc", "gregu arkajku" },
            { "gsw", "arimỹv (Suvisa)" },
            { "guz", "gusij" },
            { "gwi", "guvisĩn" },
            { "hai", "hajna" },
            { "hak", "haka" },
            { "haw", "havajỹnũ" },
            { "hil", "hirigajnãn" },
            { "hit", "hitita" },
            { "hmn", "hymãg" },
            { "hsb", "soramiv téj" },
            { "hsn", "sijỹg" },
            { "hup", "hupa" },
            { "iba", "iman" },
            { "ibb", "imimijo" },
            { "ilo", "irukỹnũ" },
            { "inh", "ĩnguse" },
            { "jbo", "rojmán" },
            { "jgo", "gẽma" },
            { "jmc", "mỹsame" },
            { "jpr", "junajko-pérsa" },
            { "jrb", "junajko-aramiko" },
            { "kaa", "kara-karkag" },
            { "kab", "kamyre" },
            { "kac", "kasĩn" },
            { "kaj", "ju" },
            { "kam", "kỹma" },
            { "kaw", "kavi" },
            { "kbd", "kamarnhijỹnũ" },
            { "kbl", "kanẽnmu" },
            { "kcg", "tyjam" },
            { "kde", "mỹkãne" },
            { "kea", "pu-tánh-vĩ" },
            { "kfo", "koro" },
            { "kgp", "kanhgág" },
            { "kha", "kasi" },
            { "kho", "kotanẽj" },
            { "khq", "kujra sĩnĩ" },
            { "kkj", "kako" },
            { "kln", "karẽnjĩn" },
            { "kmb", "kĩmuno" },
            { "koi", "komĩ-permyjag" },
            { "kok", "kãkani" },
            { "kos", "kosirajỹn" },
            { "kpe", "kepere" },
            { "krc", "karasaj-markar" },
            { "krl", "karérijo" },
            { "kru", "kurug" },
            { "ksb", "sỹmara" },
            { "ksf", "mafija" },
            { "ksh", "kárysi" },
            { "kum", "kumyg" },
            { "kut", "kutenaj" },
            { "lad", "raninũ" },
            { "lag", "rỹngi" },
            { "lah", "rahina" },
            { "lam", "rỹma" },
            { "lez", "resgi" },
            { "lkt", "rakóta" },
            { "lol", "mãgo" },
            { "lou", "rovusijỹnỹ tá ke pẽ" },
            { "loz", "roji" },
            { "lrc", "ruri nãrti" },
            { "lua", "ruma-ruruva" },
            { "lui", "rujsẽnũ" },
            { "lun", "rũna" },
            { "luo", "ruvo" },
            { "lus", "rusaj" },
            { "luy", "ruja" },
            { "mad", "mỹnurej" },
            { "maf", "mafa" },
            { "mag", "mỹgahi" },
            { "mai", "mỹjtiri" },
            { "mak", "mỹkasar" },
            { "man", "mỹnhĩga" },
            { "mas", "mỹsaj" },
            { "mde", "mama" },
            { "mdf", "mogsa" },
            { "mdr", "mỹnar" },
            { "men", "mẽne" },
            { "mer", "mẽru" },
            { "mfe", "mãrisijẽn" },
            { "mga", "irỹnej kuju" },
            { "mgh", "mỹkuva" },
            { "mgo", "mẽta" },
            { "mic", "mĩkemỹke" },
            { "min", "mĩnỹgkamavu" },
            { "mnc", "mỹsu" },
            { "mni", "mỹnĩpuri" },
            { "moh", "mãjkỹnũ" },
            { "mos", "mosi" },
            { "mua", "mũnág" },
            { "mul", "vẽnhvĩ’e" },
            { "mus", "krig" },
            { "mwl", "mĩrỹnej" },
            { "mwr", "mỹrvari" },
            { "mye", "myene" },
            { "myv", "érsija" },
            { "mzn", "mỹsánarỹni" },
            { "nan", "mĩn nỹn" },
            { "nap", "nỹporitỹnũ" },
            { "naq", "nỹmỹ" },
            { "nds", "arimỹv rur" },
            { "new", "nẽvari" },
            { "nia", "nĩja" },
            { "niu", "nivuvejỹnũ" },
            { "nmg", "kivasijo" },
            { "nnh", "gijẽmun" },
            { "nog", "nãgaj" },
            { "non", "nãrniko arkajku" },
            { "nqo", metaValue_nqo },
            { "nso", "soto nãrti" },
            { "nus", "nũver" },
            { "nwc", "nẽvari há tỹvĩ" },
            { "nym", "nyjỹm-vesi" },
            { "nyn", "nyjỹmkore" },
            { "nyo", "nyjor" },
            { "nzi", "nĩsimỹ" },
            { "osa", "osage" },
            { "ota", "turko otomỹnũ" },
            { "pag", "pangasinỹ" },
            { "pal", "paravi" },
            { "pam", "pampỹga" },
            { "pap", "papijamẽto" },
            { "pau", "paravỹnũ" },
            { "pcm", "pingĩn nĩjerijỹnũ" },
            { "peo", "pérsa arkajku" },
            { "phn", metaValue_phn },
            { "pon", "pãnhpejỹnũ" },
            { "prg", "prusijỹnũ" },
            { "pro", "provẽsar arkajku" },
            { "quc", "kisé" },
            { "raj", "hajanhtỹnĩ" },
            { "rap", "hapanũj" },
            { "rar", "harotãganũ" },
            { "rof", "hãmo" },
            { "rom", "homỹnĩ" },
            { "rup", "aromẽnũ" },
            { "rwk", "hywa" },
            { "sad", "sỹnave" },
            { "sah", "saka" },
            { "sam", "aramỹjko samaritỹnũ" },
            { "saq", "sỹmuru" },
            { "sas", "sasag" },
            { "sat", "sỹtari" },
            { "sba", "gỹmaji" },
            { "sbp", "sỹgu" },
            { "scn", "sisirijỹnũ" },
            { "sco", "isikoti" },
            { "sdh", "kurno sur" },
            { "see", "senẽka" },
            { "seh", "senỹ" },
            { "sel", "serkum" },
            { "ses", "kojyramoro senĩ" },
            { "sga", "irỹnej arkajku" },
            { "shi", "tasehiti" },
            { "shn", "sỹn" },
            { "shu", "arame sanijỹnũ" },
            { "sid", "sinamũ" },
            { "sma", "samĩ sur" },
            { "smj", "samĩ Rure tá" },
            { "smn", "samĩ Inari tá" },
            { "sms", "samĩ Isikórti tá" },
            { "snk", "sãnĩke" },
            { "sog", "sognijỹnũ" },
            { "srn", "surinỹmẽj" },
            { "srr", "serere" },
            { "ssy", metaValue_ssy },
            { "suk", "sukumỹ" },
            { "sus", "susu" },
            { "sux", "sumẽrijo" },
            { "swb", "komorijỹnũ" },
            { "syc", "sirijako há tỹvĩ" },
            { "syr", "sirijako" },
            { "tem", "timnẽ" },
            { "teo", "teso" },
            { "ter", "terẽnũ" },
            { "tet", "tétũm" },
            { "tig", "tigré" },
            { "tiv", "tivi" },
            { "tkl", "tokeravánũ" },
            { "tlh", "krĩngãg" },
            { "tli", "tiringite" },
            { "tmh", "tamỹséke" },
            { "tog", "tãnganẽj Nyjasa tá" },
            { "tpi", "tóg-pisĩn" },
            { "trv", "taroko" },
            { "tsi", "simsijỹnũ" },
            { "tum", "tũmuka" },
            { "tvl", "tuvaruvỹnũ" },
            { "twq", "tasavag" },
            { "tyv", "tuvinijỹnũ" },
            { "tzm", "tamỹjirte Atara Kuju tá" },
            { "udm", "unmũrte" },
            { "uga", "ugaritiko" },
            { "umb", "ũmunu" },
            { "und", "vẽnhvĩ ki kagtĩg" },
            { "vai", metaValue_vai },
            { "vot", "vótiko" },
            { "vun", "vũjo" },
            { "wae", "varser" },
            { "wal", "vorajta" },
            { "war", "varaj" },
            { "was", "vaso" },
            { "wbp", "varpiri" },
            { "wuu", "vu" },
            { "xal", "karmĩg" },
            { "xog", "rusoga" },
            { "yao", "javo" },
            { "yap", "japese" },
            { "yav", "jỹgmen" },
            { "ybb", "jẽma" },
            { "yrl", "nhẽgatu" },
            { "yue", "kỹtonẽj" },
            { "zap", "japoteko" },
            { "zbl", "sĩmoru mrij" },
            { "zen", "senỹga" },
            { "zgh", "tamỹjirte mỹhókinũ pã" },
            { "zun", "sunhi" },
            { "zxx", "nén ũ vẽnhvĩ ki tũ" },
            { "zza", "sasaki" },
            { "Arab", metaValue_ar },
            { "Armi", "armĩ" },
            { "Armn", "armẽnjo" },
            { "Avst", "avénhko" },
            { "Bali", metaValue_ban },
            { "Bamu", metaValue_bax },
            { "Batk", "mataki" },
            { "Beng", metaValue_bn },
            { "Blis", "sĩmuru mrij" },
            { "Bopo", "mopomãfo" },
            { "Brah", "mramĩ" },
            { "Brai", "mrajiri" },
            { "Bugi", "mugnẽj" },
            { "Buhd", "muhin" },
            { "Cakm", "kagme" },
            { "Cans", "sirama-vẽnhrá pir kanỹna tá kanhgág" },
            { "Cari", "karijỹnũ" },
            { "Cham", "sỹm" },
            { "Cher", metaValue_chr },
            { "Cirt", "sirti" },
            { "Copt", "kómtiko" },
            { "Cprt", "siprijota" },
            { "Cyrl", "siririko" },
            { "Cyrs", "siririko esiravo ekresijatiko" },
            { "Deva", "nevanỹgari" },
            { "Dsrt", "nesereti" },
            { "Egyd", "nemãtiko ejimso" },
            { "Egyh", "jeratiko ejimso" },
            { "Egyp", "jerógrifo ejimso" },
            { "Ethi", "etijópiko" },
            { "Geok", "kehunsuri geórgijỹnũ" },
            { "Geor", "geórgijỹnũ" },
            { "Glag", "gragoritiko" },
            { "Goth", metaValue_got },
            { "Grek", metaValue_el },
            { "Gujr", "guserate" },
            { "Guru", "gurmũki" },
            { "Hanb", "hỹnme" },
            { "Hang", "hỹngur" },
            { "Hani", "hỹn" },
            { "Hano", "hỹnũnũ" },
            { "Hans", "sĩpri-há" },
            { "Hant", "si-pẽ" },
            { "Hebr", "hemraiko" },
            { "Hira", "hiragỹnỹ" },
            { "Hmng", "pahav homãg" },
            { "Hrkt", "sirama-vẽnhrá japunẽj" },
            { "Hung", "hũgaru si" },
            { "Inds", "ĩnu" },
            { "Ital", "itariko si" },
            { "Jamo", "jỹmo" },
            { "Java", metaValue_jv },
            { "Jpan", "japunẽj" },
            { "Kali", "kaja-ri" },
            { "Kana", "katakỹnỹ" },
            { "Khar", "karositi" },
            { "Khmr", metaValue_km },
            { "Knda", "kan-nỹna" },
            { "Kore", metaValue_ko },
            { "Kthi", "kanhi" },
            { "Lana", "rỹnỹ" },
            { "Laoo", "ra’o" },
            { "Latf", "ratĩnh fragtur" },
            { "Latg", "ratĩnh gajériko" },
            { "Latn", metaValue_la },
            { "Lepc", "rémsa" },
            { "Limb", "rĩmu" },
            { "Lina", "rĩnẽjar A" },
            { "Linb", "rĩnẽjar B" },
            { "Lisu", "risu" },
            { "Lyci", "risijo" },
            { "Lydi", "rinh-jo" },
            { "Mand", "mỹnajku" },
            { "Mani", "mỹnĩkejỹnũ" },
            { "Maya", "hijerógrifu maja" },
            { "Merc", "mẽrojitiku nĩgé-tỹ" },
            { "Mero", "mẽrojitiku" },
            { "Mlym", "marajara" },
            { "Mong", metaValue_mn },
            { "Moon", "mũn" },
            { "Mtei", "mẽjtej mỹjéki" },
            { "Mymr", metaValue_my },
            { "Nkoo", metaValue_nqo },
            { "Ogam", "ogỹmiku" },
            { "Olck", "or siki" },
            { "Orkh", "orkihãn" },
            { "Orya", metaValue_or },
            { "Osma", "ojmỹnja" },
            { "Perm", "pérmĩku si" },
            { "Phag", "fagpa" },
            { "Phli", "pahir" },
            { "Phlp", "pahin" },
            { "Phlv", "pahiravi si" },
            { "Phnx", metaValue_phn },
            { "Plrd", "fonẽtiko porarne" },
            { "Prti", "priti" },
            { "Rjng", "rejỹg" },
            { "Roro", "rãgorãgo" },
            { "Runr", "runĩku" },
            { "Samr", "samỹritỹnũ" },
            { "Sara", "sarati" },
            { "Saur", "savurajtera" },
            { "Sgnw", "vẽnh-mu vẽnhrád" },
            { "Shaw", "savijỹnũ" },
            { "Sinh", "sĩgarẽj" },
            { "Sund", "sũnanẽj" },
            { "Sylo", "syroti nỹgri" },
            { "Syrc", "sirijaku" },
            { "Syre", "sirijaku esitarageru" },
            { "Syrj", "sirijaku rãpur" },
            { "Syrn", "sirijaku rãjur" },
            { "Tagb", "tagmánva" },
            { "Tale", "taj-re" },
            { "Talu", "taj-re tãg" },
            { "Taml", "tỹmĩr" },
            { "Tavt", "tavuti" },
            { "Telu", "térugu" },
            { "Teng", "tẽgvar" },
            { "Tfng", "tifinỹg" },
            { "Tglg", "tagaru" },
            { "Thaa", "ta’anỹ" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Ugar", "ugaritiku" },
            { "Vaii", metaValue_vai },
            { "Visp", "vĩ-ve-há" },
            { "Xpeo", "pérsa si" },
            { "Xsux", "sumẽrijo-akanhỹnũ kafén ja" },
            { "Yiii", "yji" },
            { "Zinh", "ernanu" },
            { "Zmth", "vẽnhnĩkrén rá" },
            { "Zsye", "Emãji" },
            { "Zsym", "zsym" },
            { "Zxxx", "vẽnhrá-tũ" },
            { "Zyyy", "kãmũ" },
            { "Zzzz", "vẽnhrá ki kagtĩg" },
            { "root", "haji" },
            { "de_CH", "suvisa arimỹv-téj" },
            { "nl_BE", "framẽgo" },
            { "ro_MD", "mãrnavijo" },
            { "sw_CD", "suvahiri Kãgo tá" },
            { "%%1901", "arimỹv vẽnhrá si-pẽ" },
            { "%%1994", "resijỹnỹ vẽnhrá hár-pẽ" },
            { "%%1996", "prỹg tỹ 1996 kã vẽnhrá arimỹ" },
            { "ar_001", "arame ta’ũn" },
            { "key.ca", "Kurã-kar" },
            { "key.cf", "tỹ nĩkri ve" },
            { "key.co", "jagnẽ nón fẽgfẽg há han" },
            { "key.cu", "Jẽnkamu" },
            { "key.hc", "Óra tĩg tỹ (12 vs. 24)" },
            { "key.lb", "vẽfe mranh to ke" },
            { "key.ms", "vẽnhkãmun to ke" },
            { "key.nu", "Vẽnh nĩkrer" },
            { "key.tz", "Óra tỹ’ũn" },
            { "key.va", "vẽnhmỹ tá nĩnĩ ke" },
            { "nds_NL", "sagsỹv rur" },
            { "%%BISKE", "sỹn jórjo/ mira vĩ pẽ" },
            { "%%BOONT", "mutrĩg - jamã vĩ pẽ" },
            { "%%KKCOR", "vẽnhrá to ke vẽnhmỹ ke kar" },
            { "%%LIPAW", "Resijỹn tỹ ripovasi vĩ pẽ" },
            { "%%NEDIS", "natisonẽ vĩ pẽ" },
            { "%%NJIVA", "giva/niva vĩ pẽ" },
            { "%%OSOJS", "osejako/osojỹnẽ vĩ pẽ" },
            { "%%POSIX", "kãputanor" },
            { "%%ROZAJ", "resijỹnũ" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "setorvisa/ sormika vĩ pẽ" },
            { "%%UCCOR", "vẽnhrá to ke pir" },
            { "az_Arab", "aseri sur" },
            { "zh_Hans", "sĩnẽj mẽ" },
            { "zh_Hant", "sĩnẽj pẽ" },
            { "%%AO1990", "1990 Fóg Vĩ vẽnhrá to Vẽnhkrén ja" },
            { "%%FONIPA", "Arfaméto Fonẽtiku Ĩnhternỹsonỹv to Fonẽtika" },
            { "%%FONUPA", "Arfaméto Fonẽtiku Urariko" },
            { "%%NDYUKA", "nyjuka vĩ pẽ" },
            { "%%PAMAKA", "pamỹka vĩ pẽ" },
            { "%%PINYIN", "Piny’in vẽnhrá ratinũ to" },
            { "%%SCOUSE", "enhkose vĩ pẽ" },
            { "%%TARASK", "tarasikevika vẽnhrá-pẽ" },
            { "%%UCRCOR", "vẽnhrá jẽnfĩn tỹ pir ke" },
            { "%%ABL1943", "1943 kã Fóg Vĩ Vẽnhrán Formũrariv jé hár" },
            { "%%AREVELA", "armẽnĩju rãjur" },
            { "%%AREVMDA", "armẽnĩju rãpur" },
            { "%%HEPBURN", "japonej vẽnhrá ratinũ to hépymur" },
            { "%%MONOTON", "kyr mág ve" },
            { "%%POLYTON", "ũ ag téj" },
            { "%%REVISED", "vẽnhrá jãfĩ" },
            { "%%1606NICT", "1606 kã frỹsej si" },
            { "%%1694ACAD", "frỹsej tỹ uri" },
            { "%%1959ACAD", "kanẽmĩku" },
            { "%%BAKU1926", "arfaméto turko ratinũ tỹ ũn pir" },
            { "%%BISCAYAN", "misikajo" },
            { "%%COLB1945", "Ruso-Mrasirera ki vẽnhrá to 1945 Vẽnhkrén ja" },
            { "%%HOGNORSK", "nãrovegej kynhmỹ" },
            { "%%SCOTLAND", "ĩnhgrej Enhkósija tá" },
            { "%%VALENCIA", "varensijanũ" },
            { "%%WADEGILE", "Wade-Giles vẽnhrá ratinũ to" },
            { "type.ca.roc", "Sĩnỹ Kar-mỹ Prỹg-kurã-kar" },
            { "type.co.eor", "Orópa tá vẽnhvin han to ke" },
            { "type.hc.h11", "12 óra tuke (0–11)" },
            { "type.hc.h12", "12 óra tuke (1–12)" },
            { "type.hc.h23", "24 óra tuke (0–23)" },
            { "type.hc.h24", "24 óra tuke (1–24)" },
            { "type.m0.bgn", "Vẽnhrá ũ ra tĩn BGN EUA (Vẽnhvĩ ũra tĩn)" },
            { "type.nu.arab", "Ĩno-aramiko rá pipir" },
            { "type.nu.armn", "Armẽnĩjo rá pipir" },
            { "type.nu.beng", "Meggari rá pipir" },
            { "type.nu.deva", "Nevanỹgari rá pipir" },
            { "type.nu.ethi", "Etijópijánũ rá pipir" },
            { "type.nu.geor", "Jejorjỹnũ rá pipir" },
            { "type.nu.grek", "Grego rá pipir" },
            { "type.nu.gujr", "Guserate rá pipir" },
            { "type.nu.guru", "Gurmũrá pipir rá pipir" },
            { "type.nu.hans", "Sĩnẽj rá pipir sĩmpri há" },
            { "type.nu.hant", "Sĩnẽj rá pipir pẽ" },
            { "type.nu.hebr", "Emrajko rá pipir" },
            { "type.nu.jpan", "Japonẽj rá pipir" },
            { "type.nu.khmr", "Khmẽr rá pipir" },
            { "type.nu.knda", "Kanỹrẽse rá pipir" },
            { "type.nu.laoo", "Ravosijỹnũ rá pipir" },
            { "type.nu.latn", "Rãpur rá pipir" },
            { "type.nu.mlym", "Marajaro rá pipir" },
            { "type.nu.mong", "Mãgór rá pipir" },
            { "type.nu.mymr", "Mỹjỹmỹr rá pipir" },
            { "type.nu.orya", "Orija rá pipir" },
            { "type.nu.taml", "Tỹmĩr pẽ rá pipir" },
            { "type.nu.telu", "Terugo rá pipir" },
            { "type.nu.thai", "Tajrỹnej rá pipir" },
            { "type.nu.tibt", "Timetỹnũ rá pipir" },
            { "type.nu.vaii", "Vaj nĩkrén pipir" },
            { "type.ca.dangi", "Nági Prỹg-kurã-kar" },
            { "type.co.ducet", "Unicode to ke pẽ" },
            { "type.lb.loose", "Vẽfe mranh han fã pã tovan ka" },
            { "type.nu.roman", "Romỹnũ rá pipir" },
            { "type.ca.coptic", "Komtike Prỹg-kurã-kar" },
            { "type.ca.hebrew", "Emrajko Prỹg-kurã-kar" },
            { "type.ca.indian", "Ĩnija Prỹg-kurã-kar pẽ" },
            { "type.co.compat", "Ẽgno tá jẽnẽ já kỹ ta ki já" },
            { "type.co.pinyin", "Pin-yin to nỹtĩ" },
            { "type.co.search", "Jẽnfĩn to ke Kar" },
            { "type.co.stroke", "Junhjoj to ke" },
            { "type.co.unihan", "Ranikar-jonhjoj to nỹtĩ pẽ" },
            { "type.d0.fwidth", "Tãpér kar" },
            { "type.d0.hwidth", "Tãpér kuju" },
            { "type.lb.normal", "Vẽfe mranh han fã pẽ ki" },
            { "type.lb.strict", "Vẽfe mranh han fã rá ki" },
            { "type.m0.ungegn", "Vẽnhrá ũ ra tĩn UN GEGN" },
            { "type.ms.metric", "Kãmur to ke pẽ" },
            { "type.nu.native", "Nĩkrer ũ vepã rá pipir" },
            { "type.ca.chinese", "Sĩnẽj Prỹg-kurã-kar" },
            { "type.ca.iso8601", "Prỹg-kurã-kar ISO-8601" },
            { "type.ca.persian", "Pérsa Prỹg-kurã-kar" },
            { "type.cf.account", "Kajẽm jé nĩkri hár" },
            { "type.co.big5han", "Sĩnẽj Vỹsa ke to ke pẽ - Big5" },
            { "type.d0.npinyin", "Nĩkrer" },
            { "type.nu.arabext", "Ĩno-aramiko kugjer rá pipir" },
            { "type.nu.armnlow", "Armẽnĩjo rá pipir kẽsir" },
            { "type.nu.finance", "Jãnkamu vin hár nĩkrer" },
            { "type.nu.greklow", "Grego kẽsir rá pipir" },
            { "type.nu.hanidec", "Sĩnẽj néj ki rá pipir" },
            { "type.nu.hansfin", "Sĩnẽj rá pipir jẽnkamu sĩmpri há" },
            { "type.nu.hantfin", "Sĩnẽj rá pipir jẽnkamu pẽ" },
            { "type.nu.jpanfin", "Japonẽj vin hár" },
            { "type.nu.tamldec", "Tỹmĩr rá pipir" },
            { "type.ca.buddhist", "Munisita Prỹg-kurã-kar" },
            { "type.ca.ethiopic", "Etijópi Prỹg-kurã-kar" },
            { "type.ca.japanese", "Japonẽj Prỹg-kurã-kar" },
            { "type.cf.standard", "Nĩkri han ka nĩ pẽ" },
            { "type.co.phonetic", "Fonẽtika to ke kuprãg" },
            { "type.co.searchjl", "Hangul kãsonỹte ve jãnfĩn" },
            { "type.co.standard", "to ke pẽ" },
            { "type.ms.uksystem", "Vẽnhkãmur ĩperijar ki" },
            { "type.ms.ussystem", "Amẽrikỹnũ vẽnhkãmur to hár" },
            { "type.nu.fullwide", "ti téj kar rá pipir" },
            { "type.nu.romanlow", "Romỹnũ rá kẽsir rá pipir" },
            { "type.ca.gregorian", "Papa Gregorju Prỹg-kurã-kar" },
            { "type.co.gb2312han", "Sĩnẽj ke to ke (sĩmpri há) - GB2312" },
            { "type.co.phonebook", "Terefonĩ Risita to ke" },
            { "type.co.dictionary", "Vẽnhrá Nỹtĩj-fẽ nỹtĩ há" },
            { "type.co.traditional", "To ke nỹtĩ pẽ" },
            { "type.nu.traditional", "Nĩkrer pẽ" },
            { "type.ca.ethiopic-amete-alem", "Amete Alem Etijópi Prỹg-kurã-kar" },
        };
        return data;
    }
}
