/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IDocElement;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.AbortSearchException;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.proposals.NewDefiningMethodProposalCore;
import org.eclipse.jdt.ui.text.java.IInvocationContext;

public class QuickAssistProcessorUtil {
    public static IMethodBinding getFunctionalMethodForMethodReference(MethodReference methodReference) {
        ITypeBinding targetTypeBinding = ASTNodes.getTargetType((Expression)methodReference);
        if (targetTypeBinding == null) {
            return null;
        }
        IMethodBinding functionalMethod = targetTypeBinding.getFunctionalInterfaceMethod();
        if (functionalMethod != null && functionalMethod.isSynthetic()) {
            functionalMethod = Bindings.findOverriddenMethodInType(functionalMethod.getDeclaringClass(), functionalMethod);
        }
        return functionalMethod;
    }

    public static LambdaExpression convertMethodRefernceToLambda(MethodReference methodReference, IMethodBinding functionalMethod, CompilationUnit astRoot, ASTRewrite rewrite, LinkedProposalModelCore linkedProposalModel, boolean createBlockBody) throws JavaModelException {
        AST ast = astRoot.getAST();
        LambdaExpression lambda = ast.newLambdaExpression();
        String[] lambdaParamNames = QuickAssistProcessorUtil.getUniqueParameterNames(methodReference, functionalMethod);
        List lambdaParameters = lambda.parameters();
        int i = 0;
        while (i < lambdaParamNames.length) {
            String paramName = lambdaParamNames[i];
            VariableDeclarationFragment lambdaParameter = ast.newVariableDeclarationFragment();
            SimpleName name = ast.newSimpleName(paramName);
            lambdaParameter.setName(name);
            lambdaParameters.add(lambdaParameter);
            if (linkedProposalModel != null) {
                linkedProposalModel.getPositionGroup(name.getIdentifier(), true).addPosition(rewrite.track((ASTNode)name), i == 0);
            }
            ++i;
        }
        int noOfLambdaParameters = lambdaParamNames.length;
        lambda.setParentheses(noOfLambdaParameters != 1);
        ITypeBinding returnTypeBinding = functionalMethod.getReturnType();
        IMethodBinding referredMethodBinding = methodReference.resolveMethodBinding();
        if (methodReference instanceof CreationReference) {
            CreationReference creationRef = (CreationReference)methodReference;
            Type type = creationRef.getType();
            if (type instanceof ArrayType) {
                ArrayCreation arrayCreation = ast.newArrayCreation();
                if (createBlockBody) {
                    Block blockBody = QuickAssistProcessorUtil.getBlockBodyForLambda((Expression)arrayCreation, returnTypeBinding, ast);
                    lambda.setBody((ASTNode)blockBody);
                } else {
                    lambda.setBody((ASTNode)arrayCreation);
                }
                ArrayType arrayType = (ArrayType)type;
                Type copiedElementType = (Type)rewrite.createCopyTarget((ASTNode)arrayType.getElementType());
                arrayCreation.setType(ast.newArrayType(copiedElementType, arrayType.getDimensions()));
                SimpleName name = ast.newSimpleName(lambdaParamNames[0]);
                arrayCreation.dimensions().add(name);
                if (linkedProposalModel != null) {
                    linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                }
            } else {
                ClassInstanceCreation cic = ast.newClassInstanceCreation();
                if (createBlockBody) {
                    Block blockBody = QuickAssistProcessorUtil.getBlockBodyForLambda((Expression)cic, returnTypeBinding, ast);
                    lambda.setBody((ASTNode)blockBody);
                } else {
                    lambda.setBody((ASTNode)cic);
                }
                ITypeBinding typeBinding = type.resolveBinding();
                if (!(type instanceof ParameterizedType) && typeBinding != null && typeBinding.getTypeDeclaration().isGenericType()) {
                    cic.setType((Type)ast.newParameterizedType((Type)rewrite.createCopyTarget((ASTNode)type)));
                } else {
                    cic.setType((Type)rewrite.createCopyTarget((ASTNode)type));
                }
                List<SimpleName> invocationArgs = QuickAssistProcessorUtil.getInvocationArguments(ast, 0, noOfLambdaParameters, lambdaParamNames);
                cic.arguments().addAll(invocationArgs);
                if (linkedProposalModel != null) {
                    for (SimpleName name : invocationArgs) {
                        linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                    }
                }
                cic.typeArguments().addAll(QuickAssistProcessorUtil.getCopiedTypeArguments(rewrite, methodReference.typeArguments()));
            }
        } else if (referredMethodBinding != null && Modifier.isStatic((int)referredMethodBinding.getModifiers())) {
            methodInvocation = ast.newMethodInvocation();
            if (createBlockBody) {
                Block blockBody = QuickAssistProcessorUtil.getBlockBodyForLambda((Expression)methodInvocation, returnTypeBinding, ast);
                lambda.setBody((ASTNode)blockBody);
            } else {
                lambda.setBody((ASTNode)methodInvocation);
            }
            Expression expr = null;
            boolean hasConflict = QuickAssistProcessorUtil.hasConflict(methodReference.getStartPosition(), referredMethodBinding, 17, astRoot);
            if (hasConflict || !Bindings.isSuperType(referredMethodBinding.getDeclaringClass(), ASTNodes.getEnclosingType((ASTNode)methodReference)) || methodReference.typeArguments().size() != 0) {
                Type type;
                ITypeBinding typeBinding;
                if (methodReference instanceof ExpressionMethodReference) {
                    ExpressionMethodReference expressionMethodReference = (ExpressionMethodReference)methodReference;
                    expr = (Expression)rewrite.createCopyTarget((ASTNode)expressionMethodReference.getExpression());
                } else if (methodReference instanceof TypeMethodReference && (typeBinding = (type = ((TypeMethodReference)methodReference).getType()).resolveBinding()) != null) {
                    ImportRewrite importRewrite = StubUtility.createImportRewrite(astRoot, true);
                    expr = ast.newName(importRewrite.addImport(typeBinding));
                }
            }
            methodInvocation.setExpression(expr);
            SimpleName methodName = QuickAssistProcessorUtil.getMethodInvocationName(methodReference);
            methodInvocation.setName((SimpleName)rewrite.createCopyTarget((ASTNode)methodName));
            List<SimpleName> invocationArgs = QuickAssistProcessorUtil.getInvocationArguments(ast, 0, noOfLambdaParameters, lambdaParamNames);
            methodInvocation.arguments().addAll(invocationArgs);
            if (linkedProposalModel != null) {
                for (SimpleName name : invocationArgs) {
                    linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                }
            }
            methodInvocation.typeArguments().addAll(QuickAssistProcessorUtil.getCopiedTypeArguments(rewrite, methodReference.typeArguments()));
        } else if (methodReference instanceof SuperMethodReference) {
            SuperMethodInvocation superMethodInvocation = ast.newSuperMethodInvocation();
            if (createBlockBody) {
                Block blockBody = QuickAssistProcessorUtil.getBlockBodyForLambda((Expression)superMethodInvocation, returnTypeBinding, ast);
                lambda.setBody((ASTNode)blockBody);
            } else {
                lambda.setBody((ASTNode)superMethodInvocation);
            }
            Name superQualifier = ((SuperMethodReference)methodReference).getQualifier();
            if (superQualifier != null) {
                superMethodInvocation.setQualifier((Name)rewrite.createCopyTarget((ASTNode)superQualifier));
            }
            SimpleName methodName = QuickAssistProcessorUtil.getMethodInvocationName(methodReference);
            superMethodInvocation.setName((SimpleName)rewrite.createCopyTarget((ASTNode)methodName));
            List<SimpleName> invocationArgs = QuickAssistProcessorUtil.getInvocationArguments(ast, 0, noOfLambdaParameters, lambdaParamNames);
            superMethodInvocation.arguments().addAll(invocationArgs);
            if (linkedProposalModel != null) {
                for (SimpleName name : invocationArgs) {
                    linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                }
            }
            superMethodInvocation.typeArguments().addAll(QuickAssistProcessorUtil.getCopiedTypeArguments(rewrite, methodReference.typeArguments()));
        } else {
            methodInvocation = ast.newMethodInvocation();
            if (createBlockBody) {
                Block blockBody = QuickAssistProcessorUtil.getBlockBodyForLambda((Expression)methodInvocation, returnTypeBinding, ast);
                lambda.setBody((ASTNode)blockBody);
            } else {
                lambda.setBody((ASTNode)methodInvocation);
            }
            boolean isTypeReference = QuickAssistProcessorUtil.isTypeReferenceToInstanceMethod(methodReference);
            if (isTypeReference) {
                SimpleName name = ast.newSimpleName(lambdaParamNames[0]);
                methodInvocation.setExpression((Expression)name);
                if (linkedProposalModel != null) {
                    linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                }
            } else {
                Expression expr = ((ExpressionMethodReference)methodReference).getExpression();
                if (!(expr instanceof ThisExpression) || methodReference.typeArguments().size() != 0) {
                    methodInvocation.setExpression((Expression)rewrite.createCopyTarget((ASTNode)expr));
                }
            }
            SimpleName methodName = QuickAssistProcessorUtil.getMethodInvocationName(methodReference);
            methodInvocation.setName((SimpleName)rewrite.createCopyTarget((ASTNode)methodName));
            List<SimpleName> invocationArgs = QuickAssistProcessorUtil.getInvocationArguments(ast, isTypeReference ? 1 : 0, noOfLambdaParameters, lambdaParamNames);
            methodInvocation.arguments().addAll(invocationArgs);
            if (linkedProposalModel != null) {
                for (SimpleName name : invocationArgs) {
                    linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                }
            }
            methodInvocation.typeArguments().addAll(QuickAssistProcessorUtil.getCopiedTypeArguments(rewrite, methodReference.typeArguments()));
        }
        rewrite.replace((ASTNode)methodReference, (ASTNode)lambda, null);
        return lambda;
    }

    public static Block getBlockBodyForLambda(Expression bodyExpr, ITypeBinding returnTypeBinding, AST ast) {
        ExpressionStatement statementInBlockBody;
        if (ast.resolveWellKnownType("void").isEqualTo((IBinding)returnTypeBinding)) {
            ExpressionStatement expressionStatement;
            statementInBlockBody = expressionStatement = ast.newExpressionStatement(bodyExpr);
        } else {
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression(bodyExpr);
            statementInBlockBody = returnStatement;
        }
        Block blockBody = ast.newBlock();
        blockBody.statements().add(statementInBlockBody);
        return blockBody;
    }

    public static List<Type> getCopiedTypeArguments(ASTRewrite rewrite, List<Type> typeArguments) {
        ArrayList<Type> copiedTypeArgs = new ArrayList<Type>();
        for (Type typeArg : typeArguments) {
            copiedTypeArgs.add((Type)rewrite.createCopyTarget((ASTNode)typeArg));
        }
        return copiedTypeArgs;
    }

    private static SimpleName getMethodInvocationName(MethodReference methodReference) {
        SimpleName name = null;
        if (methodReference instanceof ExpressionMethodReference) {
            name = ((ExpressionMethodReference)methodReference).getName();
        } else if (methodReference instanceof TypeMethodReference) {
            name = ((TypeMethodReference)methodReference).getName();
        } else if (methodReference instanceof SuperMethodReference) {
            name = ((SuperMethodReference)methodReference).getName();
        }
        return name;
    }

    public static String[] getUniqueParameterNames(MethodReference methodReference, IMethodBinding functionalMethod) throws JavaModelException {
        String[] originalParameterNames = ((IMethod)functionalMethod.getJavaElement()).getParameterNames();
        String[] newNames = new String[originalParameterNames.length];
        HashSet<String> excludedNames = new HashSet<String>(ASTNodes.getVisibleLocalVariablesInScope((ASTNode)methodReference));
        int i = 0;
        while (i < originalParameterNames.length) {
            String paramName = originalParameterNames[i];
            if (excludedNames.contains(paramName)) {
                HashSet<String> allNamesToExclude = new HashSet<String>(excludedNames);
                Collections.addAll(allNamesToExclude, originalParameterNames);
                String newParamName = QuickAssistProcessorUtil.createName(paramName, allNamesToExclude);
                excludedNames.add(newParamName);
                newNames[i] = newParamName;
            } else {
                newNames[i] = paramName;
            }
            ++i;
        }
        return newNames;
    }

    private static String createName(String nameRoot, Set<String> excludedNames) {
        String candidate;
        int i = 1;
        while (excludedNames.remove(candidate = nameRoot + i++)) {
        }
        return candidate;
    }

    private static List<SimpleName> getInvocationArguments(AST ast, int begIndex, int noOfLambdaParameters, String[] lambdaParamNames) {
        ArrayList<SimpleName> args = new ArrayList<SimpleName>();
        int i = begIndex;
        while (i < noOfLambdaParameters) {
            args.add(ast.newSimpleName(lambdaParamNames[i]));
            ++i;
        }
        return args;
    }

    private static boolean hasConflict(int startPosition, IMethodBinding referredMethodBinding, int flags, CompilationUnit cu) {
        ScopeAnalyzer analyzer = new ScopeAnalyzer(cu);
        IBinding[] iBindingArray = analyzer.getDeclarationsInScope(startPosition, flags);
        int n = iBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding decl = iBindingArray[n2];
            if (decl.getName().equals(referredMethodBinding.getName()) && !referredMethodBinding.getMethodDeclaration().isEqualTo(decl)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isTypeReferenceToInstanceMethod(MethodReference methodReference) {
        IBinding nameBinding;
        Expression expression;
        if (methodReference instanceof TypeMethodReference) {
            return true;
        }
        return methodReference instanceof ExpressionMethodReference && (expression = ((ExpressionMethodReference)methodReference).getExpression()) instanceof Name && (nameBinding = ((Name)expression).resolveBinding()) instanceof ITypeBinding;
    }

    public static void changeLambdaBodyToBlock(LambdaExpression lambda, AST ast, ASTRewrite rewrite) {
        Expression bodyExpr = (Expression)rewrite.createMoveTarget(lambda.getBody());
        Block blockBody = QuickAssistProcessorUtil.getBlockBodyForLambda(bodyExpr, lambda.resolveMethodBinding().getReturnType(), ast);
        rewrite.set((ASTNode)lambda, (StructuralPropertyDescriptor)LambdaExpression.BODY_PROPERTY, (Object)blockBody, null);
    }

    public static List<ASTNode> getCoveredAutoClosableNodes(List<ASTNode> astNodes) {
        ArrayList<ASTNode> autoClosableNodes = new ArrayList<ASTNode>();
        for (ASTNode astNode : astNodes) {
            if (QuickAssistProcessorUtil.isAutoClosable(astNode)) {
                autoClosableNodes.add(astNode);
                continue;
            }
            return autoClosableNodes;
        }
        return autoClosableNodes;
    }

    public static int findEndPostion(ASTNode node) {
        int end = node.getStartPosition() + node.getLength();
        Map<SimpleName, IVariableBinding> nodeSimpleNameBindings = QuickAssistProcessorUtil.getVariableStatementBinding(node);
        ArrayList<SimpleName> nodeNames = new ArrayList<SimpleName>(nodeSimpleNameBindings.keySet());
        if (nodeNames.isEmpty()) {
            return -1;
        }
        SimpleName nodeSimpleName = (SimpleName)nodeNames.get(0);
        SimpleName[] coveredNodeBindings = LinkedNodeFinder.findByNode(node.getRoot(), nodeSimpleName);
        if (coveredNodeBindings.length == 0) {
            return -1;
        }
        SimpleName[] simpleNameArray = coveredNodeBindings;
        int n = coveredNodeBindings.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleName astNode = simpleNameArray[n2];
            end = Math.max(end, astNode.getStartPosition() + astNode.getLength());
            ++n2;
        }
        return end;
    }

    public static Map<SimpleName, IVariableBinding> getVariableStatementBinding(ASTNode astNode) {
        final HashMap<SimpleName, IVariableBinding> variableBindings = new HashMap<SimpleName, IVariableBinding>();
        astNode.accept(new ASTVisitor(){

            public boolean visit(VariableDeclarationStatement node) {
                for (Object o : node.fragments()) {
                    VariableDeclarationFragment vdf;
                    SimpleName name;
                    IBinding binding;
                    if (!(o instanceof VariableDeclarationFragment) || !((binding = (name = (vdf = (VariableDeclarationFragment)o).getName()).resolveBinding()) instanceof IVariableBinding)) continue;
                    variableBindings.put(name, (IVariableBinding)binding);
                    break;
                }
                return false;
            }
        });
        return variableBindings;
    }

    public static boolean isAutoClosable(ITypeBinding typeBinding) {
        return Bindings.findTypeInHierarchy(typeBinding, "java.lang.AutoCloseable") != null;
    }

    public static boolean isAutoClosable(ASTNode astNode) {
        Map<SimpleName, IVariableBinding> simpleNames = QuickAssistProcessorUtil.getVariableStatementBinding(astNode);
        block3: for (Map.Entry<SimpleName, IVariableBinding> entry : simpleNames.entrySet()) {
            ITypeBinding typeBinding = null;
            switch (entry.getKey().getParent().getNodeType()) {
                case 7: 
                case 59: 
                case 60: {
                    typeBinding = entry.getValue().getType();
                    break;
                }
                default: {
                    continue block3;
                }
            }
            if (typeBinding == null || !QuickAssistProcessorUtil.isAutoClosable(typeBinding)) continue;
            return true;
        }
        return false;
    }

    public static int getIndex(int offset, List<Statement> statements) {
        int i = 0;
        while (i < statements.size()) {
            Statement s = statements.get(i);
            if (offset <= s.getStartPosition()) {
                return i;
            }
            if (offset < s.getStartPosition() + s.getLength()) {
                return -1;
            }
            ++i;
        }
        return statements.size();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public static boolean isDeprecatedMethodCallWithReplacement(ASTNode node) {
        IAnnotationBinding[] annotations;
        if (!(node instanceof MethodInvocation) && !((node = node.getParent()) instanceof MethodInvocation)) {
            return false;
        }
        MethodInvocation methodInvocation = (MethodInvocation)node;
        IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
        if (methodBinding == null) {
            return false;
        }
        IMethod method = (IMethod)methodBinding.getJavaElement();
        if (method == null) {
            return false;
        }
        IAnnotationBinding[] iAnnotationBindingArray = annotations = methodBinding.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotationBinding annotation = iAnnotationBindingArray[n2];
            if (annotation.getAnnotationType().getQualifiedName().equals("java.lang.Deprecated")) {
                CompilationUnit sourceCu = (CompilationUnit)node.getRoot();
                CompilationUnit cu = QuickAssistProcessorUtil.findCUForMethod(sourceCu, (ICompilationUnit)sourceCu.getJavaElement(), methodBinding);
                if (cu == null) {
                    return false;
                }
                try {
                    MethodDeclaration methodDeclaration = ASTNodeSearchUtil.getMethodDeclarationNode(method, cu);
                    Javadoc javadoc = methodDeclaration.getJavadoc();
                    if (javadoc == null) {
                        return false;
                    }
                    List tags = javadoc.tags();
                    for (TagElement tag : tags) {
                        MethodRef methodRef;
                        IMethodBinding refBinding;
                        IDocElement linkFragment;
                        List linkFragments;
                        TagElement tagElement;
                        IDocElement iDocElement;
                        TextElement textElement;
                        String text;
                        if (!"@deprecated".equals(tag.getTagName())) continue;
                        List fragments = tag.fragments();
                        if (fragments.size() < 2) {
                            return false;
                        }
                        IDocElement iDocElement2 = (IDocElement)fragments.get(0);
                        if (!(iDocElement2 instanceof TextElement) || !(text = (textElement = (TextElement)iDocElement2).getText().toLowerCase().trim()).endsWith("use") && !text.endsWith("replace by") || !((iDocElement = (IDocElement)fragments.get(1)) instanceof TagElement) || !"@link".equals((tagElement = (TagElement)iDocElement).getTagName()) || (linkFragments = tagElement.fragments()).size() != 1 || !((linkFragment = (IDocElement)linkFragments.get(0)) instanceof MethodRef) || (refBinding = (IMethodBinding)(methodRef = (MethodRef)linkFragment).resolveBinding()) == null) continue;
                        class FindNewMethodVisitor
                        extends ASTVisitor {
                            private boolean useMethodIsUsed = false;
                            private boolean referencesPrivate = false;
                            private boolean referencesProtected = false;
                            private boolean referencesPackagePrivate = false;
                            private final /* synthetic */ IMethodBinding val$refBinding;

                            FindNewMethodVisitor(IMethodBinding iMethodBinding) {
                                this.val$refBinding = iMethodBinding;
                            }

                            public boolean visit(MethodInvocation invocation) {
                                IMethodBinding binding = invocation.resolveMethodBinding();
                                if (binding != null) {
                                    if (binding.isEqualTo((IBinding)this.val$refBinding)) {
                                        this.useMethodIsUsed = true;
                                    } else {
                                        int modifiers = binding.getModifiers();
                                        if (Modifier.isPrivate((int)modifiers)) {
                                            this.referencesPrivate = true;
                                        } else if (Modifier.isProtected((int)modifiers)) {
                                            this.referencesProtected = true;
                                        } else if (!Modifier.isPublic((int)modifiers)) {
                                            this.referencesPackagePrivate = true;
                                        }
                                    }
                                }
                                return true;
                            }

                            public boolean visit(SimpleName name) {
                                IVariableBinding varBinding;
                                IBinding binding = name.resolveBinding();
                                if (binding instanceof IVariableBinding && (varBinding = (IVariableBinding)binding).isField()) {
                                    int modifiers = varBinding.getModifiers();
                                    if (Modifier.isPrivate((int)modifiers)) {
                                        this.referencesPrivate = true;
                                    } else if (Modifier.isProtected((int)modifiers)) {
                                        this.referencesProtected = true;
                                    } else if (!Modifier.isPublic((int)modifiers)) {
                                        this.referencesPackagePrivate = true;
                                    }
                                }
                                if (binding instanceof ITypeBinding) {
                                    ITypeBinding typeBinding = (ITypeBinding)binding;
                                    int modifiers = typeBinding.getModifiers();
                                    if (Modifier.isPrivate((int)modifiers)) {
                                        this.referencesPrivate = true;
                                    } else if (Modifier.isProtected((int)modifiers)) {
                                        this.referencesProtected = true;
                                    } else if (!Modifier.isPublic((int)modifiers)) {
                                        this.referencesPackagePrivate = true;
                                    }
                                }
                                return true;
                            }

                            public boolean isUseMethodUsed() {
                                return this.useMethodIsUsed;
                            }

                            public boolean referencesPrivate() {
                                return this.referencesPrivate;
                            }

                            public boolean referencesProtected() {
                                return this.referencesProtected;
                            }

                            public boolean referencesPackagePrivate() {
                                return this.referencesPackagePrivate;
                            }
                        }
                        FindNewMethodVisitor findNewMethodVisitor = new FindNewMethodVisitor(refBinding);
                        methodDeclaration.accept((ASTVisitor)findNewMethodVisitor);
                        if (!findNewMethodVisitor.isUseMethodUsed()) {
                            return false;
                        }
                        CompilationUnit cu1 = (CompilationUnit)methodInvocation.getRoot();
                        CompilationUnit cu2 = (CompilationUnit)methodDeclaration.getRoot();
                        TypeDeclaration typeDecl2 = ASTNodes.getFirstAncestorOrNull((ASTNode)methodDeclaration, TypeDeclaration.class);
                        if (typeDecl2 == null) {
                            return false;
                        }
                        int methodDeclarationTypeModifiers = typeDecl2.getModifiers();
                        ITypeBinding typeDeclBinding2 = typeDecl2.resolveBinding();
                        if (findNewMethodVisitor.referencesPrivate() || Modifier.isPrivate((int)methodDeclarationTypeModifiers)) {
                            if (methodInvocation.getRoot() == methodDeclaration.getRoot()) return true;
                            return false;
                        }
                        if (!(findNewMethodVisitor.referencesProtected() || Modifier.isProtected((int)methodDeclarationTypeModifiers) || findNewMethodVisitor.referencesPackagePrivate())) {
                            if (Modifier.isPublic((int)methodDeclarationTypeModifiers)) return true;
                        }
                        String pkgName1 = cu1.getPackage().getName().getFullyQualifiedName();
                        String pkgName2 = cu2.getPackage().getName().getFullyQualifiedName();
                        if (pkgName1 == null) return false;
                        if (pkgName2 == null) {
                            return false;
                        }
                        if (pkgName1.equals(pkgName2)) {
                            return true;
                        }
                        if (findNewMethodVisitor.referencesPackagePrivate()) return false;
                        if (!Modifier.isProtected((int)methodDeclarationTypeModifiers)) {
                            return false;
                        }
                        TypeDeclaration typeDecl1 = ASTNodes.getFirstAncestorOrNull((ASTNode)methodInvocation, TypeDeclaration.class);
                        if (typeDecl1 == null) {
                            return false;
                        }
                        ITypeBinding typeDeclBinding1 = typeDecl1.resolveBinding();
                        if (typeDeclBinding1 == null) return false;
                        if (typeDeclBinding2 == null) {
                            return false;
                        }
                        while (typeDeclBinding1 != null) {
                            if (typeDeclBinding1.isEqualTo((IBinding)typeDeclBinding2)) {
                                return true;
                            }
                            typeDeclBinding1 = typeDeclBinding1.getSuperclass();
                        }
                        return false;
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return false;
    }

    public static CompilationUnit findCUForMethod(CompilationUnit compilationUnit, ICompilationUnit cu, IMethodBinding methodBinding) {
        ASTNode methodDecl = compilationUnit.findDeclaringNode((IBinding)methodBinding.getMethodDeclaration());
        if (methodDecl == null) {
            ITypeBinding declaringTypeDecl = methodBinding.getDeclaringClass().getTypeDeclaration();
            if (declaringTypeDecl.isFromSource()) {
                ICompilationUnit targetCU = null;
                try {
                    targetCU = ASTResolving.findCompilationUnitForBinding(cu, compilationUnit, declaringTypeDecl);
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
                if (targetCU != null) {
                    return ASTResolving.createQuickFixAST(targetCU, null);
                }
            }
            return null;
        }
        return compilationUnit;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getDeprecatedFieldReplacement(ASTNode node) {
        IVariableBinding varBinding;
        IBinding binding = null;
        ASTNode aSTNode = node;
        Objects.requireNonNull(aSTNode);
        ASTNode aSTNode2 = aSTNode;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{QualifiedName.class, SimpleName.class, FieldAccess.class, SuperFieldAccess.class}, (Object)aSTNode2, 0)) {
            case 0: {
                QualifiedName q = (QualifiedName)aSTNode2;
                binding = q.resolveBinding();
                break;
            }
            case 1: {
                SimpleName s = (SimpleName)aSTNode2;
                if (s.getLocationInParent() == QualifiedName.NAME_PROPERTY) {
                    node = s.getParent();
                    binding = ((QualifiedName)node).resolveBinding();
                    break;
                }
                binding = s.resolveBinding();
                break;
            }
            case 2: {
                FieldAccess f = (FieldAccess)aSTNode2;
                binding = f.resolveFieldBinding();
                break;
            }
            case 3: {
                SuperFieldAccess sf = (SuperFieldAccess)aSTNode2;
                binding = sf.resolveFieldBinding();
                break;
            }
            default: {
                return null;
            }
        }
        if (binding instanceof IVariableBinding && (varBinding = (IVariableBinding)binding).isField()) {
            IAnnotationBinding[] annotations;
            IField field = (IField)varBinding.getJavaElement();
            if (field == null) {
                return null;
            }
            IAnnotationBinding[] iAnnotationBindingArray = annotations = varBinding.getAnnotations();
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotationBinding annotation = iAnnotationBindingArray[n2];
                if (annotation.getAnnotationType().getQualifiedName().equals("java.lang.Deprecated")) {
                    CompilationUnit sourceCu = (CompilationUnit)node.getRoot();
                    CompilationUnit cu = QuickAssistProcessorUtil.findCUForField(sourceCu, (ICompilationUnit)sourceCu.getJavaElement(), varBinding);
                    if (cu == null) {
                        return null;
                    }
                    try {
                        FieldDeclaration fieldDeclaration = ASTNodeSearchUtil.getFieldDeclarationNode(field, cu);
                        Javadoc javadoc = fieldDeclaration.getJavadoc();
                        if (javadoc == null) {
                            return null;
                        }
                        List tags = javadoc.tags();
                        for (TagElement tag : tags) {
                            IVariableBinding replaceBinding;
                            MemberRef methodRef;
                            IBinding refBinding;
                            IDocElement linkFragment;
                            List linkFragments;
                            TagElement tagElement;
                            IDocElement iDocElement;
                            TextElement textElement;
                            String text;
                            if (!"@deprecated".equals(tag.getTagName())) continue;
                            List fragments = tag.fragments();
                            if (fragments.size() < 2) {
                                return null;
                            }
                            IDocElement iDocElement2 = (IDocElement)fragments.get(0);
                            if (!(iDocElement2 instanceof TextElement) || !(text = (textElement = (TextElement)iDocElement2).getText().toLowerCase().trim()).endsWith("use") && !text.endsWith("replace by") || !((iDocElement = (IDocElement)fragments.get(1)) instanceof TagElement) || !"@link".equals((tagElement = (TagElement)iDocElement).getTagName()) || (linkFragments = tagElement.fragments()).size() != 1 || !((linkFragment = (IDocElement)linkFragments.get(0)) instanceof MemberRef) || !((refBinding = (methodRef = (MemberRef)linkFragment).resolveBinding()) instanceof IVariableBinding) || !(replaceBinding = (IVariableBinding)refBinding).isField()) continue;
                            return replaceBinding.getDeclaringClass().getQualifiedName() + "." + replaceBinding.getName();
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    public static CompilationUnit findCUForField(CompilationUnit compilationUnit, ICompilationUnit cu, IVariableBinding fieldBinding) {
        ASTNode fieldDecl = compilationUnit.findDeclaringNode((IBinding)fieldBinding.getVariableDeclaration());
        if (fieldDecl == null) {
            ITypeBinding declaringTypeDecl = fieldBinding.getDeclaringClass().getTypeDeclaration();
            if (declaringTypeDecl.isFromSource()) {
                ICompilationUnit targetCU = null;
                try {
                    targetCU = ASTResolving.findCompilationUnitForBinding(cu, compilationUnit, declaringTypeDecl);
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
                if (targetCU != null) {
                    return ASTResolving.createQuickFixAST(targetCU, null);
                }
            }
            return null;
        }
        return compilationUnit;
    }

    public static ASTNode getCopyOfInner(ASTRewrite rewrite, ASTNode statement, boolean toControlStatementBody) {
        if (statement.getNodeType() == 8) {
            Block block = (Block)statement;
            List innerStatements = block.statements();
            int nStatements = innerStatements.size();
            if (nStatements == 1) {
                return rewrite.createCopyTarget((ASTNode)innerStatements.get(0));
            }
            if (nStatements > 1) {
                if (toControlStatementBody) {
                    return rewrite.createCopyTarget((ASTNode)block);
                }
                ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY);
                ASTNode first = (ASTNode)innerStatements.get(0);
                ASTNode last = (ASTNode)innerStatements.get(nStatements - 1);
                return listRewrite.createCopyTarget(first, last);
            }
            return null;
        }
        return rewrite.createCopyTarget(statement);
    }

    public static boolean getCreateInSuperClassProposals(IInvocationContext context, ASTNode node, Collection<Object> resultingCollections) throws CoreException {
        if (!(node instanceof SimpleName) || !(node.getParent() instanceof MethodDeclaration)) {
            return false;
        }
        MethodDeclaration decl = (MethodDeclaration)node.getParent();
        if (decl.getName() != node || decl.resolveBinding() == null || Modifier.isPrivate((int)decl.getModifiers())) {
            return false;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        IMethodBinding binding = decl.resolveBinding();
        ITypeBinding[] paramTypes = binding.getParameterTypes();
        ITypeBinding[] superTypes = Bindings.getAllSuperTypes(binding.getDeclaringClass());
        if (resultingCollections == null) {
            ITypeBinding[] iTypeBindingArray = superTypes;
            int n = superTypes.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding curr = iTypeBindingArray[n2];
                if (curr.isFromSource() && Bindings.findOverriddenMethodInType(curr, binding) == null) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        List params = decl.parameters();
        String[] paramNames = new String[paramTypes.length];
        int i = 0;
        while (i < params.size()) {
            SingleVariableDeclaration param = (SingleVariableDeclaration)params.get(i);
            paramNames[i] = param.getName().getIdentifier();
            ++i;
        }
        ITypeBinding[] iTypeBindingArray = superTypes;
        int n = superTypes.length;
        int n3 = 0;
        while (n3 < n) {
            ITypeBinding typeDecl;
            ICompilationUnit targetCU;
            IMethodBinding method;
            ITypeBinding curr = iTypeBindingArray[n3];
            if (curr.isFromSource() && (method = Bindings.findOverriddenMethodInType(curr, binding)) == null && (targetCU = ASTResolving.findCompilationUnitForBinding(cu, astRoot, typeDecl = curr.getTypeDeclaration())) != null) {
                String label = Messages.format(CorrectionMessages.QuickAssistProcessor_createmethodinsuper_description, new String[]{BasicElementLabels.getJavaElementName(curr.getName()), BasicElementLabels.getJavaElementName(binding.getName())});
                resultingCollections.add(new NewDefiningMethodProposalCore(label, targetCU, (ASTNode)astRoot, typeDecl, binding, paramNames, 6));
            }
            ++n3;
        }
        return true;
    }

    public static class UnqualifiedReferencesFinder
    extends ASTVisitor {
        private final String fName;
        private final IBuffer fBuffer;
        private final IBinding fBinding;

        public UnqualifiedReferencesFinder(String name, ICompilationUnit icu, IBinding binding) throws JavaModelException {
            this.fName = name;
            this.fBuffer = icu.getBuffer();
            this.fBinding = binding;
        }

        public boolean visit(SimpleName node) {
            IBinding binding;
            if (node.getFullyQualifiedName().equals(this.fName) && node.getStartPosition() > 0 && this.fBuffer.getChar(node.getStartPosition() - 1) != '.' && (binding = node.resolveBinding()) != null && binding.getKind() == this.fBinding.getKind() && !binding.isEqualTo(this.fBinding)) {
                throw new AbortSearchException();
            }
            return false;
        }
    }
}

