/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.generic;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.common.base.LiteralType;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.InstanceBase;
import org.eclipse.etrice.core.genmodel.etricegen.InterfaceItemInstance;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.IDataConfiguration;
import org.eclipse.etrice.generator.generic.ILanguageExtension;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class TypeHelpers {
    @Inject
    @Extension
    protected RoomHelpers _roomHelpers;
    @Inject
    private ILanguageExtension languageExt;
    @Inject
    private IDataConfiguration dataConfigExt;

    public String typeName(DataType type) {
        return this.languageExt.getDataTypeName(type);
    }

    public String getTypeName(RefableType t) {
        return this.typeName(t.getType());
    }

    public String getTypeName(Message m) {
        return this.getTypeName(m.getData().getRefType());
    }

    public String getTypeName(Attribute att) {
        return this.getTypeName(att.getType());
    }

    public String getPrimitiveTypeName(RefableType t) {
        return t.getType().getName();
    }

    public String getPrimitiveTypeName(Message m) {
        return this.getPrimitiveTypeName(m.getData().getRefType());
    }

    public String getPrimitiveTypeName(Attribute att) {
        return this.getPrimitiveTypeName(att.getType());
    }

    public String defaultValue(VarDecl a) {
        return this.languageExt.defaultValue(a.getRefType().getType());
    }

    public String getArgumentList(VarDecl data) {
        return this.languageExt.generateArglistAndTypedData((EObject)data)[0];
    }

    public String getTypedDataDefinition(VarDecl data) {
        return this.languageExt.generateArglistAndTypedData((EObject)data)[1];
    }

    public String generateTypedArgumentList(VarDecl data) {
        return this.languageExt.generateArglistAndTypedData((EObject)data)[2];
    }

    public boolean isPrimitive(DataType type) {
        return type instanceof PrimitiveType;
    }

    public boolean isBoolean(DataType type) {
        return this.isPrimitive(type) && Objects.equals(((PrimitiveType)type).getType(), LiteralType.BOOL);
    }

    public boolean isEnumeration(DataType type) {
        return type instanceof EnumerationType;
    }

    public boolean isEnumerationOrPrimitive(DataType type) {
        return type instanceof EnumerationType || type instanceof PrimitiveType;
    }

    public boolean isDataClass(DataType type) {
        return type instanceof DataClass;
    }

    public boolean isCharacterType(PrimitiveType type) {
        LiteralType literalType = type.getType();
        return Objects.equals(literalType, LiteralType.CHAR);
    }

    public boolean isCharacterType(DataType type) {
        return this.isPrimitive(type) && this.isCharacterType((PrimitiveType)type);
    }

    public String getAttrInstanceConfigValue(List<Attribute> attributePath, InstanceBase instance) {
        String string = null;
        boolean bl = false;
        if (instance instanceof ActorInstance) {
            bl = true;
            string = this.dataConfigExt.getAttrInstanceConfigValue((ActorInstance)instance, attributePath);
        }
        if (!bl && instance instanceof InterfaceItemInstance) {
            bl = true;
            string = this.dataConfigExt.getAttrInstanceConfigValue((InterfaceItemInstance)instance, attributePath);
        }
        return string;
    }

    public String getAttrClassConfigValue(List<Attribute> attributePath, ActorClass actor, boolean inherite) {
        String result = this.dataConfigExt.getAttrClassConfigValue(actor, attributePath);
        if (result == null && inherite) {
            ActorClass base = actor.getActorBase();
            while (base != null && result == null) {
                result = this.dataConfigExt.getAttrClassConfigValue(base, attributePath);
                base = base.getActorBase();
            }
        }
        return result;
    }

    public String getAttrClassConfigValue(List<Attribute> attributePath, PortClass port) {
        ProtocolClass pc = this._roomHelpers.getProtocolClass((EObject)port);
        if (pc == null) {
            return null;
        }
        return this.dataConfigExt.getAttrClassConfigValue(pc, port.equals(pc.getRegular()), attributePath);
    }
}

