/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.ui.modelpath;

import com.google.inject.Inject;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.etrice.core.common.ui.modelpath.ModelPathManager;
import org.eclipse.xtext.builder.impl.BuildScheduler;
import org.eclipse.xtext.builder.impl.IBuildFlag;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.CoarseGrainedChangeEvent;
import org.eclipse.xtext.ui.editor.IDirtyStateManager;
import org.eclipse.xtext.ui.shared.contribution.IEagerContribution;

public class ModelPathChangeListener
implements IEagerContribution,
ModelPathManager.IModelPathListener {
    private BuildScheduler buildScheduler;
    private IDirtyStateManager dirtyStateManager;

    @Inject
    public ModelPathChangeListener(BuildScheduler buildScheduler, IDirtyStateManager dirtyStateManager) {
        this.buildScheduler = buildScheduler;
        this.dirtyStateManager = dirtyStateManager;
    }

    @Override
    public void onChange(Collection<IProject> projects) {
        this.dirtyStateManager.notifyListeners((IResourceDescription.Event)new CoarseGrainedChangeEvent());
        if (ResourcesPlugin.getWorkspace().isAutoBuilding()) {
            this.buildScheduler.scheduleBuildIfNecessary(projects, new IBuildFlag[]{IBuildFlag.FORGET_BUILD_STATE_ONLY});
        }
    }

    public void initialize() {
        ModelPathManager.INSTANCE.addListener(this);
        ModelPathManager.INSTANCE.startListening();
    }

    public void discard() {
        ModelPathManager.INSTANCE.stopListening();
        ModelPathManager.INSTANCE.removeListener(this);
    }
}

