/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class Sets {
    private Sets() {
    }

    public static <T> Set<T> add(Set<T> set, T elem) {
        set.add(elem);
        return set;
    }

    public static <TI, TR extends TI> Set<TR> filter(Set<TI> set, Class<TR> rsltType) {
        Set rslt = Sets.set();
        for (TI elem : set) {
            if (!rsltType.isInstance(elem)) continue;
            rslt.add(elem);
        }
        return rslt;
    }

    public static <TR, T1 extends TR, T2 extends TR> Set<TR> union(Set<T1> set1, Set<T2> set2) {
        Set rslt = Sets.set();
        rslt.addAll(set1);
        rslt.addAll(set2);
        return rslt;
    }

    @SafeVarargs
    public static <TR, TI extends TR> Set<TR> union(Set<? extends TI> ... sets) {
        Set rslt = Sets.set();
        Set<? extends TI>[] setArray = sets;
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            Set<? extends TI> set = setArray[n2];
            rslt.addAll(set);
            ++n2;
        }
        return rslt;
    }

    public static <T> boolean isEmptyIntersection(Set<? extends T> set1, Set<? extends T> set2) {
        if (set1.isEmpty() || set2.isEmpty()) {
            return true;
        }
        if (set1.size() < set2.size()) {
            for (T s : set1) {
                if (!set2.contains(s)) continue;
                return false;
            }
        } else {
            for (T s : set2) {
                if (!set1.contains(s)) continue;
                return false;
            }
        }
        return true;
    }

    public static <TR, T1 extends TR, T2 extends TR> Set<TR> intersection(Set<T1> set1, Set<T2> set2) {
        Set<TR> rslt = Sets.copy(set1);
        rslt.retainAll(set2);
        return rslt;
    }

    @SafeVarargs
    public static <TR, TI extends TR> Set<TR> intersection(Set<? extends TI> set, Set<? extends TI> ... sets) {
        Set<TR> rslt = Sets.copy(set);
        Set<? extends TI>[] setArray = sets;
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            Set<? extends TI> s = setArray[n2];
            rslt.retainAll(s);
            ++n2;
        }
        return rslt;
    }

    public static <TR, T1 extends TR, T2 extends TR> Set<TR> difference(Collection<T1> first, Collection<T2> second) {
        LinkedHashSet<T1> rslt = new LinkedHashSet<T1>(first);
        rslt.removeAll(second);
        return rslt;
    }

    @SafeVarargs
    public static <TR, TI extends TR> Set<TR> difference(Collection<? extends TI> first, Collection<? extends TI> ... others) {
        LinkedHashSet<TI> rslt = new LinkedHashSet<TI>(first);
        Collection<? extends TI>[] collectionArray = others;
        int n = others.length;
        int n2 = 0;
        while (n2 < n) {
            Collection<? extends TI> s = collectionArray[n2];
            rslt.removeAll(s);
            ++n2;
        }
        return rslt;
    }

    public static <TR, TI extends TR> Set<TR> copy(Set<TI> s) {
        return new LinkedHashSet<TI>(s);
    }

    public static <TR, TI extends TR> Set<TR> cast(Set<TI> lst) {
        return lst;
    }

    public static String toString(Set<?> s) {
        List l = Lists.listc(s.size());
        for (Object o : s) {
            l.add(o.toString());
        }
        Collections.sort(l, Strings.SORTER);
        return Strings.fmt("{%s}", String.join((CharSequence)", ", l));
    }

    @SafeVarargs
    public static <TR, TI extends TR> Set<TR> set(TI ... elems) {
        Set rslt = Sets.setc(elems.length);
        TI[] TIArray = elems;
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            TI elem = TIArray[n2];
            rslt.add(elem);
            ++n2;
        }
        return rslt;
    }

    public static <TR, TI extends TR> Set<TR> set(TI elem) {
        Set rslt = Sets.setc(1);
        rslt.add(elem);
        return rslt;
    }

    public static <T> Set<T> set() {
        return new LinkedHashSet();
    }

    public static <T> Set<T> setc(int initialCapacity) {
        return new LinkedHashSet(initialCapacity);
    }

    public static <TS, TL extends TS> Set<TS> list2set(List<TL> list) {
        return new LinkedHashSet<TL>(list);
    }

    public static <TL extends Comparable<? super TL>, TS extends TL> List<TL> sortedgeneric(Set<TS> set) {
        List lst = Lists.set2list(set);
        Collections.sort(lst);
        return lst;
    }

    public static <TL, TS extends TL> List<TL> sortedgeneric(Set<TS> set, Comparator<? super TL> cmp) {
        List lst = Lists.set2list(set);
        Collections.sort(lst, cmp);
        return lst;
    }

    public static List<String> sortedstrings(Set<String> set) {
        return Sets.sortedgeneric(set, Strings.SORTER);
    }

    public static <T> Collector<T, Set<T>, Set<T>> toSet() {
        return new Collector<T, Set<T>, Set<T>>(){

            @Override
            public Supplier<Set<T>> supplier() {
                return () -> Sets.set();
            }

            @Override
            public BiConsumer<Set<T>, T> accumulator() {
                return (collection, val) -> {
                    boolean bl = collection.add(val);
                };
            }

            @Override
            public BinaryOperator<Set<T>> combiner() {
                return (firstSet, secondSet) -> {
                    if (firstSet.size() > secondSet.size()) {
                        firstSet.addAll(secondSet);
                        return firstSet;
                    }
                    secondSet.addAll(firstSet);
                    return secondSet;
                };
            }

            @Override
            public Function<Set<T>, Set<T>> finisher() {
                return result -> result;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return EnumSet.of(Collector.Characteristics.IDENTITY_FINISH);
            }
        };
    }
}

