/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.generators;

import java.util.List;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class TextTopics {
    private final List<String> lines = Lists.list();
    private final String emptyLine;

    public TextTopics() {
        this("");
    }

    public TextTopics(String emptyLine) {
        this.emptyLine = emptyLine.stripTrailing();
    }

    public void add(String line) {
        if (!(line = line.stripTrailing()).equals(this.emptyLine) || !this.isLastEmpty()) {
            this.lines.add(line);
        }
    }

    public void addAll(List<String> lines) {
        for (String line : lines) {
            this.add(line);
        }
    }

    public void add(String pattern, Object ... args) {
        this.add(Strings.fmt((String)pattern, (Object[])args));
    }

    public void appendEmpty() {
        if (!this.isLastEmpty()) {
            this.lines.add(this.emptyLine);
        }
    }

    public void ensureEmptyAtEnd() {
        this.appendEmpty();
    }

    public void dropEmptyAtEnd() {
        if (!this.lines.isEmpty() && ((String)Lists.last(this.lines)).equals(this.emptyLine)) {
            int lastLineIndex = this.lines.size() - 1;
            this.lines.remove(lastLineIndex);
        }
    }

    public List<String> getLines() {
        return this.lines;
    }

    public boolean isLastEmpty() {
        return this.lines.isEmpty() || ((String)Lists.last(this.lines)).equals(this.emptyLine);
    }

    public int size() {
        return this.lines.size();
    }
}

