/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.egit.ui.internal.repository.tree.WorkingDirNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.ui.navigator.CommonViewer;

public class CollapseWorkingTreeCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode<?>> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List nodes = this.getSelectedNodes();
        Set nodesToCollapse = nodes.stream().map(this::getWorkingDirParent).filter(Objects::nonNull).collect(Collectors.toSet());
        if (!nodesToCollapse.isEmpty()) {
            CommonViewer viewer = this.getView(event).getCommonViewer();
            for (WorkingDirNode node : nodesToCollapse) {
                viewer.collapseToLevel((Object)node, -1);
            }
        }
        return null;
    }

    private WorkingDirNode getWorkingDirParent(RepositoryTreeNode<?> node) {
        RepositoryTreeNode candidate = node;
        while (candidate != null && candidate.getType() != RepositoryTreeNodeType.WORKINGDIR) {
            candidate = candidate.getParent();
        }
        return (WorkingDirNode)candidate;
    }
}

