/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.event;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.MethodExpression;
import jakarta.faces.component.StateHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class MethodExprActionListener
implements ActionListener,
StateHolder {
    private static final Logger LOGGER = Logger.getLogger("jakarta.faces.event", "jakarta.faces.LogStrings");
    private MethodExpression methodExpression = null;
    private boolean isTransient;

    public MethodExprActionListener() {
    }

    public MethodExprActionListener(MethodExpression newMethodExpression) {
        this.methodExpression = newMethodExpression;
    }

    public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
        if (actionEvent == null) {
            throw new NullPointerException();
        }
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            ELContext elContext = context.getELContext();
            this.methodExpression.invoke(elContext, new Object[]{actionEvent});
        }
        catch (ELException ee) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "severe.event.exception_invoking_processaction", new Object[]{ee.getCause().getClass().getName(), this.methodExpression.getExpressionString(), actionEvent.getComponent().getId()});
                LOGGER.log(Level.SEVERE, null, ee);
            }
            throw new AbortProcessingException(ee.getMessage(), ee.getCause());
        }
    }

    public Object saveState(FacesContext context) {
        return new Object[]{this.methodExpression};
    }

    public void restoreState(FacesContext context, Object state) {
        this.methodExpression = (MethodExpression)((Object[])state)[0];
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean newTransientValue) {
        this.isTransient = newTransientValue;
    }

    public MethodExpression getMethodExpression() {
        return this.methodExpression;
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof MethodExprActionListener)) {
            return false;
        }
        MethodExprActionListener other = (MethodExprActionListener)otherObject;
        MethodExpression otherMe = other.getMethodExpression();
        return this.methodExpression.equals((Object)otherMe);
    }

    public int hashCode() {
        int hash = 7;
        hash = 11 * hash;
        if (this.methodExpression != null) {
            hash += this.methodExpression.hashCode();
        }
        hash = 11 * hash;
        if (this.isTransient) {
            ++hash;
        }
        return hash;
    }
}

