/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient.protocol.ssl;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.MQAddress;
import com.sun.messaging.jmq.jmsclient.PortMapperClient;
import com.sun.messaging.jmq.jmsclient.protocol.SocketConnectionHandler;
import com.sun.messaging.jmq.jmsclient.protocol.ssl.SSLUtil;
import jakarta.jms.JMSException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.SSLSocket;

public class SSLConnectionHandler
extends SocketConnectionHandler {
    private static boolean isRegistered = false;
    private SSLSocket sslSocket = null;
    private String host = null;
    private int baseport = 0;
    private int directport = 0;
    private int port = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SSLConnectionHandler(Object conn) throws JMSException {
        ConnectionImpl connection = (ConnectionImpl)conn;
        this.directport = 0;
        try {
            this.doRegister(connection);
            this.host = connection.getProperty("imqBrokerHostName");
            this.baseport = Integer.parseInt(connection.getProperty("imqBrokerHostPort"));
            this.directport = Integer.parseInt(connection.getProperty("imqBrokerServicePort"));
            String namedservice = connection.getProperty("imqBrokerServiceName");
            boolean isHostTrusted = Boolean.parseBoolean(connection.getProperty("imqSSLIsHostTrusted"));
            if (this.directport == 0) {
                PortMapperClient pmc = new PortMapperClient(connection);
                this.port = namedservice != null && !"".equals(namedservice) ? pmc.getPortForService("tls", namedservice) : pmc.getPortForProtocol("tls");
            } else {
                this.port = this.directport;
            }
            ConnectionImpl.checkHostPort(this.host, this.port);
            this.sslSocket = SSLUtil.makeSSLSocket(this.host, this.port, isHostTrusted, connection.getProperty("imqKeyStore", null), connection.getProperty("imqKeyStorePassword", null), connection.getConnectionLogger(), AdministeredObject.cr);
        }
        catch (JMSException jmse) {
            throw jmse;
        }
        catch (Exception e) {
            ExceptionHandler.handleConnectException(e, this.host, this.port);
        }
        finally {
            connection.setLastContactedBrokerAddress(this.getBrokerAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SSLConnectionHandler(MQAddress addr, ConnectionImpl conn) throws JMSException {
        ConnectionImpl connection = conn;
        try {
            this.doRegister(connection);
            this.host = addr.getHostName();
            this.directport = 0;
            if (addr.isServicePortFinal()) {
                this.directport = addr.getPort();
            }
            String namedservice = addr.getServiceName();
            boolean isHostTrusted = true;
            isHostTrusted = addr.getIsSSLHostTrustedSet() ? Boolean.parseBoolean(addr.getProperty("isHostTrusted")) : Boolean.parseBoolean(connection.getProperty("imqSSLIsHostTrusted"));
            if (this.directport == 0) {
                PortMapperClient pmc = new PortMapperClient(addr, connection);
                this.baseport = pmc.getHostPort();
                this.port = namedservice != null && !"".equals(namedservice) ? pmc.getPortForService("tls", namedservice) : pmc.getPortForProtocol("tls");
            } else {
                this.port = this.directport;
            }
            ConnectionImpl.checkHostPort(this.host, this.port);
            this.sslSocket = SSLUtil.makeSSLSocket(this.host, this.port, isHostTrusted, connection.getProperty("imqKeyStore", null), connection.getProperty("imqKeyStorePassword", null), connection.getConnectionLogger(), AdministeredObject.cr);
        }
        catch (JMSException jmse) {
            throw jmse;
        }
        catch (Exception e) {
            ExceptionHandler.handleConnectException(e, this.host, this.port);
        }
        finally {
            connection.setLastContactedBrokerAddress(this.getBrokerAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRegister(ConnectionImpl connection) throws Exception {
        if (Boolean.getBoolean("imq.registerSSLProvider") && !isRegistered) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                String name = connection.getProperty("imqSSLProviderClassname");
                Provider provider = (Provider)Class.forName(name).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Security.addProvider(provider);
                isRegistered = true;
            }
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.sslSocket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.sslSocket.getOutputStream();
    }

    @Override
    public int getLocalPort() throws IOException {
        return this.sslSocket.getLocalPort();
    }

    @Override
    protected void closeSocket() throws IOException {
        this.sslSocket.close();
    }

    @Override
    public String getBrokerHostName() {
        return this.host;
    }

    public int getBrokerPort() {
        return this.port;
    }

    @Override
    public String getBrokerAddress() {
        if (this.directport == 0) {
            return this.host + ":" + this.baseport + "(" + this.port + ")";
        }
        return this.host + ":" + this.directport;
    }
}

