/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming.impl;

import com.sun.enterprise.naming.util.LogFacade;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import javax.naming.NamingException;
import org.glassfish.api.naming.NamedNamingObjectProxy;
import org.glassfish.api.naming.NamespacePrefixes;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;

final class NamedNamingObjectManager {
    private static final AtomicReference<ServiceLocator> locatorReference = new AtomicReference();
    private static final Map<String, NamedNamingObjectProxy> proxies = new HashMap<String, NamedNamingObjectProxy>();
    private static final ReadWriteLock rwLock = new ReentrantReadWriteLock();

    NamedNamingObjectManager() {
    }

    static void checkAndLoadProxies(ServiceLocator locator) {
        if (locator == null || locator == locatorReference.get()) {
            return;
        }
        rwLock.writeLock().lock();
        try {
            if (locatorReference.get() != locator) {
                locatorReference.set(locator);
                LogFacade.logger.log(Level.FINEST, "Clearing map of proxies: {0}", proxies);
                proxies.clear();
            }
        }
        finally {
            rwLock.writeLock().unlock();
        }
    }

    static Object tryNamedProxies(SimpleJndiName name) throws NamingException {
        LogFacade.logger.log(Level.FINEST, "tryNamedProxies(name={0})", name);
        NamedNamingObjectProxy proxy = NamedNamingObjectManager.getCachedProxy(name);
        if (proxy != null) {
            if (LogFacade.logger.isLoggable(Level.FINE)) {
                LogFacade.logger.logp(Level.FINE, "NamedNamingObjectManager", "tryNamedProxies", "Found cached proxy [{0}] for [{1}]", new Object[]{proxy, name});
            }
            return proxy.handle(name.toString());
        }
        for (ServiceHandle inhabitant : NamedNamingObjectManager.getServiceLocator().getAllServiceHandles(NamespacePrefixes.class, new Annotation[0])) {
            List prefixes = (List)inhabitant.getActiveDescriptor().getMetadata().get("NamespacePrefixes");
            LogFacade.logger.log(Level.FINEST, "Found prefixes: {0}", prefixes);
            if (prefixes == null) continue;
            String prefix = null;
            for (String candidate : prefixes) {
                if (!name.hasPrefix(candidate)) continue;
                prefix = candidate;
                break;
            }
            if (prefix == null) continue;
            proxy = (NamedNamingObjectProxy)inhabitant.getService();
            if (LogFacade.logger.isLoggable(Level.FINE)) {
                LogFacade.logger.logp(Level.FINE, "NamedNamingObjectManager", "tryNamedProxies", "found a new proxy [{0}] for [{1}]", new Object[]{proxy, name});
            }
            NamedNamingObjectManager.cacheProxy(prefix, proxy);
            return proxy.handle(name.toString());
        }
        return null;
    }

    private static ServiceLocator getServiceLocator() {
        return locatorReference.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NamedNamingObjectProxy getCachedProxy(SimpleJndiName name) {
        rwLock.readLock().lock();
        try {
            for (Map.Entry<String, NamedNamingObjectProxy> pair : proxies.entrySet()) {
                if (!name.hasPrefix(pair.getKey().toString())) continue;
                NamedNamingObjectProxy namedNamingObjectProxy = pair.getValue();
                return namedNamingObjectProxy;
            }
            Iterator<Map.Entry<String, NamedNamingObjectProxy>> iterator = null;
            return iterator;
        }
        finally {
            rwLock.readLock().unlock();
        }
    }

    private static void cacheProxy(String prefix, NamedNamingObjectProxy proxy) {
        rwLock.writeLock().lock();
        try {
            proxies.put(prefix, proxy);
        }
        finally {
            rwLock.writeLock().unlock();
        }
    }
}

