/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl;

import com.google.common.annotations.Beta;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.internal.events.BuildManager;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.xtext.builder.impl.XtextBuilder;

@Beta
public class BuildManagerAccess {
    private static final Method requestRebuild;
    private static final Field autoBuildJob;
    private static final Method forceBuild;
    private static final Method getBuilder;

    static {
        try {
            requestRebuild = BuildManager.class.getDeclaredMethod("requestRebuild", new Class[0]);
            requestRebuild.setAccessible(true);
            autoBuildJob = BuildManager.class.getDeclaredField("autoBuildJob");
            autoBuildJob.setAccessible(true);
            Class<?> autoBuildJobClass = autoBuildJob.getType();
            forceBuild = autoBuildJobClass.getDeclaredMethod("forceBuild", new Class[0]);
            forceBuild.setAccessible(true);
            getBuilder = BuildManager.class.getDeclaredMethod("getBuilder", IBuildConfiguration.class, ICommand.class, Integer.TYPE, MultiStatus.class);
            getBuilder.setAccessible(true);
        }
        catch (NoSuchFieldException | NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static XtextBuilder findBuilder(IProject project) {
        try {
            if (project.isAccessible()) {
                Project casted = (Project)project;
                IBuildConfiguration activeBuildConfig = casted.getActiveBuildConfig();
                ICommand[] iCommandArray = casted.internalGetDescription().getBuildSpec(false);
                int n = iCommandArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkspace workspace;
                    ICommand command = iCommandArray[n2];
                    if ("org.eclipse.xtext.ui.shared.xtextBuilder".equals(command.getBuilderName()) && (workspace = ResourcesPlugin.getWorkspace()) instanceof Workspace) {
                        BuildManager buildManager = ((Workspace)workspace).getBuildManager();
                        XtextBuilder result = (XtextBuilder)((Object)getBuilder.invoke((Object)buildManager, activeBuildConfig, command, -1, new MultiStatus("org.eclipse.xtext.builder", 0, null, null)));
                        return result;
                    }
                    ++n2;
                }
            }
            return null;
        }
        catch (IllegalAccessException | InvocationTargetException | CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public static void requestBuild() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace instanceof Workspace) {
            BuildManager buildManager = ((Workspace)workspace).getBuildManager();
            try {
                requestRebuild.invoke((Object)buildManager, new Object[0]);
                Object job = autoBuildJob.get(buildManager);
                forceBuild.invoke(job, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new RuntimeException("Unexpected workspace implementation");
        }
    }
}

