/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.generatortasks;

import com.google.common.base.Objects;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.project.ProjectUtility;
import org.eclipse.comma.project.generatortasks.GeneratorTask;
import org.eclipse.comma.project.generatortasks.OutputLocator;
import org.eclipse.comma.project.project.CompoundInterface;
import org.eclipse.comma.project.project.FixedSegment;
import org.eclipse.comma.project.project.ParameterSegment;
import org.eclipse.comma.project.project.Path;
import org.eclipse.comma.project.project.RESTTask;
import org.eclipse.comma.project.project.Segment;
import org.eclipse.comma.signature.comments.InterfaceEventComment;
import org.eclipse.comma.signature.interfaceSignature.Command;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.Notification;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.signature.interfaceSignature.Signal;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.comma.types.comments.SLCommentLocator;
import org.eclipse.comma.types.generator.CommaFileSystemAccess;
import org.eclipse.comma.types.scoping.TypesImportUriGlobalScopeProvider;
import org.eclipse.comma.types.types.EnumElement;
import org.eclipse.comma.types.types.EnumTypeDecl;
import org.eclipse.comma.types.types.RecordField;
import org.eclipse.comma.types.types.RecordTypeDecl;
import org.eclipse.comma.types.types.SimpleTypeDecl;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.types.TypeDecl;
import org.eclipse.comma.types.types.TypeReference;
import org.eclipse.comma.types.types.TypesModel;
import org.eclipse.comma.types.types.VectorTypeConstructor;
import org.eclipse.comma.types.types.VectorTypeDecl;
import org.eclipse.comma.types.utilities.TypeUtilities;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class RESTGeneratorTask
extends GeneratorTask {
    protected final RESTTask task;
    protected final CommaFileSystemAccess restFileSystemAccess;
    protected final String prefix;
    protected final List<Signature> signatures;
    protected final IEObjectDocumentationProvider documentationProvider;
    protected String apiName;
    protected String version;

    public RESTGeneratorTask(RESTTask task, IScopeProvider scopeProvider, OutputLocator outputLocator, IFileSystemAccess2 fsa) {
        super(task, scopeProvider, outputLocator, fsa);
        String _plus_2;
        boolean _tripleNotEquals;
        CommaFileSystemAccess _commaFileSystemAccess;
        this.task = task;
        String _name = task.getName();
        String _plus = "rest" + Character.valueOf('/') + _name;
        String _plus_1 = String.valueOf(_plus) + Character.valueOf('/');
        this.restFileSystemAccess = _commaFileSystemAccess = new CommaFileSystemAccess(_plus_1, fsa);
        Interface _sourceInterface = task.getSourceInterface();
        boolean bl = _tripleNotEquals = _sourceInterface != null;
        if (_tripleNotEquals) {
            this.apiName = task.getSourceInterface().getName();
            this.version = task.getSourceInterface().getVersion();
        } else {
            this.apiName = task.getCompoundInterface().getName();
            this.version = task.getCompoundInterface().getVersion();
        }
        String _substring = this.version.substring(0, this.version.indexOf("."));
        this.prefix = _plus_2 = "/" + this.apiName + "/v" + _substring;
        this.signatures = ProjectUtility.getSignaturesForRESTTask(task, scopeProvider);
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
            }
        }});
        this.documentationProvider = (IEObjectDocumentationProvider)injector.getInstance(IEObjectDocumentationProvider.class);
    }

    @Override
    protected void doGenerate() {
        this.generateBuiltinTypes();
        this.generateErrorResponsesFile();
        this.generateRootREST();
        this.generatePathFiles();
        this.generateRootEvent();
        this.generateChannelFiles();
        this.generateTypeDefinitions();
        for (Signature s : this.signatures) {
            boolean _not;
            boolean _isEmpty = s.getTypes().isEmpty();
            boolean bl = _not = !_isEmpty;
            if (!_not) continue;
            String _name = s.getName();
            String _plus = "datatypes/" + this.apiName + "." + _name;
            String fileName = String.valueOf(_plus) + ".yaml";
            this.restFileSystemAccess.generateFile(fileName, this.datatypesFileContentFromTypes((List<TypeDecl>)s.getTypes()));
        }
    }

    public void generateTypeDefinitions() {
        ArrayList<URI> allImportedURIs = new ArrayList<URI>();
        LinkedHashSet<URI> knownURIs = new LinkedHashSet<URI>(5);
        for (Signature s : this.signatures) {
            knownURIs.add(s.eResource().getURI());
            LinkedHashSet _traverseImportedURIs = TypesImportUriGlobalScopeProvider.traverseImportedURIs((Resource)s.eResource(), knownURIs);
            for (URI uri : _traverseImportedURIs) {
                boolean _not;
                boolean _contains = allImportedURIs.contains(uri);
                boolean bl = _not = !_contains;
                if (!_not) continue;
                allImportedURIs.add(uri);
            }
        }
        for (URI uri : allImportedURIs) {
            Resource resource = EcoreUtil2.getResource((Resource)this.task.eResource(), (String)uri.toString());
            if (resource == null) continue;
            String _lowerCase = this.apiName.toLowerCase();
            String _plus = "datatypes/" + _lowerCase;
            String _plus_1 = String.valueOf(_plus) + ".";
            String _lastSegment = uri.trimFileExtension().lastSegment();
            String _plus_2 = String.valueOf(_plus_1) + _lastSegment;
            String fileName = String.valueOf(_plus_2) + ".yaml";
            this.restFileSystemAccess.generateFile(fileName, this.datatypesFileContentFromResource(resource));
        }
    }

    public void generateBuiltinTypes() {
        String _lowerCase = this.apiName.toLowerCase();
        String _plus = "datatypes/" + _lowerCase;
        String _plus_1 = String.valueOf(_plus) + ".builtin.yaml";
        this.restFileSystemAccess.generateFile(_plus_1, this.builtinTypesContent());
    }

    public CharSequence builtinTypesContent() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("components:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("schemas:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("NullObject:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("type: boolean");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("nullable: true");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("description: 'A NullObject is used to indicate that the object is not available or not set.'");
        _builder.newLine();
        return _builder;
    }

    public void generateRootREST() {
        this.restFileSystemAccess.generateFile(this.rootRESTName(), this.rootRESTContent());
    }

    public void generateRootEvent() {
        this.restFileSystemAccess.generateFile(this.rootEventName(), this.rootEventContent());
    }

    public String rootRESTName() {
        StringConcatenation _builder = new StringConcatenation();
        String _lowerCase = this.apiName.toLowerCase();
        _builder.append(_lowerCase);
        _builder.append(".rest.yaml");
        return _builder.toString();
    }

    public String rootEventName() {
        StringConcatenation _builder = new StringConcatenation();
        String _lowerCase = this.apiName.toLowerCase();
        _builder.append(_lowerCase);
        _builder.append(".event.yaml");
        return _builder.toString();
    }

    public CharSequence rootRESTContent() {
        StringConcatenation _xblockexpression = null;
        String description = "";
        CompoundInterface _compoundInterface = this.task.getCompoundInterface();
        boolean _tripleNotEquals = _compoundInterface != null;
        description = _tripleNotEquals ? this.task.getCompoundInterface().getDescription() : this.documentationProvider.getDocumentation((EObject)this.signatures.get(0));
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("openapi: 3.0.1");
        _builder.newLine();
        _builder.newLine();
        _builder.append("info:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("title: ");
        _builder.append(this.apiName, "    ");
        _builder.append(" API");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("description: ");
        CharSequence _escapeQuotes = this.escapeQuotes(description);
        _builder.append((Object)_escapeQuotes, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("version: '");
        _builder.append(this.version, "    ");
        _builder.append("'");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("servers:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("- url: ");
        String _restServerURL = this.task.getRestServerURL();
        _builder.append(_restServerURL, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("      ");
        _builder.append("description: 'The server details'");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("variables:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("network:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("default: '");
        String _restServerURL_1 = this.task.getRestServerURL();
        _builder.append(_restServerURL_1, "              ");
        _builder.append("'");
        _builder.newLineIfNotEmpty();
        _builder.append("              ");
        _builder.append("description: 'Network adapter this service is available'");
        _builder.newLine();
        _builder.append("    ");
        _builder.newLine();
        _builder.newLine();
        _builder.append("paths:");
        _builder.newLine();
        for (Signature s : this.signatures) {
            _builder.append("    ");
            _builder.append("# ");
            String _name = s.getName();
            _builder.append(_name, "    ");
            _builder.newLineIfNotEmpty();
            EList _commands = s.getCommands();
            for (Command c : _commands) {
                _builder.append("    ");
                String _expandPath = this.expandPath(s, (InterfaceEvent)c);
                _builder.append(_expandPath, "    ");
                _builder.append(":");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("$ref: 'paths/");
                String _lowerCase = this.apiName.toLowerCase();
                _builder.append(_lowerCase, "        ");
                _builder.append(".");
                String _lowerCase_1 = s.getName().toLowerCase();
                _builder.append(_lowerCase_1, "        ");
                _builder.append(".yaml#/");
                String _name_1 = c.getName();
                _builder.append(_name_1, "        ");
                _builder.append("'");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("    ");
                _builder.newLine();
            }
            EList _signals = s.getSignals();
            for (Signal signal : _signals) {
                _builder.append("    ");
                String _expandPath_1 = this.expandPath(s, (InterfaceEvent)signal);
                _builder.append(_expandPath_1, "    ");
                _builder.append(":");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("$ref: 'paths/");
                String _lowerCase_2 = this.apiName.toLowerCase();
                _builder.append(_lowerCase_2, "        ");
                _builder.append(".");
                String _lowerCase_3 = s.getName().toLowerCase();
                _builder.append(_lowerCase_3, "        ");
                _builder.append(".yaml#/");
                String _name_2 = signal.getName();
                _builder.append(_name_2, "        ");
                _builder.append("'");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("    ");
                _builder.newLine();
            }
            ArrayList<InterfaceEvent> _notificationGetters = ProjectUtility.getNotificationGetters(this.task.getPathMappings(), s);
            for (InterfaceEvent n : _notificationGetters) {
                _builder.append("    ");
                String _expandPath_2 = this.expandPath(s, n);
                _builder.append(_expandPath_2, "    ");
                _builder.append(":");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("$ref: 'paths/");
                String _lowerCase_4 = this.apiName.toLowerCase();
                _builder.append(_lowerCase_4, "        ");
                _builder.append(".");
                String _lowerCase_5 = s.getName().toLowerCase();
                _builder.append(_lowerCase_5, "        ");
                _builder.append(".yaml#/");
                String _name_3 = n.getName();
                _builder.append(_name_3, "        ");
                _builder.append("'");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("    ");
                _builder.newLine();
            }
        }
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence rootEventContent() {
        StringConcatenation _xblockexpression = null;
        String description = "";
        CompoundInterface _compoundInterface = this.task.getCompoundInterface();
        boolean _tripleNotEquals = _compoundInterface != null;
        description = _tripleNotEquals ? this.task.getCompoundInterface().getDescription() : this.documentationProvider.getDocumentation((EObject)this.signatures.get(0));
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("asyncapi: 3.0.0");
        _builder.newLine();
        _builder.newLine();
        _builder.append("info:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("title: '");
        _builder.append(this.apiName, "    ");
        _builder.append(" API'");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("description: ");
        CharSequence _escapeQuotes = this.escapeQuotes(description);
        _builder.append((Object)_escapeQuotes, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("version: '");
        _builder.append(this.version, "    ");
        _builder.append("'");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("servers:");
        _builder.newLine();
        _builder.append("    ");
        String _asyncServer = this.task.getAsyncServer();
        _builder.append(_asyncServer, "    ");
        _builder.append(":");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("host: ");
        String _asyncServerURL = this.task.getAsyncServerURL();
        _builder.append(_asyncServerURL, "        ");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("protocol: ");
        String _asyncProtocol = this.task.getAsyncProtocol();
        _builder.append(_asyncProtocol, "        ");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("variables:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("network:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("default: '");
        String _asyncServerURL_1 = this.task.getAsyncServerURL();
        _builder.append(_asyncServerURL_1, "                ");
        _builder.append("'");
        _builder.newLineIfNotEmpty();
        _builder.append("                ");
        _builder.append("description: ''");
        _builder.newLine();
        _builder.newLine();
        _builder.append("channels:");
        _builder.newLine();
        for (Signature s : this.signatures) {
            boolean _not;
            boolean _isEmpty = s.getNotifications().isEmpty();
            boolean bl = _not = !_isEmpty;
            if (!_not) continue;
            _builder.append("    ");
            _builder.append("# ");
            String _name = s.getName();
            _builder.append(_name, "    ");
            _builder.newLineIfNotEmpty();
            EList _notifications = s.getNotifications();
            for (Notification n : _notifications) {
                _builder.append("    ");
                String _name_1 = n.getName();
                _builder.append(_name_1, "    ");
                _builder.append(":");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("$ref: 'channels/");
                String _lowerCase = this.apiName.toLowerCase();
                _builder.append(_lowerCase, "        ");
                _builder.append(".");
                String _lowerCase_1 = s.getName().toLowerCase();
                _builder.append(_lowerCase_1, "        ");
                _builder.append(".yaml#/channels/");
                String _name_2 = n.getName();
                _builder.append(_name_2, "        ");
                _builder.append("'");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public void generatePathFiles() {
        for (Signature s : this.signatures) {
            String _lowerCase = this.apiName.toLowerCase();
            String _plus = "paths/" + _lowerCase;
            String _plus_1 = String.valueOf(_plus) + ".";
            String _lowerCase_1 = s.getName().toLowerCase();
            String _plus_2 = String.valueOf(_plus_1) + _lowerCase_1;
            String _plus_3 = String.valueOf(_plus_2) + ".yaml";
            this.restFileSystemAccess.generateFile(_plus_3, this.pathFileContent(s));
        }
    }

    public void generateChannelFiles() {
        for (Signature s : this.signatures) {
            boolean _not;
            boolean _isEmpty = s.getNotifications().isEmpty();
            boolean bl = _not = !_isEmpty;
            if (!_not) continue;
            String _lowerCase = this.apiName.toLowerCase();
            String _plus = "channels/" + _lowerCase;
            String _plus_1 = String.valueOf(_plus) + ".";
            String _lowerCase_1 = s.getName().toLowerCase();
            String _plus_2 = String.valueOf(_plus_1) + _lowerCase_1;
            String _plus_3 = String.valueOf(_plus_2) + ".yaml";
            this.restFileSystemAccess.generateFile(_plus_3, this.channelFileContent(s));
        }
    }

    public CharSequence pathFileContent(Signature s) {
        StringConcatenation _builder = new StringConcatenation();
        EList _commands = s.getCommands();
        for (Command command : _commands) {
            CharSequence _pathCommandOrSignal = this.pathCommandOrSignal((InterfaceEvent)command);
            _builder.append((Object)_pathCommandOrSignal);
            _builder.newLineIfNotEmpty();
        }
        EList _signals = s.getSignals();
        for (Signal signal : _signals) {
            CharSequence _pathCommandOrSignal_1 = this.pathCommandOrSignal((InterfaceEvent)signal);
            _builder.append((Object)_pathCommandOrSignal_1);
            _builder.newLineIfNotEmpty();
        }
        ArrayList<InterfaceEvent> _notificationGetters = ProjectUtility.getNotificationGetters(this.task.getPathMappings(), s);
        for (InterfaceEvent notification : _notificationGetters) {
            CharSequence _notificationGetter = this.notificationGetter((Notification)notification);
            _builder.append((Object)_notificationGetter);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence pathCommandOrSignal(InterfaceEvent e) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = e.getName();
        _builder.append(_name);
        _builder.append(":");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        CharSequence _pathOperation = this.pathOperation(ProjectUtility.getEventRESTMapping(e, this.task.getPathMappings()), e);
        _builder.append((Object)_pathOperation, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    public CharSequence notificationGetter(Notification n) {
        boolean _not;
        StringConcatenation _xblockexpression = null;
        String _documentation = this.documentationProvider.getDocumentation((EObject)n);
        InterfaceEventComment comments = new InterfaceEventComment((InterfaceEvent)n, _documentation);
        ArrayList<Parameter> pathParameters = ProjectUtility.getPathParameters(this.task.getPathMappings(), (InterfaceEvent)n);
        List<Parameter> nonPathParameters = ProjectUtility.getNonPathParameters(this.task.getPathMappings(), (InterfaceEvent)n);
        StringConcatenation _builder = new StringConcatenation();
        String _name = n.getName();
        _builder.append(_name);
        _builder.append(":");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("get:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("operationId: '");
        String _name_1 = n.getName();
        _builder.append(_name_1, "        ");
        _builder.append("'");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("summary: ");
        CharSequence _escapeQuotes = this.escapeQuotes(comments.getEventComment());
        _builder.append((Object)_escapeQuotes, "        ");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("tags:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("- ");
        String _name_2 = n.getName();
        _builder.append(_name_2, "        ");
        _builder.newLineIfNotEmpty();
        boolean _isEmpty = pathParameters.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("        ");
            _builder.newLine();
            _builder.append("        ");
            _builder.append("parameters:");
            _builder.newLine();
            for (Parameter p : pathParameters) {
                _builder.append("        ");
                _builder.append("- name: ");
                String _name_3 = p.getName();
                _builder.append(_name_3, "        ");
                _builder.newLineIfNotEmpty();
                _builder.append("        ");
                _builder.append("  ");
                _builder.append("in: path");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("  ");
                _builder.append("required: true");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("  ");
                _builder.append("schema:");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("      ");
                _builder.append("type: string");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("      ");
                _builder.append("pattern: .+");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("  ");
                _builder.append("description: ");
                CharSequence _escapeQuotes_1 = this.escapeQuotes(comments.getCommentForParam(p.getName()));
                _builder.append((Object)_escapeQuotes_1, "          ");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("            ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("responses:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("200:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("description: 'Call returns successfully'");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("                        ");
        _builder.append("schema:");
        _builder.newLine();
        boolean _isEmpty_1 = nonPathParameters.isEmpty();
        if (_isEmpty_1) {
            _builder.append("                            ");
            _builder.append("$ref: '../datatypes/");
            String _lowerCase = this.apiName.toLowerCase();
            _builder.append(_lowerCase, "                            ");
            _builder.append(".builtin.yaml#/components/schemas/NullObject'");
            _builder.newLineIfNotEmpty();
        } else {
            boolean _equals;
            int _size = nonPathParameters.size();
            boolean bl2 = _equals = _size == 1;
            if (_equals) {
                _builder.append("                            ");
                CharSequence _typeReference = this.typeReference((EObject)nonPathParameters.get(0).getType(), (EObject)n);
                _builder.append((Object)_typeReference, "                            ");
                _builder.newLineIfNotEmpty();
                _builder.append("                            ");
                _builder.append("description: ");
                CharSequence _escapeQuotes_2 = this.escapeQuotes(comments.getCommentForParam(nonPathParameters.get(0).getName()));
                _builder.append((Object)_escapeQuotes_2, "                            ");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("                            ");
                _builder.append("type: object");
                _builder.newLine();
                _builder.append("                            ");
                _builder.append("properties:");
                _builder.newLine();
                for (Parameter p_1 : nonPathParameters) {
                    _builder.append("                            ");
                    _builder.append("    ");
                    String _name_4 = p_1.getName();
                    _builder.append(_name_4, "                                ");
                    _builder.append(":");
                    _builder.newLineIfNotEmpty();
                    _builder.append("                            ");
                    _builder.append("    ");
                    _builder.append("    ");
                    CharSequence _typeReference_1 = this.typeReference((EObject)p_1.getType(), (EObject)n);
                    _builder.append((Object)_typeReference_1, "                                    ");
                    _builder.newLineIfNotEmpty();
                    _builder.append("                            ");
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("description: ");
                    CharSequence _escapeQuotes_3 = this.escapeQuotes(comments.getCommentForParam(p_1.getName()));
                    _builder.append((Object)_escapeQuotes_3, "                                    ");
                    _builder.newLineIfNotEmpty();
                }
            }
        }
        _builder.append("            ");
        _builder.append("404:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("                        ");
        _builder.append("schema: ");
        _builder.newLine();
        _builder.append("                          ");
        _builder.append("$ref: '../");
        String _lowerCase_1 = this.apiName.toLowerCase();
        _builder.append(_lowerCase_1, "                          ");
        _builder.append(".errorresponses.yaml#/components/schemas/CommonErrorResult'");
        _builder.newLineIfNotEmpty();
        _builder.append("            ");
        _builder.append("503:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("allOf:");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("- description: 'Server is unavailable'");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("- $ref: '../");
        String _lowerCase_2 = this.apiName.toLowerCase();
        _builder.append(_lowerCase_2, "                    ");
        _builder.append(".errorresponses.yaml#/components/responses/ServerUnavailable'             ");
        _builder.newLineIfNotEmpty();
        _builder.append("                ");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("default:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("$ref: '../");
        String _lowerCase_3 = this.apiName.toLowerCase();
        _builder.append(_lowerCase_3, "                ");
        _builder.append(".errorresponses.yaml#/components/responses/UnexpectedError' ");
        _builder.newLineIfNotEmpty();
        _builder.append("            ");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence pathOperation(ProjectUtility.RESTOperation op, InterfaceEvent e) {
        CharSequence _switchResult = null;
        if (op != null) {
            switch (op) {
                case GET: {
                    _switchResult = this.pathGetOperation((Command)e);
                    break;
                }
                case PUT: {
                    _switchResult = this.pathPutOperation(e);
                    break;
                }
                default: {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Not Supported");
                    _switchResult = _builder;
                    break;
                }
            }
        } else {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Not Supported");
            _switchResult = _builder;
        }
        return _switchResult;
    }

    public CharSequence pathGetOperation(Command c) {
        boolean _not;
        boolean _greaterThan;
        StringConcatenation _xblockexpression = null;
        boolean isVoidType = TypeUtilities.isVoid((Type)c.getType());
        boolean multipleResults = false;
        Functions.Function1 _function = it -> {
            DIRECTION _direction = it.getDirection();
            return Objects.equal((Object)_direction, (Object)DIRECTION.OUT);
        };
        Iterable outParams = IterableExtensions.filter((Iterable)c.getParameters(), (Functions.Function1)_function);
        int _size = IterableExtensions.size((Iterable)outParams);
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            multipleResults = true;
        }
        if (IterableExtensions.size((Iterable)outParams) == 1 && !isVoidType) {
            multipleResults = true;
        }
        String _documentation = this.documentationProvider.getDocumentation((EObject)c);
        InterfaceEventComment comments = new InterfaceEventComment((InterfaceEvent)c, _documentation);
        ArrayList<Parameter> pathParameters = ProjectUtility.getPathParameters(this.task.getPathMappings(), (InterfaceEvent)c);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("get:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("operationId: '");
        String _name = c.getName();
        _builder.append(_name, "    ");
        _builder.append("'");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("summary: ");
        CharSequence _escapeQuotes = this.escapeQuotes(comments.getEventComment());
        _builder.append((Object)_escapeQuotes, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("tags:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("- ");
        String _name_1 = c.getName();
        _builder.append(_name_1, "    ");
        _builder.newLineIfNotEmpty();
        boolean _isEmpty = pathParameters.isEmpty();
        boolean bl2 = _not = !_isEmpty;
        if (_not) {
            _builder.append("    ");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("parameters:");
            _builder.newLine();
            for (Parameter p : pathParameters) {
                _builder.append("    ");
                _builder.append("- name: ");
                String _name_2 = p.getName();
                _builder.append(_name_2, "    ");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("  ");
                _builder.append("in: path");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("  ");
                _builder.append("required: true");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("  ");
                _builder.append("schema:");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("      ");
                _builder.append("type: string");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("      ");
                _builder.append("pattern: .+");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("  ");
                _builder.append("description: ");
                CharSequence _escapeQuotes_1 = this.escapeQuotes(comments.getCommentForParam(p.getName()));
                _builder.append((Object)_escapeQuotes_1, "      ");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("    ");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("responses:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("200:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("description: 'Call returns successfully'");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("schema:");
        _builder.newLine();
        if (multipleResults) {
            _builder.append("                        ");
            _builder.append("type: object");
            _builder.newLine();
            _builder.append("                        ");
            _builder.append("properties:");
            _builder.newLine();
            if (!isVoidType) {
                _builder.append("                        ");
                _builder.append("    ");
                _builder.append("result:");
                _builder.newLine();
                _builder.append("                        ");
                _builder.append("    ");
                _builder.append("    ");
                CharSequence _typeReference = this.typeReference((EObject)c.getType(), (EObject)c);
                _builder.append((Object)_typeReference, "                                ");
                _builder.newLineIfNotEmpty();
                _builder.append("                        ");
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("description: ");
                CharSequence _escapeQuotes_2 = this.escapeQuotes(comments.getReturnComment());
                _builder.append((Object)_escapeQuotes_2, "                                ");
                _builder.newLineIfNotEmpty();
            }
            for (Parameter p_1 : outParams) {
                _builder.append("                        ");
                _builder.append("    ");
                String _name_3 = p_1.getName();
                _builder.append(_name_3, "                            ");
                _builder.append(":");
                _builder.newLineIfNotEmpty();
                _builder.append("                        ");
                _builder.append("    ");
                _builder.append("    ");
                CharSequence _typeReference_1 = this.typeReference((EObject)p_1.getType(), (EObject)c);
                _builder.append((Object)_typeReference_1, "                                ");
                _builder.newLineIfNotEmpty();
                _builder.append("                        ");
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("description: ");
                CharSequence _escapeQuotes_3 = this.escapeQuotes(comments.getCommentForParam(p_1.getName()));
                _builder.append((Object)_escapeQuotes_3, "                                ");
                _builder.newLineIfNotEmpty();
            }
        } else if (!isVoidType) {
            _builder.append("                        ");
            CharSequence _typeReference_2 = this.typeReference((EObject)c.getType(), (EObject)c);
            _builder.append((Object)_typeReference_2, "                        ");
            _builder.newLineIfNotEmpty();
            _builder.append("                        ");
            _builder.append("description: ");
            CharSequence _escapeQuotes_4 = this.escapeQuotes(comments.getReturnComment());
            _builder.append((Object)_escapeQuotes_4, "                        ");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("                        ");
            CharSequence _typeReference_3 = this.typeReference((EObject)((Parameter[])Conversions.unwrapArray((Object)outParams, Parameter.class))[0].getType(), (EObject)c);
            _builder.append((Object)_typeReference_3, "                        ");
            _builder.newLineIfNotEmpty();
            _builder.append("                        ");
            _builder.append("description: ");
            CharSequence _escapeQuotes_5 = this.escapeQuotes(comments.getCommentForParam(((Parameter[])Conversions.unwrapArray((Object)outParams, Parameter.class))[0].getName()));
            _builder.append((Object)_escapeQuotes_5, "                        ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("        ");
        _builder.append("404:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("schema: ");
        _builder.newLine();
        _builder.append("                      ");
        _builder.append("$ref: '../");
        String _lowerCase = this.apiName.toLowerCase();
        _builder.append(_lowerCase, "                      ");
        _builder.append(".errorresponses.yaml#/components/schemas/CommonErrorResult'");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("503:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("allOf:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("- description: 'Server is unavailable'");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("- $ref: '../");
        String _lowerCase_1 = this.apiName.toLowerCase();
        _builder.append(_lowerCase_1, "                ");
        _builder.append(".errorresponses.yaml#/components/responses/ServerUnavailable'             ");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("default:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("$ref: '../");
        String _lowerCase_2 = this.apiName.toLowerCase();
        _builder.append(_lowerCase_2, "            ");
        _builder.append(".errorresponses.yaml#/components/responses/UnexpectedError' ");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence pathPutOperation(InterfaceEvent e) {
        boolean _not_1;
        boolean _not;
        StringConcatenation _xblockexpression = null;
        String _documentation = this.documentationProvider.getDocumentation((EObject)e);
        InterfaceEventComment comments = new InterfaceEventComment(e, _documentation);
        ArrayList<Parameter> pathParameters = ProjectUtility.getPathParameters(this.task.getPathMappings(), e);
        List<Parameter> nonPathParameters = ProjectUtility.getNonPathParameters(this.task.getPathMappings(), e);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("put:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("operationId: '");
        String _name = e.getName();
        _builder.append(_name, "    ");
        _builder.append("'");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("summary: ");
        CharSequence _escapeQuotes = this.escapeQuotes(comments.getEventComment());
        _builder.append((Object)_escapeQuotes, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("tags:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("- ");
        String _name_1 = e.getName();
        _builder.append(_name_1, "    ");
        _builder.newLineIfNotEmpty();
        boolean _isEmpty = pathParameters.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("    ");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("parameters:");
            _builder.newLine();
            for (Parameter p : pathParameters) {
                _builder.append("    ");
                _builder.append("- name: ");
                String _name_2 = p.getName();
                _builder.append(_name_2, "    ");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("  ");
                _builder.append("in: path");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("  ");
                _builder.append("required: true");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("  ");
                _builder.append("schema:");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("      ");
                _builder.append("type: string");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("      ");
                _builder.append("pattern: .+");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("  ");
                _builder.append("description: ");
                CharSequence _escapeQuotes_1 = this.escapeQuotes(comments.getCommentForParam(p.getName()));
                _builder.append((Object)_escapeQuotes_1, "      ");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("    ");
        _builder.newLine();
        boolean _isEmpty_1 = nonPathParameters.isEmpty();
        boolean bl2 = _not_1 = !_isEmpty_1;
        if (_not_1) {
            boolean _equals;
            _builder.append("    ");
            _builder.append("requestBody:");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("    ");
            _builder.append("content:");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("        ");
            _builder.append("application/json:");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("            ");
            _builder.append("schema:");
            _builder.newLine();
            int _size = nonPathParameters.size();
            boolean bl3 = _equals = _size == 1;
            if (_equals) {
                _builder.append("    ");
                _builder.append("                ");
                _builder.append("description: ");
                CharSequence _escapeQuotes_2 = this.escapeQuotes(comments.getCommentForParam(nonPathParameters.get(0).getName()));
                _builder.append((Object)_escapeQuotes_2, "                    ");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("                ");
                CharSequence _typeReference = this.typeReference((EObject)nonPathParameters.get(0).getType(), (EObject)e);
                _builder.append((Object)_typeReference, "                    ");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("    ");
                _builder.append("                ");
                _builder.append("type: object");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("                ");
                _builder.append("properties:");
                _builder.newLine();
                for (Parameter f : nonPathParameters) {
                    _builder.append("    ");
                    _builder.append("                ");
                    _builder.append("    ");
                    String _name_3 = f.getName();
                    _builder.append(_name_3, "                        ");
                    _builder.append(":");
                    _builder.newLineIfNotEmpty();
                    _builder.append("    ");
                    _builder.append("                ");
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("description: ");
                    CharSequence _escapeQuotes_3 = this.escapeQuotes(comments.getCommentForParam(f.getName()));
                    _builder.append((Object)_escapeQuotes_3, "                            ");
                    _builder.newLineIfNotEmpty();
                    _builder.append("    ");
                    _builder.append("                ");
                    _builder.append("    ");
                    _builder.append("    ");
                    CharSequence _typeReference_1 = this.typeReference((EObject)f.getType(), (EObject)e);
                    _builder.append((Object)_typeReference_1, "                            ");
                    _builder.newLineIfNotEmpty();
                }
            }
        }
        _builder.append("    ");
        _builder.append("responses:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("200:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("description: 'Call returns successfully'");
        _builder.newLine();
        if (e instanceof Command) {
            boolean _not_2;
            _builder.append("            ");
            Command command = (Command)e;
            _builder.newLineIfNotEmpty();
            boolean _isVoid = TypeUtilities.isVoid((Type)command.getType());
            boolean bl4 = _not_2 = !_isVoid;
            if (_not_2) {
                _builder.append("            ");
                _builder.append("content:");
                _builder.newLine();
                _builder.append("            ");
                _builder.append("    ");
                _builder.append("application/json:");
                _builder.newLine();
                _builder.append("            ");
                _builder.append("        ");
                _builder.append("schema:");
                _builder.newLine();
                _builder.append("            ");
                _builder.append("            ");
                CharSequence _typeReference_2 = this.typeReference((EObject)command.getType(), (EObject)command);
                _builder.append((Object)_typeReference_2, "                        ");
                _builder.newLineIfNotEmpty();
                _builder.append("            ");
                _builder.append("            ");
                _builder.append("description: ");
                CharSequence _escapeQuotes_4 = this.escapeQuotes(comments.getReturnComment());
                _builder.append((Object)_escapeQuotes_4, "                        ");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("        ");
        _builder.append("404:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("schema: ");
        _builder.newLine();
        _builder.append("                      ");
        _builder.append("$ref: '../");
        String _lowerCase = this.apiName.toLowerCase();
        _builder.append(_lowerCase, "                      ");
        _builder.append(".errorresponses.yaml#/components/schemas/CommonErrorResult'");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("503:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("allOf:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("- description: 'Server is unavailable'");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("- $ref: '../");
        String _lowerCase_1 = this.apiName.toLowerCase();
        _builder.append(_lowerCase_1, "                ");
        _builder.append(".errorresponses.yaml#/components/responses/ServerUnavailable'             ");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("default:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("$ref: '../");
        String _lowerCase_2 = this.apiName.toLowerCase();
        _builder.append(_lowerCase_2, "            ");
        _builder.append(".errorresponses.yaml#/components/responses/UnexpectedError' ");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence channelFileContent(Signature s) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("channels:");
        _builder.newLine();
        EList _notifications = s.getNotifications();
        for (Notification n : _notifications) {
            boolean _not;
            _builder.append("    ");
            String _documentation = this.documentationProvider.getDocumentation((EObject)n);
            InterfaceEventComment comments = new InterfaceEventComment((InterfaceEvent)n, _documentation);
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            ArrayList<Parameter> pathParameters = ProjectUtility.getPathParameters(this.task.getPathMappings(), (InterfaceEvent)n);
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            List<Parameter> nonPathParameters = ProjectUtility.getNonPathParameters(this.task.getPathMappings(), (InterfaceEvent)n);
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            String _name = n.getName();
            _builder.append(_name, "    ");
            _builder.append(":");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            _builder.append("address: ");
            String _expandPath = this.expandPath(s, (InterfaceEvent)n);
            _builder.append(_expandPath, "        ");
            _builder.newLineIfNotEmpty();
            boolean _isEmpty = pathParameters.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("parameters:");
                _builder.newLine();
                for (Parameter p : pathParameters) {
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("    ");
                    String _name_1 = p.getName();
                    _builder.append(_name_1, "            ");
                    _builder.append(":");
                    _builder.newLineIfNotEmpty();
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("description: ");
                    CharSequence _escapeQuotes = this.escapeQuotes(comments.getCommentForParam(p.getName()));
                    _builder.append((Object)_escapeQuotes, "                ");
                    _builder.newLineIfNotEmpty();
                }
            }
            _builder.append("    ");
            _builder.append("    ");
            _builder.append("messages:");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("        ");
            _builder.append("subscribe:");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("            ");
            _builder.append("name: subscribe");
            String _upperCase = n.getName().substring(0, 1).toUpperCase();
            String _substring = n.getName().substring(1);
            String _plus = String.valueOf(_upperCase) + _substring;
            _builder.append(_plus, "                ");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("            ");
            _builder.append("payload:");
            _builder.newLine();
            boolean _isEmpty_1 = nonPathParameters.isEmpty();
            if (_isEmpty_1) {
                _builder.append("    ");
                _builder.append("                ");
                _builder.append("$ref: '../datatypes/");
                String _lowerCase = this.apiName.toLowerCase();
                _builder.append(_lowerCase, "                    ");
                _builder.append(".builtin.yaml#/components/schemas/NullObject'");
                _builder.newLineIfNotEmpty();
            } else {
                boolean _equals;
                int _size = nonPathParameters.size();
                boolean bl2 = _equals = _size == 1;
                if (_equals) {
                    _builder.append("    ");
                    _builder.append("                ");
                    CharSequence _typeReference = this.typeReference((EObject)nonPathParameters.get(0).getType(), (EObject)n);
                    _builder.append((Object)_typeReference, "                    ");
                    _builder.newLineIfNotEmpty();
                    _builder.append("    ");
                    _builder.append("                ");
                    _builder.append("description: ");
                    CharSequence _escapeQuotes_1 = this.escapeQuotes(comments.getCommentForParam(nonPathParameters.get(0).getName()));
                    _builder.append((Object)_escapeQuotes_1, "                    ");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append("    ");
                    _builder.append("                ");
                    _builder.append("type: object");
                    _builder.newLine();
                    _builder.append("    ");
                    _builder.append("                ");
                    _builder.append("properties:");
                    _builder.newLine();
                    for (Parameter p_1 : nonPathParameters) {
                        _builder.append("    ");
                        _builder.append("                ");
                        _builder.append("    ");
                        String _name_2 = p_1.getName();
                        _builder.append(_name_2, "                        ");
                        _builder.append(":");
                        _builder.newLineIfNotEmpty();
                        _builder.append("    ");
                        _builder.append("                ");
                        _builder.append("    ");
                        _builder.append("    ");
                        CharSequence _typeReference_1 = this.typeReference((EObject)p_1.getType(), (EObject)n);
                        _builder.append((Object)_typeReference_1, "                            ");
                        _builder.newLineIfNotEmpty();
                        _builder.append("    ");
                        _builder.append("                ");
                        _builder.append("    ");
                        _builder.append("    ");
                        _builder.append("description: ");
                        CharSequence _escapeQuotes_2 = this.escapeQuotes(comments.getCommentForParam(p_1.getName()));
                        _builder.append((Object)_escapeQuotes_2, "                            ");
                        _builder.newLineIfNotEmpty();
                    }
                }
            }
            _builder.append("    ");
            _builder.append("                ");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence datatypesFileContentFromResource(Resource res) {
        CharSequence _xblockexpression = null;
        EObject _head = (EObject)IterableExtensions.head((Iterable)res.getContents());
        TypesModel root = (TypesModel)_head;
        _xblockexpression = this.datatypesFileContentFromTypes((List<TypeDecl>)root.getTypes());
        return _xblockexpression;
    }

    public CharSequence datatypesFileContentFromTypes(List<TypeDecl> types) {
        StringConcatenation _xblockexpression = null;
        Functions.Function1 _function = t -> t instanceof EnumTypeDecl || t instanceof RecordTypeDecl || t instanceof VectorTypeDecl;
        Iterable filteredTypes = IterableExtensions.filter(types, (Functions.Function1)_function);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("components:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("schemas:");
        _builder.newLine();
        for (TypeDecl t2 : filteredTypes) {
            _builder.append("        ");
            CharSequence _generateType = this.generateType(t2);
            _builder.append((Object)_generateType, "        ");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected CharSequence _generateType(EnumTypeDecl t) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = t.getName();
        _builder.append(_name);
        _builder.append(":");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("description: ");
        CharSequence _escapeQuotes = this.escapeQuotes(this.documentationProvider.getDocumentation((EObject)t));
        _builder.append((Object)_escapeQuotes, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("enum:");
        _builder.newLine();
        EList _literals = t.getLiterals();
        for (EnumElement l : _literals) {
            _builder.append("    ");
            _builder.append("- ");
            String _name_1 = l.getName();
            _builder.append(_name_1, "    ");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _generateType(RecordTypeDecl t) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = t.getName();
        _builder.append(_name);
        _builder.append(":");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("type: object");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("description: ");
        CharSequence _escapeQuotes = this.escapeQuotes(this.documentationProvider.getDocumentation((EObject)t));
        _builder.append((Object)_escapeQuotes, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("properties:");
        _builder.newLine();
        EList _fields = t.getFields();
        for (RecordField f : _fields) {
            _builder.append("        ");
            String _name_1 = f.getName();
            _builder.append(_name_1, "        ");
            _builder.append(":");
            _builder.newLineIfNotEmpty();
            _builder.append("        ");
            _builder.append("    ");
            _builder.append("description: ");
            CharSequence _escapeQuotes_1 = this.escapeQuotes(SLCommentLocator.getSLComment((EObject)f));
            _builder.append((Object)_escapeQuotes_1, "            ");
            _builder.newLineIfNotEmpty();
            _builder.append("        ");
            _builder.append("    ");
            CharSequence _typeReference = this.typeReference((EObject)f.getType(), (EObject)t);
            _builder.append((Object)_typeReference, "            ");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _generateType(VectorTypeDecl t) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = t.getName();
        _builder.append(_name);
        _builder.append(":");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("type: array");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("items:");
        _builder.newLine();
        _builder.append("        ");
        CharSequence _typeReference = this.typeReference((EObject)t.getConstructor().getType(), (EObject)t);
        _builder.append((Object)_typeReference, "        ");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _typeReference(TypeReference t, EObject context) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _typeReference = this.typeReference((EObject)t.getType(), context);
        _builder.append((Object)_typeReference);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _typeReference(VectorTypeConstructor t, EObject context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("type: array");
        _builder.newLine();
        _builder.append("items:");
        _builder.newLine();
        _builder.append("    ");
        CharSequence _typeReference = this.typeReference((EObject)t.getType(), context);
        _builder.append((Object)_typeReference, "    ");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _typeReference(SimpleTypeDecl t, EObject context) {
        SimpleTypeDecl _type = null;
        boolean _isPredefinedType = TypeUtilities.isPredefinedType((TypeDecl)t);
        if (_isPredefinedType) {
            _type = t;
        } else {
            _type = t.getBase();
            if (_type == null) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("type: ");
                String _name = t.getName();
                _builder.append(_name);
                _builder.append(" HAS NO BASE");
                return _builder.toString();
            }
        }
        boolean _equals = _type.getName().equals("int");
        if (_equals) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("type: integer");
            return _builder_1.toString();
        }
        boolean _equals_1 = _type.getName().equals("real");
        if (_equals_1) {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("type: number");
            return _builder_2.toString();
        }
        boolean _equals_2 = _type.getName().equals("bool");
        if (_equals_2) {
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("type: boolean");
            return _builder_3.toString();
        }
        boolean _equals_3 = _type.getName().equals("string");
        if (_equals_3) {
            StringConcatenation _builder_4 = new StringConcatenation();
            _builder_4.append("type: string");
            return _builder_4.toString();
        }
        boolean _equals_4 = _type.getName().equals("bulkdata");
        if (_equals_4) {
            StringConcatenation _builder_5 = new StringConcatenation();
            _builder_5.append("type: string");
            _builder_5.newLine();
            _builder_5.append("format: byte");
            _builder_5.newLine();
            return _builder_5.toString();
        }
        StringConcatenation _builder_6 = new StringConcatenation();
        _builder_6.append("type: UNSUPPORTED");
        return _builder_6.toString();
    }

    public CharSequence reference(TypeDecl t, EObject context) {
        Resource _eResource_1;
        StringConcatenation _xifexpression = null;
        Resource _eResource = t.eResource();
        boolean _equals = Objects.equal((Object)_eResource, (Object)(_eResource_1 = context.eResource()));
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("$ref: '#/components/schemas/");
            String _name = t.getName();
            _builder.append(_name);
            _builder.append("' ");
            _xifexpression = _builder;
        } else {
            StringConcatenation _xblockexpression = null;
            String fileName = t.eResource().getURI().trimFileExtension().lastSegment();
            StringConcatenation _xifexpression_1 = null;
            if (context instanceof InterfaceEvent) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("$ref: '../datatypes/");
                String _lowerCase = this.apiName.toLowerCase();
                _builder_1.append(_lowerCase);
                _builder_1.append(".");
                _builder_1.append(fileName);
                _builder_1.append(".yaml#/components/schemas/");
                String _name_1 = t.getName();
                _builder_1.append(_name_1);
                _builder_1.append("' ");
                _xifexpression_1 = _builder_1;
            } else {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("$ref: '");
                String _lowerCase_1 = this.apiName.toLowerCase();
                _builder_2.append(_lowerCase_1);
                _builder_2.append(".");
                _builder_2.append(fileName);
                _builder_2.append(".yaml#/components/schemas/");
                String _name_2 = t.getName();
                _builder_2.append(_name_2);
                _builder_2.append("' ");
                _xifexpression_1 = _builder_2;
            }
            _xifexpression = _xblockexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    protected CharSequence _typeReference(EnumTypeDecl t, EObject context) {
        return this.reference((TypeDecl)t, context);
    }

    protected CharSequence _typeReference(RecordTypeDecl t, EObject context) {
        return this.reference((TypeDecl)t, context);
    }

    protected CharSequence _typeReference(VectorTypeDecl t, EObject context) {
        return this.reference((TypeDecl)t, context);
    }

    public void generateErrorResponsesFile() {
        String _lowerCase = this.apiName.toLowerCase();
        String _plus = String.valueOf(_lowerCase) + ".errorresponses.yaml";
        this.restFileSystemAccess.generateFile(_plus, this.errorResponsesContent());
    }

    public CharSequence errorResponsesContent() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("components:");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("responses:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("# Schema for responses");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("BadRequest:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: 'The request is incorrect.'");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("             ");
        _builder.append("$ref: '#/components/schemas/CommonErrorResult'");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("Unauthorized:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: 'Unauthorized.'");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("             ");
        _builder.append("$ref: '#/components/schemas/CommonErrorResult'");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("NotFound:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: 'The requested resource cannot be found.'");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("             ");
        _builder.append("$ref: '#/components/schemas/CommonErrorResult'");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("MethodNotAllowed:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: 'The requested method is not allowed.'");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("             ");
        _builder.append("$ref: '#/components/schemas/CommonErrorResult'");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("Conflict:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: 'The requested method was not allowed due to a conflict with the current state.'");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("             ");
        _builder.append("$ref: '#/components/schemas/CommonErrorResult'");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("Gone:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: 'The requested resource is gone.'");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("             ");
        _builder.append("$ref: '#/components/schemas/CommonErrorResult'");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("NotImplemented:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: 'The server either does not recognize the request method, or it lacks the ability to fulfil the request.'");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("             ");
        _builder.append("$ref: '#/components/schemas/CommonErrorResult'");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("ServerUnavailable:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: 'The server is currently unable to handle the request due to a temporary overloading or maintenance of the server.'");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("             ");
        _builder.append("$ref: '#/components/schemas/CommonErrorResult'");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("ServerBusy:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: 'The server is busy to accept requests. Clients can try again.'");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("             ");
        _builder.append("$ref: '#/components/schemas/CommonErrorResult'");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("UnexpectedError:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: 'Internal server error'");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("             ");
        _builder.append("$ref: '#/components/schemas/CommonErrorResult'");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("schemas:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("CommonErrorResult:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("title: An RFC 7807 problem object");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("type: object");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("required:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- status");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("properties:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("type:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("format: uri");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: 'A URI reference that identifies the problem type'");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("status:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("type: integer");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: 'HTTP Status Code'");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("minimum: 100");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("maximum: 599");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("title:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: 'A short, human-readable summary of the problem type'");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("detail:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: 'A human-readable explanation specific to this occurrence of the problem'");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("instance:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("format: uri-reference");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: 'A URI reference that identifies the specific occurrence of the problem'");
        _builder.newLine();
        _builder.append("    ");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("#Schema error model");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("errorModel:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("type: object");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("properties:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("location:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: 'The specific item within the locationType that caused the error. For example, if an invalid value is specified for a parameter, the location will be the name of the parameter.'");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("minLength: 0");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("locationType:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: 'The location or part of the request that caused the error. Use with location to pinpoint the error.  For example, if an invalid value is specified for a parameter, the locationType will be parameter and the location will be the name of the parameter. Example values include; header and parameter.'");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("message:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: 'Description of the error. Example values include; Invalid argument, Login required, Required parameter <parameter_name>, etc.'");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("minLength: 0");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("reason:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: 'Reason for the specific error. Example values include; invalidParameter, mandatoryParameterMissing, etc.'");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("minLength: 0");
        _builder.newLine();
        return _builder;
    }

    public CharSequence escapeQuotes(String text) {
        String _xblockexpression = null;
        if (text == null) {
            return "''";
        }
        String _xifexpression = null;
        boolean _contains = text.contains("'");
        if (_contains) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("\"");
            _builder.append(text);
            _builder.append("\"");
            _xifexpression = _builder;
        } else {
            _xifexpression = "'" + text + "'";
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String expandPath(Signature sig, InterfaceEvent event) {
        Path path = ProjectUtility.getPath(this.task.getPathMappings(), sig, event);
        String result = "";
        EList<Segment> _segments = path.getSegments();
        for (Segment segment : _segments) {
            if (segment instanceof FixedSegment) {
                String _result = result;
                String _name = ((FixedSegment)segment).getName();
                String _plus = "/" + _name;
                result = String.valueOf(_result) + _plus;
                continue;
            }
            String _result_1 = result;
            String _name_1 = ((ParameterSegment)segment).getParameter().getName();
            String _plus_1 = "/{" + _name_1;
            String _plus_2 = String.valueOf(_plus_1) + "}";
            result = String.valueOf(_result_1) + _plus_2;
        }
        return result;
    }

    public CharSequence generateType(TypeDecl t) {
        if (t instanceof EnumTypeDecl) {
            return this._generateType((EnumTypeDecl)t);
        }
        if (t instanceof RecordTypeDecl) {
            return this._generateType((RecordTypeDecl)t);
        }
        if (t instanceof VectorTypeDecl) {
            return this._generateType((VectorTypeDecl)t);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(t).toString());
    }

    public CharSequence typeReference(EObject t, EObject context) {
        if (t instanceof EnumTypeDecl) {
            return this._typeReference((EnumTypeDecl)t, context);
        }
        if (t instanceof RecordTypeDecl) {
            return this._typeReference((RecordTypeDecl)t, context);
        }
        if (t instanceof SimpleTypeDecl) {
            return this._typeReference((SimpleTypeDecl)t, context);
        }
        if (t instanceof VectorTypeDecl) {
            return this._typeReference((VectorTypeDecl)t, context);
        }
        if (t instanceof TypeReference) {
            return this._typeReference((TypeReference)t, context);
        }
        if (t instanceof VectorTypeConstructor) {
            return this._typeReference((VectorTypeConstructor)t, context);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(t, context).toString());
    }
}

