/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.ModuleFactory;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.ModuleFactoryDelegate;

public abstract class ProjectModuleFactoryDelegate
extends ModuleFactoryDelegate {
    private Map<IProject, IModule[]> modules = new HashMap<IProject, IModule[]>();

    private final IModule[] cacheModules(IProject project) {
        block7: {
            if (project == null || !project.isAccessible()) {
                return null;
            }
            IModule[] m = null;
            try {
                m = this.modules.get(project);
                if (m != null) {
                    return m;
                }
            }
            catch (Exception exception) {}
            try {
                m = this.createModules(project);
                if (m != null) {
                    this.modules.put(project, m);
                    return m;
                }
            }
            catch (Throwable t) {
                if (!Trace.SEVERE) break block7;
                Trace.trace("/severe", "Error creating module", t);
            }
        }
        return new IModule[0];
    }

    private final void cacheModules() {
        block14: {
            try {
                IProject[] projects = ProjectModuleFactoryDelegate.getWorkspaceRoot().getProjects();
                int size = projects.length;
                int i = 0;
                while (i < size) {
                    if (projects[i].isAccessible()) {
                        boolean cache = true;
                        try {
                            IModule[] o = this.modules.get(projects[i]);
                            if (o != null) {
                                cache = false;
                            }
                        }
                        catch (Exception exception) {}
                        if (cache) {
                            try {
                                IModule[] modules2 = this.createModules(projects[i]);
                                if (modules2 != null) {
                                    this.modules.put(projects[i], modules2);
                                }
                            }
                            catch (Throwable t) {
                                if (Trace.SEVERE) {
                                    Trace.trace("/severe", "Error creating module for " + projects[i].getName(), t);
                                }
                            }
                        }
                    } else {
                        this.modules.remove(projects[i]);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                if (!Trace.SEVERE) break block14;
                Trace.trace("/severe", "Error caching modules", e);
            }
        }
    }

    private static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    @Override
    public final IModule[] getModules() {
        this.cacheModules();
        ArrayList<IModule> list = new ArrayList<IModule>();
        for (IModule[] m : this.modules.values()) {
            if (m == null) continue;
            list.addAll(Arrays.asList(m));
        }
        IModule[] modules2 = new IModule[list.size()];
        list.toArray(modules2);
        return modules2;
    }

    public static final void handleGlobalProjectChange(IProject project, IResourceDelta delta) {
        ModuleFactory[] factories = ServerPlugin.getModuleFactories();
        int size = factories.length;
        int i = 0;
        while (i < size) {
            ProjectModuleFactoryDelegate pmfd;
            if (factories[i].delegate != null && factories[i].delegate instanceof ProjectModuleFactoryDelegate && (pmfd = (ProjectModuleFactoryDelegate)factories[i].delegate).deltaAffectsModules(delta)) {
                pmfd.clearCache(project);
                pmfd.clearCache();
            }
            ++i;
        }
    }

    private final boolean deltaAffectsModules(IResourceDelta delta) {
        final boolean[] b = new boolean[1];
        final IPath[] listenerPaths = this.getListenerPaths();
        if (listenerPaths == null || listenerPaths.length == 0) {
            return false;
        }
        final int size = listenerPaths.length;
        try {
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta2) throws CoreException {
                    if (b[0]) {
                        return false;
                    }
                    boolean ok = false;
                    IPath path = delta2.getProjectRelativePath();
                    int i = 0;
                    while (i < size) {
                        if (listenerPaths[i].equals((Object)path)) {
                            b[0] = true;
                            return false;
                        }
                        if (path.isPrefixOf(listenerPaths[i])) {
                            ok = true;
                        }
                        ++i;
                    }
                    return ok;
                }
            });
        }
        catch (Exception exception) {}
        return b[0];
    }

    protected void clearCache() {
    }

    protected void clearCache(IProject project) {
        this.modules = new HashMap<IProject, IModule[]>();
    }

    protected IModule createModule(IProject project) {
        return null;
    }

    protected IModule[] createModules(IProject project) {
        IModule module = this.createModule(project);
        if (module == null) {
            return new IModule[0];
        }
        return new IModule[]{module};
    }

    protected IPath[] getListenerPaths() {
        return null;
    }

    @Override
    public IModule[] getModules(IProject project) {
        return this.cacheModules(project);
    }

    @Override
    public IModule findModule(String id) {
        block6: {
            try {
                IModule[] m;
                IProject project;
                Path pathToProject = new Path(null, id);
                if (pathToProject.segmentCount() == 1 && (project = ProjectModuleFactoryDelegate.getWorkspaceRoot().getProject(id)) != null && (m = this.cacheModules(project)) != null) {
                    int size = m.length;
                    int i = 0;
                    while (i < size) {
                        String id2 = m[i].getId();
                        int index = id2.indexOf(":");
                        if (index >= 0) {
                            id2 = id2.substring(index + 1);
                        }
                        if (id.equals(id2)) {
                            return m[i];
                        }
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                if (!Trace.FINER) break block6;
                Trace.trace("/finer", "Could not find " + id + ". Reverting to default behaviour", e);
            }
        }
        return super.findModule(id);
    }
}

