/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.util;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import org.eclipse.jetty.osgi.BundleMetadata;
import org.eclipse.jetty.osgi.util.BundleFileLocatorHelper;
import org.eclipse.jetty.osgi.util.BundleFileLocatorHelperFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static final Logger LOG = LoggerFactory.getLogger(Util.class);
    private static final String REGISTRATION = "org.eclipse.jetty.osgi.registration";

    public static Filter createFilter(BundleContext bundleContext, String classname, String managedServerName) throws InvalidSyntaxException {
        if (StringUtil.isBlank((String)managedServerName) || managedServerName.equals("defaultJettyServer")) {
            return bundleContext.createFilter("(&(objectclass=" + classname + ")(|(managedServerName=" + managedServerName + ")(!(managedServerName=*))))");
        }
        return bundleContext.createFilter("(&(objectclass=" + classname + ")(managedServerName=" + managedServerName + "))");
    }

    public static void deregisterAsOSGiService(ContextHandler contextHandler) {
        ServiceRegistration serviceRegistration = (ServiceRegistration)contextHandler.getAttribute(REGISTRATION);
        if (serviceRegistration == null) {
            return;
        }
        serviceRegistration.unregister();
        contextHandler.removeAttribute(REGISTRATION);
    }

    public static List<URL> fileNamesAsURLs(String val, String delims) throws Exception {
        String separators = ",;";
        if (delims == null) {
            delims = separators;
        }
        StringTokenizer tokenizer = new StringTokenizer(val, delims, false);
        ArrayList<URL> urls = new ArrayList<URL>();
        while (tokenizer.hasMoreTokens()) {
            urls.add(BundleFileLocatorHelperFactory.getFactory().getHelper().getLocalURL(new URL(tokenizer.nextToken())));
        }
        return urls;
    }

    public static Path getBundlePath(Bundle bundle) throws Exception {
        String bundleOverrideLocation = (String)bundle.getHeaders().get("Jetty-bundleInstall");
        File bundleLocation = BundleFileLocatorHelperFactory.getFactory().getHelper().getBundleInstallLocation(bundle);
        return bundleOverrideLocation == null ? bundleLocation.toPath() : Path.of(bundleOverrideLocation, new String[0]);
    }

    public static Resource newBundleResource(Bundle bundle, ResourceFactory resourceFactory) throws Exception {
        String bundleOverrideLocation = (String)bundle.getHeaders().get("Jetty-bundleInstall");
        File bundleLocation = BundleFileLocatorHelperFactory.getFactory().getHelper().getBundleInstallLocation(bundle);
        Path root = bundleOverrideLocation == null ? bundleLocation.toPath() : Path.of(bundleOverrideLocation, new String[0]);
        URL url = BundleFileLocatorHelperFactory.getFactory().getHelper().getLocalURL(root.toUri().toURL());
        return resourceFactory.newResource(url);
    }

    public static String getContextPath(Bundle bundle) {
        String location;
        String[] toks;
        int lastDot;
        Dictionary headers = bundle.getHeaders();
        Object contextPath = (String)headers.get("Web-ContextPath");
        if (contextPath == null && (lastDot = ((String)(contextPath = (toks = StringUtil.replace((String)(location = bundle.getLocation()), (char)'\\', (char)'/').split("/"))[toks.length - 1])).lastIndexOf(46)) != -1) {
            contextPath = ((String)contextPath).substring(0, lastDot);
        }
        if (!((String)contextPath).startsWith("/")) {
            contextPath = "/" + (String)contextPath;
        }
        return contextPath;
    }

    public static URL getLocalURL(URL url) throws Exception {
        if (url == null) {
            return null;
        }
        return BundleFileLocatorHelper.DEFAULT.getLocalURL(url);
    }

    public static URL getLocalizedEntry(String file, Bundle bundle) throws Exception {
        if (file == null || bundle == null) {
            return null;
        }
        URL url = bundle.getEntry(file);
        if (url == null) {
            return null;
        }
        return BundleFileLocatorHelper.DEFAULT.getLocalURL(url);
    }

    public static String getManifestHeaderValue(String name, String altName, Dictionary<String, String> manifest) {
        if (manifest == null) {
            return null;
        }
        if (name == null && altName == null) {
            return null;
        }
        if (name != null) {
            return manifest.get(name);
        }
        return manifest.get(altName);
    }

    public static String getManifestHeaderValue(String name, Dictionary<String, String> manifest) {
        return Util.getManifestHeaderValue(name, null, manifest);
    }

    public static List<Path> getPathsToBundlesBySymbolicNames(String bundleSymbolicNames, BundleContext bundleContext) throws Exception {
        String[] symbNames;
        PackageAdmin packageAdmin;
        if (bundleSymbolicNames == null) {
            return Collections.emptyList();
        }
        Objects.requireNonNull(bundleContext);
        ServiceReference ref = bundleContext.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin2 = packageAdmin = ref == null ? null : (PackageAdmin)bundleContext.getService(ref);
        if (packageAdmin == null) {
            throw new IllegalStateException("Unable to get PackageAdmin reference to locate required Tld bundles");
        }
        ArrayList<Path> paths = new ArrayList<Path>();
        for (String symbName : symbNames = bundleSymbolicNames.split("[, ]")) {
            Bundle[] bs = packageAdmin.getBundles(symbName, null);
            if (bs == null || bs.length == 0) {
                throw new IllegalArgumentException("Unable to locate the bundle '" + symbName + "' specified in manifest of " + bundleContext.getBundle().getSymbolicName());
            }
            File f = BundleFileLocatorHelperFactory.getFactory().getHelper().getBundleInstallLocation(bs[0]);
            paths.add(f.toPath());
        }
        return paths;
    }

    public static void registerAsOSGiService(ContextHandler contextHandler) {
        ServiceRegistration serviceRegistration = (ServiceRegistration)contextHandler.getAttribute(REGISTRATION);
        if (serviceRegistration == null) {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("o.e.j.o.b.watermark", "o.e.j.o.b.watermark");
            Bundle bundle = (Bundle)contextHandler.getAttribute("org.eclipse.jetty.osgi.bundle");
            if (bundle != null) {
                String bundleVersion;
                Version version;
                String bundleSymbolicName = bundle.getSymbolicName();
                if (StringUtil.isNotBlank((String)bundleSymbolicName)) {
                    ((Dictionary)properties).put("osgi.web.symbolicname", bundleSymbolicName);
                }
                if ((version = bundle.getVersion()) != null && StringUtil.isNotBlank((String)(bundleVersion = version.toString()))) {
                    ((Dictionary)properties).put("osgi.web.version", bundleVersion);
                }
            }
            ((Dictionary)properties).put("osgi.web.contextpath", contextHandler.getContextPath());
            serviceRegistration = FrameworkUtil.getBundle(BundleMetadata.class).getBundleContext().registerService(ContextHandler.class.getName(), (Object)contextHandler, properties);
            contextHandler.setAttribute(REGISTRATION, (Object)serviceRegistration);
        }
    }

    public static URI resolvePathAsLocalizedURI(String path, Bundle bundle, Path jettyHome) throws Exception {
        URL url;
        Path p;
        if (StringUtil.isBlank((String)path)) {
            return null;
        }
        if (path.startsWith("file:/")) {
            return URIUtil.correctURI((URI)new URI(path));
        }
        if (path.startsWith("/") && File.separatorChar != '/') {
            return new URI("file:" + path);
        }
        try {
            p = FileSystems.getDefault().getPath(path, new String[0]);
            if (p.isAbsolute()) {
                return p.toUri();
            }
        }
        catch (InvalidPathException x) {
            LOG.trace("IGNORED", (Throwable)x);
        }
        if (bundle != null && (url = bundle.getEntry(path)) != null) {
            return BundleFileLocatorHelper.DEFAULT.getLocalURL(url).toURI();
        }
        if (jettyHome != null && Files.exists(p = jettyHome.resolve(path), new LinkOption[0])) {
            return p.toUri();
        }
        return null;
    }

    public static String resolvePropertyValue(String value) {
        int ind = value.indexOf("${");
        if (ind == -1) {
            return value;
        }
        int ind2 = value.indexOf(125, ind);
        if (ind2 == -1) {
            return value;
        }
        String sysprop = value.substring(ind + 2, ind2);
        Object defaultValue = null;
        int comma = sysprop.indexOf(44);
        if (comma != -1 && comma + 1 != sysprop.length()) {
            defaultValue = sysprop.substring(comma + 1);
            defaultValue = Util.resolvePropertyValue((String)defaultValue);
            sysprop = sysprop.substring(0, comma);
        } else {
            defaultValue = "${" + sysprop + "}";
        }
        String v = System.getProperty(sysprop);
        String reminder = value.length() > ind2 + 1 ? value.substring(ind2 + 1) : "";
        reminder = Util.resolvePropertyValue(reminder);
        if (v != null) {
            return value.substring(0, ind) + v + reminder;
        }
        return value.substring(0, ind) + (String)defaultValue + reminder;
    }

    public static void setProperty(Dictionary<String, Object> properties, String key, Object value) {
        if (value != null) {
            properties.put(key, value);
        }
    }

    public static Bundle[] getFragmentsAndRequiredBundles(BundleContext bootBundleContext, Bundle targetBundle) {
        if (bootBundleContext == null) {
            return null;
        }
        ServiceReference sr = bootBundleContext.getServiceReference(PackageAdmin.class);
        if (sr == null) {
            return null;
        }
        PackageAdmin packageAdmin = (PackageAdmin)bootBundleContext.getService(sr);
        LinkedHashMap<String, Bundle> deps = new LinkedHashMap<String, Bundle>();
        Util.collectFragmentsAndRequiredBundles(packageAdmin, targetBundle, deps, false);
        return deps.values().toArray(new Bundle[0]);
    }

    private static void collectFragmentsAndRequiredBundles(PackageAdmin packageAdmin, Bundle bundle, Map<String, Bundle> deps, boolean onlyReexport) {
        if (packageAdmin == null) {
            return;
        }
        Bundle[] fragments = packageAdmin.getFragments(bundle);
        if (fragments != null) {
            for (Bundle f : fragments) {
                if (deps.containsKey(f.getSymbolicName())) continue;
                deps.put(f.getSymbolicName(), f);
                Util.collectRequiredBundles(packageAdmin, f, deps, onlyReexport);
            }
        }
        Util.collectRequiredBundles(packageAdmin, bundle, deps, onlyReexport);
    }

    private static void collectRequiredBundles(PackageAdmin packageAdmin, Bundle bundle, Map<String, Bundle> deps, boolean onlyReexport) {
        String requiredBundleHeader = (String)bundle.getHeaders().get("Require-Bundle");
        if (requiredBundleHeader == null) {
            return;
        }
        ManifestHeaderTokenizer tokenizer = new ManifestHeaderTokenizer(requiredBundleHeader);
        while (tokenizer.hasMoreTokens()) {
            String tok = ((StringTokenizer)tokenizer).nextToken().trim();
            StringTokenizer tokenizer2 = new StringTokenizer(tok, ";");
            String symbolicName = tokenizer2.nextToken().trim();
            if (deps.containsKey(symbolicName)) continue;
            String versionRange = null;
            boolean reexport = false;
            while (tokenizer2.hasMoreTokens()) {
                String next = tokenizer2.nextToken().trim();
                if (next.startsWith("bundle-version=")) {
                    if (next.startsWith("bundle-version=\"") || next.startsWith("bundle-version='")) {
                        versionRange = next.substring("bundle-version=\"".length(), next.length() - 1);
                        continue;
                    }
                    versionRange = next.substring("bundle-version=".length());
                    continue;
                }
                if (!next.equals("visibility:=reexport")) continue;
                reexport = true;
            }
            if (!reexport && onlyReexport) {
                return;
            }
            Bundle[] reqBundles = packageAdmin.getBundles(symbolicName, versionRange);
            if (reqBundles == null || reqBundles.length == 0) continue;
            Bundle reqBundle = null;
            for (Bundle b : reqBundles) {
                if (b.getState() != 32 && b.getState() != 8) continue;
                reqBundle = b;
                break;
            }
            if (reqBundle == null) {
                reqBundle = reqBundles[0];
            }
            deps.put(reqBundle.getSymbolicName(), reqBundle);
            Util.collectFragmentsAndRequiredBundles(packageAdmin, reqBundle, deps, true);
        }
    }

    private static class ManifestHeaderTokenizer
    extends StringTokenizer {
        public ManifestHeaderTokenizer(String header) {
            super(header, ",");
        }

        @Override
        public String nextToken() {
            Object token = super.nextToken();
            while (this.hasOpenQuote((String)token) && this.hasMoreTokens()) {
                token = (String)token + "," + super.nextToken();
            }
            return token;
        }

        private boolean hasOpenQuote(String token) {
            int quote;
            int i = -1;
            do {
                if ((quote = this.getQuote(token, i + 1)) < 0) {
                    return false;
                }
                i = token.indexOf(quote, i + 1);
            } while ((i = token.indexOf(quote, i + 1)) >= 0);
            return true;
        }

        private int getQuote(String token, int offset) {
            int i = token.indexOf(34, offset);
            int j = token.indexOf(39, offset);
            if (i < 0) {
                if (j < 0) {
                    return -1;
                }
                return 39;
            }
            if (j < 0) {
                return 34;
            }
            if (i < j) {
                return 34;
            }
            return 39;
        }
    }
}

