/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.engine.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.birt.core.archive.FileArchiveWriter;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.PDFRenderOption;
import org.eclipse.birt.report.tests.engine.EngineCase;

public class PDFRenderOptionTest
extends EngineCase {
    IReportDocument reportDoc;
    String outputPath = this.genOutputFolder() + "/";

    public void testHardPageBreak() throws Exception {
        String INPUT = "168911_test1";
        String input = this.genInputFile(INPUT + ".rptdesign");
        this.setRunAndRenderOption(input, INPUT, "true", "true");
        this.setRenderOption(input, INPUT, "true", "true");
    }

    public void testSoftPageBreak_1() throws Exception {
        String INPUT = "168911_test2";
        String input = this.genInputFile(INPUT + ".rptdesign");
        this.setRunAndRenderOption(input, INPUT, "true", "true");
        this.setRenderOption(input, INPUT, "true", "true");
    }

    public void testSoftPageBreak_2() throws Exception {
        String INPUT = "168911_test3";
        String input = this.genInputFile(INPUT + ".rptdesign");
        this.setRunAndRenderOption(input, INPUT, "true", "true");
        this.setRenderOption(input, INPUT, "true", "true");
    }

    public void testSoftPageBreak_3() throws Exception {
        String INPUT = "168911_test4";
        String input = this.genInputFile(INPUT + ".rptdesign");
        this.setRunAndRenderOption(input, INPUT, "true", "true");
        this.setRenderOption(input, INPUT, "true", "true");
    }

    public void testMasterPage() throws Exception {
        String INPUT = "168911_test5";
        String input = this.genInputFile(INPUT + ".rptdesign");
        this.setRunAndRenderOption(input, INPUT, "true", "true");
        this.setRenderOption(input, INPUT, "true", "true");
    }

    public void testPageAndContentWidth_1() throws Exception {
        String INPUT = "168911_test6";
        String input = this.genInputFile(INPUT + ".rptdesign");
        this.setRunAndRenderOption(input, INPUT, "true", "true");
        this.setRenderOption(input, INPUT, "true", "true");
    }

    public void testPageAndContentWidth_2() throws Exception {
        String INPUT = "168911_test7";
        String input = this.genInputFile(INPUT + ".rptdesign");
        this.setRunAndRenderOption(input, INPUT, "true", "true");
        this.setRenderOption(input, INPUT, "true", "true");
    }

    public void testPageAndContentWidth_3() throws Exception {
        String INPUT = "168911_test8";
        String input = this.genInputFile(INPUT + ".rptdesign");
        this.setRunAndRenderOption(input, INPUT, "true", "true");
        this.setRenderOption(input, INPUT, "true", "true");
    }

    public void testPageAndContentWidth_4() throws Exception {
        String INPUT = "168911_test9";
        String input = this.genInputFile(INPUT + ".rptdesign");
        this.setRunAndRenderOption(input, INPUT, "true", "true");
        this.setRenderOption(input, INPUT, "true", "true");
    }

    public void testPageAndContentWidth_5() throws Exception {
        String INPUT = "168911_test10";
        String input = this.genInputFile(INPUT + ".rptdesign");
        this.setRunAndRenderOption(input, INPUT, "true", "true");
        this.setRenderOption(input, INPUT, "true", "true");
    }

    public void testPageAndContentWidth_6() throws Exception {
        String INPUT = "168911_test11";
        String input = this.genInputFile(INPUT + ".rptdesign");
        this.setRunAndRenderOption(input, INPUT, "true", "true");
        this.setRenderOption(input, INPUT, "true", "true");
    }

    public void testHardPageBreak_TrueAndFalse() throws Exception {
        String INPUT = "168911_test1";
        String input = this.genInputFile(INPUT + ".rptdesign");
        this.setRunAndRenderOption(input, INPUT, "true", "false");
        this.setRenderOption(input, INPUT, "true", "false");
    }

    public void testSoftPageBreak_1_TrueAndFalse() throws Exception {
        String INPUT = "168911_test2";
        String input = this.genInputFile(INPUT + ".rptdesign");
        this.setRunAndRenderOption(input, INPUT, "true", "false");
        this.setRenderOption(input, INPUT, "true", "false");
    }

    public void testSoftPageBreak_2_TrueAndFalse() throws Exception {
        String INPUT = "168911_test3";
        String input = this.genInputFile(INPUT + ".rptdesign");
        this.setRunAndRenderOption(input, INPUT, "true", "false");
        this.setRenderOption(input, INPUT, "true", "false");
    }

    public void testSoftPageBreak_3_TrueAndFalse() throws Exception {
        String INPUT = "168911_test4";
        String input = this.genInputFile(INPUT + ".rptdesign");
        this.setRunAndRenderOption(input, INPUT, "true", "false");
        this.setRenderOption(input, INPUT, "true", "false");
    }

    public void testHardPageBreak_FalseAndTrue() throws Exception {
        String INPUT = "168911_test1";
        String input = this.genInputFile(INPUT + ".rptdesign");
        this.setRunAndRenderOption(input, INPUT, "false", "true");
        this.setRenderOption(input, INPUT, "false", "true");
    }

    public void testSoftPageBreak_1_FalseAndTrue() throws Exception {
        String INPUT = "168911_test2";
        String input = this.genInputFile(INPUT + ".rptdesign");
        this.setRunAndRenderOption(input, INPUT, "false", "true");
        this.setRenderOption(input, INPUT, "false", "true");
    }

    public void testSoftPageBreak_2_FalseAndTrue() throws Exception {
        String INPUT = "168911_test3";
        String input = this.genInputFile(INPUT + ".rptdesign");
        this.setRunAndRenderOption(input, INPUT, "false", "true");
        this.setRenderOption(input, INPUT, "false", "true");
    }

    public void testSoftPageBreak_3_FalseAndTrue() throws Exception {
        String INPUT = "168911_test4";
        String input = this.genInputFile(INPUT + ".rptdesign");
        this.setRunAndRenderOption(input, INPUT, "false", "true");
        this.setRenderOption(input, INPUT, "false", "true");
    }

    public void testHardPageBreak_FalseAndFalse() throws Exception {
        String INPUT = "168911_test1";
        String input = this.genInputFile(INPUT + ".rptdesign");
        this.setRunAndRenderOption(input, INPUT, "false", "false");
        this.setRenderOption(input, INPUT, "false", "false");
    }

    public void testSoftPageBreak_1_FalseAndFalse() throws Exception {
        String INPUT = "168911_test2";
        String input = this.genInputFile(INPUT + ".rptdesign");
        this.setRunAndRenderOption(input, INPUT, "false", "false");
        this.setRenderOption(input, INPUT, "false", "false");
    }

    public void testSoftPageBreak_2_FalseAndFalse() throws Exception {
        String INPUT = "168911_test3";
        String input = this.genInputFile(INPUT + ".rptdesign");
        this.setRunAndRenderOption(input, INPUT, "false", "false");
        this.setRenderOption(input, INPUT, "false", "false");
    }

    public void testSoftPageBreak_3_FalseAndFalse() throws Exception {
        String INPUT = "168911_test4";
        String input = this.genInputFile(INPUT + ".rptdesign");
        this.setRunAndRenderOption(input, INPUT, "false", "false");
        this.setRenderOption(input, INPUT, "false", "false");
    }

    public void setRunAndRenderOption(String inputFile, String inputName, String boolVar1, String boolVar2) throws Exception {
        this.copyResource_INPUT(inputName + ".rptdesign", inputName + ".rptdesign");
        IReportRunnable runnable = this.engine.openReportDesign((InputStream)new FileInputStream(new File(inputFile)));
        IRunAndRenderTask task = this.engine.createRunAndRenderTask(runnable);
        PDFRenderOption option = new PDFRenderOption();
        option.setOutputFileName(this.outputPath + inputName + "_" + boolVar1 + "_" + boolVar2 + ".pdf");
        option.setOutputFormat("pdf");
        option.setOption("pdfRenderOption.fitToPage", (Object)new Boolean(boolVar1));
        option.setOption("pdfRenderOption.pagebreakPaginationOnly", (Object)new Boolean(boolVar2));
        task.setRenderOption((IRenderOption)option);
        task.run();
        task.close();
    }

    public void setRenderOption(String inputFile, String inputName, String boolVar1, String boolVar2) throws Exception {
        String report_document = this.outputPath + inputName + ".rptdocument";
        this.createReportDocument(inputFile, report_document);
        this.reportDoc = this.engine.openReportDocument(report_document);
        IRenderTask taskRender = this.engine.createRenderTask(this.reportDoc);
        PDFRenderOption optionRender = new PDFRenderOption();
        optionRender.setOutputFileName(this.outputPath + inputName + "_render_" + boolVar1 + "_" + boolVar2 + ".pdf");
        optionRender.setOutputFormat("pdf");
        optionRender.setOption("pdfRenderOption.fitToPage", (Object)new Boolean(boolVar1));
        optionRender.setOption("pdfRenderOption.pagebreakPaginationOnly", (Object)new Boolean(boolVar2));
        taskRender.setRenderOption((IRenderOption)optionRender);
        taskRender.render();
        taskRender.close();
    }

    protected void createReportDocument(String reportdesign, String reportdocument) throws Exception {
        FileArchiveWriter archive = new FileArchiveWriter(reportdocument);
        IReportRunnable report = this.engine.openReportDesign(reportdesign);
        IRunTask runTask = this.engine.createRunTask(report);
        runTask.setAppContext(new HashMap());
        runTask.run((IDocArchiveWriter)archive);
        int i = runTask.getErrors().size();
        if (i > 0) {
            System.out.println("error is " + runTask.getErrors().get(0).toString());
        }
        PDFRenderOptionTest.assertEquals((String)("Exception when generate document from " + reportdesign), (int)0, (int)i);
        runTask.close();
    }
}

